import { Component, EventEmitter, Input, Output, ViewChild } from '@angular/core';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource } from '@angular/material/table';
import { Router, RouterLink } from '@angular/router';
import { NgbDropdown, NgbDropdownModule, NgbModal, NgbModalModule, NgbModule, NgbTooltipModule } from '@ng-bootstrap/ng-bootstrap';
import { ToastrService } from 'ngx-toastr';
import { Subject, debounceTime, distinctUntilChanged, switchMap } from 'rxjs';
import { AdminService } from '../../../services/admin/admin.service';
import { TranslationService } from '../../../services/translation.service';
import { SelectionModel } from '@angular/cdk/collections';
import Swal from 'sweetalert2';
import { TranslatePipes } from '../../../pipes/translate/translate.pipe';
import { CommonModule, NgClass } from '@angular/common';
import { MaterialeModules } from '../../../../material.module';
import { DateAgoPipe } from '../../../pipes/date-ago/date-ago.pipe';
import { FormsModule } from '@angular/forms';
import { NgSelectModule } from '@ng-select/ng-select';

@Component({
  standalone: true,
  imports: [CommonModule, MaterialeModules, TranslatePipes, DateAgoPipe, NgbDropdownModule, NgbModalModule, FormsModule, NgSelectModule, RouterLink, NgbTooltipModule, NgClass ],
  selector: 'app-admin-ticket-table',
  templateUrl: './admin-ticket-table.component.html',
  styleUrl: './admin-ticket-table.component.scss'
})
export class AdminTicketTableComponent {

  public tableDataSource = new MatTableDataSource<any>([]);
  settimezone = 'UTC';
  @Input() permission!: string;
  @Input() set timezone(value:string){
    this.settimezone = value;
  }
  @Input() isloader!: Boolean;
  @Input() displayedColumns!: string[];
  @Input() set tableData(data: any) {
    this.setTableDataSource(data);
  }

  @ViewChild(MatPaginator, { static: false }) paginator!: MatPaginator;
  @ViewChild(MatSort, { static: true }) sort!: MatSort;

  @Output() loadDataFn: EventEmitter<any> = new EventEmitter<any>();

  setting;
  public sendingResponse: { [key: string]: boolean } = {};
  public ticketDetails: any;
  public userDetails: any
  public assignedMem: any = [];
  
  selection = new SelectionModel<any>(true, []);


  Auth: any;
  mailnotify: any = [];


  constructor(
    private adminService: AdminService,
    private modalService: NgbModal,
    private router: Router,
    private translationService: TranslationService,
    private toastr: ToastrService,
    private translate: TranslatePipes,
  ) {

  }
  private searchTerms = new Subject<string>();

  ngOnInit(): void {
    this.searchTerms.pipe(
      debounceTime(300),
      distinctUntilChanged()
    ).subscribe(() => this.loadData());

  }

  setTableDataSource(data: any) {
    if (data) {
      this.tableDataSource = new MatTableDataSource<any>(data.data);

      if (this.tableDataSource) {

        this.paginator.pageSize = data.per_page;
        this.translationService.TranslationStatus.subscribe(() => {
          // setTimeout(() => {
          this.paginator._intl.itemsPerPageLabel = this.translate.transform('items per page:');
          this.paginator._intl.nextPageLabel = this.translate.transform('next');
          this.paginator._intl.previousPageLabel = this.translate.transform('previous');
          this.paginator._intl.firstPageLabel = this.translate.transform('first page');
          this.paginator._intl.lastPageLabel = this.translate.transform('last page');
          const of = this.translate.transform('of');
          this.paginator._intl.getRangeLabel = (page: number, pageSize: number, length: number) => {
            if (length == 0 || pageSize == 0) return `0 ${of} ${length}`;
            length = Math.max(length, 0);
            const startIndex = page * pageSize;
            const endIndex = startIndex < length ? Math.min(startIndex + pageSize, length) : startIndex + pageSize;

            return `${startIndex + 1} - ${endIndex} ${of} ${length}`;
          };
          // }, 100);
        });
        this.translationService.setTranslationaStatus(true);
        setTimeout(() => {
          this.paginator.pageIndex = data.current_page - 1;
          this.paginator.length = data.total;
        });
        this.tableDataSource.paginator = this.paginator;
        this.tableDataSource.sort = this.sort;
      }
    }

  }


  loadData() {
    let emitValue = {
      "page": this.paginator.pageIndex + 1,
      "size": this.paginator.pageSize,
      "filter": this.filterValue
    }
    this.loadDataFn.emit(emitValue);
  }

  onPaginateTable() {
    this.selection.clear();
    this.loadData();
  }
  deleteTicket(id, buttonId) {
    const data = {

    };
    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure ?'),
      text: this.translate.transform('Your will not be able to recover!'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Yes, delete it!'),
      cancelButtonText: this.translate.transform('Close'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.adminService
          .deleteTicket(id, data)
          .subscribe({
            next: (response) => {
              this.sendingResponse[buttonId] = false;
              if (response && response?.success) {
                this.toastr.success(this.translate.transform(response?.success));
              }
            },
            error: () => {
              this.sendingResponse[buttonId] = false;
            },
          });
      }
    });
  }
  deleteMassEmployee(buttonId) {
    if (!this.selection.selected.length) {
      this.toastr.error(this.translate.transform('Please select atleast one Ticket'));
      return;
    }
    const id: any = [];

    this.selection.selected.map(function (ele) {
      id.push(ele.enc_id);
    });

    const data = {

      id: id,
    };
    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure ?'),
      text: this.translate.transform('Your will not be able to recover!'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#6259ca',
      confirmButtonText: this.translate.transform('Yes, delete it!'),
      cancelButtonText: this.translate.transform('Close'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.adminService
          .massTicketdeleteAll(data)
          .subscribe({
            next: (response) => {
              this.selection.clear();
              this.sendingResponse[buttonId] = false;
              if (response && response?.success) {
                this.toastr.success(this.translate.transform(response?.success));
                this.modalService.dismissAll();
              }
            },
            error: () => {
              this.sendingResponse[buttonId] = false;
            },
          });
      }
    });
  }

  SelfAssign(row: any, buttonId) {
    const data = {

      "assigned_id": row?.selfassignuser_id,
    };
    this.sendingResponse[buttonId] = true;
    this.adminService
      .adminSelfAssign(row?.enc_id, data)
      .subscribe({
        next: (response) => {
          this.sendingResponse[buttonId] = false;
          if (response && response?.success) {
            this.toastr.success(this.translate.transform(response.success));
          }
        },
        error: () => {
          this.sendingResponse[buttonId] = false;
        },
      });
  }
  OtherAssign(event: any, buttonId) {
    const data = {
      "assigned_id": this.userDetails.assign_data.id,
      "assigned_user_id": event.assigned_user_id,
    };
    this.sendingResponse[buttonId] = true;
    this.adminService
      .otherAssignTicket(data)
      .subscribe({
        next: (response) => {
          this.sendingResponse[buttonId] = false;
          if (response && response?.success) {
            this.toastr.success(this.translate.transform(response?.success));
            this.modalService.dismissAll();
            this.assignedMem = [];
          }
        },
        error: () => {
          this.sendingResponse[buttonId] = false;
        },
      });
  }
  unAssignSelf(id, buttonId) {
    this.sendingResponse[buttonId] = true;
    this.adminService.unAssignlist(id).subscribe({
      next: (res) => {
        this.sendingResponse[buttonId] = false;
        if (res?.success) {
          this.toastr.success(this.translate.transform(res.success));
        }
        if (res?.error) {
          this.toastr.error(this.translate.transform(res.error));
        }
      },
      error: () => {
        this.sendingResponse[buttonId] = false;
      },
    });
  }
  AssignTicket(content: any, row: any) {
    this.ticketDetails = row;

    this.adminService
      .userListOtherAssign(row?.enc_id)
      .subscribe({
        next: (userlist: any) => {
          if (userlist && userlist.assign_data.ticketassignmutliples) {
            userlist.assign_data.ticketassignmutliples.map((list: any) => {
              this.assignedMem.push(list.toassignuser_id);
            });
          }
          this.userDetails = userlist;

          const modalRef = this.modalService.open(content, { backdrop: 'static', keyboard: false });
          modalRef.result.then(
            () => this.assignedMem = [],
            () => this.assignedMem = []
          );
        },
      });
  }
  showTicketDetails(id: any) {
    this.router.navigate([`/admin/ticket-view/${id.enc_ticket_id}`]);
  }
  filterValue = "";
  applyFilter(event: Event) {
    this.filterValue = (event.target as HTMLInputElement).value;
    this.searchTerms.next(this.filterValue);
  }
  refreshTable() {
    this.adminService.RefreshRquestAdmin$.next();
    this.selection.clear();
  }
  // this is needed to allow sorting on nested properties
  nestedProperty = (data: any, sortHeaderId: string): string | number => {
    return sortHeaderId
      ?.split('.')
      .reduce((accumulator, key) => accumulator && accumulator[key], data) as
      | string
      | number;
  };
  // this is needed to have caseInsensitive sorting
  caseInsensitive = (data: any, sortHeaderId: string): string | number => {
    const value = data[sortHeaderId];
    return typeof value === 'string' ? value.toUpperCase() :
      value;
  };
  nestedCaseInsensitive = (data: any, sortHeaderId: string): string | number => {
    const value = sortHeaderId
      ?.split('.')
      .reduce((accumulator, key) => accumulator && accumulator[key], data) as
      | string
      | number;
    return typeof value === 'string' ? value.toUpperCase() : value;
  };

  /** Whether the number of selected elements matches the total number of rows. */
  isAllSelected() {
    const numSelected = this.selection.selected.length;
    let numRows;
    if (this.tableDataSource) {
      numRows = this.tableDataSource.data.length;
    }
    return numSelected === numRows;
  }
  /** Selects all rows if they are not all selected; otherwise clear selection. */
  toggleAllRows() {
    if (this.isAllSelected()) {
      this.selection.clear();
      return;
    }
    this.selection.select(...this.tableDataSource.data);
  }

  /** The label for the checkbox on the passed row */
  checkboxLabel(row?: any): string {
    if (!row) {
      return `${this.isAllSelected() ? 'deselect' : 'select'} all`;
    }
    return `${this.selection.isSelected(row) ? 'deselect' : 'select'} row ${row?.id + 1
      }`;
  }
}
