import { CommonModule } from '@angular/common';
import { Component, ElementRef, EventEmitter, Input, Output, ViewChild } from '@angular/core';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { NgbAlertModule } from '@ng-bootstrap/ng-bootstrap';
import { CookieService } from 'ngx-cookie-service';

@Component({
  standalone: true,
  imports:[CommonModule, NgbAlertModule],
  selector: 'app-announcement-holiday-banner',
  templateUrl: './announcement-holiday-banner.component.html',
  styleUrl: './announcement-holiday-banner.component.scss'
})
export class AnnouncementHolidayBannerComponent {
  @Input('setting') setting:any;
  @Input('user') user:any;
  @Input('announcement') announcement:any;
  @Input('announcements') announcements:any;
  @Input('holidays') holidays:any;
  // @Input('hideAlertsUntil') hideAlertsUntil:any;
  hideAlertsUntils: { [key: string]: number } = {}
  @Input()
  get hideAlertsUntil(): any {
    
    return this.hideAlertsUntils;
  }
  set hideAlertsUntil(value: any) {
    if (value) {
      this.hideAlertsUntils = value;
    }
  }
  @Output() heightOfAlert =  new EventEmitter<any>;
  today = new Date();
  constructor(private cookieService: CookieService, private sanitizer: DomSanitizer){}
  
  
  dismissAlert(alert, type) {
    const hideAlertsUntil = (Date.now() + (30 * 60 * 1000)).toString();
    this.cookieService.set(type + alert.id, hideAlertsUntil, undefined, '/'); // Set cookie for 30 minutes from now
    this.hideAlertsUntils[type + alert.id] = parseInt(hideAlertsUntil, 10);
  }

  isAlertVisible(alert, type) {
    return !alert.dismissed && (!this.hideAlertsUntils?.[type + alert.id] || this.hideAlertsUntils?.[type + alert.id] < Date.now());
  }

  sanitizeHtml(html: string): SafeHtml {
    return this.sanitizer.bypassSecurityTrustHtml(html);
  }
  // Function to add alpha channel to RGB color
  addAlphaChannel(rgbColor: string, alpha: number): string {
    // Extracting the RGB values
    const rgbValues = rgbColor.match(/\d+/g);
    if(rgbValues){
    // Constructing the RGBA color value
    const rgbaColor = `rgba(${rgbValues[0]}, ${rgbValues[1]}, ${rgbValues[2]}, ${alpha})`;
    return rgbaColor;
    }
    return rgbColor;
  }
}
