import { DatePipe } from '@angular/common';
import { Component, Input, OnInit } from '@angular/core';
import { Unsub } from '../../../class/unsub.class';
import { AdminService } from '../../../services/admin/admin.service';
import { LoaderService } from '../../../services/loader.service';
import { TranslatePipes } from '../../../pipes/translate/translate.pipe';
import { TimezonePipe } from '../../../pipes/timzone.pipe';
import { takeUntil } from 'rxjs';
@Component({
  selector: 'admin-page-header',
  standalone: true,
  imports: [TranslatePipes, TimezonePipe],
  providers:[DatePipe],
  templateUrl: './admin-page-header.component.html',
  styleUrls: ['./admin-page-header.component.scss'],
})
export class AdminPageHeaderComponent extends Unsub implements OnInit {
  @Input('title') title!: string;
  today: any = new Date;
  data;
  timezone;
  constructor(private adminService: AdminService, loaderService: LoaderService) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.today = new Date();
  }
  ngOnInit(): void {
    this.adminService.time().pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: res => {
        this.data = res;
        this.timezone = this.data?.setting?.original?.default_timezone ?? 'UTC';
      }
    });
  }

}
