// timeout.guard.ts
import { Injectable, TemplateRef } from '@angular/core';
import { ActivatedRouteSnapshot, RouterStateSnapshot, Router, NavigationEnd } from '@angular/router';
import { Observable, of } from 'rxjs';
import Swal from 'sweetalert2';
import { TimerService } from '../services/timer.service';
import { AdminService } from '../services/admin/admin.service';
import { TranslatePipes } from '../pipes/translate/translate.pipe';
import { AdminDataService } from '../services/admin/admin-data.service';

@Injectable({
  providedIn: 'root'
})
export class TimeoutGuard {
  innerTimerValue;
  constructor(private timerService: TimerService, private router: Router, private adminService: AdminService, private translatePipe: TranslatePipes, private adminDataService: AdminDataService) {
    this.timerService.loadStateFromStorage();
  }
  canActivate(
    next: ActivatedRouteSnapshot,
    state: RouterStateSnapshot
  ): Observable<boolean> | Promise<boolean> {
    let data = this.adminDataService.getSharedData();
    if (data?.admin_users_inactive_auto_logout == "on" || data?.admin_users_inactive_auto_logout == true) {
      const inactivityDuration = Number(data?.admin_users_inactive_auto_logout_time) * 60;
      this.timerService.startTimer(inactivityDuration);
      return new Observable<boolean>((observer) => {
        const subscription = this.timerService.getTimerObservable().subscribe((timer) => {
          if (timer === 0) {
            Swal.fire({
              title: '<h4 class="fw-semibold mb-1">' + this.translatePipe.transform('You have been inactive since last') + data?.admin_users_inactive_auto_logout_time + this.translatePipe.transform('minutes. Do you wish to stay?') + '</h4>',
              icon: 'warning',
              allowOutsideClick: false,
              showConfirmButton: true,
              confirmButtonText: this.translatePipe.transform('Stay Signed In'),
              didOpen: () => {
                this.timerService.stopTimer()
                this.timerService.startInnerTimer(60);
                const innerSubscription = this.timerService.getInnerTimerObservable().subscribe((innertimer) => {
                  const storedState = localStorage.getItem('admin_session_timer');
                  if (storedState) {
                    const { timer } = JSON.parse(storedState);
                    if (timer > 0) {
                      this.timerService.stopInnerTimer();
                      innerSubscription.unsubscribe();
                      Swal.close();
                    }
                  }
                  this.innerTimerValue = '<span class="d-block text-muted fw-normal">' + this.translatePipe.transform('Your session will be timed out in') + '<h3 class="countdown mb-0">' + innertimer + '</h3>' + this.translatePipe.transform('seconds'); +'</span>';

                  Swal.update({
                    html: this.innerTimerValue,
                  });
                  if (innertimer === 0) {
                    subscription.unsubscribe();
                    innerSubscription.unsubscribe();
                    this.timerService.stopInnerTimer();
                    this.Adminlogout();
                    Swal.close();
                  }
                });
              },
            }).then((result) => {
              if (result.isConfirmed) {
                this.timerService.resetTimer(inactivityDuration);
                this.timerService.stopInnerTimer();
                observer.next(true);
                observer.complete();
              }
            });
          } else {
            observer.next(true);
            observer.complete();
          }
        });
      });
    }
    return of(true);
  }

  adminLogout$;
  Adminlogout() {
    const data = {

    };
    this.adminLogout$ = this.adminService.AdminLogout(data)
      .subscribe({
        next: (res) => {
          localStorage.clear();
          this.router.navigate(['/admin/login']).then(() => { });
          history.pushState(null, '');
          this.adminLogout$.unsubscribe();
        }
      });
  }
}
