import { Injectable } from '@angular/core';
import { HttpEvent, HttpHandler, HttpInterceptor, HttpRequest, HttpResponse } from '@angular/common/http';
import { Observable } from 'rxjs';
import { tap } from 'rxjs/operators';
import { Router } from '@angular/router';
import { Location } from '@angular/common';

@Injectable()
export class AuthInterceptor implements HttpInterceptor {
  constructor(private router: Router, private state: Location) { }
  intercept(request: HttpRequest<any>, next: HttpHandler): Observable<HttpEvent<any>> {
    return next.handle(request).pipe(
      tap(event => {
        if (event instanceof HttpResponse) {
          const userType = event.headers.get('X-User-Type');
          const Twofactor = event.headers.get('Twofactor');
          const email = event.headers.get('email');
          const Google2fa = event.headers.get('Google2fa');
          if (userType === 'admin') {
            this.router.navigate(['/admin'], {
              queryParams: {
                returnUrl: this.state.path(),
              },
            });
            // Handle admin logout
            // ...
          } else if (userType === 'customer') {
            this.router.navigate(['/customer'], {
              queryParams: {
                returnUrl: this.state.path(),
              },
            });
            // Handle customer logout
            // ...
          }
          else if (Twofactor === 'admin') {
            this.router.navigate(['/admin/admintwofactor/' + email], {
              queryParams: {
                returnUrl: this.state.path(),
              },
            });
            // Handle admin logout
            // ...
          } else if (Google2fa === 'admin') {
            this.router.navigate(['/admin/admingoogle2fa/' + email], {
              queryParams: {
                returnUrl: this.state.path(),
              },
            });
            // Handle admin logout
            // ...
          }
          else if (Twofactor === 'customer') {
            this.router.navigate(['/customer/customertwofactor/' + email], {
              queryParams: {
                returnUrl: this.state.path(),
              },
            });
            // Handle customer logout
            // ...
          } else if (Google2fa === 'customer') {
            this.router.navigate(['/customer/customergoogle2fa/' + email], {
              queryParams: {
                returnUrl: this.state.path(),
              },
            });
            // Handle customer logout
            // ...
          }
        }
      })
    );
  }
}
