import { Pipe, PipeTransform } from '@angular/core';
import { TranslatePipes } from '../translate/translate.pipe';
import { DateTime } from 'luxon';

@Pipe({
  standalone: true,
  name: 'dateAgo',
  pure: false
})
export class DateAgoPipe implements PipeTransform {
  constructor(private translate: TranslatePipes) { }

  transform(value: any, timeZone: string = 'UTC'): any {
    if (value) {
      // Ensure that value is a valid ISO string
      const date = new Date(value);

      // Use Luxon to handle time zones dynamically
      const luxonDate = DateTime.fromJSDate(date, { zone: timeZone });

      // Check if the time zone is valid using Luxon
      if (!luxonDate.isValid) {
        console.error('Invalid time zone:', timeZone);
        return value; // Return the original value if the time zone is invalid
      }

      // Calculate the time difference in seconds
      const seconds = Math.floor((+new Date() - luxonDate.toMillis()) / 1000);

      if (seconds < 29) {
        return this.translate.transform('Just now');
      }

      const intervals = {
        year: 31536000,
        month: 2592000,
        week: 604800,
        day: 86400,
        hour: 3600,
        minute: 60,
        second: 1,
      };

      let counter;
      for (const i in intervals) {
        counter = Math.floor(seconds / intervals[i]);
        if (counter > 0) {
          if (counter === 1) {
            return counter + ' ' + this.translate.transform(i) + this.translate.transform(' ago');
          } else {
            return counter + ' ' + this.translate.transform(i) + this.translate.transform('s ago');
          }
        }
      }
    }
    return value;
  }
}