import { Pipe, PipeTransform } from '@angular/core';
import { timestart } from '../../data/businesshours';

@Pipe({
  name: 'timeconvertion',
  standalone: true
})
export class TimeconvertionPipe implements PipeTransform {

  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  transform(value: unknown, ...args: unknown[]): unknown {
    const updatedvalue = timestart.filter(e => e.value == value);
    if (updatedvalue.length) {
      return updatedvalue?.[0]?.name;
    }
    return value;
  }

}
