import { Injectable } from '@angular/core';
import { BehaviorSubject, Observable, of } from 'rxjs';

@Injectable({
  providedIn: 'root'
})
export class AuthService {
  public loggedIn = new BehaviorSubject<boolean>(false);
  isLoggedIn$: Observable<boolean> = this.loggedIn.asObservable();

  public userData = new BehaviorSubject<any>(null);
  userData$: Observable<any> = this.userData.asObservable();

  constructor() {}

  login(credentials: any): Observable<boolean> {
    // Handle authentication logic (replace with your implementation)
    if (credentials.username === 'user' && credentials.password === 'password') {
      this.loggedIn.next(true);
      this.userData.next({ username: credentials.username, roles: ['user'] }); // Assume successful login
      return of(true);
    } else {
      // Handle failed login attempt (e.g., display error message)
      return of(false);
    }
  }

  logout() {
    this.loggedIn.next(false);
    this.userData.next(null);
    // Clear any stored tokens or relevant data
  }

  // Additional methods for checking current user, roles, etc.
}