/* eslint-disable @typescript-eslint/ban-types */
import { Injectable } from '@angular/core';
import { Observable, tap } from 'rxjs';
import { HttpClient, HttpParams } from '@angular/common/http';
import { Unsub } from '../../class/unsub.class';
import { AdminService } from './admin.service';
import { LoaderService } from '../loader.service';
import { TranslationService } from '../translation.service';
@Injectable({
  providedIn: 'root',
})
export class LanguagesService extends Unsub {
  public language: any;
  defaultdata: any;
  constructor(private http: HttpClient, private adminService: AdminService, private translationService: TranslationService, loaderService: LoaderService) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
  }

  data: any;

  missingTranslate: string[] = [];
  oldmissingTranslate: string[] = [];
  private _debounceTime = 2000; // milliseconds
  private _lastUpdated: number | null = null;
  addData(value: string) {
    this.missingTranslate.push(value);
    // Delay API call using debounce technique
    const currentTime = new Date().getTime();
    if (this._lastUpdated == null || currentTime - this._lastUpdated > this._debounceTime) {
      this._lastUpdated = currentTime;
      if (this.missingTranslate) {
    const newvalu = this.missingTranslate.filter(item => !this.oldmissingTranslate.includes(item));
    this.oldmissingTranslate = [...this.oldmissingTranslate, ...this.missingTranslate];
    if(newvalu.length){
        this.sendDataToApi(newvalu).subscribe();
      }
    }
    }
  }

  sendDataToApi(newvalu): Observable<any> {
    // Replace with your API endpoint
    const apiUrl = `detail/admin/missingtranslates/`;
    let data = { 'data': newvalu }
    this.missingTranslate = [];
    return this.http.post(apiUrl, data);
  }
  public languages(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/languages/`, { params: params });
  }

  public languagesValues(languag: any): Observable<any> {
    return this.http.get(
      `detail/admin/languages/translates/${languag}`
    );
  }
  public translateFilter(languag: any, parms): Observable<any> {
    let queryParams = new HttpParams();
    queryParams = queryParams.append('search', parms);
    return this.http.get(
      `detail/admin/languages/translates/${languag}`,
      { params: queryParams }
    );
  }
  public translateFilterNotTran(languag: any, key, value): Observable<any> {
    let queryParams = new HttpParams();
    queryParams = queryParams.append(key, value);
    return this.http.get(
      `detail/admin/languages/translates/${languag}`,
      { params: queryParams }
    );
  }
  public translateGroup(languag: any, key): Observable<any> {
    return this.http.get(
      `detail/admin/languages/translate/${languag}/${key}`
    );
  }

  public translateUpdate(id: any, data: any): Observable<any> {
    return this.http.post(`detail/admin/languages/` + id + '/update', data);
  }

  public store(data: any): Observable<any> {
    return this.http
      .post(`detail/admin/languages/store`, data)
      .pipe(
        tap(() => {
          this.adminService.RefreshRquestAdmin$.next();
        })
      );
  }

  public destroy(id: number, data: any): Observable<any> {
    return this.http
      .post(`detail/admin/languages/destroy/${id}`, data)
      .pipe(
        tap(() => {
          this.adminService.RefreshRquestAdmin$.next();
        })
      );
  }

  public editLanguage(id: number): Observable<any> {
    return this.http.get(`detail/admin/languages/edit/${id}`);
  }

  public update(id: number, data: any): Observable<any> {
    return this.http
      .post(`detail/admin/languages/edit/${id}`, data)
      .pipe(
        tap(() => {
          this.adminService.RefreshRquestAdmin$.next();
        })
      );
  }
  public insertLanguage(id, data): Observable<any> {
    return this.http
      .post(`detail/admin/languages/insert/${id}`, data)
      .pipe(
        tap(() => {
          this.adminService.RefreshRquestAdmin$.next();
        })
      );
  }
  public addOnNotFound(id, data): Observable<any> {
    return this.http
      .post(`detail/admin/languages/addOnNotFound/${id}`, data)
      .pipe(
        tap(() => {
          this.adminService.RefreshRquestAdmin$.next();
        })
      );
  }

  public setDefault(id: number): Observable<any> {
    return this.http
      .post(`detail/admin/languages/${id}/default`, id)
      .pipe(
        tap(() => {
          this.adminService.RefreshRquestAdmin$.next();
        })
      );
  }

  public defaultlang(): Observable<any> {
    return this.http.get(`detail/admin/languages/defaultlang`);
  }
}
