import { Injectable } from '@angular/core';
import { BehaviorSubject } from 'rxjs';

@Injectable({
  providedIn: 'root',
})
export class LivechatDataService {

  // Initial data
  private dataSubject = new BehaviorSubject<any>({
    dataUpdate: null,
    typing: null,
    conversationUpdate : null,
    writing : []
  });
  // Observable for the data
  data$ = this.dataSubject.asObservable();

  // Method to update data
  updateData(newData: any) {
    const currentState = this.dataSubject.value;
    this.dataSubject.next({
      ...currentState,
      dataUpdate: newData
    });
  }
  updateConversationData(newData: any) {
    const currentState = this.dataSubject.value;
    const currentData = this.dataSubject.value.conversationUpdate;
    this.dataSubject.next({
      ...currentState,
      conversationUpdate: {...currentData, livechatdata: newData.newconversation && newData?.messageType == "image" ? newData.newconversation :  newData.livechatdata ?? newData?.newconversation?.lastMessage}
    });
  }
  //   this.chatData = { ...this.chatData, livechatdata: res.conversationUpdate };
// Method to append an object to the existing array in dataUpdate
appendData(newItem: any) {
  const currentData = this.dataSubject.value.dataUpdate || [];
  this.dataSubject.next({
    ...this.dataSubject.value,
    dataUpdate: [...currentData, newItem?.newconversation]
  });
}

// Method to update writing
updateWriting(res: any) {
  
  const currentState = this.dataSubject.value;
  let currentUsersTyping = this.dataSubject.value?.writing;
  const index = currentUsersTyping.findIndex(e => e.userId === res.userId);

  if (index !== -1) {
    // User with the same userId exists, so update the existing entry
    currentUsersTyping[index] = res;
  } else {
    // User with the same userId does not exist, so push the new entry
    currentUsersTyping.push(res);
  }
  this.dataSubject.next({
    ...currentState,
    conversationUpdate: {livechatdata: {}},
    writing: currentUsersTyping,
  });
}
  removeWriting(id){
    const currentState = this.dataSubject.value;
    let currentUsersTyping = this.dataSubject.value?.writing;
    currentUsersTyping = currentUsersTyping.filter(e => e.userId != id);
    this.dataSubject.next({
      ...currentState,
      conversationUpdate: {livechatdata: {}},
      writing: currentUsersTyping,
    });
  }
  clearWriting(){
    const currentState = this.dataSubject.value;
    this.dataSubject.next({
      ...currentState,
      conversationUpdate: {livechatdata: {}},
      writing: [],
    });
  }
}
