import { NgModule } from '@angular/core';
import { CommonModule, DatePipe, } from '@angular/common';
import { RouterModule } from '@angular/router';
// layouts 
import { AdminLayoutComponent } from './layouts/admin-layout/admin-layout.component';
import { CustomerLayoutComponent } from './layouts/customer-layout/customer-layout.component';
import { GuestLayoutComponent } from './layouts/guest-layout/guest-layout.component';
// header 
import { AdminHeaderComponent } from './common/header/admin-header/admin-header.component';
import { CustomerHeaderComponent } from './common/header/customer-header/customer-header.component';
// menu 
import { AdminMenuComponent } from './common/menu/admin-menu/admin-menu.component';
import { CustomerMenuComponent } from './common/menu/customer-menu/customer-menu.component';
// backto top 
import { BackToTopComponent } from './common/back-to-top/back-to-top.component';
// footer
import { FooterComponent } from './common/footer/footer.component';
// page header
import { CustomerPageHeaderComponent } from './common/pageheader/customer-page-header/customer-page-header.component';
import { AdminPageHeaderComponent } from './common/pageheader/admin-page-header/admin-page-header.component';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { GuestHeaderComponent } from './common/header/guest-header/guest-header.component';
import { NgScrollbarModule } from 'ngx-scrollbar';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { TranslatePipes } from './pipes/translate/translate.pipe';
import { ManualcaptchaComponent } from './common/includes/manualcaptcha/manualcaptcha.component';
import { TicketviewPageheaderComponent } from './common/pageheader/ticketview-pageheader/ticketview-pageheader.component';
import { HoverEffectSidebarDirective } from './directives/hover-effect-sidebar.directive';
import { RatingPageComponent } from './common/rating-page/rating-page.component';
import { DateAgoPipe } from './pipes/date-ago/date-ago.pipe';
import { CustomerTicketInfoComponent } from './common/includes/customer-ticket-info/customer-ticket-info.component';
import { CustomerFooterComponent } from './common/customer-footer/customer-footer.component';
import { InvokeDirective } from './directives/invoke.directive';
import { ErrorLayoutComponent } from './layouts/error-layout/error-layout.component';
import { RecaptchaModule, RecaptchaV3Module } from 'ng-recaptcha';
import { SidemenuToggleDirective } from './directives/sidemenuToggle';
import { FullscreenDirective } from './directives/fullscreen-toggle.directive';
import { MaterialeModules } from '../material.module';
import { NgSelectModule } from '@ng-select/ng-select';
import { MaxLengthValidatorDirective } from './directives/max-length-validator.directive';
import { ReadMoreComponent } from './common/includes/read-more/read-more.component';
import { ImageUploadComponent } from './common/includes/image-upload/image-upload.component';
import { NgxDropzoneModule } from 'ngx-dropzone';
import { ImageviewComponent } from './common/imageview/imageview.component';
import { EmailtoticketimageurlComponent } from './common/emailtoticketimageurl/emailtoticketimageurl.component';
import { TranslatePipe } from '@ngx-translate/core';
import { AdminTicketTableComponent } from './common/includes/admin-ticket-table/admin-ticket-table.component';
import { MinLengthValidatorDirective } from './directives/min-length-validator.directive';
import { BusinessHourCardComponent } from './common/business-hour-card/business-hour-card.component';

@NgModule({
  declarations: [
    AdminLayoutComponent,
    CustomerLayoutComponent,
    GuestLayoutComponent,
    AdminHeaderComponent,
    AdminMenuComponent,
    CustomerMenuComponent,
    BackToTopComponent,
    FooterComponent,
    GuestHeaderComponent,
    ManualcaptchaComponent,
    TicketviewPageheaderComponent,
    HoverEffectSidebarDirective,
    RatingPageComponent,
    CustomerFooterComponent,
    InvokeDirective,
    SidemenuToggleDirective,
    FullscreenDirective,
    ErrorLayoutComponent,
    ReadMoreComponent,
    ImageviewComponent,
    EmailtoticketimageurlComponent,
  ],
  imports: [
    MinLengthValidatorDirective,
    MaxLengthValidatorDirective,
    ImageUploadComponent,
    AdminPageHeaderComponent,
    AdminTicketTableComponent,
    CustomerHeaderComponent,
    CustomerTicketInfoComponent,
    TranslatePipes,DateAgoPipe,
    CommonModule,
    RouterModule,
    FormsModule,
    ReactiveFormsModule,
    NgScrollbarModule,
    NgbModule,
    RecaptchaModule,
    RecaptchaV3Module,
    MaterialeModules,
    NgSelectModule,
    NgxDropzoneModule,
    BusinessHourCardComponent,
    CustomerPageHeaderComponent,
  ],
  providers:[TranslatePipe, DatePipe],
  exports:[
    ManualcaptchaComponent,
    TicketviewPageheaderComponent,
    CustomerMenuComponent,
    FormsModule,
    ReactiveFormsModule,
    ReadMoreComponent,    
    ImageviewComponent,
    BackToTopComponent,
    CustomerFooterComponent, 
  ]
})
export class SharedModule { }
