<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Ticket\Ticket;
use App\Models\User;
use Auth;
use App\Models\tickethistory;

use App\Notifications\TicketAssignNotification;
use laravelLara\infoinst\Jobs\MailSend;
use Torann\GeoIP\Facades\GeoIP;
use App\Models\EmployeeActivity;
use Jenssegers\Agent\Agent;

class AdminAssignedticketsController extends Controller
{

    public function create(Request $request)
    {
        $this->validate($request, [
            'assigned_user_id' => 'required',
        ]);

        $calID = Ticket::find($request->assigned_id);
        $calID->myassignuser_id     = Auth::id();
        $calID->selfassignuser_id = null;
        $calID->save();

        $calID->ticketassignmutliple()->sync($request->assigned_user_id);

        // user informatiom
        $users = User::with('roles')->where('status', 1)->findOrFail($request->assigned_user_id);
        $tickethistory = new tickethistory();
        $tickethistory->ticket_id = $calID->id;

        $tickethistory->ticketnote = $calID->ticketnote->isNotEmpty();
        $tickethistory->overduestatus = $calID->overduestatus;
        $tickethistory->ticketviolation = $calID->ticketviolation;
        $tickethistory->currentAction = null;
        $tickethistory->username = Auth::user()->name;
        $tickethistory->assigned_date = today();
        $tickethistory->assigned_time = now();
        $tickethistory->type = Auth::user()->getRoleNames()[0];
        $tickethistory->status = $calID->status;
        $tickethistory->replystatus = $calID->replystatus;
        $tickethistory->assignUser = $users;

        $tickethistory->save();



        $ticketData = [
            'ticket_username' => $calID->cust->username,
            'ticket_id' => $calID->ticket_id,
            'ticket_title' => $calID->subject,
            'ticket_description' => $calID->message,
            'ticket_customer_url' => url('/guest/ticketdetails/', encrypt($calID->ticket_id)),
            'ticket_admin_url' => url('/admin/ticket-view/' . encrypt($calID->ticket_id)),
            'ticket_category' => $calID->category ? $calID->category->name : '',
            'status' => $calID->status
        ];


        try {
            $assignee = $calID->ticketassignmutliples->pluck('toassignuser_id');
            $admins = User::whereIn('id', $assignee)->get();
            $admins->filter(function ($users)   use ($calID, $ticketData) {
                $users->notify(new TicketAssignNotification($calID));
                if ($users->usetting->emailnotifyon == 1) {
                    dispatch((new MailSend($users, 'when_ticket_assign_to_other_employee', $ticketData)));
                }
            });
        } catch (\Exception $e) {

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Assigned ticket to other employees.';
            $activity->ticket_id = $tickethistory->ticket_id;
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();
            return response()->json(['code' => 200, 'success' => 'The ticket was successfully assigned.'], 200);
        }
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Assigned ticket to other employees.';
        $activity->ticket_id = $tickethistory->ticket_id;
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        if (webSocketCheck()) {
            try {
                event(new \App\Events\ConversationEvent(dbname(), null, null, null, null, null, 'tableDataReload', null, null));
                event(new \App\Events\ConversationEvent(dbname(), null, null,  Auth::user()->id, null, null, 'otherAssigned', $calID->ticket_id, 'null'));
            } catch (\Exception $e) {
            }
        }

        return response()->json(['code' => 200, 'success' => 'The ticket was successfully assigned.'], 200);
    }


    public function show(Request $req, $id)
    {


        $output = [];

        $id = decrypt($id);
        $assign = Ticket::find($id);
        $assugnuser_id = $assign->ticketassignmutliples->pluck('toassignuser_id')->toArray();

        $users = User::with('roles')->where('status', 1)->get();

        $total_row = $users->count();

        if ($total_row > 0) {

            foreach ($users as $row) {
                if (Auth::user()->id != $row->id) {
                    array_push($output, $row);
                }
            }
        }

        $data = array(
            'assign_user_exist' => !empty($assugnuser_id) ? 'yes' : 'no',
            'assign_data' => $assign,
            'table_data' => in_array(Auth::user()->id, $assugnuser_id) ? $users : $output,
            'total_data' => $total_row,
            'currentUserId' => Auth::user()->id,
            'assugnuser_id' => $assugnuser_id
        );
        return $data;
    }

    public function update(Request $req, $id)
    {
        $id = decrypt($id);

        $calID = Ticket::find($id);
        $calID->myassignuser_id     = null;
        $calID->selfassignuser_id = null;
        $calID->save();
        $calID->ticketassignmutliple()->detach($req->assigned_userid);

        $tickethistory = new tickethistory();
        $tickethistory->ticket_id = $calID->id;

        $tickethistory->ticketnote = $calID->ticketnote->isNotEmpty();
        $tickethistory->overduestatus = $calID->overduestatus;
        $tickethistory->ticketviolation = $calID->ticketviolation;
        $tickethistory->status = $calID->status;
        $tickethistory->replystatus = $calID->replystatus;
        $tickethistory->currentAction = 'UnAssigned Ticket';
        $tickethistory->username = Auth::user()->name;
        $tickethistory->type = Auth::user()->getRoleNames()[0];
        $tickethistory->assignUser = null;

        $tickethistory->save();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Unassigned a ticket.';
        $activity->ticket_id = $tickethistory->ticket_id;
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        if (webSocketCheck()) {
            try {
                event(new \App\Events\ConversationEvent(dbname(), null, null, null, null, null, 'tableDataReload', null, null));
            } catch (\Exception $e) {
            }
        }

        return response()->json(['data' => $calID, 'success' => 'Updated successfully']);
    }
}
