<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Ticket\Category;
use App\Models\Articles\Article;
use App\Models\Apptitle;
use App\Models\Pages;
use App\Models\Subcategory;
use File;
use Illuminate\Support\Str;
use Auth;
use App\Models\Ticket\Ticket;
use App\Models\User;
use Illuminate\Support\Facades\Schema;
use Spatie\MediaLibrary\MediaCollections\Models\Media;
use Spatie\Permission\Models\Role;
use Jenssegers\Agent\Agent;
use Torann\GeoIP\Facades\GeoIP;
use App\Models\EmployeeActivity;
use App\Models\Subcategorychild;

class ArticlesController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        $this->authorize('Article Access');

        $searchTerm = $request['filter'] ?? null;
        $perPage    = $request['per_page'] ?? 15;
        $page       = $request['page'] ?? 1;
        $article = Article::with(['category' => function ($query) use ($searchTerm) {
            $query->whereIn('display', ['knowledge', 'both'])->where('status', '1');
        }])->latest('updated_at');
        if ($searchTerm) {
            $article->where(function ($query) use ($searchTerm) {
                $columns = Schema::getColumnListing('articles');
                foreach ($columns as $column) {
                    $query->orWhere($column, 'LIKE', "%{$searchTerm}%");
                }
                $query->orWhereHas('category', function ($query) use ($searchTerm) {
                    $query->where('name', 'LIKE', "%{$searchTerm}%");
                });
            });
        }
        $items = $article->paginate($perPage);
        $data['queryList'] = $items;
        $data['article'] = $article;


        $basic = Apptitle::first();
        $data['basic'] = $basic;
        $user = User::with('usetting')->findOrFail(Auth::user()->id);
        $role = Role::where('name', $user->getRoleNames()[0])->get();
        foreach ($role as $roles) {
            $data['permissions'] = $roles->getPermissionNames();
        }

        return $data;
        return $data;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('Article Create');
        $category = Category::whereIn('display', ['knowledge', 'all'])->where('status', '1')
            ->get();
        $data['category'] = $category;


        $data['setting'] = response()->json([
            'ENVATO_ON' => setting('ENVATO_ON'),
            'cc_email' => setting('cc_email'),
            'FILE_UPLOAD_MAX' => setting('FILE_UPLOAD_MAX'),
            'MAX_FILE_UPLOAD' => setting('MAX_FILE_UPLOAD'),
            'FILE_UPLOAD_TYPES' => setting('FILE_UPLOAD_TYPES'),
            'TICKET_CHARACTER' => setting('TICKET_CHARACTER'),
            'USER_FILE_UPLOAD_TYPES' => setting('USER_FILE_UPLOAD_TYPES'),
        ]);
        return $data;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $this->authorize('Article Create');

        $this->validate($request, [
            'message' => ['required',  function ($attribute, $value, $fail) {
                // Remove all HTML tags and decode entities like &nbsp;
                $decodedValue = html_entity_decode(strip_tags($value));

                // Replace non-breaking spaces (\u{A0}) with regular spaces
                $normalizedValue = str_replace("\u{A0}", ' ', $decodedValue);

                // Trim spaces and check if the result is empty
                if (trim($normalizedValue) === '') {
                    $fail('The comment must contain valid text, not just spaces or HTML.');
                }
            }]
        ]);
        
        $this->validate($request, [
            'title' => 'required|string|max:120',
            'category' => 'required',
            'message' => 'required',
            'tags' => 'required',
            'status' => 'required|in:Published,UnPublished',
        ]);
        $comment = $request->input('message');

        // Trim unwanted tags from the start and end
        $comment = preg_replace('/^(<(p|div)><br><\/(p|div)>)+|(<(p|div)><br><\/(p|div)>)+$/', '', $comment);


        $article = new Article();
        $article->title = $request->input('title');
        $article->category_id = $request->input('category');
        $article->message = $comment;
        $article->status = $request->input('status');
        $article->tags = $request->input('tags');
        $article->subcategory = $request->input('subscategory');
        $article->privatemode = $request->input('privatemode') != 'true' ? 0 : 1;


        $article->save();
        // $file = $request->featureimage;

        // $fileinput = public_path('uploads/featureimage/' . $file);
        // $article->featureimage = $file;
        // $article->storage_disk = storage()->storage_disk;


        if ($request->featureimage) {
            $file = $request->file('featureimage');

            $name = $file->getClientOriginalName();

            $provider = storage()->provider;
            $provider::uploadImage($file, '/uploads/featureimage/', $name);


            $article->featureimage = $name;
            $article->storage_disk = storage()->storage_disk;

            $article->save();
        }

        $articlefind = Article::where('articleslug', Str::slug($request->input('title'), '-'))->first();

        if (!$articlefind) {
            $articlefinds = Article::find($article->id);
            $articlefinds->articleslug = Str::slug($request->input('title'), '-');
            $articlefinds->update();
        }
        if ($articlefind) {
            $articlefinds = Article::find($article->id);
            if ($articlefinds->articleslug == null) {
                $articlefinds->articleslug = Str::slug($request->input('title'), '-') . '-' . $articlefind->id;
                $articlefinds->update();
            }
        }

        foreach ($request->file('article', []) as $file) {
            $provider =  storage()->provider;
            $provider::mediaupload($article, $file, 'article');
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Created a new article';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => 'A new article was successfully created.'], 200);
    }

    public function featureimagestoreMedia(Request $request)
    {

        if ($request->file('file')) {

            $file = $request->file('file');

            $name = $file->getClientOriginalName();

            $provider = storage()->provider;
            $provider::uploadImage($file, '/uploads/featureimage/', $name);


            return response()->json([
                'name'          => $name,
                'original_name' => $file->getClientOriginalName(),
            ]);
        }
    }
    public function storeMedia(Request $request)
    {
        if ($request->file('file')) {
            $path = public_path('uploads\article');
            if (!file_exists($path)) {
                mkdir($path, 0777, true);
            }

            $file = $request->file('file');

            $name = uniqid() . '_' . trim($file->getClientOriginalName());

            $file->move($path, $name);

            return response()->json([
                'name'          => $name,
                'original_name' => $file->getClientOriginalName(),
            ]);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $this->authorize('Article Edit');

        $article = Article::where('id', $id)->firstOrFail();
        $conversionsDisk = $article->storage_disk ?? 'public';
        $provider = existprovider($conversionsDisk)->provider;
        if ($article->featureimage) {
            $imageUrl = $provider::getimage('uploads/featureimage/' . $article->featureimage);
            // Only set the "profileimage" attribute if it's not already set
            if (!isset($article['profileimage'])) {
                $article['profileimage'] = $imageUrl;
            }
        }

        $data['article'] = $article;
        $category = Category::whereIn('display', ['knowledge', 'all'])->where('status', '1')->get();
        $data['category'] = $category;
        $subcategory = Subcategory::where('status', '1')
            ->whereHas('subcategorylist', function ($query) use ($article) {
                $query->where('category_id', $article->category_id);
            })
            ->get();

        $data['subcategory'] = $subcategory;
        $data['assetpath'] = public_path('uploads/article/');
        $post = Pages::all();
        $data['page'] = $post;

        $media = $article->getMedia('article')->all();
        // Now, iterate through each comment and add the profile image information
        foreach ($media as $comment) {
            $conversionsDisk = $comment->conversions_disk ?? 'public';
            $provider = existprovider($conversionsDisk)->provider;
            $imageUrl = $provider::getImageUrl($comment->id . '/' . $comment->file_name);

            // Only set the "profileimage" attribute if it's not already set
            if (!isset($comment['profileimage'])) {
                $comment['profileimage'] = $imageUrl;
            }
        }
        $data['media'] = $media;
        $data['setting'] = response()->json([
            'ENVATO_ON' => setting('ENVATO_ON'),
            'FILE_UPLOAD_MAX' => setting('FILE_UPLOAD_MAX'),
            'MAX_FILE_UPLOAD' => setting('MAX_FILE_UPLOAD'),
            'FILE_UPLOAD_TYPES' => setting('FILE_UPLOAD_TYPES'),
            'TICKET_CHARACTER' => setting('TICKET_CHARACTER'),
            'USER_FILE_UPLOAD_TYPES' => setting('USER_FILE_UPLOAD_TYPES'),
        ]);
        return $data;
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $this->authorize('Article Edit');
        

        $this->validate($request, [
            'message' => ['required',  function ($attribute, $value, $fail) {
                // Remove all HTML tags and decode entities like &nbsp;
                $decodedValue = html_entity_decode(strip_tags($value));

                // Replace non-breaking spaces (\u{A0}) with regular spaces
                $normalizedValue = str_replace("\u{A0}", ' ', $decodedValue);

                // Trim spaces and check if the result is empty
                if (trim($normalizedValue) === '') {
                    $fail('The comment must contain valid text, not just spaces or HTML.');
                }
            }]
        ]);

        $request->validate([
            'title' => 'required|string|max:120',
            'category' => 'required',
            'message' => 'required',
            'status' => 'required',

        ]);

        $article = Article::findOrFail($id);

        $comment = $request->input('message');

        // Trim unwanted tags from the start and end
        $comment = preg_replace('/^(<(p|div)><br><\/(p|div)>)+|(<(p|div)><br><\/(p|div)>)+$/', '', $comment);

        $article->title = $request->input('title');
        $article->category_id = $request->input('category');
        $article->message = $comment;
        $article->status = $request->input('status');
        $article->tags = $request->input('tags');
        $article->subcategory = $request->input('subscategory');
        $article->privatemode = $request->input('privatemode') != 'true' ? 0 : 1;

        $articlefind = Article::where('articleslug', Str::slug($request->input('title'), '-'))->first();

        if (!$articlefind) {
            if ($article->articleslug == null) {
                $article->articleslug = Str::slug($request->input('title'), '-');
            }
        }
        if ($articlefind) {

            if ($article->articleslug == null) {
                $article->articleslug = Str::slug($request->input('title'), '-') . '-' . $article->id;
            }
        }

        if ($request->featureImgRemoved) {
            $article->featureimage = null;
        }
        if ($request->articleRemoved) {
            foreach (explode(',', $request->articleRemoved) as $id) {
                $commentss = Media::findOrFail($id);
                $commentss->delete();
            }
        }
        if ($request->featureimage) {
            $file = $request->file('featureimage');
            $provider  = existprovider($article->storage_disk ?? 'public')->provider;
            $provider::delete('/uploads/featurebox/' . $article->featureimage);

            $name = $file->getClientOriginalName();

            $provider = storage()->provider;
            $provider::uploadImage($file, '/uploads/featureimage/', $name);


            $article->featureimage = $name;
            $article->storage_disk = storage()->storage_disk;

            $article->save();
        }
        $article->update();
        $media = $article->getMedia('article');
        if ($request->file('article', [])) {
            foreach ($request->file('article', []) as $file) {
                $provider =  storage()->provider;
                $provider::mediaupload($article, $file, 'article');
            }
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Updated article';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => 'Updated successfully']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $this->authorize('Article Delete');
        $article = Article::findOrFail($id);
        $media = $article->getMedia('article');

        foreach ($media as $media) {

            $media->delete();
        }
        $article->delete();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Deleted ' . $article->title . 'article';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => 'The article was successfully deleted.']);
    }

    public function articlemassdestroy(Request $request)
    {
        $student_id_array = $request->input('id');

        $articles = Article::whereIn('id', $student_id_array)->get();

        foreach ($articles as $article) {

            foreach ($article->getMedia('article') as $media) {

                $media->delete();
            }
            $article->delete();
        }
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Deleted multiple articles';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['success' => 'The article was successfully deleted.']);
    }

    public function article(Request $request)
    {

        $request->validate([
            'articletitle' => 'required',
        ]);
        $calID = ['id' => $request->id];
        $calldetails = [
            'articletitle' => $request->articletitle,
            'articlesub' => $request->articlesub,
            'articlecheck'  => $request->has('articlecheck') ? 'on' : 'off',

        ];

        $callaction = Apptitle::updateOrCreate(
            ['id' => $calID],
            $calldetails
        );

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Updated article';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => 'Updated successfully']);
    }


    public function status(Request $request, $id)
    {
        $calID = Article::find($id);
        $calID->status = $request->status;
        $calID->save();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Changed article status';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['code' => 200, 'success' => 'Updated successfully'], 200);
    }

    public function privatestatus(Request $request, $id)
    {
        $calID = Article::find($id);
        $calID->privatemode = $request->privatemode;

        $calID->save();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Changed private status of article';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['code' => 200, 'success' => 'Updated successfully'], 200);
    }



    public function featureimage(Request $request, $id)
    {
        $calID = Article::find($id);
        $calID->featureimage = null;
        $calID->save();
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Changed article feature image';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['code' => 200, 'success' => 'Updated successfully'], 200);
    }

    public function ticketarticle($ticket, $comment)
    {

        $category = Category::whereIn('display', ['knowledge', 'all'])->where('status', '1')->get();
        $data['category'] = $category;

        $ticket = decrypt($ticket);
        $articleticket = Ticket::where('ticket_id', $ticket)->first();
        $data['articleticket'] = $articleticket;
        $subcategory = Subcategory::where('status', '1')
            ->whereHas('subcategorylist', function ($query) use ($articleticket) {
                if ($articleticket) {
                    $query->where('category_id', $articleticket->category_id);
                }
            })
            ->get();
        $data['subcategory'] = $subcategory;

        $finalcomment = [];
        $com = explode(',', $comment);
        foreach ($articleticket->comments as $co) {
            if (in_array($co->id, $com)) {
                array_push($finalcomment, $co->comment);
            }
        }
        $data['finalcomment'] = $finalcomment;

        $data['setting'] = response()->json([
            'ENVATO_ON' => setting('ENVATO_ON'),
            'FILE_UPLOAD_MAX' => setting('FILE_UPLOAD_MAX'),
            'MAX_FILE_UPLOAD' => setting('MAX_FILE_UPLOAD'),
            'FILE_UPLOAD_TYPES' => setting('FILE_UPLOAD_TYPES'),
            'TICKET_CHARACTER' => setting('TICKET_CHARACTER'),
            'USER_FILE_UPLOAD_TYPES' => setting('USER_FILE_UPLOAD_TYPES'),
        ]);

        return $data;
    }
}
