<?php

namespace App\Http\Controllers\Admin\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\ResetsPasswords;
use Illuminate\Http\Request;
use App\Models\User;
use Hash;
use DB;
use App\Models\Announcement;
use App\Models\Apptitle;
use App\Models\Holiday;
use Carbon\Carbon;

class ResetPasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset requests
    | and uses a simple trait to include this behavior. You're free to
    | explore this trait and override any methods you wish to tweak.
    |
    */

    use ResetsPasswords;

    /**
     * Where to redirect users after resetting their password.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;


    public function showResetForm(Request $request, $token){

        
        $title = Apptitle::first();
        $data['title'] = $title;
        
        $users = DB::table('password_resets')->where('token', $token)->first();
        $data['users'] = $users;
        
        $data['session'] = session('status');
        
        $now = now();
        $announcement = announcement::whereDate('enddate', '>=', $now->toDateString())->whereDate('startdate', '<=', $now->toDateString())->get();
        $data['announcement'] = $announcement;

        $announcements = Announcement::whereNotNull('announcementday')->get();
        $data['announcements'] = $announcements;

       // $holidays = Holiday::whereDate('startdate', '<=', $now->toDateString())->whereDate('enddate', '>=', $now->toDateString())->where('status', '1')->get();
        // $data['holidays'] =  $holidays;

        $now = now();
        $currentYear = $now->year;
        $activeHolidays = Holiday::where('status', 1)->get();

       
        $data['holidays'] = $activeHolidays->filter(function ($holiday) use ($now, $currentYear) {
            $holidayStart = Carbon::parse($holiday->startdate);
            $holidayEnd = Carbon::parse($holiday->enddate);
            if ($holiday->is_fixed) {
                return $holidayStart->month === $now->month && $holidayStart->day === $now->day;
            }
            return $holidayStart->isSameDay($now);
        });

        $data['token'] = $request->route()->parameter('token');
        
        return $data;
    }

    public function reset(Request $request){

        $request->validate([
            'email' => 'required|email|exists:users',
            'password' => 'required|string|min:8|confirmed',
            'password_confirmation' => 'required',
      
        ]);
      
        $updatePassword = DB::table('password_resets')
                        ->where(['email' => $request->email, 'token' => $request->token])
                        ->first();
      
        if(!$updatePassword)
        return back()->withInput()->with('error', 'Invalid token!');
    
        $user = User::where('email', $request->email)->first();
        
		if (Hash::check($request->password, $user->password)) {
			return response()->json(['error' => 'Your New password cannot be same as your old password!']);
		}
        
        if($user->password == null){
    
            $user->update(['password' => Hash::make($request->password)]);
    
        }else{
            
            $user->update(['password' => Hash::make($request->password)]);
        }
      
        DB::table('password_resets')->where(['email'=> $request->email])->delete();
      
        return response()->json(['success' => 'Your password has been changed!']);
      

    }
}
