<?php

namespace App\Http\Controllers\Admin;

use App\Events\ConversationEvent;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Ticket\Comment;
use App\Models\Ticket\Ticket;
use App\Models\User;
use App\Models\Customer;
use App\Jobs\SendSMS;
use Auth;
use Spatie\MediaLibrary\MediaCollections\Models\Media;
use App\Notifications\TicketCreateNotifications;
use Mail;
use App\Models\Ratingtoken;
use App\Models\CCMAILS;
use App\Models\tickethistory;
use App\Models\Groups;
use App\Models\EmailTemplate;
use App\Models\Imap_setting;
use App\Models\TicketDraft;
use Illuminate\Support\Facades\Session;
use laravelLara\infoinst\Jobs\MailSend;
use Symfony\Component\Mime\Email;
use App\Notifications\TicketDraftNotification;
use Jenssegers\Agent\Agent;
use Torann\GeoIP\Facades\GeoIP;
use App\Models\EmployeeActivity;

class CommentsController extends Controller
{
    public function ticketdraftimage(Request $request, $id)
    {
        $im = Media::find($id);
        if ($im) {
            $im->delete();

            return response()->json(['success' => 'The image is deleted successfully.']);
        } else {
            abort(404);
        }
    }

    public function ticketdraft(Request $request)
    {
        $this->validate($request, [
            'comment' => ['required',  function ($attribute, $value, $fail) {
                // Remove all HTML tags and decode entities like &nbsp;
                $decodedValue = html_entity_decode(strip_tags($value));

                // Replace non-breaking spaces (\u{A0}) with regular spaces
                $normalizedValue = str_replace("\u{A0}", ' ', $decodedValue);

                // Trim unwanted tags from the start and end
                $normalizedValue = preg_replace('/^(<(p|div)><br><\/(p|div)>)+|(<(p|div)><br><\/(p|div)>)+$/', '', $normalizedValue);
                // Trim spaces and check if the result is empty
                if (trim($normalizedValue) === '') {
                    $fail('The comment must contain valid text, not just spaces or HTML.');
                }
            }]
        ]);

        $this->validate($request, [
            'ticket_id' => 'required',
            'comment' => 'required'
        ]);

        $draftiId = $request->draft_id;
        $comment = preg_replace('/^(<(p|div)><br><\/(p|div)>)+|(<(p|div)><br><\/(p|div)>)+$/', '', $request->comment);

        $draftdata =  [
            'ticket_id' => $request->ticket_id,
            'description' => $request->comment,
        ];

        $ticketdraft = TicketDraft::updateOrCreate(['id' => $draftiId], $draftdata);

        foreach ($request->file('comments', []) as $file) {
            $provider =  storage()->provider;
            $provider::mediaupload($ticketdraft, $file, 'ticketdrafts');
        }
        if ($request->mediaRemoved) {
            foreach (explode(',', $request->mediaRemoved) as $id) {
                $commentss = Media::findOrFail($id);
                $commentss->delete();
            }
        }
        $ticket = Ticket::findOrFail($request->ticket_id);

        $tickethistory = new tickethistory();
        $tickethistory->ticket_id = $ticket->id;

        $tickethistory->ticketnote = $ticket->ticketnote->isNotEmpty();
        $tickethistory->ticketviolation = $ticket->ticketviolation;
        $tickethistory->overduestatus = $ticket->overduestatus;
        $tickethistory->status = $ticket->status;
        $tickethistory->replystatus = $ticket->replystatus;
        $tickethistory->currentAction = $draftiId ? 'Tiket Draft Modified' : 'Tiket Draft Created';

        // if ($draftiId != null && $draftiId != undefined) {
        //     $tickethistory->currentAction = 'Tiket Draft Modified';
        // } 
        // else{
        //     $tickethistory->currentAction = 'Tiket Draft Created';
        // }
        $tickethistory->username = Auth::user()->name;
        $tickethistory->type = Auth::user()->getRoleNames()[0];
        $tickethistory->assignUser = null;

        $tickethistory->save();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Created a Ticket Draft';
        $activity->ticket_id =  $ticket->ticket_id;
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Created a Ticket Draft';
        $activity->ticket_id =  $ticket->ticket_id;
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        if ($draftiId == null) {
            $ticketData = [
                'username' => Auth::user()->name,
                'ticket_id' => $ticket->ticket_id,
                'ticket_description' => $request->comment,
                'created_or_respond' => 'Created',
                'ticket_admin_url' => url('/admin/ticket-view/' . encrypt($ticket->ticket_id)),
                'ticket_category' => $ticket->category ? $ticket->category->name : null,
                'status' => $ticket->status
            ];
        } else {
            $ticketData = [
                'username' => Auth::user()->name,
                'ticket_id' => $ticket->ticket_id,
                'ticket_description' => $request->comment,
                'created_or_respond' => 'Updated',
                'ticket_admin_url' => url('/admin/ticket-view/' . encrypt($ticket->ticket_id)),
            ];
        }

        try {
            $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->where('users.status', 1)->get();


            if ($ticket->category) {
                $notificationcat = $ticket->category->groupscategoryc()->get();
                $groupIds = $notificationcat->pluck('group_id')->toArray();
                $groupstatus = false;
                foreach ($groupIds as $groupid) {
                    $groupexist = Groups::where('groupstatus', '1')->find($groupid);
                    if ($groupexist) {
                        $groupstatus = true;
                    }
                }

                $icc = array();

                if ($groupstatus) {

                    foreach ($notificationcat as $igc) {
                        $groups = $igc->groupsc()
                            ->where('groupstatus', 1)
                            ->with('groupsuser')
                            ->get();

                        foreach ($groups as $group) {
                            $users = $group->groupsuser;

                            foreach ($users as $user) {
                                $icc[] = $user->users_id;
                            }
                        }
                    }

                    if (!$icc) {
                        $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->where('users.status', 1)->get();

                        foreach ($admins as $admin) {
                            if ($admin->id != Auth::id()) {
                                $admin->notify(new TicketDraftNotification($ticketData));
                                if ($admin->getRoleNames()[0] == 'superadmin' && $admin->usetting->emailnotifyon == 1) {
                                    dispatch((new MailSend($admin->email, 'Send_email_to_admin_when_ticket_draft_created', $ticketData)));
                                }
                            }
                        }
                    } else {

                        if ($ticket->myassignuser_id) {
                            $assignee = $ticket->ticketassignmutliples;
                            foreach ($assignee as $assignees) {
                                $user = User::where('id', $assignees->toassignuser_id)->where('status', 1)->get();
                                foreach ($user as $users) {
                                    if ($users->id != Auth::id()) {
                                        $users->notify(new TicketDraftNotification($ticketData));
                                        if ($users->id == $assignees->toassignuser_id && $users->usetting->emailnotifyon == 1) {
                                            dispatch((new MailSend($users->email, 'Send_email_to_admin_when_ticket_draft_created', $ticketData)));
                                        }
                                    }
                                }
                            }
                            $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->where('users.status', 1)->get();

                            foreach ($admins as $admin) {
                                if ($admin->id != Auth::id()) {
                                    $admin->notify(new TicketDraftNotification($ticketData));
                                    if ($admin->getRoleNames()[0] == 'superadmin' && $admin->usetting->emailnotifyon == 1) {
                                        dispatch((new MailSend($admin->email, 'Send_email_to_admin_when_ticket_draft_created', $ticketData)));
                                    }
                                }
                            }
                        } else if ($ticket->selfassignuser_id) {

                            $self = User::where('status', 1)->findOrFail($ticket->selfassignuser_id);
                            if ($self->id != Auth::id()) {
                                $self->notify(new TicketDraftNotification($ticketData));
                                if ($self->usetting->emailnotifyon == 1) {
                                    dispatch((new MailSend($self->email, 'Send_email_to_admin_when_ticket_draft_created', $ticketData)));
                                }
                            }

                            $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->where('users.status', 1)->get();

                            foreach ($admins as $admin) {
                                if ($admin->id != Auth::id()) {
                                    $admin->notify(new TicketDraftNotification($ticketData));
                                    if ($admin->getRoleNames()[0] == 'superadmin' && $admin->usetting->emailnotifyon == 1) {
                                        dispatch((new MailSend($admin->email, 'Send_email_to_admin_when_ticket_draft_created', $ticketData)));
                                    }
                                }
                            }
                        } else if ($icc) {

                            $user = User::whereIn('id', $icc)->where('status', 1)->get();

                            foreach ($user as $users) {
                                if ($users->id != Auth::id()) {
                                    $users->notify(new TicketDraftNotification($ticketData));
                                    if ($users->usetting->emailnotifyon == 1) {
                                        dispatch((new MailSend($users->email, 'Send_email_to_admin_when_ticket_draft_created', $ticketData)));
                                    }
                                }
                            }

                            $superAdmins = User::where('status', 1)->whereHas('roles', function ($query) {
                                $query->where('name', 'superadmin');
                            })->get();

                            foreach ($superAdmins as $admin) {
                                $admin->notify(new TicketDraftNotification($ticketData));
                                if ($admin->usetting->emailnotifyon == 1) {
                                    dispatch((new MailSend($admin->email, 'admin_send_email_ticket_created', $ticketData)));
                                }
                            }
                        } else {
                            $users = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->where('users.status', 1)->get();
                            foreach ($users as $user) {
                                if ($user->id != Auth::id()) {
                                    $user->notify(new TicketDraftNotification($ticketData));
                                    if ($user->usetting->emailnotifyon == 1) {
                                        dispatch((new MailSend($user->email, 'Send_email_to_admin_when_ticket_draft_created', $ticketData)));
                                    }
                                }
                            }
                        }
                    }
                } else {
                    if ($ticket->myassignuser) {
                        $assignee = $ticket->ticketassignmutliples;
                        foreach ($assignee as $assignees) {
                            $user = User::where('id', $assignees->toassignuser_id)->where('status', 1)->get();
                            foreach ($user as $users) {
                                if ($users->id != Auth::id()) {
                                    $users->notify(new TicketDraftNotification($ticketData));
                                    if ($users->id == $assignees->toassignuser_id && $users->usetting->emailnotifyon == 1) {
                                        dispatch((new MailSend($users->email, 'Send_email_to_admin_when_ticket_draft_created', $ticketData)));
                                    }
                                }
                            }
                        }
                        $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->where('users.status', 1)->get();
                        foreach ($admins as $admin) {
                            if ($admin->id != Auth::id()) {
                                $admin->notify(new TicketDraftNotification($ticketData));
                                if ($admin->getRoleNames()[0] == 'superadmin' && $admin->usetting->emailnotifyon == 1) {
                                    dispatch((new MailSend($admin->email, 'Send_email_to_admin_when_ticket_draft_created', $ticketData)));
                                }
                            }
                        }
                    } else if ($ticket->selfassignuser_id) {
                        $self = User::findOrFail($ticket->selfassignuser_id);
                        if ($self->id != Auth::id()) {
                            $self->notify(new TicketDraftNotification($ticketData));
                            if ($self->usetting->emailnotifyon == 1) {
                                dispatch((new MailSend($self->email, 'Send_email_to_admin_when_ticket_draft_created', $ticketData)));
                            }
                        }
                        $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->where('users.status', 1)->get();
                        foreach ($admins as $admin) {
                            if ($admin->id != Auth::id()) {
                                $admin->notify(new TicketDraftNotification($ticketData));
                                if ($admin->getRoleNames()[0] == 'superadmin' && $admin->usetting->emailnotifyon == 1) {
                                    dispatch((new MailSend($admin->email, 'Send_email_to_admin_when_ticket_draft_created', $ticketData)));
                                }
                            }
                        }
                    } else {
                        foreach (usersdata() as $user) {
                            if ($user->id != Auth::id()) {
                                $user->notify(new TicketDraftNotification($ticketData));
                                if ($user->usetting->emailnotifyon == 1) {
                                    dispatch((new MailSend($user->email, 'Send_email_to_admin_when_ticket_draft_created', $ticketData)));
                                }
                            }
                        }
                    }
                }
            } else {
                $user = User::where('id', $ticket->lastreply_mail)->where('status', 1)->get();
                foreach ($user as $users) {
                    if ($users->id != Auth::id()) {
                        $users->notify(new TicketDraftNotification($ticketData));
                        if ($users->usetting->emailnotifyon == 1) {
                            dispatch((new MailSend($users->email, 'Send_email_to_admin_when_ticket_draft_created', $ticketData)));
                        }
                    }
                }
            }
        } catch (\Exception $e) {
            return response()->json(['success' => lang('The ticket Draft was successfully created.', 'alerts')]);
        }

        if (webSocketCheck()) {
            try {
                event(new \App\Events\ConversationEvent(dbname(), null, null, null, null, null, 'tableDataReload', null));
            } catch (\Exception $e) {
                Log::error('Error dispatching WebSocket event: ' . $e->getMessage());
            }
        }

        return response()->json(['success' => 'The ticket Draft was successfully created.']);
    }

    public function draftdelete(Request $request)
    {

        $ticketdraft = TicketDraft::find($request->id);

        $ticket = Ticket::find($ticketdraft->ticket_id);
        $tickethistory = new tickethistory();
        $tickethistory->ticket_id = $ticket->id;

        $tickethistory->ticketnote = $ticket->ticketnote->isNotEmpty();
        $tickethistory->ticketviolation = $ticket->ticketviolation;
        $tickethistory->overduestatus = $ticket->overduestatus;
        $tickethistory->status = $ticket->status;
        $tickethistory->replystatus = $ticket->replystatus;
        $tickethistory->currentAction = 'Tiket Draft deleted';
        $tickethistory->username = Auth::user()->name;
        $tickethistory->type = Auth::user()->getRoleNames()[0];
        $tickethistory->assignUser = null;
        $tickethistory->save();

        if (webSocketCheck()) {
            try {
                event(new \App\Events\ConversationEvent(dbname(), null, null, null, null, null, 'tableDataReload', null, null));
            } catch (\Exception $e) {
                Log::error('Error dispatching WebSocket event: ' . $e->getMessage());
            }
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Deleted a Ticket Draft for ';
        $activity->ticket_id =  $ticket->ticket_id;
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        if ($ticketdraft) {
            foreach ($ticketdraft->getMedia('ticketdrafts') as $ticketdr) {
                $ticketdr->delete();
            }
            $ticketdraft->delete();
        }
        return response()->json(['success' => 'The draft is deleted successfully.']);
    }

    public function postComment(Request $request,  $ticket_id)
    {
        $ticket_id = decrypt($ticket_id);
        $this->validate($request, [
            'comment' => ['required',  function ($attribute, $value, $fail) {
                // Remove all HTML tags and decode entities like &nbsp;
                $decodedValue = html_entity_decode(strip_tags($value));

                // Replace non-breaking spaces (\u{A0}) with regular spaces
                $normalizedValue = str_replace("\u{A0}", ' ', $decodedValue);

                // Trim unwanted tags from the start and end
                $normalizedValue = preg_replace('/^(<(p|div)><br><\/(p|div)>)+|(<(p|div)><br><\/(p|div)>)+$/', '', $normalizedValue);

                // Trim spaces and check if the result is empty
                if (trim($normalizedValue) === '') {
                    $fail('The comment must contain valid text, not just spaces or HTML.');
                }
            }]
        ]);
        $tic = Ticket::where('ticket_id', $ticket_id)->firstOrFail();

        if ($tic->status == 'Closed') {
            return response(["error" => 'This ticket is already closed, you are not allowed to reply for this tikcet.']);
        }
        if ($request->status == 'Solved') {

            $this->validate($request, [
                'comment' => 'required'
            ]);
            $comment = $request->input('comment');
            // Trim unwanted tags from the start and end
            $comment = preg_replace('/^(<(p|div)><br><\/(p|div)>)+|(<(p|div)><br><\/(p|div)>)+$/', '', $comment);
            $comment = Comment::create([
                'ticket_id' => $request->input('ticket_id'),
                'user_id' => Auth::user()->id,
                'cust_id' => null,
                'comment' => $comment,
            ]);

            $ticketdraft = TicketDraft::where('ticket_id', $request->ticket_id)->first();

            if ($ticketdraft) {

                foreach ($ticketdraft->getMedia('ticketdrafts') as $ticketdr) {
                    if (!file_exists('public/temp/')) {
                        mkdir('public/temp/', 0777, true);
                    }
                    $localTempFilePath = 'public/temp/' . $ticketdr->file_name;
                    $existprovider = existprovider($ticketdr->disk);
                    if ($existprovider)
                        $content = $existprovider->provider::getdraft($ticketdr);

                    file_put_contents($localTempFilePath, $content);
                    $provider =  storage()->provider;

                    $media = $provider::draftupload($comment, $localTempFilePath);
                    $ticketdr->delete();
                }
                $ticketdraft->delete();
            }

            foreach ($request->file('comments', []) as $file) {
                $provider =  storage()->provider;
                $provider::mediaupload($comment, $file, 'comments');
            }


            if ($request->mediaRemoved) {
                foreach (explode(',', $request->mediaRemoved) as $id) {
                    $commentss = Media::findOrFail($id);
                    $commentss->delete();
                }
            }
            $ticket = Ticket::where('ticket_id', $ticket_id)->firstOrFail();
            $ticket->status = 'Closed';
            $ticket->replystatus = $request->input('status');
            // Auto Close Ticket
            $ticket->auto_close_ticket = null;
            // Auto Response Ticket
            $ticket->auto_replystatus = null;
            $ticket->last_reply = now();
            $ticket->closing_ticket = now();
            $ticket->auto_overdue_ticket = null;
            $ticket->overduestatus = null;
            $ticket->importantticket = null;
            $ticket->closedby_user = Auth::id();
            $ticket->lastreply_mail = Auth::id();
            if ($ticket->fileupload_allowed == 'once' || $ticket->fileupload_allowed == 'always') {
                $ticket->fileupload_allowed = null;
            }
            if (!$request->reopen_on_off) {
                $ticket->ticketreopen = 'stopreopen';
            } else {
                $ticket->ticketreopen = null;
            }
            $ticket->update();


            $tickethistory = new tickethistory();
            $tickethistory->ticket_id = $ticket->id;

            $tickethistory->ticketnote = $ticket->ticketnote->isNotEmpty();
            $tickethistory->ticketviolation = $ticket->ticketviolation;
            $tickethistory->overduestatus = $ticket->overduestatus;
            $tickethistory->status = $ticket->status;
            $tickethistory->replystatus = $ticket->replystatus;
            $tickethistory->currentAction = 'Closed';
            $tickethistory->username = $comment->user->name;
            $tickethistory->type = $comment->user->getRoleNames()[0];
            $tickethistory->assignUser = null;

            $tickethistory->save();

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Replied to ticket by marking ticket status to solved ';
            $activity->ticket_id =  $ticket->ticket_id;
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();

            $details = [];
            $details['role'] = Auth::user()->getRoleNames()[0];
            $details['user'] = Auth::user();
            if (webSocketCheck()) {
                try {

                    event(new \App\Events\ConversationEvent(dbname(), null, null, null, null, null, 'tableDataReload', null, null));
                } catch (\Exception $e) {
                    Log::error('Error dispatching tableDataReload event: ' . $e->getMessage());
                }

                try {
                    event(new ConversationEvent(dbname(), $request->comment, $request->status, $details, $comment->getMedia('comments'), $comment, 'employee', $ticket_id, null));
                } catch (\Exception $e) {
                    Log::error('Error dispatching conversation event: ' . $e->getMessage());
                }
            }

            $cust = Customer::find($ticket->cust_id);
            $cust->notify(new TicketCreateNotifications($ticket));


            // create ticket notification
            if ($ticket->category) {
                $notificationcat = $ticket->category->groupscategoryc()->get();
                $groupIds = $notificationcat->pluck('group_id')->toArray();
                $groupstatus = false;
                foreach ($groupIds as $groupid) {
                    $groupexist = Groups::where('groupstatus', '1')->find($groupid);
                    if ($groupexist) {
                        $groupstatus = true;
                    }
                }

                $icc = array();

                if ($groupstatus) {

                    foreach ($notificationcat as $igc) {
                        $groups = $igc->groupsc()
                            ->where('groupstatus', 1)
                            ->with('groupsuser')
                            ->get();

                        foreach ($groups as $group) {
                            $users = $group->groupsuser;

                            foreach ($users as $user) {
                                $icc[] = $user->users_id;
                            }
                        }
                    }

                    if (!$icc) {
                        $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->get();
                        foreach ($admins as $admin) {
                            $admin->notify(new TicketCreateNotifications($ticket));
                        }
                    } else {

                        $user = User::whereIn('id', $icc)->whereHas('roles', function ($query) {
                            $query->where('name', '!=', 'superadmin');
                        })->get();
                        foreach ($user as $users) {
                            $users->notify(new TicketCreateNotifications($ticket));
                        }
                        $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->get();
                        foreach ($admins as $admin) {
                            if ($admin->getRoleNames()[0] == 'superadmin') {
                                $admin->notify(new TicketCreateNotifications($ticket));
                            }
                        }
                    }
                } else {
                    foreach (usersdata() as $admin) {
                        $admin->notify(new TicketCreateNotifications($ticket));
                    }
                }
            }
            // Notification category Empty
            if (!$ticket->category) {
                $admins = User::get();
                foreach ($admins as $admin) {
                    $admin->notify(new TicketCreateNotifications($ticket));
                }
            }

            $ratingtoken =  Ratingtoken::create([

                'token' => str_random(64),
                'ticket_id' => $ticket->id,
            ]);

            $closed_agent = User::findOrFail(Auth::id());
            $ccemailsend = CCMAILS::where('ticket_id', $ticket->id)->first();

            if (setting('ticketrating') == 'on') {
                if ($ticket->cust->userType == 'Guest') {
                    $ticketData = [
                        'closed_agent_name' => $closed_agent->name,
                        'closed_agent_role' => $closed_agent->getRoleNames()[0],
                        'ticket_username' => $ticket->cust->username,
                        'ticket_title' => $ticket->subject,
                        'ticket_id' => $ticket->ticket_id,
                        'comment' => $comment->comment,
                        'ticket_status' => $ticket->status,
                        'ratinglink' => url('rating-page/' . encrypt($ratingtoken->token)),
                        'ticket_customer_url' =>   url('/guest/ticket/' . encrypt($ticket->ticket_id)),
                        'ticket_admin_url' => url('/admin/ticket-view/' . encrypt($ticket->ticket_id)),
                        'ticket_category' => $ticket->category && $ticket->category->name ? $ticket->category->name : null,
                    ];
                }
                if ($ticket->cust->userType == 'Customer') {
                    $ticketData = [
                        'closed_agent_name' => $closed_agent->name,
                        'closed_agent_role' => $closed_agent->getRoleNames()[0],
                        'ticket_username' => $ticket->cust->username,
                        'ticket_title' => $ticket->subject,
                        'ticket_id' => $ticket->ticket_id,
                        'comment' => $comment->comment,
                        'ticket_status' => $ticket->status,
                        'ratinglink' => url('rating-page/' . encrypt($ratingtoken->token)),
                        'ticket_customer_url' => url('/customer/ticket-view/' . encrypt($ticket->ticket_id)),
                        'ticket_admin_url' => url('/admin/ticket-view/' . encrypt($ticket->ticket_id)),
                        'ticket_category' => $ticket->category ? $ticket->category->name : null,
                    ];
                }
            } else {
                if ($ticket->cust->userType == 'Guest') {
                    $ticketData = [
                        'closed_agent_name' => $closed_agent->name,
                        'closed_agent_role' => $closed_agent->getRoleNames()[0],
                        'ticket_username' => $ticket->cust->username,
                        'ticket_title' => $ticket->subject,
                        'ticket_id' => $ticket->ticket_id,
                        'comment' => $comment->comment,
                        'ticket_status' => $ticket->status,
                        'ratinglink' => url('rating-page/' . encrypt($ratingtoken->token)),
                        'ticket_customer_url' =>   url('/guest/ticket/' . encrypt($ticket->ticket_id)),
                        'ticket_admin_url' => url('/admin/ticket-view/' . encrypt($ticket->ticket_id)),
                        'ticket_category' => $ticket->category ? $ticket->category->name : null,
                    ];
                }
                if ($ticket->cust->userType == 'Customer') {
                    $ticketData = [
                        'closed_agent_name' => $closed_agent->name,
                        'closed_agent_role' => $closed_agent->getRoleNames()[0],
                        'ticket_username' => $ticket->cust->username,
                        'ticket_title' => $ticket->subject,
                        'ticket_id' => $ticket->ticket_id,
                        'comment' => $comment->comment,
                        'ticket_status' => $ticket->status,
                        'ratinglink' => url('rating-page/' . encrypt($ratingtoken->token)),
                        'ticket_customer_url' => url('/customer/ticket-view/' . encrypt($ticket->ticket_id)),
                        'ticket_admin_url' => url('/admin/ticket-view/' . encrypt($ticket->ticket_id)),
                        'ticket_category' => $ticket->category ? $ticket->category->name : null,
                    ];
                }
            }

            try {
                if ($ticket->cust->phonesmsenable == 1 && $ticket->cust->phoneVerified == 1 && setting('twilioenable') == 'on') {
                    dispatch((new SendSMS($ticket->cust->phone, 'ticket_closed', $ticketData)));
                }

                if ($ticket->tickettype == 'emalitoticket') {
                    $replySubject = 'Re: ' . $ticket->subject;
                    if ($request->rating_on_off == null) {
                        $emailtempcode = 'send_email_when_employee_closed_emailtotckt';
                    } else {
                        $emailtempcode = 'customer_rating';
                    }

                    $emailtemplate = EmailTemplate::where('code', $emailtempcode)->first();
                    $body = $emailtemplate->body;

                    $imaps = Imap_setting::find($ticket->imap_id);
                    $imap_username = $imaps->imap_username;


                    foreach ($ticketData as $key => $value) {
                        $body = str_replace('{{' . $key . '}}', $value, $body);
                        $body = str_replace('{{ ' . $key . ' }}', $value, $body);
                    }
                    $fileNames = [];


                    $email = (new Email())->html($body);

                    Mail::raw('', function ($message) use ($email, $ticket, $imap_username, $replySubject, $comment, &$fileNames) {
                        $message->from($imap_username)
                            ->to($ticket->cust->email)
                            ->subject($replySubject)
                            ->replyTo($imap_username)
                            ->getHeaders()->addTextHeader('In-Reply-To', '<' . $ticket->MessageID . '>');

                        foreach ($comment->getMedia('comments') as $commentss) {
                            if (!file_exists('public/temp/')) {
                                mkdir('public/temp/', 0777, true);
                            }
                            $localTempFilePath = 'public/temp/' . $commentss->file_name;
                            $existprovider = existprovider($commentss->disk);
                            if ($existprovider)
                                $contentPath = $existprovider->provider::tempImage($commentss, $localTempFilePath);

                            $message->attach($contentPath);
                            $fileNames[] = $localTempFilePath;
                        }

                        $message->getHeaders()->addTextHeader('References', '<' . $ticket->MessageID . '>');
                        $message->setBody($email->getBody(), 'text/html');
                    });
                    foreach ($fileNames as $filePath) {
                        if (file_exists($filePath)) {
                            \File::delete($filePath);
                        }
                    }
                } else {
                    if ($request->rating_on_off == null) {
                        dispatch((new MailSend($ticket->cust->email, 'send_mail_to_customer_when_ticket_closed_by_admin', $ticketData)));
                    } else {
                        dispatch((new MailSend($ticket->cust->email, 'customer_rating', $ticketData)));
                    }
                }

                if ($ccemailsend != null && $ccemailsend->ccemails != null) {
                    dispatch((new MailSend($ccemailsend->ccemails, 'CCmail_sendemail_whenticketclosed', $ticketData)));
                }

                if ($ticket->category) {
                    $notificationcat = $ticket->category->groupscategoryc()->get();
                    $groupIds = $notificationcat->pluck('group_id')->toArray();
                    $groupstatus = false;
                    foreach ($groupIds as $groupid) {
                        $groupexist = Groups::where('groupstatus', '1')->find($groupid);
                        if ($groupexist) {
                            $groupstatus = true;
                        }
                    }

                    $icc = array();

                    if ($groupstatus) {

                        foreach ($notificationcat as $igc) {
                            $groups = $igc->groupsc()
                                ->where('groupstatus', 1)
                                ->with('groupsuser')
                                ->get();

                            foreach ($groups as $group) {
                                $users = $group->groupsuser;

                                foreach ($users as $user) {
                                    $icc[] = $user->users_id;
                                }
                            }
                        }
                        if (!$icc) {
                            $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->where('status', 1)->get();
                            foreach ($admins as $admin) {
                                if ($admin->getRoleNames()[0] != 'superadmin' && $admin->usetting->emailnotifyon == 1) {
                                    dispatch((new MailSend($admin->email, 'send_mail_to_agent_when_ticket_closed_by_admin_or_agent', $ticketData)));
                                }
                            }
                        } else {

                            if ($ticket->myassignuser) {
                                $assignee = $ticket->ticketassignmutliples;
                                foreach ($assignee as $assignees) {
                                    $user = User::where('id', $assignees->toassignuser_id)->where('status', 1)->get();
                                    foreach ($user as $users) {
                                        if ($users->id == $assignees->toassignuser_id && $users->getRoleNames()[0] != 'superadmin' && $users->usetting->emailnotifyon == 1) {
                                            dispatch((new MailSend($users->email, 'send_mail_to_agent_when_ticket_closed_by_admin_or_agent', $ticketData)));
                                        }
                                    }
                                }
                            } else if ($ticket->selfassignuser_id) {
                                $self = User::findOrFail($ticket->selfassignuser_id);
                                if ($self->getRoleNames()[0] != 'superadmin' && $self->usetting->emailnotifyon == 1) {
                                    dispatch((new MailSend($self->email, 'send_mail_to_agent_when_ticket_closed_by_admin_or_agent', $ticketData)));
                                }
                            } else if ($icc) {
                                $user = User::whereIn('id', $icc)->where('status', 1)->whereHas('roles', function ($query) {
                                    $query->where('name', '!=', 'superadmin');
                                })->get();
                                foreach ($user as $users) {
                                    if ($users->usetting->emailnotifyon == 1) {
                                        dispatch((new MailSend($users->email, 'send_mail_to_agent_when_ticket_closed_by_admin_or_agent', $ticketData)));
                                    }
                                }
                            } else {
                                $users = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->where('status', 1)->get();
                                foreach ($users as $user) {
                                    if ($user->getRoleNames()[0] != 'superadmin' && $user->usetting->emailnotifyon == 1) {
                                        dispatch((new MailSend($user->email, 'send_mail_to_agent_when_ticket_closed_by_admin_or_agent', $ticketData)));
                                    }
                                }
                            }
                        }
                    } else {

                        if ($ticket->myassignuser) {
                            $assignee = $ticket->ticketassignmutliples;
                            foreach ($assignee as $assignees) {
                                $user = User::where('id', $assignees->toassignuser_id)->where('status', 1)->get();
                                foreach ($user as $users) {
                                    if ($users->id == $assignees->toassignuser_id && $users->getRoleNames()[0] != 'superadmin' && $users->usetting->emailnotifyon == 1) {
                                        dispatch((new MailSend($users->email, 'send_mail_to_agent_when_ticket_closed_by_admin_or_agent', $ticketData)));
                                    }
                                }
                            }
                        } else if ($ticket->selfassignuser_id) {
                            $self = User::findOrFail($ticket->selfassignuser_id);
                            if ($self->getRoleNames()[0] != 'superadmin' && $self->usetting->emailnotifyon == 1) {
                                dispatch((new MailSend($self->email, 'send_mail_to_agent_when_ticket_closed_by_admin_or_agent', $ticketData)));
                            }
                        } else {
                            foreach (usersdata() as $user) {
                                if ($user->getRoleNames()[0] != 'superadmin' && $user->usetting->emailnotifyon == 1) {
                                    dispatch((new MailSend($user->email, 'send_mail_to_agent_when_ticket_closed_by_admin_or_agent', $ticketData)));
                                }
                            }
                        }
                    }
                }
                if (!$ticket->category) {

                    if ($ticket->myassignuser) {
                        $assignee = $ticket->ticketassignmutliples;
                        foreach ($assignee as $assignees) {
                            $user = User::where('id', $assignees->toassignuser_id)->where('status', 1)->get();
                            foreach ($user as $users) {
                                if ($users->id == $assignees->toassignuser_id && $users->getRoleNames()[0] != 'superadmin' && $users->usetting->emailnotifyon == 1) {
                                    dispatch((new MailSend($users->email, 'send_mail_to_agent_when_ticket_closed_by_admin_or_agent', $ticketData)));
                                }
                            }
                        }
                    } else if ($ticket->selfassignuser_id) {
                        $self = User::findOrFail($ticket->selfassignuser_id);
                        if ($self->getRoleNames()[0] != 'superadmin' && $self->usetting->emailnotifyon == 1) {
                            dispatch((new MailSend($self->email, 'send_mail_to_agent_when_ticket_closed_by_admin_or_agent', $ticketData)));
                        }
                    } else {

                        $users = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->where('status', 1)->get();
                        foreach ($users as $user) {
                            if ($user->getRoleNames()[0] != 'superadmin' && $user->usetting->emailnotifyon == 1) {
                                dispatch((new MailSend($user->email, 'send_mail_to_agent_when_ticket_closed_by_admin_or_agent', $ticketData)));
                            }
                        }
                    }
                }

                $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->where('status', 1)->get();
                foreach ($admins as $admin) {
                    if ($admin->getRoleNames()[0] == 'superadmin' && $admin->usetting->emailnotifyon == 1) {
                        dispatch((new MailSend($admin->email, 'send_mail_to_agent_when_ticket_closed_by_admin_or_agent', $ticketData)));
                    }
                }
            } catch (\Exception $e) {
                return response(["success" => 'The response to the ticket was successful.']);
            }

            return response(["success" => 'The response to the ticket was successful.']);
        } else {

            $this->validate($request, [
                'comment' => 'required'
            ]);
            $tic = Ticket::where('ticket_id', $ticket_id)->firstOrFail();
            if ($tic->status == 'Closed') {
                return response()->json(500, ["error" => 'This ticket is already closed, you are not allowed to reply for this tikcet.']);
            }

            if ($tic->comments()->get() != null) {
                $comm = $tic->comments()->update([
                    'display' => null
                ]);
            }

            $comment = $request->input('comment');

            // Trim unwanted tags from the start and end
            $comment = preg_replace('/^(<(p|div)><br><\/(p|div)>)+|(<(p|div)><br><\/(p|div)>)+$/', '', $comment);
            $comment = Comment::create([
                'ticket_id' => $request->input('ticket_id'),
                'user_id' => Auth::user()->id,
                'cust_id' => null,
                'comment' => $comment,
                'display' => 1,
            ]);

            $ticketdraft = TicketDraft::where('ticket_id', $request->ticket_id)->first();
            if ($ticketdraft) {
                foreach ($ticketdraft->getMedia('ticketdrafts') as $ticketdr) {
                    if (!file_exists('public/temp/')) {
                        mkdir('public/temp/', 0777, true);
                    }
                    if (!in_array($ticketdr->id, explode(',', $request->mediaRemoved))) {
                        $localTempFilePath = 'public/temp/' . $ticketdr->file_name;
                        $existprovider = existprovider($ticketdr->disk);
                        if ($existprovider)
                            $content = $existprovider->provider::getdraft($ticketdr);

                        file_put_contents($localTempFilePath, $content);
                        $provider =  storage()->provider;

                        $media = $provider::draftupload($comment, $localTempFilePath);
                        $ticketdr->delete();
                    }
                }

                $ticketdraft->delete();
            }

            foreach ($request->file('comments', []) as $file) {
                $provider =  storage()->provider;
                $provider::mediaupload($comment, $file, 'comments');
            }

            $ticket = Ticket::where('ticket_id', $ticket_id)->firstOrFail();
            $ticket->status = $request->input('status');
            $ticket->replystatus = 'Waiting';
            if ($request->status == 'On-Hold') {
                $ticket->note = $request->input('note');
                // Auto Close Ticket
                $ticket->auto_close_ticket = null;
                // Auto Response Ticket
                $ticket->auto_replystatus = null;
                //Auto Overdue Ticket
                $ticket->auto_overdue_ticket = null;
                $ticket->overduestatus = null;
            } else {
                // Auto Closing Ticket
                if (setting('AUTO_CLOSE_TICKET') == 'no') {
                    $ticket->auto_close_ticket = null;
                } else {
                    if (setting('AUTO_CLOSE_TICKET_TIME') == '0') {
                        $ticket->auto_close_ticket = null;
                    } else {
                        if (Auth::check() && Auth::user()) {
                            if ($ticket->status == 'Closed') {
                                $ticket->auto_close_ticket = null;
                            } else {
                                $ticket->auto_close_ticket = now()->addHours(setting('AUTO_RESPONSETIME_TICKET_TIME'))->addDays(setting('AUTO_CLOSE_TICKET_TIME'));
                            }
                        }
                    }
                }
                // End Auto Close Ticket

                // Auto Response Ticket

                if (setting('AUTO_RESPONSETIME_TICKET') == 'no') {
                    $ticket->auto_replystatus = null;
                } else {
                    if (setting('AUTO_RESPONSETIME_TICKET_TIME') == '0') {
                        $ticket->auto_replystatus = null;
                    } else {
                        if (Auth::check() && Auth::user()) {
                            $ticket->auto_replystatus = now()->addHours(setting('AUTO_RESPONSETIME_TICKET_TIME'));
                        }
                    }
                }
                // End Auto Response Ticket

                // Auto Overdue Ticket
                if (setting('AUTO_OVERDUE_TICKET') == 'no') {
                    $ticket->auto_overdue_ticket = null;
                    $ticket->overduestatus = null;
                } else {
                    if (setting('AUTO_OVERDUE_TICKET_TIME') == '0') {
                        $ticket->auto_overdue_ticket = null;
                        $ticket->overduestatus = null;
                    } else {
                        if (Auth::check() && Auth::user()) {
                            if ($ticket->status == 'Closed') {
                                $ticket->auto_overdue_ticket = null;
                                $ticket->overduestatus = null;
                            } else {
                                $ticket->auto_overdue_ticket = null;
                                $ticket->overduestatus = null;
                            }
                        }
                    }
                }
                // End Auto Overdue Ticket
            }
            $ticket->last_reply = now();
            $ticket->lastreply_mail = Auth::id();
            $ticket->update();


            $tickethistory = new tickethistory();
            $tickethistory->ticket_id = $ticket->id;

            $tickethistory->ticketnote = $ticket->ticketnote->isNotEmpty();
            $tickethistory->ticketviolation = $ticket->ticketviolation;
            $tickethistory->overduestatus = $ticket->overduestatus;
            $tickethistory->status = $ticket->status;
            $tickethistory->replystatus = $ticket->replystatus;
            $tickethistory->currentAction = 'Responded';
            $tickethistory->username = $comment->user->name;
            $tickethistory->type = $comment->user->getRoleNames()[0];
            $tickethistory->assignUser = null;

            $tickethistory->save();

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Replied To the ticket with status ' . $tickethistory->status;
            $activity->ticket_id =  $ticket->ticket_id;
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();

            $details = [];
            $details['role'] = Auth::user()->getRoleNames()[0];
            $details['user'] = Auth::user();


            if (webSocketCheck()) {
                try {
                    event(new ConversationEvent(dbname(), $request->comment, $request->status, $details, $comment->getMedia('comments'), $comment, 'employee', $ticket_id, 'tableDataReload'));
                    event(new \App\Events\ConversationEvent(dbname(), null, null, null, null, null, 'tableDataReload', null));
                } catch (\Exception $e) {
                    Log::error('Error dispatching WebSocket event: ' . $e->getMessage());
                }
            }

            $details = [];
            $details['role'] = Auth::user()->getRoleNames()[0];
            $details['user'] = Auth::user();


            $cust = Customer::find($ticket->cust_id);
            $cust->notify(new TicketCreateNotifications($ticket));

            $ccemailsend = CCMAILS::where('ticket_id', $ticket->id)->first();

            if ($ticket->cust->userType == 'Guest') {
                $ticketData = [
                    'ticket_username' => $ticket->cust->username,
                    'ticket_title' => $ticket->subject,
                    'ticket_id' => $ticket->ticket_id,
                    'ticket_status' => $ticket->status,
                    'comment' => $comment->comment,
                    'ratinglink' => url('rating-page/' . encrypt($ticket->ticket_id)),
                    'ticket_customer_url' =>  url('/guest/ticket/' . encrypt($ticket->ticket_id)),
                    'ticket_admin_url' => url('/admin/ticket-view/' . encrypt($ticket->ticket_id)),
                    'ticket_category' => $ticket->category ? $ticket->category->name : null,
                ];
            }
            if ($ticket->cust->userType == 'Customer') {
                $ticketData = [
                    'ticket_username' => $ticket->cust->username,
                    'ticket_title' => $ticket->subject,
                    'ticket_id' => $ticket->ticket_id,
                    'ticket_status' => $ticket->status,
                    'comment' => $comment->comment,
                    'ratinglink' => url('rating-page/' . encrypt($ticket->ticket_id)),
                    'ticket_customer_url' => url('/customer/ticket-view/' . encrypt($ticket->ticket_id)),
                    'ticket_admin_url' => url('/admin/ticket-view/' . encrypt($ticket->ticket_id)),
                    'ticket_category' => $ticket->category ? $ticket->category->name : null,
                ];
            }

            try {
                if ($ticket->cust->phonesmsenable == 1 && $ticket->cust->phoneVerified == 1 && setting('twilioenable') == 'on') {
                    dispatch((new SendSMS($ticket->cust->phone, 'reply_to_customer', $ticketData)));
                }

                if ($ticket->tickettype == 'emalitoticket') {

                    $imaps = Imap_setting::find($ticket->imap_id);
                    $imap_username = $imaps->imap_username;

                    $replySubject = 'Re: ' . $ticket->subject;
                    $emailtemplate = EmailTemplate::where('code', 'send_email_when_employee_replyto_emailtotckt')->first();
                    $body = $emailtemplate->body;

                    foreach ($ticketData as $key => $value) {
                        $body = str_replace('{{' . $key . '}}', $value, $body);
                        $body = str_replace('{{ ' . $key . ' }}', $value, $body);
                    }
                    $fileNames = [];

                    try {

                        Mail::send([], [], function ($message) use ($ticket, $replySubject, $body, $comment, $imap_username, &$fileNames) {
                            $message->to($ticket->cust->email)
                                ->from($imap_username)
                                ->replyTo($imap_username)
                                ->subject($replySubject)
                                ->html($body);
                            foreach ($comment->getMedia('comments') as $commentss) {
                                if (!file_exists('public/temp/')) {
                                    mkdir('public/temp/', 0777, true);
                                }
                                $localTempFilePath = 'public/temp/' . $commentss->file_name;
                                $existprovider = existprovider($commentss->disk);
                                if ($existprovider)
                                    $contentPath = $existprovider->provider::tempImage($commentss, $localTempFilePath);

                                $message->attach($contentPath);
                                $fileNames[] = $localTempFilePath;
                            }
                            $headers = $message->getHeaders();
                            $headers->addTextHeader('In-Reply-To', '<' . $ticket->MessageID . '>');
                            $headers->addTextHeader('References', '<' . $ticket->MessageID . '>');
                        });
                    } catch (\Exception $e) {
                    }

                    foreach ($fileNames as $filePath) {
                        if (file_exists($filePath)) {
                            \File::delete($filePath);
                        }
                    }
                } else {
                    dispatch((new MailSend($ticket->cust->email, 'customer_send_ticket_reply', $ticketData)));
                }

                if ($ccemailsend && $ccemailsend->ccemails) {
                    dispatch((new MailSend($ccemailsend->ccemails, 'customer_send_ticket_reply', $ticketData)));
                }
            } catch (\Exception $e) {
                Session::put('adminreplied', 'The response to the ticket was successful.');
                return response(["success" => 'The response to the ticket was successful.']);
            }

            Session::put('adminreplied', 'The response to the ticket was successful.');
            return response(["success" => 'The response to the ticket was successful.']);
        }
    }

    public function storeMedia(Request $request)
    {
        $path = public_path('uploads/comment');

        if (!file_exists($path)) {
            mkdir($path, 0777, true);
        }

        $file = $request->file('file');

        $name = time() . '.' . $file->getClientOriginalExtension();

        $file->move($path, $name);

        return response()->json([
            'name'          => $name,
            'original_name' => $file->getClientOriginalName(),
        ]);
    }

    public function latestcommentimgdelete($id)
    {
        $im = Media::find($id);
        if ($im) {
            $im->delete();

            return response()->json(['success' => lang('The image is deleted successfully.', 'alerts')]);
        } else {
            abort(404);
        }
    }
    public function updateedit(Request $request, $id)
    {

        if ($request->has('message')) {

            $this->validate($request, [
                'message' => 'required'
            ]);
            $ticket = Ticket::findOrFail($id);
            $ticket->message = $request->input('message');

            $ticket->update();
            return response()->json(["Success" => 'updated successfully']);
        } else {
            $this->validate($request, [
                'editcomment' => ['required',  function ($attribute, $value, $fail) {
                    // Remove all HTML tags and decode entities like &nbsp;
                    $decodedValue = html_entity_decode(strip_tags($value));

                    // Replace non-breaking spaces (\u{A0}) with regular spaces
                    $normalizedValue = str_replace("\u{A0}", ' ', $decodedValue);

                    // Trim unwanted tags from the start and end
                    $normalizedValue = preg_replace('/^(<(p|div)><br><\/(p|div)>)+|(<(p|div)><br><\/(p|div)>)+$/', '', $normalizedValue);

                    // Trim spaces and check if the result is empty
                    if (trim($normalizedValue) === '') {
                        $fail('The comment must contain valid text, not just spaces or HTML.');
                    }
                }]
            ]);

            $comment = Comment::findOrFail($id);
            if ($comment->lastseen != NULL) {
                return response()->json(["error" => 'Failed to update comment since it has already seen by the customer']);
            }
            $oldComment =  $comment->comment;

            $editcomment = $request->input('editcomment');

            // Trim unwanted tags from the start and end
            $editcomment = preg_replace('/^(<(p|div)><br><\/(p|div)>)+|(<(p|div)><br><\/(p|div)>)+$/', '', $editcomment);
            $comment->comment = $editcomment;

            $comment->update();



            $ticket = Ticket::findOrFail($comment->ticket->id);

            if ($request->status == 'Solved') {
                $ticket->status = 'Closed';
                $ticket->replystatus = $request->input('status');
                // Auto Close Ticket
                $ticket->auto_close_ticket = null;
                // Auto Response Ticket
                $ticket->auto_replystatus = null;
                $ticket->last_reply = now();
                $ticket->closing_ticket = now();
                $ticket->auto_overdue_ticket = null;
                $ticket->overduestatus = null;
                $ticket->closedby_user = Auth::id();
                $ticket->lastreply_mail = Auth::id();

                $ticket->update();
            } else {
                $ticket->status = $request->input('status');
                $ticket->replystatus = 'Waiting';
                if ($request->status == 'On-Hold') {
                    $ticket->note = $request->input('note');
                    // Auto Close Ticket
                    $ticket->auto_close_ticket = null;
                    // Auto Response Ticket
                    $ticket->auto_replystatus = null;
                    //Auto Overdue Ticket
                    $ticket->auto_overdue_ticket = null;
                    $ticket->overduestatus = null;
                } else {
                    // Auto Closing Ticket
                    if (setting('AUTO_CLOSE_TICKET') == 'no') {
                        $ticket->auto_close_ticket = null;
                    } else {
                        if (setting('AUTO_CLOSE_TICKET_TIME') == '0') {
                            $ticket->auto_close_ticket = null;
                        } else {
                            if (Auth::check() && Auth::user()) {
                                if ($ticket->status == 'Closed') {
                                    $ticket->auto_close_ticket = null;
                                } else {
                                    $ticket->auto_close_ticket = now()->addHours(setting('AUTO_RESPONSETIME_TICKET_TIME'))->addDays(setting('AUTO_CLOSE_TICKET_TIME'));
                                }
                            }
                        }
                    }
                    // End Auto Close Ticket

                    // Auto Response Ticket

                    if (setting('AUTO_RESPONSETIME_TICKET') == 'no') {
                        $ticket->auto_replystatus = null;
                    } else {
                        if (setting('AUTO_RESPONSETIME_TICKET_TIME') == '0') {
                            $ticket->auto_replystatus = null;
                        } else {
                            if (Auth::check() && Auth::user()) {
                                $ticket->auto_replystatus = now()->addHours(setting('AUTO_RESPONSETIME_TICKET_TIME'));
                            }
                        }
                    }
                    // End Auto Response Ticket

                    // Auto Overdue Ticket
                    if (setting('AUTO_OVERDUE_TICKET') == 'no') {
                        $ticket->auto_overdue_ticket = null;
                        $ticket->overduestatus = null;
                    } else {
                        if (setting('AUTO_OVERDUE_TICKET_TIME') == '0') {
                            $ticket->auto_overdue_ticket = null;
                            $ticket->overduestatus = null;
                        } else {
                            if (Auth::check() && Auth::user()) {
                                if ($ticket->status == 'Closed') {
                                    $ticket->auto_overdue_ticket = null;
                                    $ticket->overduestatus = null;
                                } else {
                                    $ticket->auto_overdue_ticket = null;
                                    $ticket->overduestatus = null;
                                }
                            }
                        }
                    }
                    // End Auto Overdue Ticket
                }
                $ticket->last_reply = now();
                $ticket->lastreply_mail = Auth::id();
                $ticket->update();
            }

            foreach ($request->file('comments', []) as $file) {
                $provider =  storage()->provider;
                $provider::mediaupload($comment, $file, 'comments');
            }

            if ($request->mediaRemoved) {
                foreach (explode(',', $request->mediaRemoved) as $id) {
                    $commentss = Media::findOrFail($id);
                    $commentss->delete();
                }
            }
            $tickethistory = new tickethistory();
            $tickethistory->ticket_id = $ticket->id;

            $tickethistory->ticketnote = $ticket->ticketnote->isNotEmpty();
            $tickethistory->ticketviolation = $ticket->ticketviolation;
            $tickethistory->overduestatus = $ticket->overduestatus;
            $tickethistory->status = $ticket->status;
            $tickethistory->replystatus = $ticket->replystatus;
            $tickethistory->currentAction = 'Comment Modified';
            $tickethistory->username = Auth::user()->name;
            $tickethistory->type = Auth::user()->getRoleNames()[0];
            $tickethistory->assignUser = null;
            $tickethistory->commentmodify = $comment->comment;
            $tickethistory->oldcomment = $oldComment;

            $tickethistory->save();

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Modified a comment in ';
            $activity->ticket_id =  $ticket->ticket_id;
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();

            return response()->json(['success' => 'Updated Successfully']);
        }
    }

    public function deletecomment(Request $request, $id)
    {
        $comment = Comment::findOrFail($id);
        if ($comment->lastseen != NULL) {
            return response()->json(['error' => lang('Failed to delete comment since it has already seen by the customer', 'alerts'),]);
        } else {
            $comment->delete();
            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Deleted a comment.';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();

            $tic = Ticket::find($comment->ticket_id);
            $latestcomment = $tic->comments()->latest('created_at')->first();
            $tic = Ticket::find($comment->ticket_id);
            $latestcomment = $tic->comments()->latest('created_at')->first();

            if ($latestcomment != null) {
                $comm = $latestcomment->update([
                    'display' => 1
                ]);
            }
            $tickethistory = new tickethistory();
            $tickethistory->ticket_id = $tic->id;

            $tickethistory->ticketnote = $tic->ticketnote->isNotEmpty();
            $tickethistory->ticketviolation = $tic->ticketviolation;
            $tickethistory->overduestatus = $tic->overduestatus;
            $tickethistory->status = $tic->status;
            $tickethistory->replystatus = $tic->replystatus;
            $tickethistory->currentAction = 'Comment Deleted';
            $tickethistory->username = Auth::user()->name;
            $tickethistory->type = Auth::user()->getRoleNames()[0];
            $tickethistory->assignUser = null;
            $tickethistory->commentmodify = null;
            $tickethistory->oldcomment = null;


            $tickethistory->save();

            return response()->json(['success' => 'The ticket comment has been deleted successfully.',]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($ticket_id) {}

    public function imagedestroy($id)
    {   //For Deleting Users
        $commentss = Media::findOrFail($id);
        $commentss->delete();
        return response()->json([
            'success' => 'Deleted Successfully'
        ]);
    }

    public function reopenticket(Request $req)
    {

        $reopenticket = Ticket::find($req->reopenid);
        $reopenticket->status = 'Re-Open';
        $reopenticket->replystatus = null;
        $reopenticket->closedby_user = null;
        $reopenticket->lastreply_mail = Auth::id();
        $reopenticket->update();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Re-Opened a ticket ';
        $activity->ticket_id =  $reopenticket->ticket_id;
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        $tickethistory = new tickethistory();
        $tickethistory->ticket_id = $reopenticket->id;

        $tickethistory->ticketnote = $reopenticket->ticketnote->isNotEmpty();
        $tickethistory->ticketviolation = $reopenticket->ticketviolation;
        $tickethistory->overduestatus = $reopenticket->overduestatus;
        $tickethistory->status = $reopenticket->status;
        $tickethistory->replystatus = $reopenticket->replystatus;
        $tickethistory->currentAction = 'Re-opened';
        $tickethistory->username = Auth::user()->name;
        $tickethistory->type = Auth::user()->getRoleNames()[0];
        $tickethistory->assignUser = null;
        $tickethistory->commentmodify = null;
        $tickethistory->oldcomment = null;

        $tickethistory->save();


        $details = [];
        $details['role'] = Auth::user()->getRoleNames()[0];
        $details['user'] = Auth::user();

        if (webSocketCheck()) {
            try {
                event(new ConversationEvent(dbname(), NULL, 'Reopen', $details, NULL, NULL, 'employee', $reopenticket->ticket_id, null));
                event(new \App\Events\ConversationEvent(dbname(), null, null, null, null, null, 'tableDataReload', null, null));
            } catch (\Exception $e) {
                Log::error('Error dispatching WebSocket event: ' . $e->getMessage());
            }
        }


        $cust = Customer::with('custsetting')->find($reopenticket->cust_id);
        $cust->notify(new TicketCreateNotifications($reopenticket));

        if ($reopenticket->cust->userType == 'Guest') {
            $ticketData = [
                'ticket_username' => $reopenticket->cust->username,
                'ticket_title' => $reopenticket->subject,
                'ticket_id' => $reopenticket->ticket_id,
                'ticket_status' => $reopenticket->status,
                'ratinglink' => url('rating-page/' . encrypt($reopenticket->ticket_id)),
                'ticket_customer_url' => url('/guest/ticket/' . encrypt($reopenticket->ticket_id)),
                'ticket_admin_url' => url('/admin/ticket-view/' . encrypt($reopenticket->ticket_id)),
            ];
        }
        if ($reopenticket->cust->userType == 'Customer') {
            $ticketData = [
                'ticket_username' => $reopenticket->cust->username,
                'ticket_title' => $reopenticket->subject,
                'ticket_id' => $reopenticket->ticket_id,
                'ticket_status' => $reopenticket->status,
                'ratinglink' => url('rating-page/' . encrypt($reopenticket->ticket_id)),
                'ticket_customer_url' => url('/customer/ticket-view/' . encrypt($reopenticket->ticket_id)),
                'ticket_admin_url' => url('/admin/ticket-view/' . encrypt($reopenticket->ticket_id)),
            ];
        }

        return response()->json([
            'success' => 'The ticket has been successfully reopened.',
            'data' => $ticketData
        ]);
    }
}
