<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\customizeerror;
use Torann\GeoIP\Facades\GeoIP;
use App\Models\EmployeeActivity;
use Jenssegers\Agent\Agent;
use Illuminate\Support\Facades\Auth;

class CustomerrorpagesController extends Controller
{
    public function index()
    {

        $this->authorize('404 Error Page Access');

        $errorsList = [];
        $errors = customizeerror::get();
        foreach ($errors as $error) {
            if ($error['errorname'] == '404title' || $error['errorname'] == '404subtitle') {
                array_push($errorsList, $error);
            }
        }

        return $errorsList;
    }

    public function store(Request $request)
    {
        $this->authorize('404 Error Page Access');
        $request->validate([
            '404title' => 'required|max:10000',

        ]);
        if ($request->input('404subtitle')) {
            $request->validate([
                '404subtitle' => 'max:10000',

            ]);
        }
        $data = $request->only(['404subtitle', '404title']);

        $this->updateSettings($data);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Updated 404 Error Page.';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => 'Updated successfully']);
    }

    public function maintenancepage()
    {
        $this->authorize('Under Maintenance Page Access');

        $data['503title'] = settingpages('503title');
        $data['503subtitle'] = settingpages('503subtitle');
        $data['503description'] = settingpages('503description');
        $data['redirectionURL'] = settingpages('redirectionURL');
        $data['MAINTENANCE_MODE'] = settingpages('MAINTENANCE_MODE');

        return $data;
    }

    public function maintenancepagestore(Request $request)
    {
        $this->authorize('Under Maintenance Page Access');
        $request->validate([
            '503title' => 'required|max:10000',
            '503subtitle' => 'required|max:10000',
            'redirectionURL' => $request->input('redirectionURL') != null ? 'url' : '',
            '503description' => $request->has('503description') ? 'max:10000' : '',

        ]);
        $data['503subtitle']  =  $request->input('503subtitle');
        $data['503title']  =  $request->input('503title');
        $data['503description']  =  $request->input('503description');
        $data['redirectionURL']  =  $request->input('redirectionURL');
        $data['MAINTENANCE_MODE']  =  $request->input('MAINTENANCE_MODE') == true ? 'on' : 'off';

        if (!empty($data['503description'])) {
            $data['503description'] = preg_replace('/^(<(p|div)><br><\/(p|div)>)+|(<(p|div)><br><\/(p|div)>)+$/', '', $data['503description']);
        }
        
        $this->updateSettings($data);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Updated Miantenance page';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => 'Updated successfully']);
    }

    /**
     *  Settings Save/Update.
     *
     * @return \Illuminate\Http\Response
     */
    private function updateSettings($data)
    {

        foreach ($data as $errorname => $errorvalue) {
            $setting = customizeerror::where('errorname', $errorname);
            if ($setting->exists())
                $setting->first()->update(['errorvalue' => $errorvalue]);
        }
    }
}
