<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\FaqCategory;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Auth;
use Illuminate\Support\Facades\Schema;
use Jenssegers\Agent\Agent;
use Torann\GeoIP\Facades\GeoIP;
use App\Models\EmployeeActivity;

class FaqCategoryController extends Controller
{
    public function index(Request  $request)
    {
        $this->authorize('FAQ Category Access');
        $faqcategory = FaqCategory::latest();

        $searchTerm = $request['filter'] ?? null;
        $perPage    = $request['per_page'] ?? 15;
        $page       = $request['page'] ?? 1;

        if ($searchTerm) {
            $faqcategory->where(function ($query) use ($searchTerm) {
                $columns = Schema::getColumnListing('faq_categories');
                foreach ($columns as $column) {
                    $query->orWhere($column, 'LIKE', "%{$searchTerm}%");
                }
            });
        }
        $items = $faqcategory->paginate($perPage);
        $data['queryList'] = $items;

        $user = User::with('usetting')->findOrFail(Auth::user()->id);
        $role = Role::where('name', $user->getRoleNames()[0])->get();
        foreach ($role as $roles) {
            $data['permissions'] = $roles->getPermissionNames();
        }

        return $data;
    }

    public function storeupdate(Request $request)
    {
        $this->authorize('FAQ Category Create');
        $validate = FaqCategory::find($request->faqcat_id);
        if (!$validate) {
            $request->validate([
                'faqcategoryname' => 'required|max:255|unique:faq_categories',

            ]);
        }
        if ($validate) {
            if ($request->faqcategoryname == $validate->faqcategoryname) {
                $request->validate([
                    'faqcategoryname' => 'required|max:255',

                ]);
            } else {
                $request->validate([
                    'faqcategoryname' => 'required|max:255|unique:faq_categories',

                ]);
            }
        }
        $faqcategory_id = $request->faqcat_id;
        $faqcategory_data =  [
            'faqcategoryname' => $request->faqcategoryname,
            'status' => $request->status ? '1' : '0',
        ];
        $faqcategory = FaqCategory::updateOrCreate(['id' => $faqcategory_id], $faqcategory_data);
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Created FAQ Category';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        $message = $faqcategory_id ? lang('Faq Category updated successfully.', 'alerts') : lang('Faq Category created successfully.', 'alerts');
        return response()->json(['code' => 200, 'success' => $message, 'data' => $faqcategory], 200);
    }

    public function faqcategorylist(Request $request)
    {
        $this->authorize('FAQ Category Edit');
        $faqcategorylist = FaqCategory::get();

        $faqcatlist = '';

        $faqcatlist .= '<option label ="Select Faq Category"></option>';
        foreach ($faqcategorylist as $faqcategorylists) {
            $faqcatlist .= '<option value=' . $faqcategorylists->id . '>' . $faqcategorylists->faqcategoryname . '</option>';
        }

        return response()->json(['faqcategoryList' => $faqcategorylist]);
    }

    public function edit($id)
    {
        $this->authorize('FAQ Category Edit');
        $faqsubcatlist = FaqCategory::find($id);
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Edited faq category';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json($faqsubcatlist);
    }

    public function destroy($id)
    {
        $this->authorize('FAQ Category Delete');
        $faqsubcatdelete = FaqCategory::find($id);
        $faqsubcatdelete->delete();
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Deleted faq category';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['success' => 'Deleted Successfully'], 200);
    }

    public function allfaqcategorydelete(Request $request)
    {
        $this->authorize('FAQ Category Delete');
        $id_array = $request->input('id');

        $allfaqcategorydeletes = FaqCategory::whereIn('id', $id_array)->get();

        foreach ($allfaqcategorydeletes as $allfaqcategorydelete) {
            $allfaqcategorydelete->delete();
        }
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Deleted multiple faq categories';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['success' => 'Deleted Successfully']);
    }


    public function status(Request $request, $id)
    {
        $this->authorize('FAQ Category Edit');
        $calID = FaqCategory::find($id);
        $calID->status = $request->status;
        $calID->save();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Changed faq category status';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['code' => 200, 'success' => 'Updated Successfully'], 200);
    }
}
