<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Apptitle;
use App\Models\Footertext;
use App\Models\Seosetting;
use App\Models\Holiday;
use App\Models\Announcement;
use App\Models\Pages;
use App\Imports\HolidaysImport;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Schema;
use App\Models\User;
use Auth;
use Spatie\Permission\Models\Role;
use Jenssegers\Agent\Agent;
use Torann\GeoIP\Facades\GeoIP;
use App\Models\EmployeeActivity;
use Carbon\Carbon;
use Illuminate\Support\Facades\Validator;

class HolidayController extends Controller
{
    public function index(Request $request)
    {

        $setting = response()->json(['start_week' => setting('start_week')]);
        $data['setting'] = $setting;

        $holiday =  Holiday::latest();

        $searchTerm = $request['filter'] ?? null;
        $perPage    = $request['per_page'] ?? 15;

        $user = User::with('usetting')->findOrFail(Auth::user()->id);
        $role = Role::where('name', $user->getRoleNames()[0])->get();
        foreach ($role as $roles) {
            $data['permissions'] = $roles->getPermissionNames();
        }
        if ($searchTerm) {
            $holiday->where(function ($query) use ($searchTerm) {
                $columns = Schema::getColumnListing('holidays');
                foreach ($columns as $column) {
                    $query->orWhere($column, 'LIKE', "%{$searchTerm}%");
                }
            });
        }
        $items = $holiday->paginate($perPage);
        $data['queryList'] = $items;
        return response($data);
    }

    public function saveholidays(Request $request)
    {
        $this->authorize('Holidays Create');

        $request->validate([
            'occasion' => 'required',
            'startdate' => 'required',
            'enddate' => 'required',
            'holidaydescription' => 'required',
            'primary_color' => 'required',
            'secondary_color' => 'required',
        ]);

        $hodidayid = $request->holiday_id;
        $holidaydescription = $request->input('holidaydescription');

        // Trim unwanted tags from the start and end
        $holidaydescription = preg_replace('/^(<(p|div)><br><\/(p|div)>)+|(<(p|div)><br><\/(p|div)>)+$/', '', $holidaydescription);
        $holidaydata =  [
            'occasion' => $request->occasion,
            'startdate' => Carbon::parse($request['startdate']),
            'enddate' => Carbon::parse($request['enddate']),
            'holidaydescription' => $holidaydescription,
            'primaray_color' => $request->primary_color,
            'secondary_color' => $request->secondary_color,
            'status' => $request->status,
            'is_fixed' => $request->is_fixed,

        ];

        $ipdtaa = Holiday::updateOrCreate(['id' => $hodidayid], $holidaydata);
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = $hodidayid ? 'Updated Holidays' : 'created Holidays';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        // Set the message based on the presence of $holidayId
        $message = $hodidayid ? 'Holidays updated successfully.' : 'Holidays created successfully.';
        return response()->json(['success' => $message, 'data' => $ipdtaa,]);
    }
    public function edit($id)
    {
        $this->authorize('Holidays Edit');

        $data = Holiday::find($id);
        return response()->json($data);
    }

    public function delete($id)
    {
        $this->authorize('Holidays Delete');

        $data = Holiday::find($id);
        $data->delete();
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Deleted a holiday';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['code' => 200, 'success' => lang('Deleted successfully', 'alerts')], 200);
    }

    public function statuschange(Request $request, $id)
    {
        $this->authorize('Holidays Edit');

        $custstatus = Holiday::find($id);
        $custstatus->status = $request->status;
        $custstatus->save();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Changed status of holiday';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['code' => 200, 'success' => lang('Status Updated successfully', 'alerts')], 200);
    }

    public function massdelete(Request $request)
    {
        $this->authorize('Holidays Delete');

        $holiday_array = $request->input('id');


        $holidays = Holiday::whereIn('id', $holiday_array)->get();

        foreach ($holidays as $holiday) {
            $holiday->delete();
        }
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Deleted multiple holidays';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['success' => lang('The holidays was deleted successfully.', 'alerts')]);
    }

    public function holidaysimport()
    {
        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $post = Pages::all();
        $data['page'] = $post;


        return view('admin.holidays.holidaysimport')->with($data);
    }

    public function holidayscsv(Request $request)
    {
        $this->authorize('Holidays Import Access');

        if ($request->hasFile('file')) {
            $validator = Validator::make(
                $request->all(),
                [

                    'file' => 'required|file|mimes:xlsx,csv,txt',
                ],
                [
                    'file.mimes' => 'The file must be a file of type: xlsx, csv.',
                ]
            );
            if ($validator->fails()) {
                return response()->json(['error' => $validator]);
            }


            $file = $request->file('file')->store('import');
            $import = new HolidaysImport;
            Excel::import($import, $file);

            $errors = $import->getErrors();

            if (!empty($errors)) {
                return response()->json(['error' => $errors]);
            }

            // $import = Excel::import(new HolidaysImport, $file);
            if ($import->hasData) {
                $geolocation = GeoIP::getLocation(request()->getClientIp());
                $agent = new Agent();
                $activity = new EmployeeActivity();
                $activity->user_id = Auth::user()->id;
                $activity->activity_type = 'Imported holidays list';
                $activity->ip_address = $geolocation->ip;
                $activity->browser = $agent->browser();
                $activity->device = $agent->device();
                $activity->save();
                return response()->json(['success' => 'The Holidays list was imported successfully.']);
            } else {
                return response()->json(['error' => 'The imported file does not contain any data.']);
            }
            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Imported holidays list';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();
            return response()->json(['success' => 'The Holidays list was imported successfully.']);
        } else {
            return response()->json(['error' => 'Please select file to import data of Holidays.']);
        }
    }
}
