<?php

namespace App\Http\Controllers\Admin;

use App\Events\AgentMessageEvent;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\LiveChatCustomers;
use App\Models\LiveChatConversations;
use App\Models\livechat_flow;
use App\Models\User;
use App\Events\ChatMessageEvent;
use App\Models\AgentConversation;
use App\Models\AgentGroupConversation;
use App\Models\Customer;
use App\Models\Setting;
use App\Models\Ticket\Category;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\Str;
use App\Models\Ticket\Ticket;
use Spatie\Permission\Models\Role;
use Auth;
use GeoIP;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Validator;
use App\Models\Cannedmessages;


use App\Models\livechatReviews;
use App\Models\Userrating;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Pagination\Paginator;
use Exception;
use Illuminate\Support\Facades\Mail;
use Spatie\SslCertificate\SslCertificate;
use Symfony\Component\Process\Process;
use App\Models\EmployeeActivity;
use Illuminate\Support\Facades\Schema;
use Jenssegers\Agent\Agent;

class LiveChatController extends Controller
{
    public function index(Request $request)
    {

        $user = User::where('id', '!=', Auth::id())->get();
        $data['user'] = $user;

        $livecust = LiveChatCustomers::latest('updated_at')->get();


        $filteredLiveCust = $livecust->filter(function ($item) {
            return $item->engage_conversation === null || $item->engage_conversation === '' && $item->status != 'solved';
        });

        if ($request->operatorID) {
            $filteredLiveCust = $livecust->filter(function ($customer) use ($request) {
                $engageConversation = $customer->engage_conversation;
                return collect($engageConversation)->contains('id', $request->operatorID);
            });
        }
        $data['operatorID'] = $request->operatorID;


        foreach ($filteredLiveCust as $customer) {
            $livechatdata = LiveChatConversations::where('unique_id', $customer->cust_unique_id)->get();
            $unreadIndexNumber = 0;
            foreach ($livechatdata as $message) {
                if ($message->livechat_cust_id !== null && $message->status != "seen" && !$message->delete) {
                    $unreadIndexNumber = $unreadIndexNumber + 1;
                }
            }
            $customer->unreadIndexNumber = $unreadIndexNumber;
            $customer->lastMessage = $livechatdata->isNotEmpty() ? $livechatdata->last() : null;
        }

        $filteredLiveCust = $filteredLiveCust->sortByDesc(function ($customer) {
            return optional($customer->lastMessage)->created_at ? $customer->lastMessage->created_at->timestamp : null;
        });

        $data['filteredLiveCust'] = $filteredLiveCust->filter(function ($item) {
            return $item->lastMessage->delete == null;
        })->values()->all();
        $data['userId'] = auth()->user()->id;
        // $data['engage_conversation'] = collect(json_decode(LiveCust->engage_conversation));

        $data['settings'] = [
            'liveChatCustomerOnlineUsers' => setting('liveChatCustomerOnlineUsers'),
            'TICKET_CHARACTER' => setting('TICKET_CHARACTER'),
        ];
        $data['timezonedata'] = Auth::user()->timezone ?? setting('default_timezone');
        return $data;
    }

    public function customerdata(Request $request)
    {
        $cust = LiveChatCustomers::where('email', $request->email)->first();
        if ($cust && $cust->count()) {
            return response()->json(['success' => 'your live chat process is started.', 'custdata' => $cust]);
        } else {
            $cust = new LiveChatCustomers();
            $cust->cust_unique_id = Str::random(9);
            $cust->username = $request->name;
            $cust->email = $request->email;
            $cust->chat_flow_messages = $request->flowChatMessages;
            $cust->mobile_number = $request->mobilenumber;
            $cust->userType = 'livechat';
            $cust->login_at = now();
            $cust->browser_info = $request->browserAndOSInfo;
            $cust->login_ip = $request->loginIp;
            $cust->city = $request->city;
            $cust->state = $request->state;
            $cust->timezone = $request->timezone;
            $cust->country = $request->country;
            $cust->full_address = $request->fullAddress;
            $cust->save();

            event(new ChatMessageEvent($request->name, 'newUser', $cust->id, null, null, null, null, null, null, null, null, null));
            return response()->json(['success' => 'your live chat process is started.', 'custdata' => $cust]);
        }
    }

    public function singlecustdata(Request $request, $id)
    {
        $livecust = LiveChatCustomers::find($id);
        if ($livecust == null) {
            return response()->json(['nocustomerdatafound' => true]);
        }
        if (LiveChatConversations::where('unique_id', $livecust->cust_unique_id)->first()->delete != null) {
            $livecust->chat_flow_messages = null;
        }

        $livechatdata = LiveChatConversations::where('unique_id', $livecust->cust_unique_id)->get();
        $currentUserId = Auth::id();
        $filteredLiveChatData = $livechatdata->reject(function ($message) use ($currentUserId) {
            return $message->delete != null;
        });

        if ($currentUserId && strpos($request->header('referer'), 'livechat-flow/test-it-out') == false) {
            foreach ($filteredLiveChatData as $message) {
                if ($message->livechat_cust_id !== null && $message->status != "comment") {
                    $message->status = 'seen';
                    $message->save();
                }
            }
        }

        if ($filteredLiveChatData->count() != $livechatdata->count()) {
            $livecust->deletedMessage = true;
        }
        $filteredLiveChatData = $filteredLiveChatData->sortBy('created_at')->values();
        $livecust->onlineUsers = Setting::where("key", 'All_Online_Users')->first();
        $livecust->livechatMaxFileUpload = setting('livechatMaxFileUpload');
        $livecust->livechatFileUploadMax = setting('livechatFileUploadMax');
        $livecust->livechatFileUploadTypes = setting('livechatFileUploadTypes');
        $livecust->liveChatFlowload = setting('liveChatFlowload');
        $livecust->livechatIconSize = setting('livechatIconSize');
        $livecust->livechatPosition = setting('livechatPosition');
        $livecust->isonlineoroffline = $this->isonlineoroffline();
        $livecust->OfflineMessage = setting('OfflineMessage');
        $livecust->OfflineStatusMessage = setting('OfflineStatusMessage');
        $livecust->OnlineStatusMessage = setting('OnlineStatusMessage');
        $livecust->offlineDisplayLiveChat = setting('offlineDisplayLiveChat');
        $livecust->liveChatHidden = setting('liveChatHidden');
        $livecust->liveChatCustomerOnlineUsers = setting('liveChatCustomerOnlineUsers');
        $livecust->livechatFeedbackDropdown = setting('livechatFeedbackDropdown');
        $livecust->LivechatCustFeedbackQuestion = setting('LivechatCustFeedbackQuestion');
        $livecust->LivechatCustWelcomeMsg = setting('LivechatCustWelcomeMsg');
        $livecust->liveChatIcon = setting('liveChatIcon');

        $customer = Customer::where('email', $livecust->email)->first();
        if ($customer) {
            $livecust->gustId = $customer->id;
            $livecust->livechatTickets = Ticket::where('cust_id', $customer->id)->get()->count();
        }

        $cannedmessages = Cannedmessages::latest()->where('responsetype', 'livechat')->get();


        $user = Auth::user();
        event(new ChatMessageEvent(null, null, null, $id, null, null, null, null, null, null, null, null, null));

        return response()->json(['livechatcust' => $livecust, 'livechatdata' => $filteredLiveChatData, 'cannedmessages' => $cannedmessages]);
    }

    public function broadcastMessage(Request $request)
    {

        if ($request->cust_id != null) {
            $user = Auth::user();
            $cust = LiveChatCustomers::find($request->cust_id);
            if ($cust->status == 'solved') {
                $cust->status = "";
                $cust->save();
            }

            $newconversation = new LiveChatConversations();
            $newconversation->created_at = now();
            $newconversation->unique_id = $cust->cust_unique_id;
            $newconversation->livechat_user_id = $user->id;
            $newconversation->livechat_username = $user->name;
            $newconversation->message = $request->message;
            $newconversation->sender_image = $user->image;


            $livecust = LiveChatCustomers::where('cust_unique_id', $cust->cust_unique_id)->first();

            $livechatdata = LiveChatConversations::where('unique_id', $livecust->cust_unique_id)->get();
            $livecust->lastMessage = $newconversation;


            if ($request->messageType) {
                $newconversation->message_type = $request->messageType;
                event(new ChatMessageEvent($user->name, $request->message, $user->id, $request->customerId, null, null, null, Auth::user(), null, null, $request->messageType, null, $newconversation));
            } else {
                event(new ChatMessageEvent($user->name, $request->message, $user->id, $request->customerId, null, null, null, Auth::user(), null, null, null, null, $livecust));
            };
            $newconversation->save();
        } else {

            $cust = LiveChatCustomers::find($request->id);
            if ($request->messageType == 'welcomeMessage') {
                // return $cust;

                if ($cust->status == 'solved') {
                    $cust->status = "";
                    $cust->save();
                }

                $newconversation = new LiveChatConversations();
                $newconversation->unique_id = $cust->cust_unique_id;
                $newconversation->livechat_user_id = $request->id;
                $newconversation->livechat_username = 'chatBot';
                $newconversation->message = $request->message;
                $newconversation->message_type = 'welcomeMessage';
                $newconversation->save();
                event(new ChatMessageEvent('chatBot', $request->message, $request->id, $request->customerId, null, null, null, null, null, null, 'welcomeMessage', null));
            } else {
                if ($cust->status == 'solved') {
                    $cust->status = "";
                    event(new ChatMessageEvent($request->username, 'newUser', null, null, null, null, null, null, null, null, null, null));
                }
                $cust->updated_at = now();
                $cust->save();

                $newconversation = new LiveChatConversations();
                $newconversation->unique_id = $cust->cust_unique_id;
                $newconversation->livechat_cust_id = $request->id;
                $newconversation->livechat_username = $request->username;
                $newconversation->message = $request->message;

                if ($request->messageType) {
                    $newconversation->message_type = $request->messageType;
                }
                $newconversation->save();


                $livecust = LiveChatCustomers::where('cust_unique_id', $cust->cust_unique_id)->first();
                if ($livecust->engage_conversation === null || $livecust->engage_conversation === '' && $livecust->status != 'solved') {
                    if ($request->operatorID) {
                        $engageConversation = $livecust->engage_conversation;
                        $livecust = collect($engageConversation)->contains('id', $request->operatorID);
                    }
                }


                $livechatdata = LiveChatConversations::where('unique_id', $livecust->cust_unique_id)->get();
                $unreadIndexNumber = 0;
                foreach ($livechatdata as $message) {
                    if ($message->livechat_cust_id !== null && $message->status != "seen" && !$message->delete) {
                        $unreadIndexNumber = $unreadIndexNumber + 1;
                    }
                }
                $livecust->unreadIndexNumber = $unreadIndexNumber;
                $livecust->lastMessage = $livechatdata->isNotEmpty() ? $livechatdata->last() : null;
                optional($livecust->lastMessage)->created_at ? $livecust->lastMessage->created_at->timestamp : null;

                if ($request->messageType) {

                    event(new ChatMessageEvent($request->username, $request->message, $request->id, $request->customerId, null, null, null, null, null, null, $request->messageType, null, $livecust));
                } else {
                    event(new ChatMessageEvent($request->username, $request->message, $request->id, $request->customerId, null, null, null, null, null, null, null, null, $livecust));
                }
            }
        }
        if ($request->messageType == "feedBack") {
            $cust = LiveChatCustomers::find($request->id);
            $liveChatEngageConversation = $cust->engage_conversation;
            foreach ($liveChatEngageConversation as $EngageUser) {
                $feedBackRating = json_decode($request->message, true);
                $ratingModel = new livechatReviews();
                $ratingModel->users_id = $EngageUser['id'];
                $ratingModel->cust_id = $request->customerId;
                $ratingModel->starRating = $feedBackRating['starRating'];
                $ratingModel->problemRectified = $feedBackRating['problemRectified'];
                $ratingModel->feedBackData = $feedBackRating['feedBackData'];
                $ratingModel->save();
            }

            // For Left chat
            if ($cust->engage_conversation) {
                foreach ($cust->engage_conversation as $engageusers) {
                    // For the Left User comment
                    $user = $engageusers;
                    $newconversation = new LiveChatConversations();
                    $newconversation->unique_id = $cust->cust_unique_id;
                    $newconversation->livechat_user_id = $user['id'];
                    $newconversation->livechat_username = $user['name'];
                    $newconversation->message = $user['name'] . ' left the discussion at';
                    $newconversation->status = 'comment';
                    $newconversation->save();
                    event(new ChatMessageEvent(null, null, $user['id'], $cust->id, null, null, true, $cust->engage_conversation, $newconversation->message, null, null, null));
                }
            }

            // For Slove

            $solvedUser = User::find(1);
            $newconversation = new LiveChatConversations();
            $newconversation->unique_id = $cust->cust_unique_id;
            $newconversation->livechat_user_id = $solvedUser->id;
            $newconversation->livechat_username = $solvedUser->name;
            $newconversation->message = 'The customer given feedback to the chat, and as a result, the discussion was automatically marked as solved at';
            $newconversation->status = 'comment';
            $newconversation->save();
            event(new ChatMessageEvent(null, null, $solvedUser->id, $cust->id, null, null, true, $cust->engage_conversation, $newconversation->message, null, null, null));

            $cust->engage_conversation = '';
            $cust->status = 'solved';
            $cust->save();
            return response()->json(['success' => "Solved"]);
        }
    }

    public function broadcastMessageTyping(Request $request)
    {

        event(new ChatMessageEvent($request->username, null, $request->id, $request->customerId, $request->typingMessage ? $request->typingMessage : "empty", null, null, $request->agentInfo, null, null, null, null, null));
    }

    public function liveChatFlow($id)
    {
        $flow = livechat_flow::find($id);
        if ($flow && $flow->active == 1 && $flow->active_draft) {
            $flow->liveChatFlow = $flow->active_draft;
        }
        $data['flow'] = $flow;

        $flowChatId = $id;
        $data['flowChatId'] = $flowChatId;


        return $data;
    }

    public function operators(Request $request)
    {
        // $livecust = LiveChatCustomers::latest('updated_at')->get();
        // $data['livecust'] = $livecust;

        $newUserId = Auth::user()->id;
        $data['userId'] = $newUserId;

        $cannedmessages = Cannedmessages::latest()->where('responsetype', 'livechat')->get();
        $data['cannedmessages'] = $cannedmessages;
        
        $user = User::where('id', '!=', Auth::id())->get();
        $data['user'] = $user;

        $userId = AgentConversation::where('sender_user_id', Auth::id())->first();
        if ($userId != null) {
            $userconversation = AgentConversation::where('unique_id', $userId->unique_id)->get();
            $data['userconversation'] = $userconversation;
        }

        $agenconver = AgentConversation::where(function ($query) {
            $query->where('sender_user_id', Auth::id())
                ->orWhere('receiver_user_id', Auth::id());
        })->latest('created_at')->get()->groupBy(function ($group) {
            return $group->unique_id;
        });


        $group_conver = AgentGroupConversation::get()->groupBy(function ($group) {
            return $group->unique_id;
        });

        $filteredGroups = $group_conver->map(function ($conversationGroup) {
            $filteredConversations = $conversationGroup->filter(function ($conversation) {
                // To make the seen staus
                $markAsUnread =  (array) $conversation->mark_as_unread;
                $receiverUserId =  (array) $conversation->receiver_user_id;
                if ($markAsUnread && $receiverUserId && empty(array_diff($receiverUserId, $markAsUnread))) {
                    $conversation->update(['message_status' => 'seen']);
                };

                // To remove the array which not include the auth id in the receiver_user_id
                $authUserId = Auth::id();
                return in_array($authUserId, $conversation->receiver_user_id);
            });
            $conversationGroup = $filteredConversations;
            return $conversationGroup;
        });

        $finalFilteredGrouparray = $filteredGroups->filter(function ($item) {
            return !empty($item->all());
        });


        $sortedCollection = new Collection(array_merge($agenconver->toArray(), $finalFilteredGrouparray->toArray()));
        $allconver = $sortedCollection->sortByDesc(function ($item) {
            return isset($item[0]['created_user_id']) ? $item[count($item) - 1]['created_at'] : $item[0]['created_at'];
        });
        // Initialize an empty array to store the sorted conversations
        $sortedConversations = [];

        $usersInGroup = [];
        // Loop through each conversation
        foreach ($allconver as $conversation) {

            // Sort messages within the conversation by created_at in descending order
            $sortedMessages = collect($conversation)->sortByDesc('created_at')->first();
            $messageCount = collect($conversation)->filter(function ($message) {
                return $message['message_status'] !== 'seen';
            })->count();

            // $messageCount = collect($conversation)->filter(function ($message) {
            //     $markAsUnreadArray = $message['mark_as_unread'];
            //     return !in_array(Auth::id(), $markAsUnreadArray);
            // })->count();
            $sortedMessages['messageCount'] = $messageCount;
            $sortedMessages["message_status_delivered"] = collect($conversation)->where('message_status', 'delivered')->count();

            $usereceiverUserImg = [];
            if (is_array($sortedMessages['receiver_user_id'])) {

                foreach ($sortedMessages['receiver_user_id'] as $userId) {
                    $user = User::find($userId);
                    if ($user) {
                        $usereceiverUserImg[] = ['name' => $user->name, 'image' =>  $user->image ?? 'user-profile.png'];
                    }
                }
            } else {
                $user = User::find($sortedMessages['receiver_user_id']);
                $usereceiverUserImg[] = ['name' => $user->name, 'image' =>  $user->image ?? 'user-profile.png'];
            }
            $sortedMessages['receiver_user_image'] = $usereceiverUserImg;


            // Add the latest message to the sortedConversations array
            // Retrieve the user who created the latest message
            // $createdUser = User::find($sortedMessages['created_user_id']);

            if (isset($sortedMessages['sender_user_id'])) {
                $createdUser = User::find($sortedMessages['sender_user_id']);
                // Add the user's name to the latest message
                $sortedMessages['name'] = $createdUser->name;

                // Add sender, receiver, and group images
                if ($sortedMessages['sender_user_id'] != Auth::id() && !isset($sortedMessages['sender_user_id'])) {
                    $sortedMessages['image'] = User::find($sortedMessages['sender_user_id'])->image ?? 'user-profile.png';
                } elseif (!isset($sortedMessages['sender_user_id'])) {
                    $sortedMessages['image'] = User::find($sortedMessages['receiver_user_id'])->image ?? 'user-profile.png';
                } elseif (isset($sortedMessages['sender_user_id'])) {
                    $sortedMessages['image'] = User::find($sortedMessages['sender_user_id'])->image ?? 'user-profile.png';
                }

                $sortedConversations[] = $sortedMessages;
            }
        }
        $data['allconver'] = $sortedConversations;

        $data['settings'] = response([
            "liveChatFileUpload" => setting('liveChatFileUpload'),
            "AgentlivechatMaxFileUpload" => setting('AgentlivechatMaxFileUpload'),
            "AgentlivechatFileUploadMax" => setting('AgentlivechatFileUploadMax'),
            "AgentlivechatFileUploadTypes" => setting('AgentlivechatFileUploadTypes'),
            "liveChatAgentFileUpload" => setting('liveChatAgentFileUpload'),
        ]);
        
        $data['timezonedata'] = Auth::user()->timezone ?? setting('default_timezone');
        return $data;
    }

    public function groupconversion(Request $request, $id)
    {
        $group_conver = AgentGroupConversation::where('unique_id', $id)->get();

        foreach ($group_conver as $group_convers) {
            if (!$group_convers->mark_as_unread) {
                $group_convers->mark_as_unread = [Auth::user()->id];
                $group_convers->save();
            } else {
                if (!in_array(Auth::id(), $group_convers->mark_as_unread)) {
                    $existingData = [];
                    $existingData = $group_convers->mark_as_unread;

                    $newUserId = Auth::user()->id;
                    $existingData[] = $newUserId;
                    $group_convers->mark_as_unread = json_encode($existingData);

                    $group_convers->save();
                }
            }
            $markAsUnread = (array) $group_convers->mark_as_unread;
            $receiverUserId = (array) $group_convers->receiver_user_id;
            if ($markAsUnread && $receiverUserId && empty(array_diff($receiverUserId, $markAsUnread))) {
                $group_convers->update(['message_status' => 'seen']);
            };
        }
        $receiverUsersInfo = null;

        foreach ($group_conver as $group) {
            $receiverUsersInfo = $group->reciever_username;
        }

        // Filter the remove the messages
        $filteredConversations = $group_conver->filter(function ($conversation) {
            $authUserId = Auth::id();
            $receiverUserIds = $conversation->receiver_user_id;
            $deleteStatus = json_decode($conversation->delete_status);
            return in_array($authUserId, $receiverUserIds) && (empty($deleteStatus) || !in_array($authUserId, $deleteStatus));
        });

        $conversationGroup = $filteredConversations->values()->all();
        $group_converLast = AgentGroupConversation::where('unique_id', $id)
            ->where('sender_user_id', Auth::id())
            ->orderBy('id', 'desc')
            ->first();

        event(new AgentMessageEvent(null, null, Auth::id(), null, null, $id, null, null, null, null, null, null, null, $group_converLast ? $group_converLast->message_status : null, $id));


        return response()->json(['livechatdata' => $conversationGroup, 'receiverUsersInfo' => $receiverUsersInfo, 'unique_id' => $id]);
    }


    public function singleoperator(Request $request, $id)
    {
        $seenconversation = AgentConversation::where('receiver_user_id', Auth::id())->where('sender_user_id', $id)->get();
        foreach ($seenconversation as $seenconversations) {
            if ($seenconversations->message_status != 'seen') {
                $seenconversations->message_status = 'seen';
                $seenconversations->save();
            }
        }

        $userId = AgentConversation::where('sender_user_id', Auth::id())->where('receiver_user_id', $id)->first();
        if ($userId == null) {
            $userId = AgentConversation::where('receiver_user_id', Auth::id())->where('sender_user_id', $id)->first();
        }

        if ($userId != null) {
            $userconversation = AgentConversation::where('unique_id', $userId->unique_id)
                ->where(function ($query) {
                    $query->whereJsonDoesntContain('delete_status', Auth::id())
                        ->orWhereNull('delete_status');
                })
                ->get();
        } else {
            $userconversation = null;
        }
        $user = Auth::user();
        $receiverdata = User::find($id);
        event(new AgentMessageEvent(null, null, $user->id, null, null, $id, null, null, null, null, null, null, null, null, $userId ? $userId->unique_id : null));

        if ($userId != null) {
            $this->markasread($userId->unique_id);
        }
        return response()->json(['senderdata' => $user, 'receiverdata' => $receiverdata, 'userconversation' => $userconversation, 'unique_id' => $userId ? $userId->unique_id : null]);
    }

    public function conversationdelete(Request $request, $id)
    {
        $allconver = AgentConversation::where('unique_id', $id)->get();
        foreach ($allconver as $allconvers) {

            if (!$allconvers->delete_status) {
                $allconvers->delete_status = [Auth::user()->id];
                $allconvers->save();
            } else {
                if (!in_array(Auth::id(), json_decode($allconvers->delete_status))) {
                    $existingData = [];
                    $existingData = json_decode($allconvers->delete_status, true);

                    $newUserId = Auth::user()->id;
                    $existingData[] = $newUserId;
                    $allconvers->delete_status = json_encode($existingData);


                    $allconvers->save();
                }
            }
        }

        $this->markasread($id);


        return response()->json(['success' => 'Conversations deleted successfully.']);
    }

    public function broadcastoperatorReplyViewed(Request $request)
    {
        $user = Auth::user();
        $data = [];
        $unique_id  = $request->unique_id;
        if ($request->type == 'operator') {
            $uniqueId = AgentConversation::where('unique_id', $unique_id)
                ->where('receiver_user_id', $user->id)
                ->update(['message_status' => 'seen']);
            $data['Conversation'] = AgentConversation::where('unique_id', $unique_id)->get();
        } else if ($request->type == 'group') {
            $uniqueId1 = AgentGroupConversation::where('unique_id', $unique_id)
                ->whereJsonContains('receiver_user_id', $user->id)->where('message_status', '!=', 'seen')->get();
            if ($uniqueId1) {
                foreach ($uniqueId1 as $record) {
                    $maskAsUnread = is_string($record->mark_as_unread) ? json_decode($record->mark_as_unread, true) :  $record->mark_as_unread;
                    $receiverUserId = is_string($record->receiver_user_id) ? json_decode($record->receiver_user_id, true) : $record->receiver_user_id;
                    if (is_array($maskAsUnread) && is_array($receiverUserId)) {
                        // Check if user ID is in maskAsUnread, if not, add it
                        if (!in_array($user->id, $maskAsUnread)) {
                            $maskAsUnread[] = $user->id;
                            // Optionally, update the record in the database if you want the change to persist
                            $record->update(['mark_as_unread' => json_encode($maskAsUnread)]);
                        }
                        sort($maskAsUnread);
                        sort($receiverUserId);
                        if ($maskAsUnread == $receiverUserId) {
                            $record->update(['message_status' => 'seen']);
                        }
                    }
                }
            }
            $data['Conversation'] = AgentGroupConversation::where('unique_id', $unique_id)->get();
        }

        return $data;
    }
    public function broadcastoperator(Request $request)
    {
        $user = Auth::user();

        $receiverdata = User::find($request->receiverId);

        $uniqueId = AgentConversation::where('sender_user_id', $user->id)->where('receiver_user_id', $request->receiverId)->first();
        $agentConversation = AgentConversation::where('sender_user_id', $user->id)->where('receiver_user_id', $request->receiverId)->get();
        $isNew = null;
        if ($uniqueId == null) {
            $uniqueId = AgentConversation::where('sender_user_id', $request->receiverId)->where('receiver_user_id', $user->id)->first();
            $isNew = "newoperator";
        }

        // event(new AgentMessageEvent($request->message,$request->receiverId,$user->id,$user->name));

        $users = User::get();
        $newconversation = new AgentConversation();
        $newconversation->unique_id = $uniqueId != null ? $uniqueId->unique_id : Str::random(9);
        $newconversation->sender_username = $user->name;
        $newconversation->reciever_username = $receiverdata->name;
        $newconversation->sender_user_id = $user->id;
        $newconversation->receiver_user_id = $request->receiverId;
        $newconversation->message = $request->message;
        $newconversation->message_status = $request->messageStatus;
        $newconversation->created_at = now();

        $messageCount = collect($agentConversation)->filter(function ($message) {
            return $message['message_status'] !== 'seen';
        })->count();

        $newconversation->messageCount = $messageCount + 1;

        if ($request->messageType) {
            $newconversation->message_type = $request->messageType;
            event(new AgentMessageEvent($request->message, $request->receiverId, $user->id, $user->name, null, null, null, null, 'image', $newconversation, $isNew, $users, null, null, $newconversation->unique_id));
        } else {
            event(new AgentMessageEvent($request->message, $request->receiverId, $user->id, $user->name, null, null, null, null, null, $newconversation, $isNew, $users, null, null, $newconversation->unique_id));
        }
        unset($newconversation->messageCount);

        $newconversation->save();

        if ($uniqueId) {
            $this->markasread($uniqueId->unique_id);
        }

        return response()->json(['MessageSent' => $newconversation,]);
    }

    public function agentBroadcastMessageTyping(Request $request)
    {
        $groupincludeIds = AgentGroupConversation::where('unique_id', $request->receiverId)->first() ? AgentGroupConversation::where('unique_id', $request->receiverId)->first()->receiver_user_id : null;
        $user = Auth::user();
        event(new AgentMessageEvent(null, $request->receiverId, $user->id, $user->name, $request->typingMessage, null, Auth::user()->image, $groupincludeIds, null, null, null, null, $request->receiverId));
    }

    public function markasunread(Request $request, $id)
    {
        $agentconver =  AgentConversation::where('unique_id', $id)->latest('updated_at')->latest('id')->first();
        if (!$agentconver->mark_as_unread) {
            $agentconver->mark_as_unread = [Auth::id()];
            $agentconver->save();
        } else {
            if (!in_array(Auth::id(), json_decode($agentconver->mark_as_unread))) {
                $existingData = [];
                $existingData = json_decode($agentconver->mark_as_unread, true);

                $newUserId = Auth::id();
                $existingData[] = $newUserId;
                $agentconver->mark_as_unread = json_encode($existingData);

                $agentconver->save();
            }
        }

        return response()->json(['success' => 'Mark As Unread.']);
    }

    public function markasread($id)
    {
        $agentconver =  AgentConversation::where('unique_id', $id)->get();
        $agentconver->each(function ($message) {
            if (is_array(json_decode($message->mark_as_unread))) {
                $message->update([
                    'mark_as_unread' => array_diff(json_decode($message->mark_as_unread), [auth()->id()])
                ]);
            }
        });

        return response()->json(['success' => 'Mark All As Read.']);
    }

    public function groupbroadcastoperator(Request $request)
    {
        $group = new AgentGroupConversation();
        $group->unique_id = Str::random(9);
        $group->message = 'Group created by' . ' ' . Auth::user()->name;
        $group->sender_username = Auth::user()->name;
        $group->reciever_username = $request->recieverUsersNames;
        $usersArray = explode(',', $request->usersId);
        $uniqueUsers = array_unique($usersArray);
        $group->receiver_user_id = implode(',', $uniqueUsers);
        // $group->receiver_user_id = array_unique($request->usersId);
        $group->sender_user_id = Auth::id();
        $group->created_user_id = Auth::id();
        $group->mark_as_unread = "[" . Auth::user()->id . "]";
        $group->created_at = now();
        $group->save();

        event(new AgentMessageEvent($group->message, $group->unique_id, Auth::id(), Auth::user()->name, null, null, Auth::user()->image, $request->usersId, null, $group, 'newGroup'));
        return response()->json(['group' => $group,]);
    }

    public function groupconversionstore(Request $request, $id)
    {
        $createdId = AgentGroupConversation::where('unique_id', $id)->first();

        if ($createdId->receiver_user_id != $createdId->mark_as_unread) {
            $createdId->mark_as_unread = $createdId->receiver_user_id;
            $createdId->save();
        }
        $group = new AgentGroupConversation();
        $group->unique_id = $id;
        $group->sender_username = Auth::user()->name;
        $group->sender_image = Auth::user()->image;
        $group->reciever_username = $request->recieverUsersNames;
        $group->message = $request->message;
        $group->sender_user_id = Auth::id();
        $usersArray = explode(',', $request->usersId);
        $uniqueUsers = array_unique($usersArray);
        $group->receiver_user_id = implode(',', $uniqueUsers);
        // $group->receiver_user_id = array_unique($request->usersId);
        $group->created_user_id = $createdId->created_user_id;
        $group->mark_as_unread = $request->seenUserIds;
        $group->message_status = $request->messageStatus;
        $group->created_at = now();

        if ($request->messageType) {
            $group->message_type = $request->messageType;
            event(new AgentMessageEvent($request->message, $id, Auth::id(), Auth::user()->name, null, null, Auth::user()->image, $request->usersId, 'image', $group, null, null, null, null, $id));
        } else {
            event(new AgentMessageEvent($request->message, $id, Auth::id(), Auth::user()->name, null, null, Auth::user()->image, $request->usersId, null, $group, null, null, null, null, $id));
        }
        $group->save();
    }

    public function groupconversiondelete($id)
    {
        $groupConversations = AgentGroupConversation::where('unique_id', $id)->get();
        $authId = Auth::id();

        foreach ($groupConversations as $key => $conversation) {
            if (!$conversation->delete_status) {
                $conversation->delete_status = [Auth::user()->id];
                $conversation->save();
            } else {
                if (!in_array(Auth::id(), json_decode($conversation->delete_status))) {
                    $existingData = [];
                    $existingData = json_decode($conversation->delete_status, true);
                    $newUserId = Auth::user()->id;
                    $existingData[] = $newUserId;
                    $conversation->delete_status = json_encode($existingData);
                    $conversation->save();
                }
            }
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Deleted live chat group conversaitons';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => 'Delete Successfully.']);
    }

    public function ChatFlowSave(Request $req)
    {
        livechat_flow::where('active', 1)->update(['active' => 0]);

        $ActiveChat = livechat_flow::where('id', $req->chatId)->first();
        if ($req->chat) {
            $ActiveChat->liveChatFlow = $req->chat;
        }
        $ActiveChat->active = 1;
        $ActiveChat->active_draft = null;
        $ActiveChat->save();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Saved live chat flow';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => lang('Livechat flow saved successfully'), 'flow' => $ActiveChat]);
    }

    public function activeChatFlow(Request $req)
    {
        livechat_flow::where('active', 1)->update(['active' => 0]);
        if ($req->checked) {
            $ActiveChat = livechat_flow::where('id', $req->chatId)->first();
            $ActiveChat->active = 1;
            $ActiveChat->save();
        }
        return response()->json(['success' => lang('Livechat flow saved')]);
    }

    function deleteChatFlow(Request $req, $id)
    {
        $flow = livechat_flow::find($id);
        if ($req->query('active-draft-delete')) {
            $flow->active_draft = null;
            $flow->save();
            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Deleted live chat flow';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();
        } else {
            $flow->delete();
            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Deleted live chat flow';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();
        }
        return response()->json(['success' => lang('Chat Flow Deleted')]);
    }


    public function ChatAutoFlowSave(Request $req)
    {
        $autoSave = null;
        if ($req->chatId == "null") {
            $autoSave = new livechat_flow();
            $autoSave->liveChatFlow = $req->chat;
            $autoSave->responseName = $req->responseName;
            $autoSave->save();
        } else {
            $autoSave = livechat_flow::where('id', $req->chatId)->first();
            if ($autoSave->active == 1) {
                $autoSave->active_draft = $req->chat;
            } else {
                $autoSave->liveChatFlow = $req->chat;
            }
            $autoSave->responseName = $req->responseName;
            $autoSave->save();
        }
        return response()->json(['success' => $autoSave]);
    }

    public function ChatFlowData(Request $request, $id)
    {
        $requaredchart = null;
        if ($id != 'null') {
            $requaredchart = livechat_flow::find($id);
            if ($requaredchart->active_draft) {
                $requaredchart->liveChatFlow = $requaredchart->active_draft;
            }
            $requaredchart->onlineUsers = Setting::where("key", 'All_Online_Users')->first();
            $requaredchart->isonlineoroffline = $this->isonlineoroffline();
            $requaredchart->OnlineStatusMessage = setting('OnlineStatusMessage');
            $requaredchart->OfflineStatusMessage = setting('OfflineStatusMessage');
            $requaredchart->OfflineMessage = setting('OfflineMessage');
            $requaredchart->offlineDisplayLiveChat = setting('offlineDisplayLiveChat');
            $requaredchart->livechatIconSize = setting('livechatIconSize');
            $requaredchart->livechatPosition = setting('livechatPosition');
            $requaredchart->liveChatHidden = setting('liveChatHidden');
            $requaredchart->LivechatCustWelcomeMsg = setting('LivechatCustWelcomeMsg');
            $requaredchart->liveChatIcon = setting('liveChatIcon');
        }

        $activeChatData = livechat_flow::where('active', 1)->first();

        $activeChatDataArray = [
            'onlineUsers' => Setting::where("key", 'All_Online_Users')->first(),
            'isonlineoroffline' => $this->isonlineoroffline(),
            'OnlineStatusMessage' => setting('OnlineStatusMessage'),
            'OfflineStatusMessage' => setting('OfflineStatusMessage'),
            'OfflineMessage' => setting('OfflineMessage'),
            'offlineDisplayLiveChat' => setting('offlineDisplayLiveChat'),
            'livechatIconSize' => setting('livechatIconSize'),
            'livechatPosition' => setting('livechatPosition'),
            'liveChatHidden' => setting('liveChatHidden'),
            'LivechatCustWelcomeMsg' => setting('LivechatCustWelcomeMsg'),
            'liveChatIcon' => setting('liveChatIcon'),
        ];

        if ($activeChatData) {
            $activeChatDataArray = array_merge($activeChatDataArray, $activeChatData->toArray());
        }

        $flow = $id != 'null' ? $requaredchart : $activeChatDataArray;
        return response()->json(['success' => $flow]);
    }

    public function chatResponses()
    {
        $flow = livechat_flow::where('active', 1)->first();
        $data['flow'] = $flow;
        $allDraftflow = livechat_flow::where('active', 0)->get();
        $data['allDraftflow'] = $allDraftflow;
        $data['setting'] = response(['date_format' => setting('date_format')]);
        $data['timezonedata'] = Auth::user()->timezone ?? setting('default_timezone');
        return $data;
    }


    public function testItOut($id)
    {
        $flowChatId = $id;
        $data['flowChatId'] = $flowChatId;

        return $data;
    }

    public function AddOnlineUsers(Request $request)
    {
        $onlineUsers = Setting::where("key", 'All_Online_Users')->first();
        $onlineUsers->update(["value" => $request->users]);
        event(new ChatMessageEvent(null, null, null, null, null, $request->onlineUserUpdated, null, null, null, null, null, null));
    }

    public function engageConversation(Request $request)
    {
        $livecust = LiveChatCustomers::find($request->custId);

        $existingEngageConversation = $livecust->engage_conversation;
        if ($existingEngageConversation === null || $existingEngageConversation == '') {
            $existingEngageConversation = [];
        }
        $newUsers = is_array($request->users) ? $request->users : json_decode($request->users, true);
        $existingIds = array_column($existingEngageConversation, 'id');
        foreach ($newUsers as $user) {
            if (!in_array($user['id'], $existingIds)) {
                $existingEngageConversation[] = $user;
            }
        }
        $livecust->engage_conversation = json_encode($existingEngageConversation);
        $livecust->save();

        // For the Joined comment
        $user = Auth::user();
        $newconversation = new LiveChatConversations();
        $newconversation->unique_id = $livecust->cust_unique_id;
        $newconversation->livechat_user_id = $user->id;
        $newconversation->livechat_username = $user->name;
        $newconversation->message = $user->name . ' joined the discussion at';
        $newconversation->status = 'comment';
        $newconversation->save();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = $user->name . ' joined the livechat discussion';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        event(new ChatMessageEvent(null, null, $user->id, $request->custId, null, null, true, $livecust->engage_conversation, $newconversation->message, null, null, null));

        return response()->json(['success' => "Engaged", 'id' =>  $request->custId]);
    }

    public function solvedChats()
    {

        $user = User::where('id', '!=', Auth::id())->get();
        $data['user'] = $user;

        $livecust = LiveChatCustomers::latest('updated_at')->get();

        $filteredLiveCust = $livecust->filter(function ($item) {
            return !$item->engage_conversation && $item->status == 'solved';
        });

        foreach ($filteredLiveCust as $customer) {
            $livechatdata = LiveChatConversations::where('unique_id', $customer->cust_unique_id)->get();
            $unreadIndexNumber = 0;
            foreach ($livechatdata as $message) {
                if ($message->livechat_cust_id !== null && $message->status != "seen" && !$message->delete) {
                    $unreadIndexNumber = $unreadIndexNumber + 1;
                }
            }
            $customer->unreadIndexNumber = $unreadIndexNumber;
            $customer->lastMessage = $livechatdata->isNotEmpty() ? $livechatdata->last() : null;
        }

        $filteredLiveCust = $filteredLiveCust->sortByDesc(function ($customer) {
            return optional($customer->lastMessage)->created_at->timestamp;
        });

        $data['filteredLiveCust'] = $filteredLiveCust->values()->all();
        $data['userId'] = auth()->user()->id;

        $data['settings'] = [
            'liveChatCustomerOnlineUsers' => setting('liveChatCustomerOnlineUsers'),
            'TICKET_CHARACTER' => setting('TICKET_CHARACTER'),
        ];

        $data['timezonedata'] = Auth::user()->timezone ?? setting('default_timezone');
        
        return $data;
    }

    public function myOpenedChats()
    {
        $livecust = LiveChatCustomers::all();
        $filteredLiveCust = $livecust->filter(function ($customer) {
            $engageConversation = $customer->engage_conversation;
            return collect($engageConversation)->contains('id', auth()->id());
        });


        foreach ($filteredLiveCust as $customer) {
            $livechatdata = LiveChatConversations::where('unique_id', $customer->cust_unique_id)->get();
            $unreadIndexNumber = 0;
            foreach ($livechatdata as $message) {
                if ($message->livechat_cust_id !== null && $message->status != "seen" && !$message->delete) {
                    $unreadIndexNumber = $unreadIndexNumber + 1;
                }
            }
            $customer->unreadIndexNumber = $unreadIndexNumber;
            $customer->lastMessage = $livechatdata->isNotEmpty() ? $livechatdata->last() : null;
        }

        $filteredLiveCust = $filteredLiveCust->sortByDesc(function ($customer) {
            return optional(optional($customer->lastMessage)->created_at)->timestamp;
        });

        $data['filteredLiveCust'] = $filteredLiveCust->values()->all();
        $user = User::where('id', '!=', Auth::id())->get();
        $data['user'] = $user;

        $userCurrent = User::find(Auth::user()->id);
        $userCurrent->getRoleNames()[0] == "superadmin";
        $data['superadmin'] = $userCurrent;

        $categories = Category::whereIn('display', ['ticket', 'all'])->where('status', '1')->get();
        $data['categories'] = $categories;

        $data['settings'] = [
            'liveChatCustomerOnlineUsers' => setting('liveChatCustomerOnlineUsers'),
            'liveChatAgentFileUpload' => setting('liveChatAgentFileUpload'),
            'liveChatFileUpload' => setting('liveChatFileUpload'),
            'AgentlivechatMaxFileUpload' => setting('AgentlivechatMaxFileUpload'),
            'AgentlivechatFileUploadMax' => setting('AgentlivechatFileUploadMax'),
            'AgentlivechatFileUploadTypes' => setting('AgentlivechatFileUploadTypes'),
            'ENVATO_EXPIRED_BLOCK' => setting('ENVATO_EXPIRED_BLOCK'),
            'envato_on' => setting('envato_on'),
            'SUPPORT_POLICY_URL' => setting('SUPPORT_POLICY_URL'),
            'TICKET_CHARACTER' => setting('TICKET_CHARACTER'),
        ];

        $data['userId'] = auth()->user()->id;
        $data['timezonedata'] = Auth::user()->timezone ?? setting('default_timezone');
        return $data;
    }


    public function getCannedmessages()
    {
        $cannedmessages = Cannedmessages::latest()->where('responsetype', 'livechat')->get();
        $data['cannedmessages'] = $cannedmessages;
        return response()->json(['success' => true, 'message' => $data]);
    }


    public function conversationLeave(Request $request)
    {
        $livecust = LiveChatCustomers::find($request->id);
        $engageConversation = $livecust->engage_conversation;
        $engageConversation = array_filter($engageConversation, function ($conversation) use ($request) {
            return $conversation['id'] != auth()->id();
        });
        $livecust->engage_conversation = json_encode(array_values($engageConversation));
        $livecust->save();

        // For the Joined comment
        $user = Auth::user();
        $newconversation = new LiveChatConversations();
        $newconversation->unique_id = $livecust->cust_unique_id;
        $newconversation->livechat_user_id = $user->id;
        $newconversation->livechat_username = $user->name;
        $newconversation->message = $user->name . ' left the discussion at';
        $newconversation->status = 'comment';
        $newconversation->save();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Left the live chat conversation';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        event(new ChatMessageEvent(null, null, $user->id, $request->id, null, null, true, $livecust->engage_conversation, $newconversation->message, null, null, null));
        return response()->json(['success' => 'Left the conversation']);
    }

    public function conversationReassign(Request $request)
    {
        $livecust = LiveChatCustomers::find($request->custId);
        $user = User::find($request->assignUser);
        $authUser  = Auth::user();

        if ($livecust) {
            $engageConversation = $livecust->engage_conversation
                ? $livecust->engage_conversation
                : [];
            $engageConversation = array_filter($engageConversation, function ($participant) use ($authUser) {
                return $participant['id'] !== $authUser->id;
            });
            $userInArray = collect($engageConversation)->first(function ($participant) use ($user) {
                return $participant['id'] === $user->id;
            });
            if (!$userInArray) {
                $engageConversation[] = $user->toArray();
            }
            $livecust->engage_conversation = json_encode(array_values($engageConversation));
            $livecust->save();

            // For the Joined comment
            $newconversation = new LiveChatConversations();
            $newconversation->unique_id = $livecust->cust_unique_id;
            $newconversation->livechat_user_id = $authUser->id;
            $newconversation->livechat_username = $authUser->name;
            $newconversation->message = $authUser->name . ' Reassign discussion to ' . $user->name . ' at ';
            $newconversation->status = 'comment';
            $newconversation->save();
        }
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = $authUser->name . ' Reassign discussion to ' . $user->name;
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        event(new ChatMessageEvent(null, null, $user->id, $request->custId, null, null, true, $livecust->engage_conversation, $newconversation->message, null, null, null));
    }

    public function userSeenMessagesIndication(Request $request)
    {
        LiveChatConversations::where('unique_id', $request->cust_unique_id)
            ->whereNotNull('livechat_user_id')
            ->where(function ($query) {
                $query->where('status', '!=', 'comment')
                    ->orWhereNull('status');
            })
            ->update(['status' => 'seen']);
        event(new ChatMessageEvent(null, null, null, $request->id, null, null, null, null, null, true, null, null));
    }

    public function conversationUnread(Request $request)
    {
        $livecust = LiveChatCustomers::find($request->id);
        $userId = Auth::id();
        $unreadArray = json_decode($livecust->mark_as_unread, true) ?? [];
        if (!in_array($userId, $unreadArray)) {
            $unreadArray[] = $userId;
            $livecust->update(['mark_as_unread' => json_encode($unreadArray)]);
        }
        return response()->json(['success' => 'Unread Conversation successfully']);
    }

    public function removeUserFromUnread(Request $request)
    {
        $livecust = LiveChatCustomers::find($request->id);
        $userId = Auth::id();
        $unreadArray = json_decode($livecust->mark_as_unread, true) ?? [];
        if (($key = array_search($userId, $unreadArray)) !== false) {
            unset($unreadArray[$key]);
            $livecust->update(['mark_as_unread' => json_encode($unreadArray)]);
        }
        return response()->json(['success' => 'Remove User from Unread successfully']);
    }

    function livechatConversationDelete(Request $request)
    {
        $unqid = $request->unqid;
        $userId = Auth::id();
        $liveChatMessages = LiveChatConversations::where('unique_id', $unqid)->get();
        $livecust = LiveChatCustomers::where('cust_unique_id', $liveChatMessages[0]->unique_id)->first();
        $livecust->update(['engage_conversation' => null]);

        foreach ($liveChatMessages as $message) {
            $deleteArray = json_decode($message->delete, true) ?? [];
            if (!in_array($userId, $deleteArray)) {
                $deleteArray[] = $userId;
                $message->update(['delete' => json_encode($deleteArray)]);
            }
        }

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Deleted live chat conversation';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => 'Updated successfully']);
    }
    function markAsSolved(Request $request)
    {
        $livecust = LiveChatCustomers::find($request->id);
        if (isset($livecust->engage_conversation)) {
            foreach ($livecust->engage_conversation as $engageusers) {
                // For the Left User comment
                $user = $engageusers;
                $newconversation = new LiveChatConversations();
                $newconversation->unique_id = $livecust->cust_unique_id;
                $newconversation->livechat_user_id = $user['id'];
                $newconversation->livechat_username = $user['name'];
                $newconversation->message = $user['name'] . ' left the discussion at';
                $newconversation->status = 'comment';
                $newconversation->save();
                $geolocation = GeoIP::getLocation(request()->getClientIp());
                $agent = new Agent();
                $activity = new EmployeeActivity();
                $activity->user_id = Auth::user()->id;
                $activity->activity_type = 'Marks live chat conversation as solved';
                $activity->ip_address = $geolocation->ip;
                $activity->browser = $agent->browser();
                $activity->device = $agent->device();
                $activity->save();
                event(new ChatMessageEvent(null, null, $user['id'], $request->id, null, null, true, $livecust->engage_conversation, $newconversation->message, null, null, null));
            }
        }

        $solvedUser = Auth::user();
        $newconversation = new LiveChatConversations();
        $newconversation->unique_id = $livecust->cust_unique_id;
        $newconversation->livechat_user_id = $solvedUser->id;
        $newconversation->livechat_username = $solvedUser->name;
        $newconversation->message = $solvedUser->name . ' Solved the discussion at';
        $newconversation->status = 'comment';
        $newconversation->save();
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Marks live chat conversation as solved';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        event(new ChatMessageEvent(null, null, $solvedUser->id, $request->id, null, null, true, $livecust->engage_conversation, $newconversation->message, null, null, null));

        $livecust->engage_conversation = '';
        $livecust->status = 'solved';
        $livecust->save();
        return response()->json(['success' => 'Resolved successfully', 'id' => $request->id]);
    }

    function livechatSettings()
    {
        $flow = livechat_flow::where('active', 1)->first();
        $data['flow'] = $flow;

        $soundPath = public_path('uploads/livechatsounds');

        if (file_exists($soundPath)) {
            $soundNames = File::files($soundPath);
        } else {
            $soundNames = [];
        }

        $sounds = [];
        foreach ($soundNames as $soundName) {
            $sounds[] = (object)['name' => $soundName->getFilename()];
        }
        $data['sounds'] = $sounds;

        $data['settings'] = [
            'liveChatFileUpload' => setting('liveChatFileUpload'),
            'LivechatCustWelcomeMsg' => setting('LivechatCustWelcomeMsg'),
            'LivechatCustFeedbackQuestion' => setting('LivechatCustFeedbackQuestion'),
            'livechatMaxFileUpload' => setting('livechatMaxFileUpload'),
            'livechatFileUploadMax' => setting('livechatFileUploadMax'),
            'livechatFileUploadTypes' => setting('livechatFileUploadTypes'),
            'liveChatAgentFileUpload' => setting('liveChatAgentFileUpload'),
            'AgentlivechatMaxFileUpload' => setting('AgentlivechatMaxFileUpload'),
            'AgentlivechatFileUploadMax' => setting('AgentlivechatFileUploadMax'),
            'AgentlivechatFileUploadTypes' => setting('AgentlivechatFileUploadTypes'),
            'liveChatPort' => setting('liveChatPort'),
            'notificationsSounds' => setting('notificationsSounds'),
            'notificationType' => setting('notificationType'),
            'newMessageWebNot' => setting('newMessageWebNot'),
            'newMessageSound' => setting('newMessageSound'),
            'newChatRequestWebNot' => setting('newChatRequestWebNot'),
            'newChatRequestSound' => setting('newChatRequestSound'),
            'operatorsNotificationsSounds' => setting('operatorsNotificationsSounds'),
            'operatorsAgentToAgentWebNot' => setting('operatorsAgentToAgentWebNot'),
            'operatorsAgentToAgentSound' => setting('operatorsAgentToAgentSound'),
            'operatorsGroupChatWebNot' => setting('operatorsGroupChatWebNot'),
            'operatorsGroupChatSound' => setting('operatorsGroupChatSound'),
            'liveChatFlowload' => setting('liveChatFlowload'),
            'livechatIconSize' => setting('livechatIconSize'),
            'livechatPosition' => setting('livechatPosition'),
            'OnlineStatusMessage' => setting('OnlineStatusMessage'),
            'offlineDisplayLiveChat' => setting('offlineDisplayLiveChat'),
            'autoSloveCloseTimer' => setting('autoSloveCloseTimer'),
            'OfflineStatusMessage' => setting('OfflineStatusMessage'),
            'OfflineMessage' => setting('OfflineMessage'),
            'enableAutoSlove' => setting('enableAutoSlove'),
            'autoSloveEmailTimer' => setting('autoSloveEmailTimer'),
            'livechatFeedbackDropdown' => setting('livechatFeedbackDropdown'),
            'serversslcertificate' => setting('serversslcertificate'),
            'serversslkey' => setting('serversslkey'),
            'serverssldomainname' => setting('serverssldomainname'),
            'liveChatHidden' => setting('liveChatHidden'),
            'AUTO_DELETE_LIVECHAT_ENABLE' => setting('AUTO_DELETE_LIVECHAT_ENABLE'),
            'AUTO_DELETE_LIVECHAT_IN_MONTHS' => setting('AUTO_DELETE_LIVECHAT_IN_MONTHS'),
            'liveChatIcon' => setting('liveChatIcon'),
        ];

        $domainname = url('/');
        $data['domainname'] = $domainname;
        return $data;
    }

    function liveChatNotificationsSetting(Request $request)
    {
        $data['notificationsSounds']  =  $request->notificationsSounds == "true" ? true : false;
        $data['newMessageWebNot'] = $request->newMessageWebNot == "true" ? true : false;
        $data['newMessageSound'] = $request->newMessageSound;
        $data['newChatRequestWebNot'] = $request->newChatRequestWebNot == "true" ? true : false;
        $data['notificationType'] = $request->notificationType;
        $this->updateSettings($data);
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Updated live chat notification settingfs';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['success' => 'Updated successfully']);
    }

    function liveChatNotificationsSound(Request $request)
    {

        $request->validate([
            'uploadSound' => 'required|mimes:mp3,audio/*',
        ]);
        $path = public_path('uploads/livechatsounds');
        $file = $request->file('uploadSound');
        $filename = $file->getClientOriginalName();
        $file->move($path, $filename);
        return response()->json(['success' => true, 'message' => 'Sound uploaded successfully']);
    }

    function liveChatIcon(Request $request)
    {
        if ($request->file('livechaticon')) {
            $request->validate([
                'livechaticon' => 'required|mimes:jpg,jpeg,png,svg|max:512',
            ]);

            //delete old file
            $livechaticon = setting('liveChatIcon');
            $imagepath = public_path('/uploads/livechaticon/' . $livechaticon);

            if (\File::exists($imagepath)) {
                \File::delete($imagepath);
            }
            //insert new file
            $path = public_path('uploads/livechaticon');
            if (!File::exists($path)) {
                File::makeDirectory($path, 0777, true);
            }
            $file = $request->file('livechaticon');
            $filename = date('YmdHis') . "." . $file->getClientOriginalName();
            $file->move($path, $filename);
            $data['liveChatIcon'] = "$filename";

            $this->updateSettings($data);

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Updated live chat icon image';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();

            return response()->json(['success' => true, 'message' => 'livechat Icon uploaded successfully']);
        }

        if ($request->delete_icon == true) {
            // Handle delete logic
            $livechaticon = setting('liveChatIcon');
            if ($livechaticon) {
                $imagepath = public_path('/uploads/livechaticon/' . $livechaticon);
                if (\File::exists($imagepath)) {
                    \File::delete($imagepath);
                }
                // Update settings to remove the icon
                $data['liveChatIcon'] = null;
                $this->updateSettings($data);

                $geolocation = GeoIP::getLocation(request()->getClientIp());
                $agent = new Agent();
                $activity = new EmployeeActivity();
                $activity->user_id = Auth::user()->id;
                $activity->activity_type = 'Deleted live chat icon';
                $activity->ip_address = $geolocation->ip;
                $activity->browser = $agent->browser();
                $activity->device = $agent->device();
                $activity->save();

                return response()->json(['success' => 'Livechat icon deleted successfully']);
            }

            return response()->json(['error'=> 'No livechat icon found to delete']);
        }
    }
    function liveChatFlowSettings(Request $request)
    {
        $data['liveChatFlowload']  =  $request->liveChatFlowload;
        $this->updateSettings($data);
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Updated live chat flow setting';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['success' => 'Updated successfully']);
    }


    function liveChatImageUpload(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'chatFileUpload' => 'required|file',
        ]);

        if ($validator->passes()) {
            $path = public_path('uploads/livechat');
            $file = $request->file('chatFileUpload');
            $filename =  time() . '' . $file->getClientOriginalName();
            $file->move($path, $filename);
            return response()->json(['success' => true, 'message' => 'Image Upload', 'image' => url('') . '/public/uploads/livechat/' . $filename, 'uploadedfilename' => $filename]);
        }
        return response()->json(['uploadError' => lang('The given file is invalid.')]);
    }

    function removeChatImage(Request $request)
    {
        $path = public_path('uploads/livechat');
        $filepath = $path . '/' . $request->filename;

        if (File::exists($filepath)) {
            File::delete($filepath);
            return response()->json(['success' => true, 'message' => 'File removed']);
        } else {
            return response()->json(['success' => false, 'message' => 'File not found']);
        }
    }

    function liveChatFileSettings(Request $request)
    {
        $userfileuploadtypes = explode(',', $request->livechatFileUploadTypes);
        $fileuploadtypes = explode(',', $request->AgentlivechatFileUploadTypes);
        // $allowedFormats = ['.xlsx', '.csv', '.docx', '.pdf', '.jpg', '.jpeg', '.png', '.mp3', '.wav', '.mp4', '.zip', '.webp'];
        // if ($request->livechatFileUploadTypes != null) {
        //     foreach ($userfileuploadtypes as $userfileuploadtype) {
        //         if (!in_array($userfileuploadtype, $allowedFormats)) {
        //             return back()->with('error', lang('You are enter wrong file formats please enter correct format.', 'alerts'));
        //         }
        //     }
        // }
        // if ($request->AgentlivechatFileUploadTypes != null) {
        //     foreach ($fileuploadtypes as $fileuploadtype) {
        //         if (!in_array($fileuploadtype, $allowedFormats)) {
        //             return back()->with('error', lang('You are enter wrong file formats please enter correct format.', 'alerts'));
        //         }
        //     }
        // }

        if ($request->has('liveChatFileUpload')) {
            $request->validate([
                'livechatMaxFileUpload' => 'required|numeric|gt:0',
                'livechatFileUploadMax' => 'required|numeric|gt:0',
            ]);
        }

        if ($request->has('liveChatAgentFileUpload')) {
            $request->validate([
                'AgentlivechatMaxFileUpload' => 'required|numeric|gt:0',
                'AgentlivechatFileUploadMax' => 'required|numeric|gt:0',
            ]);
        }

        $livecust = LiveChatCustomers::all();
        if ($request->livechatMaxFileUpload) {
            $data['liveChatFileUpload']  =  $request->liveChatFileUpload ? true : false;
            if ($request->liveChatFileUpload) {
                foreach ($livecust as $cust) {
                    $cust->update(['file_upload_permission' => $request->liveChatFileUpload ? true : false]);
                }
            } else {
                foreach ($livecust as $cust) {
                    $cust->update(['file_upload_permission' => false]);
                }
            }
            $data['livechatMaxFileUpload'] = $request->livechatMaxFileUpload;
            $data['livechatFileUploadMax'] = $request->livechatFileUploadMax;
            $data['livechatFileUploadTypes'] = $request->livechatFileUploadTypes;
        } else {
            $data['liveChatAgentFileUpload']  =  $request->liveChatAgentFileUpload ? true : false;
            $data['AgentlivechatMaxFileUpload'] = $request->AgentlivechatMaxFileUpload;
            $data['AgentlivechatFileUploadMax'] = $request->AgentlivechatFileUploadMax;
            $data['AgentlivechatFileUploadTypes'] = $request->AgentlivechatFileUploadTypes;
        }
        $this->updateSettings($data);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'updated live chat file setting';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['success' => 'Updated successfully']);
    }

    function liveChatCustFileUpload(Request $request)
    {
        $livecust = LiveChatCustomers::find($request->custUser);
        $livecust->file_upload_permission = $request->permission == 'true' ? 1 : 0;
        $livecust->save();
        event(new ChatMessageEvent(null, null, null, null, null, null, null, null, null, null, 'fileuploadermision', null, null, $livecust));
        return response()->json(['success' => true, 'message' => 'Updated successfully']);
    }

    function livechatNotificationsSonds(Request $request)
    {

        $soundPath = public_path('uploads/livechatsounds');
        if (file_exists($soundPath)) {
            $perPage = 10;
            // Get all files from the directory
            $soundFiles = File::files($soundPath);
            $filesCollection = collect($soundFiles)->map(function ($file) {
                return [
                    'path' => $file->getPathname(),
                    'name' => $file->getFilename(),
                ];
            });

            $currentPage = LengthAwarePaginator::resolveCurrentPage();
            $currentItems = $filesCollection->slice(($currentPage - 1) * $perPage, $perPage)->all();
            $paginatedFiles = new LengthAwarePaginator($currentItems, $filesCollection->count(), $perPage);

            // return $paginatedFiles;
            $data['queryList'] = $paginatedFiles;
        } else {
            $data['queryList'] = new Paginator([], 0, 10, [1], [
                'path' => Paginator::resolveCurrentPath(),
            ]);
        }


        return $data;
    }

    function livechatNotificationsSondsDelete(Request $request)
    {
        $path = public_path('uploads/livechatsounds');
        $filepath = $path . '/' . $request['sound'];

        if (File::exists($filepath)) {
            File::delete($filepath);
            return response()->json(['success' => 'Deleted successfully']);
        } else {
            return response()->json(['error' => 'File not found']);
        }
    }

    function livechatNotificationsMassSondsDelete(Request $request)
    {
        $path = public_path('uploads/livechatsounds');
        foreach ($request->id as $soung) {
            $filepath = $path . '/' . $soung;
            if (File::exists($filepath)) {
                File::delete($filepath);
            }
        }
        return response()->json(['success' => true, 'message' => 'Updated successfully']);
    }

    function liveChatIconSize(Request $request)
    {
        if ($request->livechatIconSize) {
            $data['livechatIconSize'] = $request->livechatIconSize;
            $this->updateSettings($data);
            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'updated live chat icon size setting';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();
            return response()->json(['success' => 'Updated successfully']);
        }
    }

    function liveChatPosition(Request $request)
    {
        if ($request->livechatPosition) {
            $data['livechatPosition'] = $request->livechatPosition;
            $this->updateSettings($data);
            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'updated live chat position setting';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();
            return response()->json(['success' => 'Updated successfully']);
        }
    }

    function liveChatOfflineSetting(Request $request)
    {
        $request->validate([
            'OnlineStatusMessage' => 'required',
            'OfflineStatusMessage' => $request->offlineDisplayLiveChat ? 'required' : '',
            'OfflineMessage' => $request->offlineDisplayLiveChat ? 'required' : '',
        ]);
        $data['offlineDisplayLiveChat']  =  $request->offlineDisplayLiveChat == "true" ? true : false;
        $data['OfflineStatusMessage']  =  $request->OfflineStatusMessage;
        $data['OnlineStatusMessage']  =  $request->OnlineStatusMessage;
        $data['OfflineMessage']  =  $request->OfflineMessage;
        $this->updateSettings($data);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'updated livechat offline setting';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['success' => 'Updated successfully']);
    }

    private function isonlineoroffline()
    {
        $status = null;
        // $status = 'offline';
        $now = now();
        $holidays = \App\Models\Holiday::whereDate('startdate', '<=', $now->toDateString())->where('status', '1')->get();
        if ($holidays->isNotEmpty()) {
            $status = 'offline';
        } else {
            foreach (bussinesshour() as $bussiness) {
                if (now()->timezone(setting('default_timezone'))->format('D') == $bussiness->weeks) {
                    if (strtotime($bussiness->starttime) <= strtotime(now()->timezone(setting('default_timezone'))->format('h:i A')) && strtotime($bussiness->endtime) >= strtotime(now()->timezone(setting('default_timezone'))->format('h:i A')) || $bussiness->starttime == "24H") {
                        $status = 'online';
                    } else {
                        $status = 'offline';
                    }
                }
            }
        }

        return $status;
    }

    function operatorsNotificationsSetting(Request $request)
    {
        $data['operatorsNotificationsSounds']  =  $request->operatorsNotificationsSounds == "true" ? true : false;
        $data['operatorsAgentToAgentWebNot'] = $request->operatorsAgentToAgentWebNot == "true" ? true : false;
        $data['operatorsGroupChatWebNot'] = $request->operatorsGroupChatWebNot == "true" ? true : false;
        $data['operatorsAgentToAgentSound'] = $request->operatorsAgentToAgentSound;
        $data['operatorsGroupChatSound'] = $request->operatorsGroupChatSound;
        $this->updateSettings($data);
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'updated live chat operatorsNotificationsSetting';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['success' => 'Updated successfully']);
    }
    function livechatssldstore(Request $request)
    {

        $request->validate([
            'sslcertificate' => 'required',
            'sslkey' => 'required',
        ]);

        $domainname = parse_url(url('/'));
        $appurl = url('/');
        if (setting('serverssldomainname') == $appurl) {
            return response()->json(['error' => 'Your ssl certificate details all ready working, do not edit it.']);
        } else {
            file_put_contents(base_path('config/localhost/server.key'), $request->sslkey);
            file_put_contents(base_path('config/localhost/server.crt'), $request->sslcertificate);

            $localCertPath = base_path('config/localhost/server.crt');
            $localKeyPath = base_path('config/localhost/server.key');

            try {
                $remoteCert = SslCertificate::createForHostName($domainname['host']);
                $remoteCertArray = $remoteCert->toArray();

                // if ($remoteCert->isValid()) {
                    $certContent = file_get_contents($localCertPath);
                    $keyContent = file_get_contents($localKeyPath);

                    $certDetails = openssl_x509_parse($certContent);

                    if ($certDetails === false) {
                        return response()->json(['error' => 'Failed to parse certificate: ' . openssl_error_string()]);
                    } else {
                        $keyValid = openssl_x509_check_private_key($certContent, $keyContent);

                        if ($keyValid) {
                            $data['serversslcertificate'] = $request->sslcertificate;
                            $data['serversslkey'] = $request->sslkey;
                            $data['serverssldomainname'] = $appurl;
                            $this->updateSettings($data);
                            $geolocation = GeoIP::getLocation(request()->getClientIp());
                            $agent = new Agent();
                            $activity = new EmployeeActivity();
                            $activity->user_id = Auth::user()->id;
                            $activity->activity_type = 'updated live chat ssl certificate data';
                            $activity->ip_address = $geolocation->ip;
                            $activity->browser = $agent->browser();
                            $activity->device = $agent->device();
                            $activity->save();
                            return response()->json(['success' => 'SSL certificate data has been saved successfully.']);
                        } else {
                            return response()->json(['error' => 'The private key does not correspond to the given certificate']);
                        }
                    }
                // } else {
                //     return response()->json(['error' => 'Your ssl certificate is not valid.']);
                // }
            } catch (Exception $e) {
                return response()->json(['error' => $e->getMessage()]);
            }
        }
    }

    function livechatCredentials(Request $request)
    {
        if (setting('serverssldomainname') == null || setting('serverssldomainname') != url('/')) {
            return response()->json(['code' => 500, 'error' => lang("First you need to setup ssl cert and key details correctly.", "alerts")], 500);
        } else {

            if ($request->liveChat_hidden != "false") {
                $request->validate([
                    'liveChatPort' => 'required',
                ]);

                $data['liveChatHidden'] = 'false';
                $data['liveChatPort'] = $request->liveChatPort;
                $this->updateSettings($data);

                if ($request->liveChatPort != setting('liveChatPort')) {
                    try {
                        $data['liveChatHidden'] = $request->liveChat_hidden ? 'false' : 'true';
                        $data['liveChatPort'] = $request->liveChatPort;
                        $this->updateSettings($data);

                        $startport = $request->liveChatPort;
                        $serveProcess = new Process(["php", "artisan", "websockets:serve", "--port=$startport"]);
                        $serveProcess->start();

                        sleep(3);

                        return response()->json(['success' => "WebSocket server started on port $startport."], 200);
                    } catch (\Exception $e) {
                        return response()->json(['code' => 500, 'error' => $e->getMessage()], 500);
                    }
                }

                return response()->json(["code" => 200, "success" => "This websocket is already started, please re-start your server websokcet if it is not work. "], 200);
            } else {
                $data['liveChatHidden'] = 'true';
                $data['liveChatPort'] = $request->liveChatPort;
                $this->updateSettings($data);
                $geolocation = GeoIP::getLocation(request()->getClientIp());
                $agent = new Agent();
                $activity = new EmployeeActivity();
                $activity->user_id = Auth::user()->id;
                $activity->activity_type = 'updated live chat credentials setting';
                $activity->ip_address = $geolocation->ip;
                $activity->browser = $agent->browser();
                $activity->device = $agent->device();
                $activity->save();

                return response()->json(["code" => 200, "success" => "Data updated successfully"], 200);
            }
        }
    }
    function livechatAutoSave(Request $request)
    {
        $request->validate([
            'autoSloveEmailTimer' => 'required|numeric|gt:0',
            'autoSloveCloseTimer' => 'required|numeric|gt:0',
        ]);

        $data['enableAutoSlove']  =  $request->enableAutoSlove ? true : false;
        $data['autoSloveEmailTimer'] = $request->autoSloveEmailTimer;
        $data['autoSloveCloseTimer'] = $request->autoSloveCloseTimer;
        $this->updateSettings($data);
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'updated live chat autosave setting';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(["code" => 200, "success" => "updated successfully"], 200);
    }

    function livechatAutoDelete(Request $request)
    {
        if ($request->has('AUTO_DELETE_LIVECHAT_ENABLE')) {
            $request->validate([
                'AUTO_DELETE_LIVECHAT_IN_MONTHS' => 'required|numeric|gt:0',
            ]);
        }

        $data['AUTO_DELETE_LIVECHAT_ENABLE']  =  $request->has('AUTO_DELETE_LIVECHAT_ENABLE') ? 'on' : 'off';
        $data['AUTO_DELETE_LIVECHAT_IN_MONTHS'] = $request->AUTO_DELETE_LIVECHAT_IN_MONTHS;
        $this->updateSettings($data);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'updated live chat auto delete setting';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['success' => 'Updated successfully']);
    }


    function livechatTickets(Request $request)
    {
        $user = User::with('usetting')->findOrFail(Auth::user()->id);
        $data['timezonedata'] = Auth::user()->timezone ?? setting('default_timezone');;
        $role = Role::where('name', $user->getRoleNames()[0])->get();
        foreach ($role as $roles) {
            $data['permissions'] = $roles->getPermissionNames();
        }
        $query = Ticket::where('cust_id', $request->id)->with('cust', 'ticketdraft', 'ticketnote', 'ticketassignmutliples', 'selfassign', 'category', 'users')->latest('tickets.updated_at');
        $category      = $request['categories'] ?? null;
        $user  = $request['user'] ?? null;
        $status  = $request['status'] ?? null;
        $searchTerm = $request['filter'] ?? null;
        $perPage    = $request['per_page'] ?? 15;
        $page       = $request['page'] ?? 1;
        // filter by category
        if ($category && $category != 'null') {
            $query->where('category_id', $category);
        }

        // get only tickets that specified user has created
        if ($user && $user != 'null') {
            $query->WhereHas('cust', function ($query) use ($user) {
                $query->where('userType', $user);
            });
        }
        // get only tickets that specified user has created
        if ($status && $status != 'null') {
            $query->where('status', $status);
        }

        if ($searchTerm) {
            $query->where(function ($query) use ($searchTerm) {
                $columns = Schema::getColumnListing('tickets');
                foreach ($columns as $column) {
                    $query->orWhere($column, 'LIKE', "%{$searchTerm}%");
                }
                $query->orWhereHas('category', function ($query) use ($searchTerm) {
                    $query->where('name', 'LIKE', $searchTerm . '%');
                })->orWhereHas('cust', function ($query) use ($searchTerm) {
                    $query->where('username', 'LIKE', $searchTerm . '%');
                })
                    ->orWhereHas('selfassign', function ($query) use ($searchTerm) {
                        $query->where(function ($query) use ($searchTerm) {
                            $query->where('name', 'LIKE', "%{$searchTerm}%");
                            // Check for 'self' in the search term
                            if (strpos('self', strtolower($searchTerm)) !== false) {
                                // Also check if the selfassignuser_id is not null
                                $query->orWhere('selfassignuser_id', '!=', null);
                            }
                        });
                    })
                    ->orWhereHas('ticketassignmutliples', function ($query) use ($searchTerm) {
                        // Assuming you defined the 'assignedUser()' relationship in ticketassignchild model
                        $query->whereHas('toassignuser', function ($query) use ($searchTerm) {
                            $query->where('name', 'LIKE', "%{$searchTerm}%");
                        });
                        if (stripos('multi Assign', strtolower($searchTerm)) !== false) {
                            $query->orWhere('ticket_id', '!=', null);
                        }
                    });
            });
        }
        $items = $query->paginate($perPage);
        $data['queryList'] = $items;
        $data['setting'] = response()->json(['date_format' => setting('date_format'), 'time_format' => setting('time_format')]);
        return $data;
    }

    function livechatTicketMassDelete(Request $request)
    {
        foreach ($request->id as $ticketId) {
            Ticket::where('ticket_id', $ticketId)->delete();
        }
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Deleted live chat tickets';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['success' => true, 'message' => 'Updated successfully']);
    }

    function livechatTicketDelete(Request $request)
    {
        Ticket::where('ticket_id', $request->id)->delete();
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Deleted live chat ticket';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['success' => true, 'message' => 'Updated successfully']);
    }

    function livechatCustomerOnline(Request $request)
    {
        $currentOnlineUsers = setting('liveChatCustomerOnlineUsers');
        $onlineUsersArray = explode(',', $currentOnlineUsers);
        $custID = $request->custID;
        if (!in_array($custID, $onlineUsersArray)) {
            $onlineUsersArray[] = $custID;
            $updatedOnlineUsers = implode(',', $onlineUsersArray);
            Setting::where('key', 'liveChatCustomerOnlineUsers')->update(['value' => $updatedOnlineUsers]);
            event(new ChatMessageEvent(null, null, null, $request->custID, null, null, null, null, null, null, null, "online"));
        }
    }

    function removeLivechatOnlineUsers(Request $request)
    {
        $currentOnlineUsers = setting('liveChatCustomerOnlineUsers');
        $onlineUsersArray = explode(',', $currentOnlineUsers);
        $index = array_search($request->custID, $onlineUsersArray);
        if ($index !== false) {
            unset($onlineUsersArray[$index]);
            $updatedOnlineUsers = implode(',', $onlineUsersArray);
            Setting::where('key', 'liveChatCustomerOnlineUsers')->update(['value' => $updatedOnlineUsers]);
            event(new ChatMessageEvent(null, null, null, $request->custID, null, null, null, null, null, null, null, "offline"));
        }
    }

    function livechatFeedbackDropdown(Request $request)
    {
        $request->validate([
            'LivechatCustFeedbackQuestion' => 'required',
        ]);

        $data['livechatFeedbackDropdown'] = $request->livechatFeedbackDropdown;
        $data['LivechatCustFeedbackQuestion'] = $request->LivechatCustFeedbackQuestion;
        $this->updateSettings($data);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'updated live chat feedback setting';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['success' => 'Updated successfully']);
    }

    function LivechatCustWelcomeMsg(Request $request)
    {
        $request->validate([
            'LivechatCustWelcomeMsg' => 'required',
        ]);

        $data['LivechatCustWelcomeMsg'] = $request->LivechatCustWelcomeMsg;
        $this->updateSettings($data);
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'updated live chat welcome msg setting';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['success' => 'Updated successfully']);
    }
    function livechatAllRatings(Request $request)
    {
        $users = User::with(['roles', 'livechatReviews'])
            ->withAvg('livechatReviews', 'starRating')
            ->latest();


        $searchTerm = $request['filter'] ?? null;
        $perPage    = $request['per_page'] ?? 15;
        $page       = $request['page'] ?? 1;

        if ($searchTerm) {
            $users->where(function ($query) use ($searchTerm) {
                $columns = Schema::getColumnListing('users');
                foreach ($columns as $column) {
                    $query->orWhere($column, 'LIKE', "%{$searchTerm}%");
                }
                $query->orWhereHas('roles', function ($query) use ($searchTerm) {
                    $query->where('name', 'LIKE', $searchTerm . '%');
                });
            });
        }
        $items = $users->paginate($perPage);
        $items->loadCount('liveChatConversations');

        $data['queryList'] = $items;
        $reviewsData = livechatReviews::all();
        $data['reviewsData'] = $reviewsData;

        return $data;
    }

    function livechatEmpliyerRatings(Request $req, $id)
    {
        $users = User::with('roles')->find($id);
        $data['users'] = $users;

        $query = livechatReviews::with('livechatcust')->where('users_id', $id)->latest();
        $category      = $request['categories'] ?? null;
        $user  = $request['user'] ?? null;
        $status  = $request['status'] ?? null;
        $searchTerm = $request['filter'] ?? null;
        $perPage    = $request['per_page'] ?? 15;
        $page       = $request['page'] ?? 1;
        // filter by category
        if ($category && $category != 'null') {
            $query->where('category_id', $category);
        }

        // get only tickets that specified user has created
        if ($user && $user != 'null') {
            $query->WhereHas('cust', function ($query) use ($user) {
                $query->where('userType', $user);
            });
        }
        // get only tickets that specified user has created
        if ($status && $status != 'null') {
            $query->where('status', $status);
        }

        if ($searchTerm) {
            $query->where(function ($query) use ($searchTerm) {
                $columns = Schema::getColumnListing('livechat_reviews');
                foreach ($columns as $column) {
                    $query->orWhere($column, 'LIKE', "%{$searchTerm}%");
                };
            });
        }
        $items = $query->paginate($perPage);
        $data['reviewsData'] = $items;
        // $data['reviewsData'] = $reviewsData;

        return $data;
    }

    function livechatDeleteFeedback($id)
    {
        $review = livechatReviews::find($id);
        $review->delete();
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Deleted live chat feedback';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['success' => 'Updated successfully']);
    }

    public function downloadFile(Request $req)
    {
        $file = $req->file('file');
        $email = $req->input('email');
        // return $file;
        Mail::send([], [], function ($message) use ($email, $file) {
            $message->to($email)
                ->subject('Your LiveChat backup file')
                ->attach($file->getRealPath(), [
                    'as' => $file->getClientOriginalName(), // You can set the attachment name here
                ])
                ->setBody('Your LiveChat backup file'); // You can set the body of the email here
        });

        // Check if the email was sent successfully
        if (count(Mail::failures()) > 0) {
            return response()->json(['message' => 'Failed to send email'], 500);
        }

        return response()->json(['message' => 'Email sent successfully'], 200);
    }

    function securitySettings(Request $request)
    {
        $data['inspectDisable'] = $request->inspectDisable ? "on" : "off";
        $data['selectDisabled'] = $request->selectDisabled ? "on" : "off";
        $this->updateSettings($data);
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'updated live chat security setting';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['success' => 'Updated successfully']);
    }



    private function updateSettings($data)
    {
        foreach ($data as $key => $val) {
            $setting = Setting::where('key', $key);
            if ($setting->exists())
                $setting->first()->update(['value' => $val]);
        }
    }
}
