<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Jenssegers\Agent\Agent;
use Torann\GeoIP\Facades\GeoIP;
use App\Models\EmployeeActivity;
use Illuminate\Support\Facades\Auth;

class PermissionstatusController extends Controller
{
   public function index()
   {
        $role = Role::get();
        $data['role'] = $role;
        $permission = Permission::get();
        $data['permission'] = $permission;

        return view ('admin.roles.index')->with($data)->with('i', (request()->input('page', 1) - 1) * 5);
    }



    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
            
        ]);
    
        $role = Role::find($id);
        $role->name = $request->input('name');
        $role->save();
    

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Updated role';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        $role->syncPermissions($request->input('permission'));
        
        return response()->json(['success' => 'Role updated successfully']);
    }
}
