<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Setting;
use App\Models\Countries;
use GeoIP;
use Auth;
use Jenssegers\Agent\Agent;
use App\Models\EmployeeActivity;

class SecuritySettingController extends Controller
{
    public function index()
    {
        $country = Countries::all();
        $data['countries'] = $country;

        $data['IPBLOCKTYPE'] = setting('IPBLOCKTYPE');
        $data['IPMAXATTEMPT'] = setting('IPMAXATTEMPT');
        $data['IPSECONDS'] = setting('IPSECONDS');
        $data['DOS_Enable'] = setting('DOS_Enable');
        $data['EMAILDOMAIN_BLOCKTYPE'] = setting('EMAILDOMAIN_BLOCKTYPE');
        $data['EMAILDOMAIN_LIST'] = setting('EMAILDOMAIN_LIST');
        $data['COUNTRY_LIST'] = setting('COUNTRY_LIST');
        $data['COUNTRY_BLOCKTYPE'] = setting('COUNTRY_BLOCKTYPE');
        $data['ADMIN_COUNTRY_BLOCKTYPE'] = setting('ADMIN_COUNTRY_BLOCKTYPE');
        $data['ADMIN_COUNTRY_LIST'] = setting('ADMIN_COUNTRY_LIST');
        $data['CAPTCHATYPE'] = setting('CAPTCHATYPE');

        return $data;
        return $data;
    }

    public function store()
    {
        $data['COUNTRY_BLOCKTYPE'] = request()->countryblock;
        if (request()->countrylist) {
            $countrycode = implode(',', request()->countrylist);
            $data['COUNTRY_LIST'] = $countrycode;
        } else {
            $data['COUNTRY_LIST'] = request()->countrylist;
        }

        $this->updateSettings($data);
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Updated Country Block/Unblock Settings';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['success' => 'Updated successfully']);
    }

    public function adminstore()
    {
        $admincountry = GeoIP::getLocation(request()->getClientIp());

        if (request()->admincountryblock == 'block') {
            if (request()->admincountrylist) {
                if (in_array($admincountry->iso_code, request()->admincountrylist)) {
                    return response()->json(['error' => 'You are not supposed to block your own country.']);
                } else {
                    $data['ADMIN_COUNTRY_BLOCKTYPE'] = request()->admincountryblock;
                    if (request()->admincountrylist) {
                        $admincountrycode = implode(',', request()->admincountrylist);
                        $data['ADMIN_COUNTRY_LIST'] = $admincountrycode;
                    } else {
                        $data['ADMIN_COUNTRY_LIST'] = request()->admincountrylist;
                    }

                    $this->updateSettings($data);
                    $agent = new Agent();
                    $activity = new EmployeeActivity();
                    $activity->user_id = Auth::user()->id;
                    $activity->activity_type = 'Updated Admin Country Block/Unblock Settings.';
                    $activity->ip_address = $admincountry->ip;
                    $activity->browser = $agent->browser();
                    $activity->device = $agent->device();
                    $activity->save();
                    return response()->json(['success' => 'Updated successfully']);
                }
            } else {
                $data['ADMIN_COUNTRY_BLOCKTYPE'] = request()->admincountryblock;
                if (request()->admincountrylist) {
                    $admincountrycode = implode(',', request()->admincountrylist);
                    $data['ADMIN_COUNTRY_LIST'] = $admincountrycode;
                } else {
                    $data['ADMIN_COUNTRY_LIST'] = request()->admincountrylist;
                }
                $this->updateSettings($data);
                $agent = new Agent();
                $activity = new EmployeeActivity();
                $activity->user_id = Auth::user()->id;
                $activity->activity_type = 'Updated Admin Country Block/Unblock Settings.';
                $activity->ip_address = $admincountry->ip;
                $activity->browser = $agent->browser();
                $activity->device = $agent->device();
                $activity->save();
                return response()->json(['success' => 'Updated successfully']);
            }
        }
        if (request()->admincountryblock == 'allow') {
            if (request()->admincountrylist) {
                if (in_array($admincountry->iso_code, request()->admincountrylist)) {
                    $data['ADMIN_COUNTRY_BLOCKTYPE'] = request()->admincountryblock;
                    if (request()->admincountrylist) {
                        $admincountrycode = implode(',', request()->admincountrylist);
                        $data['ADMIN_COUNTRY_LIST'] = $admincountrycode;
                    } else {
                        $data['ADMIN_COUNTRY_LIST'] = request()->admincountrylist;
                    }
                    $this->updateSettings($data);
                    $agent = new Agent();
                    $activity = new EmployeeActivity();
                    $activity->user_id = Auth::user()->id;
                    $activity->activity_type = 'Updated Admin Country Block/Unblock Settings.';
                    $activity->ip_address = $admincountry->ip;
                    $activity->browser = $agent->browser();
                    $activity->device = $agent->device();
                    $activity->save();
                    return response()->json(['success' => 'Updated successfully']);
                } else {
                    return response()->json(['error' => 'You are not supposed to block your own country.']);
                }
            } else {
                $data['ADMIN_COUNTRY_BLOCKTYPE'] = request()->admincountryblock;
                if (request()->admincountrylist) {
                    $admincountrycode = implode(',', request()->admincountrylist);
                    $data['ADMIN_COUNTRY_LIST'] = $admincountrycode;
                } else {
                    $data['ADMIN_COUNTRY_LIST'] = request()->admincountrylist;
                }
                $this->updateSettings($data);
                $agent = new Agent();
                $activity = new EmployeeActivity();
                $activity->user_id = Auth::user()->id;
                $activity->activity_type = 'Updated Admin Country Block/Unblock Settings.';
                $activity->ip_address = $admincountry->ip;
                $activity->browser = $agent->browser();
                $activity->device = $agent->device();
                $activity->save();
                return response()->json(['success' => 'Updated successfully']);
            }
        }
    }

    public function dosstore()
    {

        $this->validate(request(), [
            'ip_max_attempt' => ['required', 'numeric', 'digits_between:1,10000'],
            'ip_seconds' => ['required', 'numeric', 'digits_between:1,10000'],

        ]);

        if (request()->ipblocktype == 'captcha' && request()->has('dosswitch')) {
            if (setting('CAPTCHATYPE') == 'off') {
                return redirect()->back()->with('error', lang('First you need to enable captcha in the captcha setting.', 'alerts'));
            }
        }
        $data['IPBLOCKTYPE'] = request()->ipblocktype;
        $data['IPMAXATTEMPT'] = request()->ip_max_attempt;
        $data['IPSECONDS'] = request()->ip_seconds;
        $data['DOS_Enable'] =  request()->dosswitch == true || request()->dosswitch == 'on'  ? 'on' : 'off';


        $this->updateSettings($data);
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Updated DOS Attack Setting.';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['success' => 'Updated successfully']);
    }


    public function emailtoticket()
    {
        $data['setting'] = response()->json([
            'IMAP_STATUS' => setting('IMAP_STATUS'),
            'IMAP_HOST' => setting('IMAP_HOST'),
            'IMAP_PORT' => setting('IMAP_PORT'),
            'IMAP_ENCRYPTION' => setting('IMAP_ENCRYPTION'),
            'IMAP_PROTOCOL' => setting('IMAP_PROTOCOL'),
            'IMAP_USERNAME' => setting('IMAP_USERNAME'),
            'IMAP_PASSWORD' => setting('IMAP_PASSWORD'),
        ]);

        return $data;
    }

    public function emailticketstore()
    {
        $this->validate(request(), [

            'imap_host' => ['required', 'max:255'],
            'imap_port' => ['required', 'numeric', 'between:1,10000'],
            'imap_encryption' => ['required', 'max:255'],
            'imap_protocol' => ['required', 'max:255'],
            'imap_username' => ['required', 'max:255'],
            'imap_password' => ['required', 'max:255'],

        ]);

        $data['IMAP_STATUS'] = request()->has('IMAP_STATUS') ? 'on' : 'off';
        $data['IMAP_HOST'] = request()->input('imap_host');
        $data['IMAP_PORT'] = request()->input('imap_port');
        $data['IMAP_ENCRYPTION'] = request()->input('imap_encryption');
        $data['IMAP_PROTOCOL'] = request()->input('imap_protocol');
        $data['IMAP_USERNAME'] = request()->input('imap_username');
        $data['IMAP_PASSWORD'] = request()->input('imap_password');
        $this->updateSettings($data);

        return response()->json(['code' => 200, 'success' => 'Updated successfully'], 200);
    }

    public function emaildomainlist(Request $request)
    {
        if ($request->emaildomain == null) {
            return redirect()->back()->with('error', lang('Please enter atleast one domain name, to setup domain list.', 'alerts'));
        } else {
            $data['EMAILDOMAIN_BLOCKTYPE'] = $request->emaildomainblock;
            $data['EMAILDOMAIN_LIST'] = $request->emaildomain;
            $this->updateSettings($data);

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Updated Domain List.';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();
            return response()->json(['code' => 200, 'success' => 'Updated successfully'], 200);
        }
    }


    /**
     *  Settings Save/Update.
     *
     * @return \Illuminate\Http\Response
     */
    private function updateSettings($data)
    {

        foreach ($data as $key => $val) {
            $setting = Setting::where('key', $key);
            if ($setting->exists())
                $setting->first()->update(['value' => $val]);
        }
    }

    public function setLanguage($locale)
    {

        App::setlocale($locale);
        session()->put('locale', $locale);
        return  response()->json(['success' => 'The language has been successfully updated']);
    }
}
