<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Validator;

class TextGeneratorController extends Controller
{
    public function generateText(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'prompt' => 'required|string|max:3000', // Validate the prompt
        ]);

        if($validator->passes()){
        
            // Get the prompt from the frontend
            $prompt = $request->input('prompt');
           
            $apiKey = setting('geminiApiKey');
            $url = "https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash-latest:generateContent?key={$apiKey}";

            // Send the POST request to the Gemini API
            $response = Http::withHeaders([
                'Content-Type' => 'application/json',
            ])->post($url, [
                'contents' => [
                    [
                        'parts' => [
                            [
                                'text' => $prompt,
                            ]
                        ]
                    ]
                ]
            ]);
            // Check for errors in the response
            if ($response->successful()) {
                return response()->json([
                    'generated_text' => $response->json('candidates')[0]['content']['parts'][0]['text'] // Get the first candidate's output
                ]);
            } else {
                // Handle the error case
                return response()->json([
                    // 'error' => 'Network error '
                    'error' => 'Error generating text: ' . $response->body()
                ], 500);
            }
        }else{
            return Response::json(['errors' => $validator->errors()]);
        }

    }
}
