<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Auth;
use Spatie\Permission\Models\Role;

class checkUser extends Controller
{
    public function index(Request $request)
    {
        if (Auth::user()) {
            $user = User::with('roles', 'permissions')->find(Auth::user()->id);
            $data['user'] = $user;
            $role = Role::where('name', $user->getRoleNames()[0])->first();
            $data['permissions'] = $role->getPermissionNames();
            $data['ENVATO_ON'] = setting('ENVATO_ON');
            $data['token'] = setting('isToken');
            $data['admin_users_inactive_auto_logout_time'] = setting('admin_users_inactive_auto_logout_time');
            $data['admin_users_inactive_auto_logout'] = setting('admin_users_inactive_auto_logout');


            $redirectionstatus = null;
            if (setting('Employe_email_two_fact') == 'on' && User::where(['id' => Auth::id(), 'twofactorauth' => 'emailtwofact'])->exists()) {
                if (!(session()->get('admintwofactoremail') == Auth::user()->email)) {
                    $redirectionstatus = 'twofactoremail';
                }
            } else if (setting('Customer_google_two_fact') == 'on' && User::where(['id' => Auth::id(), 'twofactorauth' => 'googletwofact'])->exists()) {
                if (!(session()->get('admingoogleauthid') == Auth::user()->email)) {
                    $redirectionstatus = 'googletwofact';
                }
            }
            $data["email"] = $user->email;
            $data['redirectionstatus'] = $redirectionstatus;
            return $data;
        }
    }
    public function time(Request $request)
    {

        $setting  = response()->json(['date_format' => setting('date_format'), 'default_timezone' => setting('default_timezone'), 'time_format' => setting('time_format')]);
        $data['setting'] = $setting;
        return $data;
    }
}
