<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\ArticleComment;
use Auth;

use App\Models\Ticket\Category;
use App\Models\Articles\Article;

use App\Models\SocialAuthSetting;


class ArticleCommentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if(setting('KNOWLEDGE_ENABLE') !="yes") abort(403);

        $article = Article::where('status', 'published')->with('subcategorys')->latest()->take(6)->get();
        $data['article'] = $article;

        $populararticle = Article::where('status', 'published')->with('subcategorys')->latest()->take(6)->get();
        $data['populararticle'] = $populararticle;

        $articlecomments = ArticleComment::latest('created_at')->take(6)->get();
        $data['articlecomment'] = $articlecomments;

        $category =  Category::where('status', '1')->whereIn('display', ['knowledge', 'all'])
        ->with(['articles.subcategorys' => function ($query) {
            $query->latest()->take(6);
        }])->latest()->get();

        $data['category'] = $category;

        $socialAuthSettings = SocialAuthSetting::first();
        $data['socialAuthSettings'] = $socialAuthSettings;

        return response()->json($data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, $id)
    {
        if (Auth::check()) {

            $this->validate($request, [
                'comment' => 'required',

            ]);

            $articlecomments = new ArticleComment();
            $articlecomments->article_id = $id;
            $articlecomments->user_id = Auth::user()->id;
            $articlecomments->comment = $request->comment;
            $articlecomments->save();

            return redirect()->back()->with('success', 'Comment Added successfully..!');
        }
    }
}
