<?php

namespace App\Http\Controllers\Contactform;

use App\Http\Controllers\Controller;
use App\Mail\ContactMail;
use Illuminate\Http\Request;
use Mail;
use App\Models\SocialAuthSetting;
use laravelLara\infoinst\Jobs\MailSend;

class ContactController extends Controller
{
    public function contact(){

        $socialAuthSettings = SocialAuthSetting::first();
        $data['socialAuthSettings'] = $socialAuthSettings;
        $data['setting'] = response()->json(['TICKET_CHARACTER' => setting('TICKET_CHARACTER'), 'CAPTCHATYPE' => setting('CAPTCHATYPE'), 'RECAPTCH_ENABLE_CONTACT' => setting('RECAPTCH_ENABLE_CONTACT'), 'GOOGLE_RECAPTCHA_KEY' => setting('GOOGLE_RECAPTCHA_KEY')]);
        return $data;
    }

    public function saveContact(Request $request) {
        if(setting('CAPTCHATYPE') == 'off'){
            $this->validate($request, [
                'name' => 'required|max:255',
                'email' => 'required|email|indisposable|max:255',
                'subject' => 'required|max:255',
                'phone_number' => 'required|numeric',
                'message' => 'required',
            ]);
        }else{
            if(setting('CAPTCHATYPE') == 'manual'){
                if(setting('RECAPTCH_ENABLE_CONTACT')=='yes'){
                    $this->validate($request, [
                        'name' => 'required|max:255',
                        'email' => 'required|email|indisposable|max:255',
                        'subject' => 'required|max:255',
                        'phone_number' => 'required|numeric',
                        'message' => 'required',
                        'captcha' => 'required',

                    ]);
                }else{
                    $this->validate($request, [
                        'name' => 'required|max:255',
                        'email' => 'required|email|indisposable|max:255',
                        'subject' => 'required|max:255',
                        'phone_number' => 'required|numeric',
                        'message' => 'required',
                    ]);
                }

            }
            if(setting('CAPTCHATYPE') == 'google'){
                if(setting('RECAPTCH_ENABLE_CONTACT')=='yes'){
                    $this->validate($request, [
                        'name' => 'required|max:255',
                        'email' => 'required|email|indisposable|max:255',
                        'subject' => 'required|max:255',
                        'phone_number' => 'required|numeric',
                        'message' => 'required',
                        'g-recaptcha-response'  =>  'required|recaptcha',

                    ]);
                }else{
                    $this->validate($request, [
                        'name' => 'required|max:255',
                        'email' => 'required|email|indisposable|max:255',
                        'subject' => 'required|max:255',
                        'phone_number' => 'required|numeric',
                        'message' => 'required',
                    ]);
                }
            }
        }

        $contactData = [
            'Contact_name' => $request->name,
            'Contact_email' => $request->email,
            'Contact_subject' => $request->subject,
            'Contact_phone' => $request->phone_number,
            'Contact_message' => $request->message,

        ];

        try{

            Mail::send( new ContactMail('admin_sendmail_contactus', $contactData) );
            dispatch((new MailSend($request->email, 'customer_sendmail_contactus', $contactData)));

        }catch(\Exception $e){
        }
        
          return response()->json(['success' => 'Thank you for contacting us!']);
    }
}
