<?php

namespace App\Http\Controllers;

use App\Mail\mailmailablesend;
use App\Models\Apptitle;
use App\Models\Articles\Article;
use App\Models\CCMAILS;
use App\Models\Customer;
use App\Models\CustomerSetting;
use App\Models\Customfield;
use App\Models\Employeerating;
use App\Models\Footertext;
use App\Models\Pages;
use App\Models\Projects;
use App\Models\Ratingtoken;
use App\Models\Seosetting;
use App\Models\SocialAuthSetting;
use App\Models\Subcategorychild;
use App\Models\Groups;
use App\Models\TicketCustomfield;
use App\Models\Ticket\Category;
use App\Models\Ticket\Comment;
use App\Models\Ticket\Ticket;
use App\Models\User;
use App\Models\Userrating;
use App\Models\VerifyOtp;
use App\Notifications\TicketCreateNotifications;
use Auth;
use GeoIP;
use Illuminate\Http\Request;
use Mail;
use App\Entities\APIData;
use App\Entities\CategoryEnvato;
use Spatie\MediaLibrary\MediaCollections\Models\Media;
use App\Models\tickethistory;
use App\Models\Businesshours;
use App\Models\Announcement;
use Carbon\Carbon;
use App\Models\Holiday;
use laravelLara\infoinst\Jobs\MailSend;

use App\Models\AddSpace;
use App\Events\ConversationEvent;

class GuestticketController extends Controller
{
    public function index()
    {
        if (setting('GUEST_TICKET') == 'yes') {
            $tickets = Ticket::get();

            $now = now();
            $announcement = announcement::whereDate('enddate', '>=', $now->toDateString())->whereDate('startdate', '<=', $now->toDateString())->get();
            $data['announcement'] = $announcement;

            $announcements = Announcement::whereNotNull('announcementday')->get();
            $data['announcements'] = $announcements;

            $holidays = Holiday::whereDate('startdate', '<=', $now->toDateString())->whereDate('enddate', '>=', $now->toDateString())->where('status', 1)->get();
            $data['holidays'] =  $holidays;
            $categories = Category::whereIn('display', ['ticket', 'all'])->where('status', '1')
                ->get();
            $data['categories'] = $categories;

            $data['setting'] = response()->json(
                [
                    'MAX_FILE_UPLOAD' => setting('MAX_FILE_UPLOAD'),
                    'FILE_UPLOAD_TYPES' => setting('FILE_UPLOAD_TYPES'),
                    'FILE_UPLOAD_MAX' => setting('FILE_UPLOAD_MAX'),
                    'terms_url' => setting('terms_url'),
                    'GUEST_TICKET_OTP' => setting('GUEST_TICKET_OTP'),
                    'GUEST_TICKET' => setting('GUEST_TICKET'),
                    'cc_email'  => setting('cc_email'),
                    'TICKET_CHARACTER' => setting('TICKET_CHARACTER'),
                    'GUEST_FILE_UPLOAD_ENABLE' => setting('GUEST_FILE_UPLOAD_ENABLE'),
                    'CAPTCHATYPE' => setting('CAPTCHATYPE'),
                    'RECAPTCH_ENABLE_GUEST' => setting('RECAPTCH_ENABLE_GUEST'),
                    'GOOGLE_RECAPTCHA_KEY' => setting('GOOGLE_RECAPTCHA_KEY'),
                    'ENVATO_EXPIRED_BLOCK' => setting('ENVATO_EXPIRED_BLOCK'),
                    'LengthTextFieldStatus' => setting('LengthTextFieldStatus'),
                    'maxLengthTextField' => setting('maxLengthTextField'),
                    'minLengthTextField' => setting('minLengthTextField'),
                    'offlineTextMessage' => setting('offlineTextMessage'),
                    'offlineTextTitle' => setting('offlineTextTitle'),
                    'businesshourofflinemsg' => setting('businesshourofflinemsg')
                ]
            );
            $title = Apptitle::first();
            $data['title'] = $title;


            $recentarticles = Article::latest()->take(5)->get();
            $data['recentarticles'] = $recentarticles;

            $populararticle = Article::orderBy('views', 'desc')->latest()->take(5)->get();
            $data['populararticles'] = $populararticle;

            $customfields = Customfield::whereIn('displaytypes', ['both', 'createticket'])->where('status', 1)->get();
            $data['customfields'] = $customfields;

            $currentYear = $now->year;
            $activeHolidays = Holiday::where('status', 1)->get();

            $data['addspace'] = AddSpace::where('status', 1)->get();

            // Filter holidays
            $data['holidays'] = $activeHolidays->filter(function ($holiday) use ($now, $currentYear) {
                $holidayStart = Carbon::parse($holiday->startdate);
                $holidayEnd = Carbon::parse($holiday->enddate);

                // Check for fixed holidays (compare only day and month)
                if ($holiday->is_fixed) {
                    return $holidayStart->month === $now->month && $holidayStart->day === $now->day;
                }

                // For non-fixed holidays, check the full date
                return $holidayStart->isSameDay($now);
            });


            $now = now();
            $holidays = Holiday::whereDate('startdate', '<=', $now->toDateString())->where('status', '1')->get();
            if ($holidays->isNotEmpty()) {
                $data['isOnline'] = false;
            } else {
                $businesshours = Businesshours::get();
                $data['businesshours'] = $businesshours;
                foreach ($businesshours as $business) {
                    if (now()->timezone(setting('default_timezone'))->format('D') == $business->weeks) {
                        if (strtotime($business->starttime) <= strtotime(now()->timezone(setting('default_timezone'))->format('h:i A')) && strtotime($business->endtime) >= strtotime(now()->timezone(setting('default_timezone'))->format('h:i A')) || $business->starttime == "24H") {
                            $data['isOnline'] = true;
                        } else {

                            $data['isOnline'] = false;
                        }
                    }
                }
            }

            return response()->json($data);
        } else {
            return response()->json(['error' => 'You cannot have access for this guest ticket create.']);
        }
    }

    // Guest Ticket Creating
    public function gueststore(Request $request)
    {
        // guest restrict to create tickets based on allowed to create.
        if (setting('RESTRICT_TO_CREATE_TICKET') == 'on' && setting('MAXIMUM_ALLOW_TICKETS') > 0) {
            $customers = Customer::where('email', $request->email)->first();
            if ($customers != null && $customers->tickets != null) {
                $star1 = now()->subHour(setting('MAXIMUM_ALLOW_HOURS'));
                $star2 = now();
                $latestReplies = $customers->tickets()->whereBetween('created_at', [$star1, $star2])->get()->take(setting('MAXIMUM_ALLOW_TICKETS'));
                if ($latestReplies->isNotEmpty()) {
                    $totalcount = 0;
                    foreach ($latestReplies as $comment) {
                        if ($comment->user_id !== null) {
                            $totalcount++;
                        }
                    }
                    if (!$totalcount) {
                        $currentTcikets = $latestReplies->last();
                        $data['difference'] = $currentTcikets->created_at->addHour(setting('REPLY_ALLOW_IN_HOURS'))->diffForHumans(now());

                        $ticketscount = Ticket::where('cust_id', $customers->id)->whereBetween('created_at', [$star1, $star2])->count();
                        if ($ticketscount >= setting('MAXIMUM_ALLOW_TICKETS')) {
                            return response()->json(['error' => 'Customer has reached maximum allowed tickets to create.', 'ticcreaterestrict' => 'on']);
                        }
                    }
                }
            }
        }

        $categories = CategoryEnvato::where('category_id', $request->category)->first();

        if (setting('ENVATO_ON') == 'on' && $categories != null) {
            if ($request->envato_id == 'undefined' || $request->envato_id == null || isset($request->envato_id) == false) {
                return response()->json(['message' => 'envatoerror', 'error' => lang('Please enter valid details to create a ticket.', 'alerts')], 200);
            }
        }
        $subcategoriess = Subcategorychild::where('category_id', $request->category)->pluck('subcategory_id')->toArray();
        if ($request->subscategory && $subcategoriess != null && ($request->subscategory != "null" || $request->subscategory != null) && !in_array($request->subscategory, $subcategoriess)) {
            return response()->json(['message' => 'subcaterror', 'error' => lang('Please enter valid details to create a ticket.', 'alerts')], 200);
        }

        if ($request->session()->has('sessionemail')) {
            $emailvalidate = $request->session()->get('sessionemail');
        } else {
            $emailvalidate = null;
        }

        if (setting('CAPTCHATYPE') == 'off') {
            $this->validate($request, [
                'subject' => 'required|max:255',
                'category' => 'required',
                'message' => 'required|no_script_tags|string',
                'verifyotp' => 'required',
                'agree_terms' =>  'required|in:agreed',

            ]);
        } else {
            if (setting('CAPTCHATYPE') == 'manual') {
                if (setting('RECAPTCH_ENABLE_GUEST') == 'yes') {
                    $request->validate([
                        'subject' => 'required|max:255',
                        'category' => 'required',
                        'message' => 'required|no_script_tags|string',
                        // 'captcha' => 'required',
                        'verifyotp' => 'required',
                        'agree_terms' =>  'required|in:agreed',
                    ]);
                } else {
                    $request->validate([
                        'subject' => 'required|max:255',
                        'category' => 'required',
                        'message' => 'required',
                        'verifyotp' => 'required',
                        'agree_terms' =>  'required|in:agreed',

                    ]);
                }
            }
            if (setting('CAPTCHATYPE') == 'google') {
                if (setting('RECAPTCH_ENABLE_GUEST') == 'yes') {
                    $request->validate([
                        'subject' => 'required|max:255',
                        'category' => 'required',
                        'message' => 'required',
                        'g-recaptcha-response' => 'required|recaptcha',
                        'verifyotp' => 'required',
                        'agree_terms' =>  'required|in:agreed',

                    ]);
                } else {
                    $request->validate([
                        'subject' => 'required|max:255',
                        'category' => 'required',
                        'message' => 'required',
                        'verifyotp' => 'required',
                        'agree_terms' =>  'required|in:agreed',

                    ]);
                }
            }
        }

        $guest = Customer::where('email', $emailvalidate)->first();

        if ($guest) {
            if ($guest->userType == 'Guest') {
                $comment = $request->input('message');

                // Trim unwanted tags from the start and end
                $comment = preg_replace('/^(<(p|div)><br><\/(p|div)>)+|(<(p|div)><br><\/(p|div)>)+$/', '', $comment);
                $ticket = Ticket::create([
                    'subject' => $request->input('subject'),
                    'cust_id' => $guest->id,
                    'category_id' => $request->input('category'),
                    'message' => $comment,
                    'project' => $request->input('project'),
                    'status' => 'New',
                ]);
                $ticket = Ticket::find($ticket->id);
                $ticket->ticket_id = setting('CUSTOMER_TICKETID') . 'G-' . $ticket->id;

                if ($request->input('envato_id')) {

                    $ticket->purchasecode = encrypt($request->input('envato_id'));
                    if ($request->input('productname')) {
                        $ticket->item_name = $request->input('productname');
                    }
                }
                if ($request->input('envato_support')) {

                    $ticket->purchasecodesupport = $request->input('envato_support');
                }
                $categoryfind = Category::find($request->category);
                $ticket->priority = $categoryfind->priority;
                if ($request->subscategory) {
                    $ticket->subcategory = $request->subscategory;
                }

                // Auto Overdue Ticket
                if (setting('AUTO_OVERDUE_TICKET') == 'no') {
                    $ticket->auto_overdue_ticket = null;
                    $ticket->overduestatus = null;
                } else {
                    if (setting('AUTO_OVERDUE_TICKET_TIME') == '0') {
                        $ticket->auto_overdue_ticket = null;
                        $ticket->overduestatus = null;
                    } else {

                        if ($ticket->status == 'Closed') {
                            $ticket->auto_overdue_ticket = null;
                            $ticket->overduestatus = null;
                        } else {
                            $ticket->auto_overdue_ticket = now()->addDays(setting('AUTO_OVERDUE_TICKET_TIME'));
                            $ticket->overduestatus = null;
                        }
                    }
                }
                // End Auto Overdue Ticket
                $ticket->update();

                $geolocation = GeoIP::getLocation(request()->getClientIp());
                $custupdate = Customer::find($ticket->cust_id);
                $custupdate->last_login_ip = $geolocation->ip;
                $custupdate->timezone = $geolocation->timezone;
                $custupdate->country = $geolocation->country;
                $custupdate->update();

                $customfields = Customfield::whereIn('displaytypes', ['both', 'createticket'])->where('status', 1)->get();

                if ($customfields != false) {
                    foreach ($customfields as $customfield) {
                        $ticketcustomfield = new TicketCustomfield();
                        $ticketcustomfield->ticket_id = $ticket->id;
                        $ticketcustomfield->fieldnames = $customfield->fieldnames;
                        $ticketcustomfield->fieldtypes = $customfield->fieldtypes;
                        $ticketcustomfield->fieldoptions = $customfield->fieldoptions;
                        if ($customfield->fieldtypes == 'checkbox') {
                            if ($request->input('custom_' . $customfield->id) != null) {

                                $string = $request->input('custom_' . $customfield->id);
                                $ticketcustomfield->values = $string;
                            }
                        }
                        if ($customfield->fieldtypes != 'checkbox') {
                            if ($customfield->fieldprivacy == '1') {
                                $ticketcustomfield->privacymode = $customfield->fieldprivacy;
                                $ticketcustomfield->values = encrypt($request->input('custom_' . $customfield->id));
                            } else {

                                $ticketcustomfield->values = $request->input('custom_' . $customfield->id);
                            }
                        }
                        $ticketcustomfield->save();
                    }
                }

                $ccmails = new CCMAILS();
                $ccmails->ticket_id = $ticket->id;
                $ccmails->ccemails = $request->ccmail;
                $ccmails->save();


                // $tickethistory = new tickethistory();
                // $tickethistory->ticket_id = $ticket->id;

                // $tickethistory->ticketnote = $ticket->ticketnote->isNotEmpty();
                // $tickethistory->overduestatus = $ticket->overduestatus;
                // $tickethistory->ticketviolation = $ticket->ticketviolation;
                // $tickethistory->currentAction = 'Created';
                // $tickethistory->username = $ticket->cust->username;
                // $tickethistory->type = $ticket->cust->userType;
                // $tickethistory->status = $ticket->status;
                // $tickethistory->replystatus = $ticket->replystatus;
                // $tickethistory->assignUser = null;

                // $tickethistory->save();


                foreach ($request->file('ticket', []) as $file) {
                    $provider =  storage()->provider;
                    $provider::mediaupload($ticket, $file, 'ticket');
                }

                $tickethistory = new tickethistory();
                $tickethistory->ticket_id = $ticket->id;

                $tickethistory->status = $ticket->status;
                $tickethistory->currentAction = 'Ticket Created';
                if ($request->input('ticket_source') != null && $request->input('ticket_source') == 'Livechat') {
                    $tickethistory->username = Auth::user()->name;
                    $tickethistory->type = Auth::user()->getRoleNames()[0];
                } else {
                    $tickethistory->username = $ticket->cust->username;
                    $tickethistory->type = $ticket->cust->userType;
                }

                $tickethistory->save();

                // Create a New ticket reply
                if ($ticket->category) {
                    $notificationcat = $ticket->category->groupscategoryc()->get();
                    $groupIds = $notificationcat->pluck('group_id')->toArray();
                    $groupstatus = false;
                    foreach ($groupIds as $groupid) {
                        $groupexist = Groups::where('groupstatus', '1')->find($groupid);
                        if ($groupexist) {
                            $groupstatus = true;
                        }
                    }

                    $icc = array();

                    if ($groupstatus) {

                        foreach ($notificationcat as $igc) {
                            $groups = $igc->groupsc()
                                ->where('groupstatus', 1)
                                ->with('groupsuser')
                                ->get();

                            foreach ($groups as $group) {
                                $users = $group->groupsuser;

                                foreach ($users as $user) {
                                    $icc[] = $user->users_id;
                                }
                            }
                        }

                        if (!$icc) {
                            $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->get();
                            foreach ($admins as $admin) {
                                $admin->notify(new TicketCreateNotifications($ticket));
                            }
                        } else {

                            $user = User::whereIn('id', $icc)->get();
                            foreach ($user as $users) {
                                $users->notify(new TicketCreateNotifications($ticket));
                            }
                            $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->get();
                            foreach ($admins as $admin) {
                                $admin->notify(new TicketCreateNotifications($ticket));
                            }
                        }
                    } else {
                        foreach (usersdata() as $admin) {
                            $admin->notify(new TicketCreateNotifications($ticket));
                        }
                    }
                }
                $verifyUser = VerifyOtp::where('type', 'guestotp')->where('otp', $request->verifyotp)->first();
                if ($verifyUser) {

                    $verifyUser->delete();
                }

                $guestdetailssession = session()->put('guestdetailssession', $ticket->ticket_id);
                $guestimageaccess = session()->put('guestimageaccess', $ticket->ticket_id);

                $ccemailsend = CCMAILS::where('ticket_id', $ticket->id)->first();

                $ticketData = [
                    'ticket_username' => $ticket->cust->username,
                    'ticket_id' => $ticket->ticket_id,
                    'ticket_title' => $ticket->subject,
                    'ticket_status' => $ticket->status,
                    'ticket_description' => $ticket->message,
                    'ticket_customer_url' => url('/guest/ticket/' . encrypt($ticket->ticket_id)),
                    'ticket_admin_url' => url('/admin/ticket-view/' . encrypt($ticket->ticket_id)),
                    'ticket_category' => $ticket->category ? $ticket->category->name : null,
                    'status' => $ticket->status,
                    'comment' => $request->input('message')
                ];
                try {

                    // $today = Carbon::today();
                    // $holidays = Holiday::whereDate('startdate', '<=', $today)->whereDate('enddate', '>=', $today)->where('status', '1')->get();
                    // $today = Carbon::today();
                    // $holidays = Holiday::whereDate('startdate', '<=', $today)->whereDate('enddate', '>=', $today)->where('status','1')->get();

                    $today = Carbon::today();
                    $activeHolidays = Holiday::where('status', 1)->get();
                    $now = now();
                    $currentYear = $now->year;
                    $holidays = $activeHolidays->filter(function ($holiday) use ($now, $currentYear) {
                        $holidayStart = Carbon::parse($holiday->startdate);
                        $holidayEnd = Carbon::parse($holiday->enddate);
                        if ($holiday->is_fixed) {
                            return $holidayStart->month === $now->month && $holidayStart->day === $now->day;
                        }
                        return $holidayStart->isSameDay($now);
                    });
                    if ($holidays->isNotEmpty() && setting('24hoursbusinessswitch') != 'on') {
                        dispatch((new MailSend($ticket->cust->email, 'customer_send_ticket_created_that_holiday_or_announcement', $ticketData)));
                        if ($ccemailsend->ccemails != null) {
                            dispatch((new MailSend($ccemailsend->ccemails, 'customer_send_ticket_created_that_holiday_or_announcement', $ticketData)));
                        }
                    } else {
                        dispatch((new MailSend($ticket->cust->email, 'customer_send_guestticket_created', $ticketData)));
                        if ($ccemailsend->ccemails != null) {
                            dispatch((new MailSend($ccemailsend->ccemails, 'customer_send_guestticket_created', $ticketData)));
                        }
                    }

                    if ($ticket->category) {
                        $notificationcat = $ticket->category->groupscategoryc()->get();
                        $groupIds = $notificationcat->pluck('group_id')->toArray();
                        $groupstatus = false;
                        foreach ($groupIds as $groupid) {
                            $groupexist = Groups::where('groupstatus', '1')->find($groupid);
                            if ($groupexist) {
                                $groupstatus = true;
                            }
                        }

                        $icc = array();

                        if ($groupstatus) {

                            foreach ($notificationcat as $igc) {
                                $groups = $igc->groupsc()
                                    ->where('groupstatus', 1)
                                    ->with('groupsuser')
                                    ->get();

                                foreach ($groups as $group) {
                                    $users = $group->groupsuser;

                                    foreach ($users as $user) {
                                        $icc[] = $user->users_id;
                                    }
                                }
                            }

                            if (!$icc) {
                                $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->where('users.status', 1)->get();
                                foreach ($admins as $admin) {
                                    if ($admin->usetting->emailnotifyon == 1) {
                                        dispatch((new MailSend($admin->email, 'admin_send_email_ticket_created', $ticketData)));
                                    }
                                }
                            } else {

                                $user = User::whereIn('id', $icc)->where('status', 1)->get();
                                foreach ($user as $users) {
                                    if ($users->usetting->emailnotifyon == 1) {
                                        dispatch((new MailSend($users->email, 'admin_send_email_ticket_created', $ticketData)));
                                    }
                                }
                                $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->where('users.status', 1)->get();
                                foreach ($admins as $admin) {
                                    if ($admin->usetting->emailnotifyon == 1) {
                                        dispatch((new MailSend($admin->email, 'admin_send_email_ticket_created', $ticketData)));
                                    }
                                }
                            }
                        } else {
                            foreach (usersdata() as $admin) {
                                if ($admin->getRoleNames()[0] == 'superadmin' && $admin->usetting->emailnotifyon == 1) {
                                    dispatch((new MailSend($admin->email, 'admin_send_email_ticket_created', $ticketData)));
                                }
                            }
                        }
                    }
                } catch (\Exception $e) {

                    return response()->json(['guest' => 'pass', 'data' => $ticket, 'success' => 'A ticket has been opened with the ticket ID ' . $ticket->ticket_id, 'ticket_id' => encrypt($ticket->ticket_id)], 200);
                }

                return response()->json(['guest' => 'pass', 'data' => $ticket, 'success' => 'A ticket has been opened with the ticket ID ' . $ticket->ticket_id, 'ticket_id' => encrypt($ticket->ticket_id)], 200);
            }

            if ($guest->userType == 'Customer') {
                return response()->json(['error' => 'Email is already registered, Please login to create a Ticket', 'email' => 'already']);
            }
        }
        if (!$guest) {
            return response(['warning' => 'Email is not registered, Please register the account', 'email' => 'already']);
        }
    }

    // Guest Ticket Creating1
    public function gueststore1(Request $request)
    {

        // customer restrict to create tickets based on allowed to create.
        if (setting('RESTRICT_TO_CREATE_TICKET') == 'on' && setting('MAXIMUM_ALLOW_TICKETS') > 0) {
            $customers = Customer::where('email', $request->email)->first();
            if ($customers != null && $customers->tickets != null) {
                $star1 = now()->subHour(setting('MAXIMUM_ALLOW_HOURS'));
                $star2 = now();
                $latestReplies = $customers->tickets()->whereBetween('created_at', [$star1, $star2])->get()->take(setting('MAXIMUM_ALLOW_TICKETS'));
                if ($latestReplies->isNotEmpty()) {
                    $totalcount = 0;
                    foreach ($latestReplies as $comment) {
                        if ($comment->user_id !== null) {
                            $totalcount++;
                        }
                    }
                    if (!$totalcount) {
                        $currentTcikets = $latestReplies->last();
                        $data['difference'] = $currentTcikets->created_at->addHour(setting('REPLY_ALLOW_IN_HOURS'))->diffForHumans(now());

                        $ticketscount = Ticket::where('cust_id', $customers->id)->whereBetween('created_at', [$star1, $star2])->count();
                        if ($ticketscount >= setting('MAXIMUM_ALLOW_TICKETS')) {
                            return response()->json(['error' => 'Customer has reached maximum allowed tickets to create.', 'ticcreaterestrict' => 'on']);
                        }
                    }
                }
            }
        }

        $categories = CategoryEnvato::where('category_id', $request->category)->first();

        if (setting('ENVATO_ON') == 'on' && $categories != null) {
            if ($request->envato_id == 'undefined' || $request->envato_id == null || isset($request->envato_id) == false) {
                return response()->json(['message' => 'envatoerror', 'error' => lang('Please enter valid details to create a ticket.', 'alerts')], 200);
            }
        }


        $subcategoriess = Subcategorychild::where('category_id', $request->category)->pluck('subcategory_id')->toArray();
        if ($subcategoriess != null &&  ($request->subscategory != "null" || $request->subscategory != null)  && !in_array($request->subscategory, $subcategoriess)) {
            return response()->json(['message' => 'subcaterror', 'error' => lang('Please enter valid details to create a ticket.', 'alerts')], 200);
        }

        if (setting('GUEST_TICKET') == 'yes') {
            session()->put('guestdetailssession', $request->session()->get('guestdetailssession'));
            if (setting('CAPTCHATYPE') == 'off') {
                $this->validate($request, [
                    'subject' => 'required|max:255',
                    'category' => 'required',
                    'message' => 'required',
                    'email' => 'required|max:255|indisposable|email',
                    'agree_terms' =>  'required|in:agreed',

                ]);
            } else {
                if ($request->input('ticket_source') != null && $request->input('ticket_source') == 'Livechat') {
                    $this->validate($request, [
                        'subject' => 'required|max:255',
                        'category' => 'required',
                        'message' => 'required',
                        'email' => 'required|max:255|indisposable|email',
                    ]);
                } else {
                    if (setting('CAPTCHATYPE') == 'manual') {
                        if (setting('RECAPTCH_ENABLE_GUEST') == 'yes') {
                            $request->validate([
                                'subject' => 'required|max:255',
                                'category' => 'required',
                                'message' => 'required',
                                'email' => 'required|max:255|indisposable|email',
                                // 'captcha' => 'required',
                                'agree_terms' =>  'required|in:agreed',
                            ]);
                        } else {
                            $request->validate([
                                'subject' => 'required|max:255',
                                'category' => 'required',
                                'email' => 'required|max:255|indisposable|email',
                                'message' => 'required',
                                'agree_terms' =>  'required|in:agreed',

                            ]);
                        }
                    }
                    if (setting('CAPTCHATYPE') == 'google') {
                        if (setting('RECAPTCH_ENABLE_GUEST') == 'yes') {
                            $request->validate([
                                'subject' => 'required|max:255',
                                'category' => 'required',
                                'message' => 'required',
                                'email' => 'required|max:255|indisposable|email',
                                'g-recaptcha-response' => 'required|recaptcha',
                                'agree_terms' =>  'required|in:agreed',

                            ]);
                        } else {
                            $request->validate([
                                'subject' => 'required|max:255',
                                'category' => 'required',
                                'email' => 'required|max:255|indisposable|email',
                                'message' => 'required',
                                'agree_terms' =>  'required|in:agreed',

                            ]);
                        }
                    }
                }
            }
            $email = $request->email;
            $completeDomain = substr(strrchr($email, "@"), 1);
            $emaildomainlist = setting('EMAILDOMAIN_LIST');
            $emaildomainlistArray = explode(",", $emaildomainlist);

            if (setting('EMAILDOMAIN_BLOCKTYPE') == 'blockemail') {

                if (setting('EMAILDOMAIN_LIST') == null) {
                    $tickets = $this->validateemaildomain($request);
                    if ($tickets == 'customer') {
                        return response()->json(['error' => lang('Email is already registered, Please login to create a Ticket', 'alerts'), 'email' => 'already']);
                    }
                    if ($tickets == 'notguest') {
                        return response()->json(['warning' => lang('Email is not registered, Please register the account', 'alerts'), 'email' => 'already']);
                    }

                    session()->put('guestdetailssession', $tickets->ticket_id);
                    session()->put('guestimageaccess', $tickets->ticket_id);
                    return response()->json(['guest' => 'pass', 'data' => $tickets, 'success' => lang('A ticket has been opened with the ticket ID ', 'alerts') . $tickets->ticket_id, 'ticket_id' => encrypt($tickets->ticket_id)], 200);
                } else {
                    if (in_array($completeDomain, $emaildomainlistArray)) {

                        return response()->json(['message' => 'domainblock', 'error' => lang('Domain is Blocked List', 'alerts')], 200);
                    }
                    $tickets = $this->validateemaildomain($request);
                    if ($tickets == 'customer') {
                        return response()->json(['error' => lang('Email is already registered, Please login to create a Ticket', 'alerts'), 'email' => 'already']);
                    }
                    if ($tickets == 'notguest') {
                        return response()->json(['warning' => lang('Email is not registered, Please register the account', 'alerts'), 'email' => 'already']);
                    }

                    session()->put('guestdetailssession', $tickets->ticket_id);
                    session()->put('guestimageaccess', $tickets->ticket_id);
                    return response()->json(['guest' => 'pass', 'data' => $tickets, 'success' => lang('A ticket has been opened with the ticket ID ', 'alerts') . $tickets->ticket_id, 'ticket_id' => encrypt($tickets->ticket_id)], 200);
                }
            }

            if (setting('EMAILDOMAIN_BLOCKTYPE') == 'allowemail') {
                if (setting('EMAILDOMAIN_LIST') == null) {
                    $tickets = $this->validateemaildomain($request);
                    if ($tickets == 'customer') {
                        return response()->json(['error' => lang('Email is already registered, Please login to create a Ticket', 'alerts'), 'email' => 'already']);
                    }
                    if ($tickets == 'notguest') {
                        return response()->json(['warning' => lang('Email is not registered, Please register the account', 'alerts'), 'email' => 'already']);
                    }
                    $guestdetailssession = session()->put('guestdetailssession', $tickets->ticket_id);
                    return response()->json(['guest' => 'pass', 'data' => $tickets, 'success' => lang('A ticket has been opened with the ticket ID ', 'alerts') . $tickets->ticket_id, 'ticket_id' => encrypt($tickets->ticket_id)], 200);
                } else {
                    if (in_array($completeDomain, $emaildomainlistArray)) {
                        $tickets = $this->validateemaildomain($request);
                        if ($tickets == 'customer') {
                            return response()->json(['error' => lang('Email is already registered, Please login to create a Ticket', 'alerts'), 'email' => 'already']);
                        }
                        if ($tickets == 'notguest') {
                            return response()->json(['warning' => lang('Email is not registered, Please register the account', 'alerts'), 'email' => 'already']);
                        }
                        $guestdetailssession = session()->put('guestdetailssession', $tickets->ticket_id);
                        return response()->json(['guest' => 'pass', 'data' => $tickets, 'success' => lang('A ticket has been opened with the ticket ID ', 'alerts') . $tickets->ticket_id, 'ticket_id' => encrypt($tickets->ticket_id)], 200);
                    }
                    return response()->json(['message' => 'domainblock', 'error' => lang('Domain is Blocked List', 'alerts')], 200);
                }
            }
        } else {
            return response()->json(['message' => 'accessdenied', 'error' => 'you are not autherised to this ticket create'], 500);
        }
    }

    private function validateemaildomain($request)
    {

        $userexits = Customer::where('email', $request->email)->count();
        if ($userexits == 1) {
            $guest = Customer::where('email', $request->email)->first();
        } else {

            if ($request->input('ticket_source') != null && $request->input('ticket_source') == 'Livechat') {
                $custtype = 'Livechat';
                $custname = $request->input('username');
            } else {
                $custtype = 'Guest';
                $custname = 'GUEST';
            }

            $guest = Customer::create([

                'firstname' => '',
                'lastname' => '',
                'username' => 'GUEST',
                'email' => $request->email,
                'userType' => 'Guest',
                'password' => null,
                'status' => '1',
                'image' => null,

            ]);
            $customersetting = new CustomerSetting();
            $customersetting->custs_id = $guest->id;
            $customersetting->save();
        }
        $guest = Customer::where('email', $request->email)->first();
        if (!$guest) {
            return 'notguest';
        }
        if ($guest) {

            if ($guest->userType == 'Customer') {

                return 'customer';
            }

            $comment = $request->input('message');

            // Trim unwanted tags from the start and end
            $comment = preg_replace('/^(<(p|div)><br><\/(p|div)>)+|(<(p|div)><br><\/(p|div)>)+$/', '', $comment);


            $ticket = Ticket::create([
                'subject' => $request->input('subject'),
                'cust_id' => $guest->id,
                'category_id' => $request->input('category'),
                'message' => $comment,
                'project' => $request->input('project'),
                'tickettype' => $request->input('ticket_source') != null ? $request->input('ticket_source') : null,
                'status' => 'New',
            ]);
            $ticket = Ticket::find($ticket->id);
            $ticket->ticket_id = setting('CUSTOMER_TICKETID') . 'G-' . $ticket->id;
            if ($request->input('envato_id')) {

                $ticket->purchasecode = encrypt($request->input('envato_id'));
                if ($request->input('productname')) {
                    $ticket->item_name = $request->input('productname');
                }
            }
            if ($request->input('envato_support')) {

                $ticket->purchasecodesupport = $request->input('envato_support');
            }
            $categoryfind = Category::find($request->category);
            $ticket->priority = $categoryfind->priority;
            if ($request->subscategory) {
                $ticket->subcategory = $request->subscategory;
            }

            // Auto Overdue Ticket
            if (setting('AUTO_OVERDUE_TICKET') == 'no') {
                $ticket->auto_overdue_ticket = null;
                $ticket->overduestatus = null;
            } else {
                if (setting('AUTO_OVERDUE_TICKET_TIME') == '0') {
                    $ticket->auto_overdue_ticket = null;
                    $ticket->overduestatus = null;
                } else {

                    if ($ticket->status == 'Closed') {
                        $ticket->auto_overdue_ticket = null;
                        $ticket->overduestatus = null;
                    } else {
                        $ticket->auto_overdue_ticket = now()->addDays(setting('AUTO_OVERDUE_TICKET_TIME'));
                        $ticket->overduestatus = null;
                    }
                }
            }
            // End Auto Overdue Ticket

            $ticket->update();
            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $custupdate = Customer::find($ticket->cust_id);
            $custupdate->last_login_ip = $geolocation->ip;
            $custupdate->timezone = $geolocation->timezone;
            $custupdate->country = $geolocation->country;
            $custupdate->update();

            $customfields = Customfield::whereIn('displaytypes', ['both', 'createticket'])->where('status', 1)->get();

            if ($customfields != false) {
                foreach ($customfields as $customfield) {
                    $ticketcustomfield = new TicketCustomfield();
                    $ticketcustomfield->ticket_id = $ticket->id;
                    $ticketcustomfield->fieldnames = $customfield->fieldnames;
                    $ticketcustomfield->fieldtypes = $customfield->fieldtypes;
                    $ticketcustomfield->fieldoptions = $customfield->fieldoptions;
                    if ($customfield->fieldtypes == 'checkbox') {
                        if ($request->input('custom_' . $customfield->id) != null) {

                            $string = $request->input('custom_' . $customfield->id);
                            $ticketcustomfield->values = $string;
                        }
                    }
                    if ($customfield->fieldtypes != 'checkbox') {
                        if ($customfield->fieldprivacy == '1') {
                            $ticketcustomfield->privacymode = $customfield->fieldprivacy;
                            $ticketcustomfield->values = encrypt($request->input('custom_' . $customfield->id));
                        } else {

                            $ticketcustomfield->values = $request->input('custom_' . $customfield->id);
                        }
                    }
                    $ticketcustomfield->save();
                }
            }
            $ccmails = new CCMAILS();
            $ccmails->ticket_id = $ticket->id;
            $ccmails->ccemails = $request->ccmail;
            $ccmails->save();
            foreach ($request->file('ticket', []) as $file) {
                $provider =  storage()->provider;
                if ($request->input('ticket_source') == 'Livechat') {
                    $provider::mediaupload($ticket, 'uploads/livechat/' . $file, 'ticket');
                } else {
                    $provider::mediaupload($ticket, $file, 'ticket');
                }
                // $provider::mediaupload($ticket, $file, 'ticket');
            }

            $tickethistory = new tickethistory();
            $tickethistory->ticket_id = $ticket->id;


            $tickethistory->ticketnote = $ticket->ticketnote->isNotEmpty();
            $tickethistory->status = $ticket->status;
            $tickethistory->status = $ticket->replystatus;
            $tickethistory->overduestatus = $ticket->overduestatus;
            $tickethistory->ticketviolation = $ticket->ticketviolation;
            $tickethistory->currentAction = 'Created';
            $tickethistory->username = $ticket->cust->username;
            $tickethistory->type = $ticket->cust->userType;
            $tickethistory->assignUser = null;

            $tickethistory->save();



            foreach ($request->input('ticket', []) as $file) {
                $provider =  storage()->provider;
                // $provider::mediaupload($ticket, $file, 'ticket');
                if ($request->input('ticket_source') == 'Livechat') {
                    $provider::mediaupload($ticket, 'uploads/livechat/' . $file, 'ticket');
                } else {
                    $provider::mediaupload($ticket, 'uploads/guestticket/' . $file, 'ticket');
                }
            }


            $tickethistory = new tickethistory();
            $tickethistory->ticket_id = $ticket->id;

            $tickethistory->ticketnote = $ticket->ticketnote->isNotEmpty();
            $tickethistory->overduestatus = $ticket->overduestatus;
            $tickethistory->ticketviolation = $ticket->ticketviolation;
            $tickethistory->currentAction = 'Ticket Created';
            $tickethistory->username = $ticket->cust->username;
            $tickethistory->type = $ticket->cust->userType;
            $tickethistory->status = $ticket->status;
            $tickethistory->replystatus = $ticket->replystatus;
            $tickethistory->assignUser = null;

            $tickethistory->save();


            // Create a New ticket reply
            if ($ticket->category) {
                $notificationcat = $ticket->category->groupscategoryc()->get();
                $groupIds = $notificationcat->pluck('group_id')->toArray();
                $groupstatus = false;
                foreach ($groupIds as $groupid) {
                    $groupexist = Groups::where('groupstatus', '1')->find($groupid);
                    if ($groupexist) {
                        $groupstatus = true;
                    }
                }

                $icc = array();

                if ($groupstatus) {

                    foreach ($notificationcat as $igc) {
                        $groups = $igc->groupsc()
                            ->where('groupstatus', 1)
                            ->with('groupsuser')
                            ->get();

                        foreach ($groups as $group) {
                            $users = $group->groupsuser;

                            foreach ($users as $user) {
                                $icc[] = $user->users_id;
                            }
                        }
                    }

                    if (!$icc) {
                        $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->get();
                        foreach ($admins as $admin) {
                            $admin->notify(new TicketCreateNotifications($ticket));
                        }
                    } else {

                        $user = User::whereIn('id', $icc)->get();
                        foreach ($user as $users) {
                            $users->notify(new TicketCreateNotifications($ticket));
                        }
                        $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->get();
                        foreach ($admins as $admin) {
                            $admin->notify(new TicketCreateNotifications($ticket));
                        }
                    }
                } else {
                    foreach (usersdata() as $admin) {
                        $admin->notify(new TicketCreateNotifications($ticket));
                    }
                }
            }
            $ccemailsend = CCMAILS::where('ticket_id', $ticket->id)->first();
            $ticketData = [
                'ticket_username' => $ticket->cust->username,
                'ticket_title' => $ticket->subject,
                'ticket_id' => $ticket->ticket_id,
                'ticket_status' => $ticket->status,
                'ticket_description' => $ticket->message,
                'ticket_customer_url' => url('/guest/ticket/' . encrypt($ticket->ticket_id)),
                'ticket_admin_url' => url('/admin/ticket-view/' . encrypt($ticket->ticket_id)),
                'ticket_category' => $ticket->category ? $ticket->category->name : null,
                'status' => $ticket->status,
                'comment' => $request->input('message')
            ];
            $ticket['customer_url'] = $ticketData['ticket_customer_url'];
            try {
                // $today = Carbon::today();
                // $holidays = Holiday::whereDate('startdate', '<=', $today)->whereDate('enddate', '>=', $today)->where('status','1')->get();

                $today = Carbon::today();
                $activeHolidays = Holiday::where('status', 1)->get();
                $now = now();
                $currentYear = $now->year;
                $holidays = $activeHolidays->filter(function ($holiday) use ($now, $currentYear) {
                    $holidayStart = Carbon::parse($holiday->startdate);
                    $holidayEnd = Carbon::parse($holiday->enddate);
                    if ($holiday->is_fixed) {
                        return $holidayStart->month === $now->month && $holidayStart->day === $now->day;
                    }
                    return $holidayStart->isSameDay($now);
                });


                if ($holidays->isNotEmpty() && setting('24hoursbusinessswitch') != 'on') {
                    dispatch((new MailSend($ticket->cust->email, 'customer_send_ticket_created_that_holiday_or_announcement', $ticketData)));
                    if ($ccemailsend->ccemails != null) {
                        dispatch((new MailSend($ccemailsend->ccemails, 'customer_send_ticket_created_that_holiday_or_announcement', $ticketData)));
                    }
                } else {
                    dispatch((new MailSend($ticket->cust->email, 'customer_send_guestticket_created', $ticketData)));
                    if ($ccemailsend->ccemails != null) {
                        dispatch((new MailSend($ccemailsend->ccemails, 'customer_send_guestticket_created', $ticketData)));
                    }
                }

                if ($ticket->category) {
                    $notificationcat = $ticket->category->groupscategoryc()->get();
                    $groupIds = $notificationcat->pluck('group_id')->toArray();
                    $groupstatus = false;
                    foreach ($groupIds as $groupid) {
                        $groupexist = Groups::where('groupstatus', '1')->find($groupid);
                        if ($groupexist) {
                            $groupstatus = true;
                        }
                    }

                    $icc = array();

                    if ($groupstatus) {

                        foreach ($notificationcat as $igc) {
                            $groups = $igc->groupsc()
                                ->where('groupstatus', 1)
                                ->with('groupsuser')
                                ->get();

                            foreach ($groups as $group) {
                                $users = $group->groupsuser;

                                foreach ($users as $user) {
                                    $icc[] = $user->users_id;
                                }
                            }
                        }
                        if (!$icc) {
                            $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->where('users.status', 1)->get();
                            foreach ($admins as $admin) {
                                if ($admin->usetting->emailnotifyon == 1) {
                                    dispatch((new MailSend($admin->email, 'admin_send_email_ticket_created', $ticketData)));
                                }
                            }
                        } else {

                            $user = User::whereIn('id', $icc)->where('status', 1)->get();
                            foreach ($user as $users) {
                                if ($users->usetting->emailnotifyon == 1) {
                                    dispatch((new MailSend($users->email, 'admin_send_email_ticket_created', $ticketData)));
                                }
                            }
                            $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->where('users.status', 1)->get();
                            foreach ($admins as $admin) {
                                if ($admin->getRoleNames()[0] == 'superadmin' && $admin->usetting->emailnotifyon == 1) {
                                    dispatch((new MailSend($admin->email, 'admin_send_email_ticket_created', $ticketData)));
                                }
                            }
                        }
                    } else {
                        foreach (usersdata() as $admin) {
                            if ($admin->usetting->emailnotifyon == 1) {
                                dispatch((new MailSend($admin->email, 'admin_send_email_ticket_created', $ticketData)));
                            }
                        }
                    }
                }
            } catch (\Exception $e) {

                return $ticket;
            }

            return $ticket;
        }
    }

    public function guestmedia(Request $request)
    {
        $path = public_path('uploads/guestticket/');

        if (!file_exists($path)) {
            mkdir($path, 0777, true);
        }

        $file = $request->file('file');

        $name = uniqid() . '_' . trim($file->getClientOriginalName());

        $file->move($path, $name);

        return response()->json([
            'name' => $name,
            'original_name' => $file->getClientOriginalName(),
        ]);
    }

    public function guestview($ticket_id)
    {
        $ticket_id = decrypt($ticket_id);
        $ticket = Ticket::where('ticket_id', $ticket_id)->firstOrFail();
        $comments = $ticket->comments()->paginate(5);
        $category = $ticket->category;

        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $post = Pages::all();
        $data['page'] = $post;

        $socialAuthSettings = SocialAuthSetting::first();
        $data['socialAuthSettings'] = $socialAuthSettings;

        $now = now();
        $announcement = announcement::whereDate('enddate', '>=', $now->toDateString())->whereDate('startdate', '<=', $now->toDateString())->get();
        $data['announcement'] = $announcement;

        $announcements = Announcement::whereNotNull('announcementday')->get();
        $data['announcements'] = $announcements;

        // $holidays = Holiday::whereDate('startdate', '<=', $now->toDateString())->whereDate('enddate', '>=', $now->toDateString())->where('status', '1')->get();
        // $data['holidays'] =  $holidays;

        $currentYear = $now->year;
        $activeHolidays = Holiday::where('status', 1)->get();

        // Filter holidays
        $data['holidays'] = $activeHolidays->filter(function ($holiday) use ($now, $currentYear) {
            $holidayStart = Carbon::parse($holiday->startdate);
            $holidayEnd = Carbon::parse($holiday->enddate);

            // Check for fixed holidays (compare only day and month)
            if ($holiday->is_fixed) {
                return $holidayStart->month === $now->month && $holidayStart->day === $now->day;
            }

            // For non-fixed holidays, check the full date
            return $holidayStart->isSameDay($now);
        });

        $data['addspace'] = AddSpace::where('status', 1)->get();

        // customer restrict to reply for the ticket.
        $commentsNull = $ticket->comments()->get();
        $latestone = $ticket->comments()->latest('created_at')->first();
        if ($commentsNull->all() != null) {
            $tricky = $ticket->comments()->where('cust_id', $ticket->cust_id)->latest('created_at')->first();
            $data['tricky'] = $tricky;

            if ($tricky) {
                $created_at = $tricky->created_at;
                $now = Carbon::now();
                $created_atMod = $tricky->created_at->addHour(setting('REPLY_ALLOW_IN_HOURS'));

                $difference = $created_atMod->diffForHumans($now);
                // Calculate the difference in hours
                $differenceInHours = $created_at->diffInHours($now);
                if ($differenceInHours < setting('REPLY_ALLOW_IN_HOURS')) {
                    $data['difference'] = $difference;
                }
            }

            if ($latestone->lastseen == null && $latestone->user_id != null) {
                $latestone->lastseen = now();
                $latestone->save();
            }
        }

        if (setting('RESTRICT_TO_REPLY_TICKET') == 'on' && $commentsNull->all() != null && setting('MAXIMUM_ALLOW_REPLIES') > 0) {

            if ($latestone->user_id == null) {
                $ticComment = $ticket->comments()->where('cust_id', $ticket->cust_id)->latest('created_at')->first();
                if ($ticComment != null) {
                    if ($ticComment->created_at->timezone(setting('default_timezone'))->format('Y-m-d') == now()->timezone(setting('default_timezone'))->format('Y-m-d')) {

                        $star1 = now()->subHour(setting('REPLY_ALLOW_IN_HOURS'));
                        $star2 = now();
                        $star3 = now()->addHour(setting('REPLY_ALLOW_IN_HOURS'));

                        $createdcount = $ticket->comments()->where('cust_id', $ticket->cust_id)->whereBetween('created_at', [$star1, $star2])->count();
                        if (session()->get('guestdetailssession') == $ticket_id) {
                            if (request()->page) {
                                $view = view('guestticket.showdataticket', compact('comments', 'createdcount', 'ticket'))->render();
                                return response()->json(['html' => $view]);
                            }
                            return view('guestticket.show', compact('ticket', 'category', 'comments', 'createdcount'))->with($data);
                        } else {
                            return view('guestticket.shownosession')->with($data);
                        }
                    }
                }
            }
        }

        $createdcount = '';
        if (session()->get('guestdetailssession') == $ticket_id) {
            if (request()->page) {
                $view = view('guestticket.showdataticket', compact('comments', 'createdcount', 'ticket'))->render();
                return response()->json(['html' => $view]);
            }
            return view('guestticket.show', compact('ticket', 'category', 'comments', 'createdcount'))->with($data);
        } else {
            return view('guestticket.shownosession')->with($data);
        }
    }

    public function postComment(Request $request, $ticket_id)
    {
        $ticket_id = decrypt($ticket_id);
        $ticket = Ticket::where('ticket_id', $ticket_id)->firstOrFail();

        if ($ticket->status == "Closed") {

            return response()->json(["error" => 'The ticket has been already closed.']);
        } else {
            $this->validate($request, [
                'comment' => ['required',  function ($attribute, $value, $fail) {
                    // Remove all HTML tags and decode entities like &nbsp;
                    $decodedValue = html_entity_decode(strip_tags($value));

                    // Replace non-breaking spaces (\u{A0}) with regular spaces
                    $normalizedValue = str_replace("\u{A0}", ' ', $decodedValue);

                    // Trim unwanted tags from the start and end
                    $normalizedValue = preg_replace('/^(<(p|div)><br><\/(p|div)>)+|(<(p|div)><br><\/(p|div)>)+$/', '', $normalizedValue);
                    // Trim spaces and check if the result is empty
                    if (trim($normalizedValue) === '') {
                        $fail('The comment must contain valid text, not just spaces or HTML.');
                    }
                }]
            ]);


            $commentInput = $request->input('comment');

            // Trim unwanted tags from the start and end
            $commentInput = preg_replace('/^(<(p|div)><br><\/(p|div)>)+|(<(p|div)><br><\/(p|div)>)+$/', '', $commentInput);
            $comment = Comment::create([
                'ticket_id' => $request->input('ticket_id'),
                'cust_id' => $ticket->cust->id,
                'user_id' => null,
                'comment' => $commentInput,
                'commentfrom' => 'guestview',
            ]);
            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $custupdate = Customer::find($ticket->cust_id);
            $custupdate->last_login_ip = $geolocation->ip;
            $custupdate->timezone = $geolocation->timezone;
            $custupdate->country = $geolocation->country;
            $custupdate->update();

            foreach ($request->file('comments', []) as $file) {
                $provider =  storage()->provider;
                $provider::mediaupload($comment, $file, 'comments');
            }

            // Closing the ticket

            if (request()->has(['status'])) {

                $ticket = Ticket::where('ticket_id', $ticket_id)->firstOrFail();
                if ($request->input('status') == "New") {
                    $ticket->status != "New" ? $ticket->status : $request->input('status');
                } else {
                    $ticket->status = $request->input('status');
                }
                $ticket->closing_ticket = now();
                $ticket->replystatus = 'Replied';
                if ($ticket->fileupload_allowed == 'once') {
                    $ticket->fileupload_allowed = null;
                }
                $ticket->update();

                $ticketOwner = $ticket->user;
            }
            if (webSocketCheck()) {
                try {
                    event(new ConversationEvent(dbname(), $request->comment, $request->status, $ticket->cust, $comment->getMedia('comments'), $comment, 'customer', $ticket_id, $ticket, null));
                } catch (\Exception $e) {
                }
            }
            $ticket = Ticket::where('ticket_id', $ticket_id)->firstOrFail();
            $ticket->last_reply = now();
            if ($ticket->fileupload_allowed == 'once') {
                $ticket->fileupload_allowed = null;
            }
            // Auto Overdue Ticket

            if (setting('AUTO_OVERDUE_TICKET') == 'no') {

                $ticket->auto_overdue_ticket = null;
            } else {
                if (setting('AUTO_OVERDUE_TICKET_TIME') == '0') {

                    $ticket->auto_overdue_ticket = null;
                } else {

                    if ($ticket->status == 'Closed') {
                        $ticket->auto_overdue_ticket = null;
                    } else {
                        $ticket->auto_overdue_ticket = now()->addDays(setting('AUTO_OVERDUE_TICKET_TIME'));
                    }
                }
            }
            // Auto Overdue Ticket

            // Auto Closing Ticket

            if (setting('AUTO_CLOSE_TICKET') == 'no') {

                $ticket->auto_close_ticket = null;
            } else {
                if (setting('AUTO_CLOSE_TICKET_TIME') == '0') {

                    $ticket->auto_close_ticket = null;
                } else {

                    $ticket->auto_close_ticket = null;
                }
            }
            // End Auto Close Ticket

            // Auto Response Ticket

            if (setting('AUTO_RESPONSETIME_TICKET') == 'no') {
                $ticket->auto_replystatus = null;
            } else {
                if (setting('AUTO_RESPONSETIME_TICKET_TIME') == '0') {
                    $ticket->auto_replystatus = null;
                } else {
                    $ticket->auto_replystatus = null;
                }
            }
            // End Auto Response Ticket

            if (request()->input(['status']) == 'Closed') {
                $ticket->replystatus = 'Solved';
            }
            $ticket->update();

            $ccemailsend = CCMAILS::where('ticket_id', $ticket->id)->first();

            if (request()->input(['status']) == 'Closed') {

                $tickethistory = new tickethistory();
                $tickethistory->ticket_id = $ticket->id;

                $tickethistory->ticketnote = $ticket->ticketnote->isNotEmpty();
                $tickethistory->overduestatus = $ticket->overduestatus;
                $tickethistory->ticketviolation = $ticket->ticketviolation;
                $tickethistory->currentAction = 'Closed';
                $tickethistory->username = $comment->cust->username;
                $tickethistory->type = $comment->cust->userType;
                $tickethistory->status = $ticket->status;
                $tickethistory->replystatus = $ticket->replystatus;
                $tickethistory->assignUser = null;

                $tickethistory->save();


                $ticketData = [
                    'ticket_username' => $ticket->cust->username,
                    'ticket_id' => $ticket->ticket_id,
                    'ticket_title' => $ticket->subject,
                    'ticket_status' => $ticket->status,
                    'comment' => $comment->comment,
                    'ticket_description' => $ticket->message,
                    'ticket_customer_url' =>  url('/guest/ticket/' . encrypt($ticket->ticket_id)),
                    'ticket_admin_url' => url('/admin/ticket-view/' . encrypt($ticket->ticket_id)),
                    'ticket_category' => $ticket->category ? $ticket->category->name : null,
                    'status' => $ticket->status
                ];

                try {
                    /**** Close Ticket mail and notificaton ****/
                    if ($ticket->category) {
                        $notificationcat = $ticket->category->groupscategoryc()->get();
                        $groupIds = $notificationcat->pluck('group_id')->toArray();
                        $groupstatus = false;
                        foreach ($groupIds as $groupid) {
                            $groupexist = Groups::where('groupstatus', '1')->find($groupid);
                            if ($groupexist) {
                                $groupstatus = true;
                            }
                        }

                        $icc = array();

                        if ($groupstatus) {

                            foreach ($notificationcat as $igc) {
                                $groups = $igc->groupsc()
                                    ->where('groupstatus', 1)
                                    ->with('groupsuser')
                                    ->get();

                                foreach ($groups as $group) {
                                    $users = $group->groupsuser;

                                    foreach ($users as $user) {
                                        $icc[] = $user->users_id;
                                    }
                                }
                            }


                            if (!$icc) {
                                $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->get();
                                foreach ($admins as $admin) {
                                    $admin->notify(new TicketCreateNotifications($ticket));
                                    if ($admin->usetting->emailnotifyon == 1) {
                                        dispatch((new MailSend($admin->email, 'admin_sendemail_whenticketclosed', $ticketData)));
                                    }
                                }
                            } else {
                                if ($ticket->myassignuser) {
                                    $assignee = $ticket->ticketassignmutliples;
                                    foreach ($assignee as $assignees) {
                                        $user = User::where('id', $assignees->toassignuser_id)->get();
                                        foreach ($user as $users) {
                                            if ($users->id == $assignees->toassignuser_id && $users->status == '1') {
                                                $users->notify(new TicketCreateNotifications($ticket));
                                                if ($users->usetting->emailnotifyon == 1) {
                                                    dispatch((new MailSend($users->email, 'admin_sendemail_whenticketclosed', $ticketData)));
                                                }
                                            }
                                        }
                                    }
                                } else if ($ticket->selfassignuser_id) {
                                    $self = User::findOrFail($ticket->selfassignuser_id);
                                    $self->notify(new TicketCreateNotifications($ticket));
                                    if ($self->usetting->emailnotifyon == 1) {
                                        dispatch((new MailSend($self->email, 'admin_sendemail_whenticketclosed', $ticketData)));
                                    }
                                } else if ($icc) {
                                    $user = User::whereIn('id', $icc)->where('status', 1)->get();
                                    foreach ($user as $users) {
                                        $users->notify(new TicketCreateNotifications($ticket));
                                        if ($users->usetting->emailnotifyon == 1) {
                                            dispatch((new MailSend($users->email, 'admin_sendemail_whenticketclosed', $ticketData)));
                                        }
                                    }
                                    $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->where('status', 1)->get();
                                    foreach ($admins as $admin) {
                                        if ($admin->getRoleNames()[0] == 'superadmin') {
                                            $admin->notify(new TicketCreateNotifications($ticket));
                                            if ($admin->usetting->emailnotifyon == 1) {
                                                dispatch((new MailSend($admin->email, 'admin_sendemail_whenticketclosed', $ticketData)));
                                            }
                                        }
                                    }
                                } else {
                                    $users = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->where('users.status', 1)->get();
                                    foreach ($users as $user) {
                                        $user->notify(new TicketCreateNotifications($ticket));
                                        if ($user->usetting->emailnotifyon == 1) {
                                            dispatch((new MailSend($user->email, 'admin_sendemail_whenticketclosed', $ticketData)));
                                        }
                                    }
                                }
                            }
                        } else {
                            if ($ticket->myassignuser) {
                                $assignee = $ticket->ticketassignmutliples;
                                foreach ($assignee as $assignees) {
                                    $user = User::where('id', $assignees->toassignuser_id)->get();
                                    foreach ($user as $users) {
                                        if ($users->id == $assignees->toassignuser_id && $users->status == '1') {
                                            $users->notify(new TicketCreateNotifications($ticket));
                                            if ($users->usetting->emailnotifyon == 1) {
                                                dispatch((new MailSend($users->email, 'admin_sendemail_whenticketclosed', $ticketData)));
                                            }
                                        }
                                    }
                                }
                            } else if ($ticket->selfassignuser_id) {
                                $self = User::findOrFail($ticket->selfassignuser_id);
                                $self->notify(new TicketCreateNotifications($ticket));
                                if ($self->usetting->emailnotifyon == 1) {
                                    dispatch((new MailSend($self->email, 'admin_sendemail_whenticketclosed', $ticketData)));
                                }
                            } else {
                                foreach (usersdata() as $user) {
                                    $user->notify(new TicketCreateNotifications($ticket));
                                    if ($user->usetting->emailnotifyon == 1) {
                                        dispatch((new MailSend($user->email, 'admin_sendemail_whenticketclosed', $ticketData)));
                                    }
                                }
                            }
                        }
                    } else {

                        $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')
                            ->leftJoin('groups', 'groups.id', 'groups_users.groups_id')
                            ->select('users.id', 'users.firstname', 'users.lastname', 'users.email', 'groups.groupname', 'groups.groupstatus')
                            ->where('users.status', 1)
                            ->where(function ($query) {
                                $query->whereNull('groups_users.groups_id')
                                    ->orWhere('groups.groupstatus', '!=', 1);
                            })
                            ->get();
                        foreach ($admins as $admin) {
                            $admin->notify(new TicketCreateNotifications($ticket));
                            if ($admin->usetting->emailnotifyon == 1) {
                                dispatch((new MailSend($admin->email, 'admin_sendemail_whenticketclosed', $ticketData)));
                            }
                        }
                    }

                    dispatch((new MailSend($ticket->cust->email, 'customer_sendemail_whenticketclosed', $ticketData)));
                    if ($ccemailsend->ccemails != null) {
                        dispatch((new MailSend($ccemailsend->ccemails, 'CCmail_sendemail_whenticketclosed', $ticketData)));
                    }
                    /**** End Close Ticket mail and notificaton ****/
                } catch (\Exception $e) {
                    if (setting('ticketrating') == 'on') {

                        return response()->json(["success" => 'The response to the ticket was successful.']);
                    } else {
                        $commentsfind = $ticket->comments()->where('user_id', '!=', null)->distinct()->first();
                        if ($commentsfind) {
                            $ratingtoken = Ratingtoken::create([

                                'token' => str_random(64),
                                'ticket_id' => $ticket->id,
                            ]);

                            return response(['rating' => encrypt($ratingtoken->token)]);
                        } else {
                            return response(['appreciate' => 'Thank You! for your confirmation.']);
                        }
                    }
                }

                if (setting('ticketrating') == 'on') {

                    return response()->json(["success" => 'The response to the ticket was successful.']);
                } else {
                    $commentsfind = $ticket->comments()->where('user_id', '!=', null)->distinct()->first();
                    if ($commentsfind) {
                        $ratingtoken = Ratingtoken::create([

                            'token' => str_random(64),
                            'ticket_id' => $ticket->id,
                        ]);

                        return response(['rating' => encrypt($ratingtoken->token)]);
                    } else {
                        return response(['appreciate' => 'Thank You! for your confirmation.']);
                    }
                }
            } else {

                $tickethistory = new tickethistory();
                $tickethistory->ticket_id = $ticket->id;

                $tickethistory->ticketnote = $ticket->ticketnote->isNotEmpty();
                $tickethistory->overduestatus = $ticket->overduestatus;
                $tickethistory->ticketviolation = $ticket->ticketviolation;
                $tickethistory->currentAction = 'Responded';
                $tickethistory->username = $comment->cust->username;
                $tickethistory->type = $comment->cust->userType;
                $tickethistory->status = $ticket->status;
                $tickethistory->replystatus = $ticket->replystatus;
                $tickethistory->assignUser = null;

                $tickethistory->save();

                if ($ticket->cust->userType == 'Guest') {
                    $ticketData = [
                        'ticket_username' => $ticket->cust->username,
                        'ticket_title' => $ticket->subject,
                        'ticket_id' => $ticket->ticket_id,
                        'ticket_status' => $ticket->status,
                        'ticket_description' => $ticket->message,
                        'comment' => $comment->comment,
                        'ratinglink' => url('rating-page/' . encrypt($ticket->ticket_id)),
                        'ticket_customer_url' =>  url('/guest/ticket/' . encrypt($ticket->ticket_id)),
                        'ticket_admin_url' => url('/admin/ticket-view/' . encrypt($ticket->ticket_id)),
                        'ticket_category' => $ticket->category ? $ticket->category->name : null,
                        'status' => $ticket->status
                    ];
                }
                if ($ticket->cust->userType == 'Customer') {
                    $ticketData = [
                        'ticket_username' => $ticket->cust->username,
                        'ticket_title' => $ticket->subject,
                        'ticket_id' => $ticket->ticket_id,
                        'ticket_status' => $ticket->status,
                        'comment' => $comment->comment,
                        'ticket_description' => $ticket->message,
                        'ratinglink' => url('rating-page/' . encrypt($ticket->ticket_id)),
                        'ticket_customer_url' => url('/customer/ticket-view/' . encrypt($ticket->ticket_id)),
                        'ticket_admin_url' => url('/admin/ticket-view/' . encrypt($ticket->ticket_id)),
                        'ticket_category' => $ticket->category ? $ticket->category->name : null,
                        'status' => $ticket->status
                    ];
                }

                try {

                    // $today = Carbon::today();
                    // $holidays = Holiday::whereDate('startdate', '<=', $today)->whereDate('enddate', '>=', $today)->where('status','1')->get();

                    $today = Carbon::today();
                    $activeHolidays = Holiday::where('status', 1)->get();
                    $now = now();
                    $currentYear = $now->year;
                    $holidays = $activeHolidays->filter(function ($holiday) use ($now, $currentYear) {
                        $holidayStart = Carbon::parse($holiday->startdate);
                        $holidayEnd = Carbon::parse($holiday->enddate);
                        if ($holiday->is_fixed) {
                            return $holidayStart->month === $now->month && $holidayStart->day === $now->day;
                        }
                        return $holidayStart->isSameDay($now);
                    });

                    if ($holidays->isNotEmpty() && setting('24hoursbusinessswitch') != 'on') {
                        dispatch((new MailSend($ticket->cust->email, 'customer_send_ticket_created_that_holiday_or_announcement', $ticketData)));
                        if ($ccemailsend->ccemails != null) {
                            dispatch((new MailSend($ccemailsend->ccemails, 'customer_send_ticket_created_that_holiday_or_announcement', $ticketData)));
                        }
                    } else {
                        dispatch((new MailSend($ticket->cust->email, 'customer_send_ticket_reply', $ticketData)));
                        if ($ccemailsend->ccemails != null) {
                            dispatch((new MailSend($ccemailsend->ccemails, 'customer_send_ticket_reply', $ticketData)));
                        }
                    }
                    /** Reply ticket notification and mail**/
                    if ($ticket->lastreply_mail == null) {
                        if ($ticket->category) {
                            $notificationcat = $ticket->category->groupscategoryc()->get();
                            $groupIds = $notificationcat->pluck('group_id')->toArray();
                            $groupstatus = false;
                            foreach ($groupIds as $groupid) {
                                $groupexist = Groups::where('groupstatus', '1')->find($groupid);
                                if ($groupexist) {
                                    $groupstatus = true;
                                }
                            }

                            $icc = array();

                            if ($groupstatus) {

                                foreach ($notificationcat as $igc) {
                                    $groups = $igc->groupsc()
                                        ->where('groupstatus', 1)
                                        ->with('groupsuser')
                                        ->get();

                                    foreach ($groups as $group) {
                                        $users = $group->groupsuser;

                                        foreach ($users as $user) {
                                            $icc[] = $user->users_id;
                                        }
                                    }
                                }


                                if (!$icc) {
                                    $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->where('users.status', 1)->get();
                                    foreach ($admins as $admin) {
                                        if ($admin->getRoleNames()[0] == 'superadmin') {
                                            $admin->notify(new TicketCreateNotifications($ticket));
                                            if ($admin->usetting->emailnotifyon == 1) {
                                                dispatch((new MailSend($admin->email, 'admin_send_email_ticket_reply', $ticketData)));
                                            }
                                        }
                                    }
                                } else {
                                    if ($ticket->myassignuser) {
                                        $assignee = $ticket->ticketassignmutliples;
                                        foreach ($assignee as $assignees) {
                                            $user = User::where('id', $assignees->toassignuser_id)->where('status', 1)->get();
                                            foreach ($user as $users) {
                                                if ($users->id == $assignees->toassignuser_id) {
                                                    $users->notify(new TicketCreateNotifications($ticket));
                                                    if ($users->usetting->emailnotifyon == 1) {
                                                        dispatch((new MailSend($users->email, 'admin_send_email_ticket_reply', $ticketData)));
                                                    }
                                                }
                                            }
                                        }
                                    } else if ($ticket->selfassignuser_id) {
                                        $self = User::where('status', 1)->findOrFail($ticket->selfassignuser_id);
                                        $self->notify(new TicketCreateNotifications($ticket));
                                        if ($self->usetting->emailnotifyon == 1) {
                                            dispatch((new MailSend($self->email, 'admin_send_email_ticket_reply', $ticketData)));
                                        }
                                    } else if ($icc) {
                                        $user = User::whereIn('id', $icc)->where('status', 1)->get();
                                        foreach ($user as $users) {
                                            $users->notify(new TicketCreateNotifications($ticket));
                                            if ($users->usetting->emailnotifyon == 1) {
                                                dispatch((new MailSend($users->email, 'admin_send_email_ticket_reply', $ticketData)));
                                            }
                                        }
                                        $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->where('users.status', 1)->get();
                                        foreach ($admins as $admin) {
                                            if ($admin->getRoleNames()[0] == 'superadmin') {
                                                $admin->notify(new TicketCreateNotifications($ticket));
                                                if ($admin->usetting->emailnotifyon == 1) {
                                                    dispatch((new MailSend($admin->email, 'admin_send_email_ticket_reply', $ticketData)));
                                                }
                                            }
                                        }
                                    } else {
                                        $users = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->where('users.status', 1)->get();
                                        foreach ($users as $user) {
                                            $user->notify(new TicketCreateNotifications($ticket));
                                            if ($user->usetting->emailnotifyon == 1) {
                                                dispatch((new MailSend($user->email, 'admin_send_email_ticket_reply', $ticketData)));
                                            }
                                        }
                                    }
                                }
                            } else {
                                if ($ticket->myassignuser) {
                                    $assignee = $ticket->ticketassignmutliples;
                                    foreach ($assignee as $assignees) {
                                        $user = User::where('id', $assignees->toassignuser_id)->where('status', 1)->get();
                                        foreach ($user as $users) {
                                            if ($users->id == $assignees->toassignuser_id) {
                                                $users->notify(new TicketCreateNotifications($ticket));
                                                if ($users->usetting->emailnotifyon == 1) {
                                                    dispatch((new MailSend($users->email, 'admin_send_email_ticket_reply', $ticketData)));
                                                }
                                            }
                                        }
                                    }
                                } else if ($ticket->selfassignuser_id) {
                                    $self = User::where('status', 1)->findOrFail($ticket->selfassignuser_id);
                                    $self->notify(new TicketCreateNotifications($ticket));
                                    if ($self->usetting->emailnotifyon == 1) {
                                        dispatch((new MailSend($self->email, 'admin_send_email_ticket_reply', $ticketData)));
                                    }
                                } else {
                                    foreach (usersdata() as $user) {
                                        $user->notify(new TicketCreateNotifications($ticket));
                                        if ($user->usetting->emailnotifyon == 1) {
                                            dispatch((new MailSend($user->email, 'admin_send_email_ticket_reply', $ticketData)));
                                        }
                                    }
                                }
                            }
                        } else {
                            foreach (usersdata() as $admin) {
                                $admin->notify(new TicketCreateNotifications($ticket));
                                if ($admin->usetting->emailnotifyon == 1) {
                                    dispatch((new MailSend($admin->email, 'admin_send_email_ticket_reply', $ticketData)));
                                }
                            }
                        }
                    }

                    if ($ticket->lastreply_mail != null) {
                        if ($ticket->category) {
                            $notificationcat = $ticket->category->groupscategoryc()->get();
                            $groupIds = $notificationcat->pluck('group_id')->toArray();
                            $groupstatus = false;
                            foreach ($groupIds as $groupid) {
                                $groupexist = Groups::where('groupstatus', '1')->find($groupid);
                                if ($groupexist) {
                                    $groupstatus = true;
                                }
                            }

                            $icc = array();

                            if ($groupstatus) {

                                foreach ($notificationcat as $igc) {
                                    $groups = $igc->groupsc()
                                        ->where('groupstatus', 1)
                                        ->with('groupsuser')
                                        ->get();

                                    foreach ($groups as $group) {
                                        $users = $group->groupsuser;

                                        foreach ($users as $user) {
                                            $icc[] = $user->users_id;
                                        }
                                    }
                                }


                                if (!$icc) {
                                    $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->where('users.status', 1)->get();
                                    foreach ($admins as $admin) {
                                        if ($admin->getRoleNames()[0] == 'superadmin') {
                                            $admin->notify(new TicketCreateNotifications($ticket));
                                            if ($admin->usetting->emailnotifyon == 1) {
                                                dispatch((new MailSend($admin->email, 'admin_send_email_ticket_reply', $ticketData)));
                                            }
                                        }
                                    }
                                } else {
                                    if ($ticket->myassignuser_id) {
                                        $assignee = $ticket->ticketassignmutliples;
                                        foreach ($assignee as $assignees) {
                                            $user = User::where('status', 1)->where('id', $assignees->toassignuser_id)->get();
                                            foreach ($user as $users) {
                                                if ($users->id == $assignees->toassignuser_id) {
                                                    $users->notify(new TicketCreateNotifications($ticket));
                                                    if ($users->usetting->emailnotifyon == 1) {
                                                        dispatch((new MailSend($users->email, 'admin_send_email_ticket_reply', $ticketData)));
                                                    }
                                                }
                                            }
                                        }
                                    } else if ($ticket->selfassignuser_id) {

                                        $self = User::where('status', 1)->findOrFail($ticket->selfassignuser_id);
                                        $self->notify(new TicketCreateNotifications($ticket));
                                        if ($self->usetting->emailnotifyon == 1) {
                                            dispatch((new MailSend($self->email, 'admin_send_email_ticket_reply', $ticketData)));
                                        }
                                    } else if ($icc) {
                                        $user = User::whereIn('id', $icc)->where('status', 1)->get();
                                        foreach ($user as $users) {
                                            $users->notify(new TicketCreateNotifications($ticket));
                                            if ($users->usetting->emailnotifyon == 1) {
                                                dispatch((new MailSend($users->email, 'admin_send_email_ticket_reply', $ticketData)));
                                            }
                                        }
                                        $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->where('users.status', 1)->get();
                                        foreach ($admins as $admin) {
                                            if ($admin->getRoleNames()[0] == 'superadmin') {
                                                $admin->notify(new TicketCreateNotifications($ticket));
                                                if ($admin->usetting->emailnotifyon == 1) {
                                                    dispatch((new MailSend($admin->email, 'admin_send_email_ticket_reply', $ticketData)));
                                                }
                                            }
                                        }
                                    } else {
                                        $users = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->where('users.status', 1)->get();
                                        foreach ($users as $user) {
                                            $user->notify(new TicketCreateNotifications($ticket));
                                            if ($user->usetting->emailnotifyon == 1) {
                                                dispatch((new MailSend($user->email, 'admin_send_email_ticket_reply', $ticketData)));
                                            }
                                        }
                                    }
                                }
                            } else {
                                if ($ticket->myassignuser) {
                                    $assignee = $ticket->ticketassignmutliples;
                                    foreach ($assignee as $assignees) {
                                        $user = User::where('id', $assignees->toassignuser_id)->where('status', 1)->get();
                                        foreach ($user as $users) {
                                            if ($users->id == $assignees->toassignuser_id) {
                                                $users->notify(new TicketCreateNotifications($ticket));
                                                if ($users->usetting->emailnotifyon == 1) {
                                                    dispatch((new MailSend($users->email, 'admin_send_email_ticket_reply', $ticketData)));
                                                }
                                            }
                                        }
                                    }
                                } else if ($ticket->selfassignuser_id) {
                                    $self = User::where('status', 1)->findOrFail($ticket->selfassignuser_id);
                                    $self->notify(new TicketCreateNotifications($ticket));
                                    if ($self->usetting->emailnotifyon == 1) {
                                        dispatch((new MailSend($self->email, 'admin_send_email_ticket_reply', $ticketData)));
                                    }
                                } else {
                                    foreach (usersdata() as $user) {
                                        $user->notify(new TicketCreateNotifications($ticket));
                                        if ($user->usetting->emailnotifyon == 1) {
                                            dispatch((new MailSend($user->email, 'admin_send_email_ticket_reply', $ticketData)));
                                        }
                                    }
                                }
                            }
                        } else {
                            $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')
                                ->leftJoin('groups', 'groups.id', 'groups_users.groups_id')
                                ->select('users.id', 'users.firstname', 'users.lastname', 'users.email', 'groups.groupname', 'groups.groupstatus')
                                ->where('users.status', 1)
                                ->where(function ($query) {
                                    $query->whereNull('groups_users.groups_id')
                                        ->orWhere('groups.groupstatus', '!=', 1);
                                })
                                ->get();
                            foreach ($admins as $admin) {
                                $admin->notify(new TicketCreateNotifications($ticket));
                                if ($admin->usetting->emailnotifyon == 1) {
                                    dispatch((new MailSend($admin->email, 'admin_send_email_ticket_reply', $ticketData)));
                                }
                            }
                        }
                    }


                    /** End Reply ticket notification and mails **/
                } catch (\Exception $e) {
                    return response()->json(["success" => 'The response to the ticket was successful.']);
                }

                return response()->json(["success" => 'The response to the ticket was successful.']);
            }
        }
    }

    public function envatoverify(Request $request)
    {

        if ($request->data) {

            $apidatatoken = APIData::first();

            $envato_license = $request->data;

            $url = "https://api.envato.com/v3/market/author/sale?code=" . $envato_license;
            $curl = curl_init($url);

            $personal_api_token = $apidatatoken != null ? $apidatatoken->envatoapitoken : '';

            /*Correct header for the curl extension*/
            $header = array();
            $header[] = 'Authorization: Bearer ' . $personal_api_token;
            $header[] = 'User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:41.0) Gecko/20100101 Firefox/41.0';
            $header[] = 'timeout: 20';
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($curl, CURLOPT_HTTPHEADER, $header);

            /*Connect to the API, and get values from there*/
            $envatoCheck = curl_exec($curl);
            curl_close($curl);

            $envatoCheck = json_decode($envatoCheck);

            $firstone = isset($envatoCheck->error);

            $secondone = null;
            if ($firstone == true) {
                $personal_api_token = $apidatatoken != null ? $apidatatoken->envatoapitokensecond : '';
                $header = array();
                $header[] = 'Authorization: Bearer ' . $personal_api_token;
                $header[] = 'User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:41.0) Gecko/20100101 Firefox/41.0';
                $header[] = 'timeout: 100';
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
                $envatoCheck = curl_exec($curl);
                curl_close($curl);
                $envatoCheck = json_decode($envatoCheck);
                if (isset($envatoCheck->error)) {
                    $secondone = true;
                }
            }

            if ($secondone == true) {
                $personal_api_token = $apidatatoken != null ? $apidatatoken->envatoapitokenthird : '';
                $header = array();
                $header[] = 'Authorization: Bearer ' . $personal_api_token;
                $header[] = 'User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:41.0) Gecko/20100101 Firefox/41.0';
                $header[] = 'timeout: 100';
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
                $envatoCheck = curl_exec($curl);
                curl_close($curl);

                $envatoCheck = json_decode($envatoCheck);
            }

            /*Variable request from the API*/
            $date = new \DateTime(isset($envatoCheck->supported_until) ? $envatoCheck->supported_until : false);
            $support_date = $date->format('Y-m-d H:i:s');
            $sold = new \DateTime(isset($envatoCheck->sold_at) ? $envatoCheck->sold_at : false);
            $sold_at = $sold->format('Y-m-d H:i:s');
            $buyer = (isset($envatoCheck->buyer) ? $envatoCheck->buyer : false);
            $license = (isset($envatoCheck->license) ? $envatoCheck->license : false);
            $count = (isset($envatoCheck->purchase_count) ? $envatoCheck->purchase_count : false);
            $support_amount = (isset($envatoCheck->support_amount) ? $envatoCheck->support_amount : false);
            $item = (isset($envatoCheck->item->previews->landscape_preview->landscape_url) ? $envatoCheck->item->previews->landscape_preview->landscape_url : false);

            /*If Purchase code exists, But Purchase ended*/
            if (setting('ENVATO_EXPIRED_BLOCK') == 'on') {
                if (isset($envatoCheck->item->name) && (date('Y-m-d H:i:s') >= $support_date)) {
                    return response()->json(['valid' => 'expired', 'message' => 'The purchase code has been verified, but your product support has expired.', 'key' => $envato_license, 'name' => $envatoCheck->item->name]);
                }
            } else {
                if (isset($envatoCheck->item->name) && (date('Y-m-d H:i:s') >= $support_date)) {
                    return response()->json(['valid' => 'expired', 'message' => 'The purchase code has been verified, but your product support has expired.', 'key' => $envato_license, 'name' => $envatoCheck->item->name]);
                }
            }

            /*If Purchase code exists, display client information*/
            if (isset($envatoCheck->item->name) && (date('Y-m-d H:i:s') < $support_date)) {
                return response()->json(['valid' => 'true', 'message' => 'The purchase code has been validated and is supported.', 'key' => $envato_license, 'name' => $envatoCheck->item->name]);
            }

            /*If Purchase Code doesn't exist,*/
            if (!isset($envatoCheck->item->name)) {
                return response()->json(['valid' => 'false', 'message' => 'The Purchase Code is invalid.', 'invalid' => true]);
            }
        }
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function rating($ticket_id)
    {
        $ticket_id = decrypt($ticket_id);
        $ratingticket = Ratingtoken::where('token', $ticket_id)->first();

        if (!$ratingticket) {

            return response()->json(["error" => 'Your rating has already been submitted.', 'redirect' => 'back']);
        }
        $ticket = Ticket::where('id', $ratingticket->ticket_id)->first();


        $rating = $ticket->comments()->whereNotNull('user_id')->get();
        $comment = Comment::select('user_id')->where('ticket_id', $ticket->id)->distinct()->get();
        $data['rating'] = $rating;
        $data['comment'] = $comment;
        $data['ticket'] = $ticket;

        return response()->json($data);
    }

    /// rating system ///
    public function star5($id)
    {

        $user = User::with('usetting')->findorFail($id);
        $user->usetting->increment('star5');
        $user->usetting->update();

        return redirect('/')->with('success', 'Thank you for rating us.');
    }

    public function star4($id)
    {

        $user = User::with('usetting')->findorFail($id);
        $user->usetting->increment('star4');
        $user->usetting->update();

        return redirect('/')->with('success', 'Thank you for rating us.');
    }

    public function star3($id)
    {

        $user = User::with('usetting')->findorFail($id);
        $user->usetting->increment('star3');
        $user->usetting->update();

        return redirect('/')->with('success', 'Thank you for rating us.');
    }

    public function star2($id)
    {

        $user = User::with('usetting')->findorFail($id);
        $user->usetting->increment('star2');
        $user->usetting->update();

        return redirect('/')->with('success', 'Thank you for rating us.');
    }

    public function star1($id)
    {

        $user = User::with('usetting')->findorFail($id);
        $user->usetting->increment('star1');
        $user->usetting->update();

        return redirect('/')->with('success', 'Thank you for rating us.');
    }

    public function star($id, Request $request)
    {
        $user = User::with('usetting')->findorFail($id);
        $user->usetting->increment($request->star);
        $user->usetting->update();

        return redirect('/')->with('success', 'Thank you for rating us.');
    }

    public function ticketrating(Request $req)
    {
        $ticketfinding = Ticket::find($req->ticket_id);
        $ratingticket = Userrating::where('ticket_id', $req->ticket_id)->first();
        if ($ratingticket) {
            $ratingticket->ratingstar = $req->ratingticket;
            $ratingticket->ratingcomment = $req->ratingcomment;
            $ratingticket->update();

            $employeeratingloop = Employeerating::where('urating_id', $ratingticket->id)->get();
            foreach ($employeeratingloop as $employeeratings) {
                $employeeratings->delete();
            }

            $commentsfind = $ticketfinding->comments()->where('user_id', '!=', null)->distinct()->get();
            $processedUserIds = [];
            foreach ($commentsfind as $commentfinds) {
                if (!in_array($commentfinds->user_id, $processedUserIds) && $commentfinds->user_id != 741741741) {

                    $employeerating = new Employeerating();
                    $employeerating->urating_id = $ratingticket->id;
                    $employeerating->rating = $ratingticket->ratingstar;
                    $employeerating->user_id = $commentfinds->user_id;
                    $employeerating->save();

                    $userdata = User::find($employeerating->user_id);
                    $emaildata = [
                        'ticket_username' => $userdata->name,
                        'username' => $ticketfinding->cust->username,
                        'rating_value' => $ratingticket->ratingstar,
                        'comment' => $ratingticket->ratingcomment,
                        'ticket_admin_url' => url('/admin/reports/employeedetails/' . $userdata->id),
                    ];

                    dispatch((new MailSend($userdata->email, 'send_email_admin_panel_users_when_customer_given_rating', $emaildata)));

                    $processedUserIds[] = $commentfinds->user_id;
                }
            }
        } else {

            $ticketrating = new Userrating();
            $ticketrating->ticket_id = $req->ticket_id;
            $ticketrating->ratingstar = $req->ratingticket;
            $ticketrating->ratingcomment = $req->ratingcomment;
            $ticketrating->cust_id = $ticketfinding->cust->id;
            $ticketrating->save();

            $ticketsfind = Ticket::where('id', $req->ticket_id)->first();
            $commentsfind = $ticketsfind->comments()->where('user_id', '!=', null)->distinct()->get();
            $processedUserIds = [];
            foreach ($commentsfind as $commentfinds) {
                if (!in_array($commentfinds->user_id, $processedUserIds) && $commentfinds->user_id != 741741741) {
                    $employeerating = new Employeerating();
                    $employeerating->urating_id = $ticketrating->id;
                    $employeerating->rating = $ticketrating->ratingstar;
                    $employeerating->user_id = $commentfinds->user_id;
                    $employeerating->save();
                    $userdata = User::find($employeerating->user_id);
                    $emaildata = [
                        'ticket_username' => $userdata->name,
                        'username' => $ticketfinding->cust->username,
                        'rating_value' => $ticketrating->ratingstar,
                        'comment' => $ticketrating->ratingcomment,
                        'ticket_admin_url' => url('/admin/reports/employeedetails/' . $userdata->id),
                    ];

                    dispatch((new MailSend($userdata->email, 'send_email_admin_panel_users_when_customer_given_rating', $emaildata)));

                    $processedUserIds[] = $commentfinds->user_id;
                }
            }
        }

        $ratingticketdelete = Ratingtoken::where('ticket_id', $req->ticket_id)->get();
        foreach ($ratingticketdelete as $ratingticketdeletes) {
            $ratingticketdeletes->delete();
        }

        return response()->json(['success' => 'Thank you for rating us.']);
    }
    /// end rating system ///

    public function imagedestroy($id)
    {
        //For Deleting Users
        $commentss = Media::findOrFail($id);
        $commentss->delete();
        return response()->json([
            'success' => 'The image has been deleted successfully!',
        ]);
    }

    public function close(Request $request, $ticket_id)
    {
        $ticket_id = decrypt($ticket_id);

        $ticket = Ticket::where('ticket_id', $ticket_id)->firstOrFail();

        $ticket->status = 'Re-Open';

        $ticket->update();

        $tickethistory = new tickethistory();
        $tickethistory->ticket_id = $ticket->id;
        $tickethistory->ticketnote = $ticket->ticketnote->isNotEmpty();
        $tickethistory->overduestatus = $ticket->overduestatus;
        $tickethistory->ticketviolation = $ticket->ticketviolation;
        $tickethistory->currentAction = 'Reopened';
        $tickethistory->username = $ticket->cust->username;
        $tickethistory->type = $ticket->cust->userType;
        $tickethistory->status = $ticket->status;
        $tickethistory->replystatus = $ticket->replystatus;
        $tickethistory->assignUser = null;

        $tickethistory->save();
        if (webSocketCheck()) {
            try {
                event(new \App\Events\ConversationEvent(null, null, null, null, null, 'tableDataReload', null, null));
                event(new \App\Events\ConversationEvent(dbname(), null, 'Reopen', null, null, null, 'customer', $ticket->ticket_id, null));
            } catch (\Exception $e) {
            }
        }

        // Create a New ticket reply
        if ($ticket->category) {
            $notificationcat = $ticket->category->groupscategoryc()->get();
            $groupIds = $notificationcat->pluck('group_id')->toArray();
            $groupstatus = false;
            foreach ($groupIds as $groupid) {
                $groupexist = Groups::where('groupstatus', '1')->find($groupid);
                if ($groupexist) {
                    $groupstatus = true;
                }
            }

            $icc = array();

            if ($groupstatus) {

                foreach ($notificationcat as $igc) {
                    $groups = $igc->groupsc()
                        ->where('groupstatus', 1)
                        ->with('groupsuser')
                        ->get();

                    foreach ($groups as $group) {
                        $users = $group->groupsuser;

                        foreach ($users as $user) {
                            $icc[] = $user->users_id;
                        }
                    }
                }

                if (!$icc) {
                    $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->get();
                    foreach ($admins as $admin) {
                        $admin->notify(new TicketCreateNotifications($ticket));
                    }
                } else {

                    $user = User::whereIn('id', $icc)->get();
                    foreach ($user as $users) {
                        $users->notify(new TicketCreateNotifications($ticket));
                    }
                    $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->get();
                    foreach ($admins as $admin) {
                        $admin->notify(new TicketCreateNotifications($ticket));
                    }
                }
            } else {
                foreach (usersdata() as $admin) {
                    $admin->notify(new TicketCreateNotifications($ticket));
                }
            }
        }

        // Notification category Empty
        if (!$ticket->category) {
            $admins = User::get();
            foreach ($admins as $admin) {
                $admin->notify(new TicketCreateNotifications($ticket));
            }
        }
        $ccemailsend = CCMAILS::where('ticket_id', $ticket->id)->first();

        $ticketData = [
            'ticket_title' => $ticket->subject,
            'ticket_description' => $ticket->message,
            'ticket_id' => $ticket->ticket_id,
            'ticket_username' => $ticket->cust->username,
            'ticket_status' => $ticket->status,
            'ticket_customer_url' =>  url('/guest/ticket/' . encrypt($ticket->ticket_id)),
            'ticket_admin_url' => url('/admin/ticket-view/' . encrypt($ticket->ticket_id)),
            'ticket_category' => $ticket->category ? $ticket->category->name : null,
            'status' => $ticket->status
        ];

        try {

            if ($ticket->category) {
                $notificationcat = $ticket->category->groupscategoryc()->get();
                $groupIds = $notificationcat->pluck('group_id')->toArray();
                $groupstatus = false;
                foreach ($groupIds as $groupid) {
                    $groupexist = Groups::where('groupstatus', '1')->find($groupid);
                    if ($groupexist) {
                        $groupstatus = true;
                    }
                }

                $icc = array();

                if ($groupstatus) {

                    foreach ($notificationcat as $igc) {
                        $groups = $igc->groupsc()
                            ->where('groupstatus', 1)
                            ->with('groupsuser')
                            ->get();

                        foreach ($groups as $group) {
                            $users = $group->groupsuser;

                            foreach ($users as $user) {
                                $icc[] = $user->users_id;
                            }
                        }
                    }
                    if (!$icc) {
                        $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->get();
                        foreach ($admins as $admin) {
                            if ($admin->usetting->emailnotifyon == 1) {
                                dispatch((new MailSend($admin->email, 'admin_sendemail_whenticketreopen', $ticketData)));
                            }
                        }
                    } else {

                        $user = User::whereIn('id', $icc)->where('status', 1)->get();
                        foreach ($user as $users) {
                            if ($users->usetting->emailnotifyon == 1) {
                                dispatch((new MailSend($users->email, 'admin_sendemail_whenticketreopen', $ticketData)));
                            }
                        }
                        $admins = User::leftJoin('groups_users', 'groups_users.users_id', 'users.id')->whereNull('groups_users.groups_id')->whereNull('groups_users.users_id')->get();
                        foreach ($admins as $admin) {
                            if ($admin->usetting->emailnotifyon == 1) {
                                dispatch((new MailSend($admin->email, 'admin_sendemail_whenticketreopen', $ticketData)));
                            }
                        }
                    }
                } else {
                    foreach (usersdata() as $admin) {
                        if ($admin->usetting->emailnotifyon == 1) {
                            dispatch((new MailSend($admin->email, 'admin_sendemail_whenticketreopen', $ticketData)));
                        }
                    }
                }
            }
            if (!$ticket->category) {
                $admins = User::where('users.status', 1)->get();
                foreach ($admins as $admin) {
                    if ($admin->usetting->emailnotifyon == 1) {
                        dispatch((new MailSend($admin->email, 'admin_sendemail_whenticketreopen', $ticketData)));
                    }
                }
            }

            dispatch((new MailSend($ticket->cust->email, 'customer_send_ticket_reopen', $ticketData)));
            if ($ccemailsend->ccemails != null) {
                dispatch((new MailSend($ccemailsend->ccemails, 'customer_send_ticket_reopen', $ticketData)));
            }
        } catch (\Exception $e) {
            return response()->json(["success" => 'The ticket has been successfully reopened.']);
        }

        return response()->json(["success" => 'The ticket has been successfully reopened.']);
    }

    public function emailsvalidateguest(Request $request)
    {

        if (setting('GUEST_TICKET') == 'yes') {
            $request->validate([
                'email' => 'required|max:255|indisposable|email',

            ]);

            $customers = Customer::where('email', $request->email)->first();
            if ($customers != null && $customers->userType == 'Customer') {
                return response()->json(['message' => 'alreadyregistered', 'error' => lang('Email is already registered, Please login to create a Ticket.', 'alerts')], 200);
            }

            // Guest restrict to create tickets based on allowed to create.
            if (setting('RESTRICT_TO_CREATE_TICKET') == 'on' && setting('MAXIMUM_ALLOW_TICKETS') > 0) {
                $customers = Customer::where('email', $request->email)->first();
                if ($customers != null && $customers->tickets != null) {
                    foreach ($customers->tickets as $tic) {
                        $tttt = $tic->latest('created_at')->first();
                        if ($tttt->created_at->timezone(setting('default_timezone'))->format('Y-m-d') == now()->timezone(setting('default_timezone'))->format('Y-m-d')) {
                            $star1 = $tttt->created_at->timezone(setting('default_timezone'))->subHour(setting('MAXIMUM_ALLOW_HOURS'))->format('Y-m-d H:i:s');
                            $star2 = $tttt->created_at->timezone(setting('default_timezone'))->format('Y-m-d H:i:s');
                            $ticketscount = Ticket::where('cust_id', $tic->cust_id)->whereBetween('created_at', [$star1, $star2])->count();
                            if ($ticketscount >= setting('MAXIMUM_ALLOW_TICKETS')) {
                                return response()->json(['message' => 'ticcreaterestrict', 'error' => lang('Customer has reached maximum allowed tickets to create.', 'alerts')], 200);
                            }
                        }
                    }
                }
            }

            $email = $request->email;
            $completeDomain = substr(strrchr($email, "@"), 1);
            $emaildomainlist = setting('EMAILDOMAIN_LIST');
            $emaildomainlistArray = explode(",", $emaildomainlist);

            if (setting('EMAILDOMAIN_BLOCKTYPE') == 'blockemail') {

                if (setting('EMAILDOMAIN_LIST') == null) {
                    $ticket = $this->createverifyotp($request);
                    return response()->json(['message' => 'createverifyotp', 'success' => lang('An OTP (One Time Password) has been sent to your email ID. Please enter the OTP below to submit your guest ticket', 'alerts')], 200);
                } else {
                    if (in_array($completeDomain, $emaildomainlistArray)) {

                        return response()->json(['message' => 'domainblock', 'error' => lang('Domain is Blocked List', 'alerts')], 200);
                    }
                    $ticket = $this->createverifyotp($request);
                    return response()->json(['message' => 'createverifyotp', 'success' => lang('An OTP (One Time Password) has been sent to your email ID. Please enter the OTP below to submit your guest ticket.', 'alerts')], 200);
                }
            }

            if (setting('EMAILDOMAIN_BLOCKTYPE') == 'allowemail') {
                if (setting('EMAILDOMAIN_LIST') == null) {
                    $ticket = $this->createverifyotp($request);
                    return response()->json(['message' => 'createverifyotp', 'success' => lang('An OTP (One Time Password) has been sent to your email ID. Please enter the OTP below to submit your guest ticket.', 'alerts')], 200);
                } else {
                    if (in_array($completeDomain, $emaildomainlistArray)) {
                        $ticket = $this->createverifyotp($request);
                        return response()->json(['message' => 'createverifyotp', 'success' => lang('An OTP (One Time Password) has been sent to your email ID. Please enter the OTP below to submit your guest ticket.', 'alerts')], 200);
                    }
                    return response()->json(['message' => 'domainblock', 'error' => lang('Domain is Blocked List', 'alerts')], 200);
                }
            }
        } else {
            return response()->json(['message' => 'accessdenied', 'error' => lang('you are not autherised to this ticket create', 'alerts')], 500);
        }
    }

    private function createverifyotp($request)
    {
        $guest = VerifyOtp::where('type', 'guestotp')->where('cust_id', $request->email)->first();

        if ($guest) {
            $guest->otp = rand(100000, 999999);
            $guest->update();
            if ($request->session()->has('sessionemail')) {
                $request->session()->forget('sessionemail');
            }
            $request->session()->put('sessionemail', $guest->cust_id);
            $guestticket = [

                'guestotp' => $guest->otp,
                'guestemail' => $guest->cust_id,
                'guestname' => 'Guest',
            ];
            try {
                dispatch((new MailSend($guest->cust_id, 'guestticket_email_verification', $guestticket)));
            } catch (\Exception $e) {

                return response()->json(['success' => 'Please check your Email', 'email' => 'exists']);
            }
        }
        if (!$guest) {
            $verifyOtp = VerifyOtp::create([
                'cust_id' => $request->email,
                'otp' => rand(100000, 999999),
                'type' => 'guestotp',
            ]);

            if ($request->session()->has('sessionemail')) {
                $request->session()->forget('sessionemail');
            }
            $request->session()->put('sessionemail', $verifyOtp->cust_id);
            $guestticket = [

                'guestotp' => $verifyOtp->otp,
                'guestemail' => $verifyOtp->cust_id,
                'guestname' => 'Guest',
            ];

            try {
                dispatch((new MailSend($verifyOtp->cust_id, 'guestticket_email_verification', $guestticket)));
            } catch (\Exception $e) {

                return response()->json(['success' => 'Please check your Email', 'email' => 'exists']);
            }
        }
    }

    public function verifyotp(Request $request)
    {
        if ($request->session()->has('sessionemail')) {
            $emailvalidate = $request->session()->get('sessionemail');
        }
        $verify = VerifyOtp::where('type', 'guestotp')->where('otp', $request->otpvalue)->first();
        if ($verify) {
            if ($emailvalidate == $verify->cust_id) {
                $customerfind = Customer::where('email', $verify->cust_id)->first();
                if (!$customerfind) {
                    $guest = Customer::create([

                        'firstname' => '',
                        'lastname' => '',
                        'username' => 'GUEST',
                        'email' => $verify->cust_id,
                        'userType' => 'Guest',
                        'password' => null,
                        'status' => '1',
                        'image' => null,

                    ]);
                    $customersetting = new CustomerSetting();
                    $customersetting->custs_id = $guest->id;
                    $customersetting->save();

                    return response()->json(['success' => 'verified', $guest], 200);
                }

                if ($customerfind) {
                    return response()->json(['success' => 'verified', $customerfind], 200);
                }
            }
        } else {
            return response()->json(['error' => 'Invalid OTP'], 200);
        }
        if (!$verify) {
            return response()->json(['error' => 'Invalid OTP'], 200);
        }
    }

    public function subcategorylist(Request $request)
    {

        $parent_id = $request->cat_id;

        $subcategories = Subcategorychild::where('category_id', $parent_id)->get();

        $output = [];
        if ($subcategories->isNotEmpty()) {
            foreach ($subcategories as $subcats) {
                $sucatss = $subcats->subcatlists()->where('status', '1')->get();
                if ($sucatss->isNotEmpty()) {
                    foreach ($sucatss as $subcategory) {
                        array_push($output, $subcategory);
                    }
                }
            }
        }

        //projectlist
        $projects = Projects::select('projects.*', 'projects_categories.category_id')->join('projects_categories', 'projects_categories.projects_id', 'projects.id')
            ->where('projects_categories.category_id', $parent_id)
            ->get();

        // envato asssign

        $categoryenvato = CategoryEnvato::where('category_id', $parent_id)->get();

        $data = [
            'subcategories' => $output,
            'projects' => $projects,
            'envatosuccess' => $categoryenvato,
            'ENVATO_ON' => setting('ENVATO_ON'),
        ];

        return response()->json($data);
    }

    public function ticketview(Request $request, $ticket_id)
    {
        $ticket_id = decrypt($ticket_id);
        $ticket = Ticket::with('cust', 'ticket_customfield', 'media', 'subcategoriess')->where('ticket_id', $ticket_id)->first();

        if (!$ticket) {
            return response(['noticket' => 'There was no ticket with ' . $ticket_id]);
        }
        $data['ticket'] = $ticket;


        $data['addspace'] = AddSpace::where('status', 1)->get();

        $page = $request['page'] ?? 1;
        $comments =  Comment::with(['cust', 'user', 'media' => function ($query) {
            $query->where('collection_name', 'comments');
        }])->where('ticket_id', $ticket->id)->latest()->paginate($request['per_page']);

        $data['comments'] = $comments;

        $category = $ticket->category;
        $data['category'] = $category;


        if (setting('supporticonimage')) {
            $data['supporticonimageprev'] = asset('/uploads/support/' . setting('supporticonimage'));
        } else {
            $data['supporticonimageprev'] = asset('/uploads/support/support/support.png');
        }

        $data['languages'] = languages();
        $setting  = response()->json(
            [
                'businesshoursswitch' => setting('businesshoursswitch'),
                'date_format' => setting('date_format'),
                'businesshourssubtitle' => setting('businesshourssubtitle'),
                'businesshourstitle' => setting('businesshourstitle'),
                'default_timezone' => setting('default_timezone'),
                'customer_panel_employee_protect' => setting('customer_panel_employee_protect'),
                'employeeprotectname' => setting('employeeprotectname'),
                'USER_REOPEN_TIME' => setting('USER_REOPEN_TIME'),
                'USER_REOPEN_ISSUE' => setting('USER_REOPEN_ISSUE'),
                'FILE_UPLOAD_MAX' => setting('FILE_UPLOAD_MAX'),
                'GUEST_FILE_UPLOAD_ENABLE' => setting('GUEST_FILE_UPLOAD_ENABLE'),
                'cc_email' => setting('cc_email'),
                'MAX_FILE_UPLOAD' => setting('MAX_FILE_UPLOAD'),
                'TICKET_CHARACTER' => setting('TICKET_CHARACTER'),
                'FILE_UPLOAD_TYPES' => setting('FILE_UPLOAD_TYPES'),
                'MAXIMUM_ALLOW_REPLIES' => setting('MAXIMUM_ALLOW_REPLIES'),
                'ANNOUNCEMENT_USER' => setting('ANNOUNCEMENT_USER'),
                "bot_image" => setting("bot_image"),
                "bot_name" => setting("bot_name"),
                'LengthTextFieldStatus' => setting('LengthTextFieldStatus'),
                'maxLengthTextField' => setting('maxLengthTextField'),
                'minLengthTextField' => setting('minLengthTextField'),
                'cust_google_translate' => setting('cust_google_translate'),
                'businesshourofflinemsg' => setting('businesshourofflinemsg'),
                'offlineTextTitle' => setting('offlineTextTitle'),
                'offlineTextMessage' => setting('offlineTextMessage'),
            ]
        );
        $data['setting'] = $setting;


        $now = now();
        $holidays = Holiday::whereDate('startdate', '<=', $now->toDateString())->where('status', '1')->get();
        if ($holidays->isNotEmpty()) {
            $data['isOnline'] = false;
        } else {
            $businesshours = Businesshours::get();
            $data['businesshours'] = $businesshours;

            foreach ($businesshours as $business) {
                if (now()->timezone(setting('default_timezone'))->format('D') == $business->weeks) {
                    if (strtotime($business->starttime) <= strtotime(now()->timezone(setting('default_timezone'))->format('h:i A')) && strtotime($business->endtime) >= strtotime(now()->timezone(setting('default_timezone'))->format('h:i A')) || $business->starttime == "24H") {
                        $data['isOnline'] = true;
                    } else {

                        $data['isOnline'] = false;
                    }
                }
            }
        }
        $data['nouser'] =  asset('uploads/profile/user-profile.png');


        $holidays = Holiday::whereDate('startdate', '<=', $now->toDateString())->whereDate('enddate', '>=', $now->toDateString())->where('status', 1)->get();
        $data['holidays'] =  $holidays;


        if (auth()->guard('customer')->user()) {
            $data['user'] = auth()->guard('customer')->user();
        }
        // customer restrict to reply for the ticket.
        $commentsNull = $ticket->comments()->get();
        $latestone = $ticket->comments()->latest('created_at')->first();
        $ticComment = $ticket->comments()->latest('created_at')->take(setting('MAXIMUM_ALLOW_REPLIES'))->get();
        if ($ticComment != null) {
            $hasAdmin = false;
            foreach ($ticComment as $tic) {
                if ($tic->user_id != null) {
                    $hasAdmin = true;
                }
            }
            if (!$hasAdmin) {
                if ($commentsNull->all() != null && $latestone->lastseen == null && $latestone->user_id != null) {
                    $latestone->lastseen = now();
                    $latestone->save();
                }

                if (setting('RESTRICT_TO_REPLY_TICKET') == 'on' && $commentsNull->all() != null && setting('MAXIMUM_ALLOW_REPLIES') > 0) {
                    $star1 = now()->subHour(setting('REPLY_ALLOW_IN_HOURS'));
                    $star2 = now();
                    $latestReplies = $ticket->comments()->whereBetween('created_at', [$star1, $star2])->get()->take(setting('MAXIMUM_ALLOW_REPLIES'));
                    $totalcount = 0;
                    foreach ($latestReplies as $comment) {
                        if ($comment->user_id !== null) {
                            $totalcount++;
                        }
                    }
                    if (!$totalcount) {
                        $currentTcikets = $latestReplies->last();
                        $data['difference'] = $currentTcikets->created_at->addHour(setting('REPLY_ALLOW_IN_HOURS'))->diffForHumans($now);
                        $createdcount = $ticket->comments()->where('cust_id', $ticket->cust_id)->whereBetween('created_at', [$star1, $star2])->count();
                        $data['createdcount'] = $createdcount;
                    }
                }
            }
        }
        $editTimeLimit = setting('custreplyeditwithintime');
        if (is_numeric($editTimeLimit)) {
            $editTimeLimit = (int) $editTimeLimit;
        } else {
            $editTimeLimit = 0;
        }
        $createdAt = $comments->first()?->created_at;
        $currentTime = now();
        $timeDifference = $currentTime->diffInMinutes($createdAt);
        if ($timeDifference < $editTimeLimit) {
            $data['editTimeLimit'] = true;
        }
        if (session()->get('sessionverifyemail') == $ticket_id || session()->get('guestdetailssession') == $ticket_id) {
            return $data;
        }
        return response()->json(['error' => 'verify the email']);
    }

    public function senddataverify(Request $request)
    {
        $ticketid = $request->id;

        $ticketfind = Ticket::find($ticketid);

        $email = $ticketfind->cust->email;

        $guest = VerifyOtp::where('type', 'guestverifyotp')->where('cust_id', $email)->first();

        if (!$guest) {
            $verifyOtp = VerifyOtp::create([
                'cust_id' => $email,
                'otp' => rand(100000, 999999),
                'type' => 'guestverifyotp',
            ]);

            if ($request->session()->has('sessionverifyemail')) {
                $request->session()->forget('sessionverifyemail');
            }
            $request->session()->put('sessionverifyemail', $ticketfind->ticket_id);
            session()->put('guestdetailssession',  $ticketfind->ticket_id);
            $guestticket = [

                'guestotp' => $verifyOtp->otp,
                'guestemail' => $verifyOtp->cust_id,
                'guestname' => 'Guest',
            ];

            try {
                dispatch((new MailSend($verifyOtp->cust_id, 'guestticket_email_verification_view', $guestticket)));
            } catch (\Exception $e) {

                return response()->json(['success' => 'Please check your Email', 'verifyemail' => 'OK']);
            }
            return response()->json(['success' => 'Please check your Email', 'verifyemail' => 'OK']);
        }

        if ($guest) {
            $guest->otp = rand(100000, 999999);
            $guest->update();
            if ($request->session()->has('sessionverifyemail')) {
                $request->session()->forget('sessionverifyemail');
            }
            $request->session()->put('sessionverifyemail', $guest->cust_id);
            $guestticket = [

                'guestotp' => $guest->otp,
                'guestemail' => $guest->cust_id,
                'guestname' => 'Guest',
            ];

            try {
                dispatch((new MailSend($guest->cust_id, 'guestticket_email_verification_view', $guestticket)));
            } catch (\Exception $e) {

                return response()->json(['success' => 'Please check your Email', 'verifyemail' => 'OK']);
            }
            return response()->json(['success' => 'Please check your Email', 'verifyemail' => 'OK']);
        }
    }

    public function verifyguestotp(Request $request)
    {
        $otpverify = $request->otpvalue;

        if ($request->session()->has('sessionemail')) {
            $emailvalidate = $request->session()->get('sessionemail');
        }
        $verify = VerifyOtp::where('type', 'guestverifyotp')->where('otp', $request->otpvalue)->first();
        if ($verify) {
            // sessionverifyemail
            $guestticketdetailssession = session()->put('guestticketdetailssession', $verify->cust_id);
            return response()->json(['success' => 'Valid OTP'], 200);
        }
        if (!$verify) {
            return response()->json(['error' => 'Invalid OTP'], 200);
        }
    }

    public function ticketdetailshow($ticket_id)
    {

        $ticket_id = decrypt($ticket_id);
        $title = Apptitle::first();
        $data['title'] = $title;
        $ticket = Ticket::where('ticket_id', $ticket_id)->first();
        if (!$ticket) {
            return response(['noticket' => 'There was no ticket with ' . $ticket_id]);
        }
        $data['ticket'] = $ticket;
        $comments = $ticket->comments()->get();
        $data['comments'] = $comments;
        $category = $ticket->category;
        $data['category'] = $category;


        $verifyUser = VerifyOtp::where('type', 'guestverifyotp')->where('cust_id', $ticket->cust->email)->first();
        if ($verifyUser) {

            $verifyUser->delete();
        }
        $now = now();
        // $holidays = Holiday::whereDate('startdate', '<=', $now->toDateString())->whereDate('enddate', '>=', $now->toDateString())->where('status', 1)->get();
        // $data['holidays'] =  $holidays;

        $currentYear = $now->year;
        $activeHolidays = Holiday::where('status', 1)->get();

        // Filter holidays
        $data['holidays'] = $activeHolidays->filter(function ($holiday) use ($now, $currentYear) {
            $holidayStart = Carbon::parse($holiday->startdate);
            $holidayEnd = Carbon::parse($holiday->enddate);

            // Check for fixed holidays (compare only day and month)
            if ($holiday->is_fixed) {
                return $holidayStart->month === $now->month && $holidayStart->day === $now->day;
            }

            // For non-fixed holidays, check the full date
            return $holidayStart->isSameDay($now);
        });

        $data['addspace'] = AddSpace::where('status', 1)->get();

        // customer restrict to reply for the ticket.
        $commentsNull = $ticket->comments()->get();
        if ($commentsNull->all() != null) {

            foreach ($commentsNull as $latestone) {
                if ($latestone->lastseen == null && $latestone->user_id != null) {
                    $latestone->lastseen = now();
                    $latestone->save();
                }
            }
        }

        if (setting('RESTRICT_TO_REPLY_TICKET') == 'on' && $commentsNull->all() != null && setting('MAXIMUM_ALLOW_REPLIES') > 0) {

            $star1 = now()->subHour(setting('REPLY_ALLOW_IN_HOURS'));
            $star2 = now();
            $latestReplies = $ticket->comments()->whereBetween('created_at', [$star1, $star2])->get()->take(setting('MAXIMUM_ALLOW_REPLIES'));
            $totalcount = 0;
            foreach ($latestReplies as $comment) {
                if ($comment->user_id !== null) {
                    $totalcount++;
                }
            }

            if (!$totalcount) {
                $currentTcikets = $latestReplies->last();
                $data['difference'] = $currentTcikets->created_at->addHour(setting('REPLY_ALLOW_IN_HOURS'))->diffForHumans(now());
                $createdcount = $ticket->comments()->where('cust_id', $ticket->cust_id)->whereBetween('created_at', [$star1, $star2])->count();

                if (session()->get('sessionverifyemail') == $ticket_id) {
                    return $data;
                } else {
                    return response()->json(['ticket' => (object)['enc_ticket_id' => encrypt($ticket_id), 'ticket_id' => $ticket_id, 'id' => $ticket->id,  'cust' => (object)['email' => $ticket->cust->email]], 'title' => Apptitle::first()]);
                }
            }
        }

        $createdcount = '';
        if (session()->get('sessionverifyemail') == $ticket_id) {
            return $data;
        } else {
            return response()->json(['ticket' => (object)['enc_ticket_id' => encrypt($ticket_id), 'ticket_id' => $ticket_id, 'id' => $ticket->id,  'cust' => (object)['email' => $ticket->cust->email]], 'title' => Apptitle::first()]);
        }
    }

    public function notificationalerts()
    {

        if (Auth::check() && Auth::user()) {
            $data = Auth::user()->unreadNotifications()->where('notifiable', '0')->get();
            $data->transform(function ($groups) {
                if (isset($groups->data['ticket_id'])) {
                    $groups->enc_ticket_id = encrypt($groups->data['ticket_id']);
                }
                return $groups;
            });
            $dataa = $data->count();
            return response()->json($data, 200);
        }
    }

    public function notificationalertsread()
    {
        if (Auth::check() && Auth::user()) {
            $data = Auth::user()->unreadNotifications()->get();
            foreach ($data as $dataas) {
                $dataas->notifiable = '1';
                $dataas->update();
            }
            return response()->noContent();
        }
    }

    public function notificationsreading()
    {
        if (auth()->user()) {
            $notify = auth()->user()->unreadNotifications()->paginate(2);

            $notify->getCollection()->transform(function ($groups) {
                if (isset($groups->data['ticket_id'])) {
                    $groups->enc_ticket_id = encrypt($groups->data['ticket_id']);
                }
                return $groups;
            });
            $data['notifys'] = $notify;
            $badgecount = auth()->user()->unreadNotifications->count();
            $data['badgecount'] = $badgecount;
            return $data;
        }
    }

    public function cnotificationalerts()
    {

        if (Auth::guard('customer')->check() && Auth::guard('customer')->user()) {
            $data = Auth::guard('customer')->user()->unreadNotifications()->where('notifiable', '0')->get();

            $data->transform(function ($groups) {
                if (isset($groups->data['ticket_id'])) {
                    $groups->enc_ticket_id = encrypt($groups->data['ticket_id']);
                }
                return $groups;
            });
            $dataa = $data->count();
            return response()->json($data, 200);
        }
    }

    public function cnotificationalertsread()
    {
        if (Auth::guard('customer')->check() && Auth::guard('customer')->user()) {
            $data = Auth::guard('customer')->user()->unreadNotifications()->get();
            foreach ($data as $dataas) {
                $dataas->notifiable = '1';
                $dataas->update();
            }
            return response()->noContent();
        }
    }

    public function cnotificationsreading()
    {
        if (auth()->guard('customer')->user()) {
            $notify = auth()->guard('customer')->user()->unreadNotifications()->paginate(2);

            $notify->getCollection()->transform(function ($groups) {
                if (isset($groups->data['ticket_id'])) {
                    $groups->enc_ticket_id = encrypt($groups->data['ticket_id']);
                }
                return $groups;
            });
            $data['notifys'] = $notify;

            $badgecount = auth()->guard('customer')->user()->unreadNotifications->count();
            $data['badgecount'] = $badgecount;
            return $data;
        }
    }

    public function markallnotify()
    {
        if (auth()->guard('customer')->user()) {
            auth()->guard('customer')->user()->unreadNotifications->markAsRead();

            return response()->noContent();
        }
    }
}
