<?php

namespace App\Http\Controllers\User\Auth\Passwords;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Apptitle;
use App\Models\passwordreset;
use App\Models\Customer;
use App\Models\Seosetting;
use App\Models\Announcement;
use App\Models\Holiday;
use Carbon\Carbon;
use laravelLara\infoinst\Jobs\MailSend;

class ForgotpasswordController extends Controller
{

    public function forgot()
    {

        $title = Apptitle::first();
        $data['title'] = $title;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $now = now();
        $announcement = announcement::whereDate('enddate', '>=', $now->toDateString())->whereDate('startdate', '<=', $now->toDateString())->get();
        $data['announcement'] = $announcement;

        $announcements = Announcement::whereNotNull('announcementday')->get();
        $data['announcements'] = $announcements;
        // $holidays = Holiday::whereDate('startdate', '<=', $now->toDateString())->whereDate('enddate', '>=', $now->toDateString())->where('status', '1')->get();
        // $data['holidays'] =  $holidays;

        $now = now();
        $currentYear = $now->year;
        $activeHolidays = Holiday::where('status', 1)->get();
        $data['holidays'] = $activeHolidays->filter(function ($holiday) use ($now, $currentYear) {
            $holidayStart = Carbon::parse($holiday->startdate);
            $holidayEnd = Carbon::parse($holiday->enddate);
            if ($holiday->is_fixed) {
                return $holidayStart->month === $now->month && $holidayStart->day === $now->day;
            }
            return $holidayStart->isSameDay($now);
        });

        return view('user.auth.passwords.forgotpassword')->with($data);
    }

    public function Email(Request $request)
    {
        $request->validate([
            'email' => 'required|email|exists:customers',
        ]);

        $customerExist = Customer::where('email', $request->email)->first();

        if ($customerExist->userType == 'Guest') {
            return response()->json(['error' => 'You have created a guest account for our application; to access the application, please register. Your tickets will appear after you register.', 'redirect' => 'resgister']);
        }

        $token = str_random(64);

        $reset = passwordreset::create([
            'email' => $request->email,
            'token' => $token,
        ]);

        $verifyData = [
            'reset_password_url' => url('customer/' . $reset->token . '/reset-password'),
        ];

        try {
            dispatch((new MailSend($reset->email, 'forget_password', $verifyData)));
        } catch (\Exception $e) {

            if (setting('REGISTER_POPUP') == 'yes') {

                return response()->json(['success' => 'We have e-mailed your password reset link!', 'redirect' => '/home']);
            } else {

                return response()->json(['success' => 'We have e-mailed your password reset link!']);
            }
        }
        if (setting('REGISTER_POPUP') == 'yes') {

            return response()->json(['success' => 'We have e-mailed your password reset link!', 'redirect' => '/home']);
        } else {

            return response()->json(['success' => 'We have e-mailed your password reset link!']);
        }
    }

    public function Emailajax(Request $request)
    {

        $customerExist = Customer::where(['email' => $request->email])->exists();

        if ($customerExist) {
            $token = str_random(64);

            $reset = passwordreset::create([
                'email' => $request->email,
                'token' => $token,
            ]);

            $verifyData = [

                'reset_password_url' => url('customer/' . $reset->token . '/reset-password'),

            ];

            try {
                dispatch((new MailSend($reset->email, 'forget_password', $verifyData)));
            } catch (\Exception $e) {
                return response()->json([[1]]);
            }
            return response()->json([[1]]);
        } else {
            return response()->json([[3]]);
        }
    }
}
