<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Auth;
use App\Models\Ticket\Ticket;
use App\Models\Businesshours;
use App\Models\Customer;
use App\Models\Setting;
use Illuminate\Support\Facades\Schema;
use App\Models\Announcement;
use App\Models\Holiday;
use Carbon\Carbon;
use App\Models\AddSpace;
use App\Models\AllTransactions;
class DashboardController extends Controller
{


    public function userTickets(Request $request)
    {
        if ((Auth::guard('customer')->user())) {


            $customer = Customer::findOrFail(Auth::guard('customer')->user()->id);
            $data['authId'] = $customer->id;

            $mailnotify = Auth::guard('customer')->user()->unreadNotifications()->where('data->status', 'mail')->get();

            $mailnotify->transform(function ($groups) {
                if (isset($groups->data['ticket_id'])) {
                    $groups->enc_ticket_id = encrypt($groups->data['ticket_id']);
                }
                return $groups;
            });
            $data['mailnotify'] = $mailnotify;

            $permission = Setting::get();
            $data['permission'] = $permission;

            $searchTerm = $request['filter'] ?? null;
            $perPage    = $request['per_page'] ?? 15;
            $page       = $request['page'] ?? 1;
            $totlaTicketscount = Ticket::with('cust', 'ticketdraft', 'ticketnote', 'ticketassignmutliples', 'selfassign', 'category')->where('cust_id', Auth::guard('customer')->user()->id)->count();
            $data['totlaTicketscount'] = $totlaTicketscount;
            $activeTicketscount = Ticket::with('cust', 'ticketdraft', 'ticketnote', 'ticketassignmutliples', 'selfassign', 'category')->where('cust_id', Auth::guard('customer')->user()->id)
                ->whereIn('status', ['New', 'Re-Open', 'Inprogress'])->count();
            $data['activeTicketscount'] = $activeTicketscount;
            $onhoildTicketscount = Ticket::with('cust', 'ticketdraft', 'ticketnote', 'ticketassignmutliples', 'selfassign', 'category')->where('cust_id', Auth::guard('customer')->user()->id)->where('status', 'On-Hold')->count();
            $data['onhoildTicketscount'] = $onhoildTicketscount;
            $closedTicketscount = Ticket::with('cust', 'ticketdraft', 'ticketnote', 'ticketassignmutliples', 'selfassign', 'category')->where('cust_id', Auth::guard('customer')->user()->id)
                ->where('status', 'Closed')->count();
            $data['closedTicketscount'] = $closedTicketscount;

            $quotations = AllTransactions::where('cust_id', Auth::guard('customer')->user()->id) ->whereIn('status', ['pending', 'cancelled'])->latest('created_at')->get();
            $data['quotationscount'] = $quotations->count();
    
            $unviewedQuotations = $quotations->where('cust_viewed', '!=', 1)->where('status','pending');
            $data['unviewedQuotations'] = $unviewedQuotations;
    
            $invoices = AllTransactions::where('cust_id', Auth::guard('customer')->user()->id)->where('status', 'paid')->get();
            $data['invoicescount'] = $invoices->count();
    
            $refunds = AllTransactions::where('cust_id', Auth::guard('customer')->user()->id)->where('status', ['refunded', 'refundpending', 'refundRejected'])->get();
            $data['refundscount'] = $refunds->count();


            $tickets = Ticket::with('cust', 'ticketdraft', 'ticketnote', 'ticketassignmutliples', 'selfassign', 'category')->where('cust_id', Auth::guard('customer')->user()->id)->latest('updated_at');

            if ($searchTerm) {
                $tickets->where(function ($query) use ($searchTerm) {
                    $columns = Schema::getColumnListing('tickets');
                    foreach ($columns as $column) {
                        $query->orWhere($column, 'LIKE', "%{$searchTerm}%");
                    }
                    $query->orWhereHas('category', function ($query) use ($searchTerm) {
                        $query->where('name', 'LIKE', $searchTerm . '%');
                    })->orWhereHas('cust', function ($query) use ($searchTerm) {
                        $query->where('username', 'LIKE', $searchTerm . '%');
                    });
                });
            }
            $ticketsitems = $tickets->paginate($perPage);
            $data['tickets'] = $ticketsitems;

            $active = Ticket::with('cust', 'ticketdraft', 'ticketnote', 'ticketassignmutliples', 'selfassign', 'category')->where('cust_id', Auth::guard('customer')->user()->id)
                ->whereIn('status', ['New', 'Re-Open', 'Inprogress']);

            if ($searchTerm) {
                $active->where(function ($query) use ($searchTerm) {
                    $columns = Schema::getColumnListing('tickets');
                    foreach ($columns as $column) {
                        $query->orWhere($column, 'LIKE', "%{$searchTerm}%");
                    }
                    $query->orWhereHas('category', function ($query) use ($searchTerm) {
                        $query->where('name', 'LIKE', $searchTerm . '%');
                    })->orWhereHas('cust', function ($query) use ($searchTerm) {
                        $query->where('username', 'LIKE', $searchTerm . '%');
                    })
                        ->orWhereHas('selfassign', function ($query) use ($searchTerm) {
                            $query->where(function ($query) use ($searchTerm) {
                                $query->where('name', 'LIKE', "%{$searchTerm}%");
                                // Check for 'self' in the search term
                                if (stripos('self', strtolower($searchTerm)) !== false) {
                                    // Also check if the selfassignuser_id is not null
                                    $query->orWhere('selfassignuser_id', '!=', null);
                                }
                            });
                        })
                        ->orWhereHas('ticketassignmutliples', function ($query) use ($searchTerm) {
                            // Assuming you defined the 'assignedUser()' relationship in ticketassignchild model
                            $query->whereHas('toassignuser', function ($query) use ($searchTerm) {
                                $query->where('name', 'LIKE', "%{$searchTerm}%");
                            });
                            if (stripos('multi Assign', strtolower($searchTerm)) !== false) {
                                $query->orWhere('ticket_id', '!=', null);
                            }
                        });
                });
            }
            $activeitems = $active->paginate($perPage);
            $data['active'] = $activeitems;


            $closed = Ticket::with('cust', 'ticketdraft', 'ticketnote', 'ticketassignmutliples', 'selfassign', 'category')->where('cust_id', Auth::guard('customer')->user()->id)
                ->where('status', 'Closed');

            if ($searchTerm) {
                $closed->where(function ($query) use ($searchTerm) {
                    $columns = Schema::getColumnListing('tickets');
                    foreach ($columns as $column) {
                        $query->orWhere($column, 'LIKE', "%{$searchTerm}%");
                    }
                    $query->orWhereHas('category', function ($query) use ($searchTerm) {
                        $query->where('name', 'LIKE', $searchTerm . '%');
                    })->orWhereHas('cust', function ($query) use ($searchTerm) {
                        $query->where('username', 'LIKE', $searchTerm . '%');
                    });
                });
            }
            $closeditems = $closed->paginate($perPage);
            $data['closed'] = $closeditems;

            $onhold = Ticket::with('cust', 'ticketdraft', 'ticketnote', 'ticketassignmutliples', 'selfassign', 'category')->where('cust_id', Auth::guard('customer')->user()->id)
                ->where('status', 'On-Hold');

            if ($searchTerm) {
                $onhold->where(function ($query) use ($searchTerm) {
                    $columns = Schema::getColumnListing('tickets');
                    foreach ($columns as $column) {
                        $query->orWhere($column, 'LIKE', "%{$searchTerm}%");
                    }
                    $query->orWhereHas('category', function ($query) use ($searchTerm) {
                        $query->where('name', 'LIKE', $searchTerm . '%');
                    })->orWhereHas('cust', function ($query) use ($searchTerm) {
                        $query->where('username', 'LIKE', $searchTerm . '%');
                    });
                });
            }
            $onholditems = $onhold->paginate($perPage);
            $data['onhold'] = $onholditems;

            $setting  = response()->json(
                ['CUSTOMER_TICKET' => setting('CUSTOMER_TICKET'), 'CUSTOMER_RESTICT_TO_DELETE_TICKET' => setting('CUSTOMER_RESTICT_TO_DELETE_TICKET'), 'date_format' => setting('date_format'), 'time_format' => setting('time_format'), 'enableRefund' => setting('enableRefund')]
            );
            $data['setting'] = $setting;

            $now = now();
            $announcement = announcement::whereDate('enddate', '>=', $now->toDateString())->whereDate('startdate', '<=', $now->toDateString())->get();
            $data['announcement'] = $announcement;

            $announcements = Announcement::whereNotNull('announcementday')->get();
            $data['announcements'] = $announcements;

            $holidays = Holiday::whereDate('startdate', '<=', $now->toDateString())->whereDate('enddate', '>=', $now->toDateString())->where('status', '1')->get();
            $data['holidays'] =  $holidays;


            $user = auth()->guard('customer')->user();
            $data['timezonedata'] = $user->timezone ?? setting('default_timezone');

            // $holidays = Holiday::whereDate('startdate', '<=', $now->toDateString())->whereDate('enddate', '>=', $now->toDateString())->where('status', '1')->get();
            // $data['holidays'] =  $holidays;

            $now = now();
            $currentYear = $now->year;
            $activeHolidays = Holiday::where('status', 1)->get();


            $data['holidays'] = $activeHolidays->filter(function ($holiday) use ($now, $currentYear) {
                $holidayStart = Carbon::parse($holiday->startdate);
                $holidayEnd = Carbon::parse($holiday->enddate);
                if ($holiday->is_fixed) {
                    return $holidayStart->month === $now->month && $holidayStart->day === $now->day;
                }
                return $holidayStart->isSameDay($now);
            });


            // $hasquotations = AllTransactions::where('cust_id', Auth::guard('customer')->user()->id)->exists();
            // $data['hasquotations'] = $hasquotations;

            $quotations = AllTransactions::where('cust_id', Auth::guard('customer')->user()->id)->whereIn('status', ['pending', 'cancelled'])->latest('created_at')->get();
            $data['quotations'] = $quotations;

            $unviewedQuotations = $quotations->where('cust_viewed', '!=', 1)->where('status', 'pending');
            $data['unviewedQuotations'] = $unviewedQuotations;

            $invoices = AllTransactions::where('cust_id', Auth::guard('customer')->user()->id)->where('status', 'paid')->get();
            $data['invoices'] = $invoices;

            $refunds = AllTransactions::where('cust_id', Auth::guard('customer')->user()->id)->where('status', ['refunded', 'refundpending', 'refundRejected'])->get();
            $data['refunds'] = $refunds;

            $addspace = AddSpace::where('status', 1)->get();
            $data['addspace'] = $addspace;

            return $data;
        }
    }

    public function businesshours()
    {


        if ((Auth::guard('customer')->user())) {
            $setting  = response()->json(
                [
                    'supporticonimage' => setting('supporticonimage'),
                    'businesshoursswitch' => setting('businesshoursswitch'),
                    'date_format' => setting('date_format'),
                    'businesshourssubtitle' => setting('businesshourssubtitle'),
                    'businesshourstitle' => setting('businesshourstitle'),
                    'default_timezone' => setting('default_timezone'),
                    'customer_panel_employee_protect' => setting('customer_panel_employee_protect'),
                    'employeeprotectname' => setting('employeeprotectname'),
                    'USER_REOPEN_TIME' => setting('USER_REOPEN_TIME'),
                    'USER_REOPEN_ISSUE' => setting('USER_REOPEN_ISSUE'),
                    'FILE_UPLOAD_MAX' => setting('FILE_UPLOAD_MAX'),
                    'GUEST_FILE_UPLOAD_ENABLE' => setting('GUEST_FILE_UPLOAD_ENABLE'),
                    'CUSTOMER_TICKET' => setting('CUSTOMER_TICKET')
                ]
            );
            $data['setting'] = $setting;

            if (setting('supporticonimage')) {
                $data['supporticonimageprev'] = asset('/uploads/support/' . setting('supporticonimage'));
            } else {
                $data['supporticonimageprev'] = asset('/uploads/support/support/support.png');
            }
            $now = now();
            $holidays = Holiday::whereDate('startdate', '<=', $now->toDateString())->where('status', '1')->get();
            if ($holidays->isNotEmpty()) {
                $data['isOnline'] = false;
            } else {
                $businesshours = Businesshours::get();
                $data['businesshours'] = $businesshours;
                foreach ($businesshours as $business) {
                    if (now()->timezone(setting('default_timezone'))->format('D') == $business->weeks) {
                        if (strtotime($business->starttime) <= strtotime(now()->timezone(setting('default_timezone'))->format('h:i A')) && strtotime($business->endtime) >= strtotime(now()->timezone(setting('default_timezone'))->format('h:i A')) || $business->starttime == "24H") {
                            $data['isOnline'] = true;
                        } else {

                            $data['isOnline'] = false;
                        }
                    }
                }
            }
            $data['nouser'] =  asset('uploads/profile/user-profile.png');
            return $data;
        }
    }

    public function notify(Request $request)
    {
        if ((Auth::guard('customer')->user())) {

            $customer = Customer::findOrFail(Auth::guard('customer')->user()->id);
            $data['authId'] = $customer->id;

            $notifications = auth()->guard('customer')->user()->notifications();

            $status = json_decode($request->status);
            if (count($status)) {
                $notifications->whereIn('data->status', $status);
            }
            $searchterm = $request->notifysearch;
            if ($searchterm != "null") {
                $notifications->where(function ($query) use ($searchterm) {
                    $query->where('data->title', 'LIKE', "%{$searchterm}%")
                        ->orWhere('data->ticket_id', 'LIKE', "%{$searchterm}%")
                        ->orWhere('data->mailsubject', 'LIKE', "%{$searchterm}%")
                        ->orWhere('data->mailtext', 'LIKE', "%{$searchterm}%");
                });
            }
            $item = $notifications->select('*', \DB::raw('DATE(created_at) as created_date'))
                ->orderBy('created_at', 'desc')
                ->paginate(6);
            $item->getCollection()->transform(function ($groups) {
                if (isset($groups->data['ticket_id'])) {
                    $groups->enc_ticket_id = encrypt($groups->data['ticket_id']);
                }
                return $groups;
            });
            $data['notifications'] = $item;

            $setting = response()->json(['date_format' => setting('date_format'), 'time_format' => setting('time_format')]);
            $data['setting'] = $setting;

            $addspace = AddSpace::where('status', 1)->get();
            $data['addspace'] = $addspace;

            $quotations = AllTransactions::where('cust_id', Auth::guard('customer')->user()->id)->whereIn('status', ['pending', 'cancelled'])->latest('created_at')->get();
            $data['quotations'] = $quotations;

            $unviewedQuotations = $quotations->where('cust_viewed', '!=', 1)->where('status', 'pending');
            $data['unviewedQuotations'] = $unviewedQuotations;
            return $data;
        }
    }

    public function markNotification(Request $request)
    {

        auth()->guard('customer')->user()
            ->unreadNotifications
            ->when($request->input('id'), function ($query) use ($request) {
                return $query->where('id', $request->input('id'));
            })
            ->markAsRead();

        return response()->noContent();
    }

    public function Notificationview($id)
    {

        if ((Auth::guard('customer')->user())) {
            $notification = auth()->guard('customer')->user()->notifications()->where('id', $id)->firstOrFail();

            $data['notifications'] = $notification;

            $setting = response()->json(['date_format' => setting('date_format'), 'time_format' => setting('time_format')]);
            $data['setting'] = $setting;

            $user = auth()->guard('customer')->user();
            $data['timezonedata'] = $user->timezone ?? setting('default_timezone');
            return $data;
        }
    }

    public function notifystatus(Request $request)
    {

        if ((Auth::guard('customer')->user())) {
            $status = $request->statusnotify;
            if (is_array($status) && in_array('refund', $status)) {
                // Merge additional statuses
                $status = array_merge($status, ['refundpending', 'refundRejected', 'refunded']);
            }
            if (!$status) {
                $notifications = auth()->guard('customer')->user()->notifications()->paginate()->groupBy(function ($date) {
                    return \Carbon\Carbon::parse($date->created_at)->format('Y-m-d');
                });
                $data['notifications'] = $notifications;
            } else {
                $notifications =  auth()->guard('customer')->user()->notifications()->whereIn('data->status', $status)->paginate()->groupBy(function ($date) {
                    return \Carbon\Carbon::parse($date->created_at)->format('Y-m-d');
                });
                $data['notifications'] = $notifications;
            }
            return $data;
        }
    }

    public function notifysearch(Request $request)
    {

        if ((Auth::guard('customer')->user())) {
            $status = $request->notifysearch;

            if ($status) {
                $notifications = auth()->guard('customer')->user()->notifications()->where(function ($query) {
                    $keyword = request()->notifysearch;
                    $query->where('data->title', 'LIKE', "%{$keyword}%")
                        ->orwhere('data->status', 'LIKE', "%{$keyword}%")
                        ->orWhere('data->ticket_id', 'LIKE', "%{$keyword}%")
                        ->orWhere('data->mailsubject', 'LIKE', "%{$keyword}%")
                        ->orWhere('data->mailtext', 'LIKE', "%{$keyword}%");
                })->get()->groupBy(function ($date) {
                    return \Carbon\Carbon::parse($date->created_at)->format('Y-m-d');
                });
                $data['notifications'] = $notifications;
            } else {
                $notifications =  auth()->guard('customer')->user()->notifications()->paginate()->groupBy(function ($date) {
                    return \Carbon\Carbon::parse($date->created_at)->format('Y-m-d');
                });
                $data['notifications'] = $notifications;
            }
            return $data;
        }
    }

    public function notifydelete(Request $request)
    {
        $id = $request->id;

        $notificationsdelete = auth()->guard('customer')->user()->notifications()->find($id);
        $notificationsdelete->delete();

        return response()->json(['success' => 'Deleted Successfully', 200]);
    }
}
