<?php

namespace App\Http\Middleware;

use App\Models\Setting;
use Closure;
use Illuminate\Http\Request;
use DB;
use Illuminate\Support\Str; // Add this line

class MaintananceModeMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $excludedRoutes = [
            'admin/*',
            'detail/admin/*',
            'detail/basic',
            'detail/encoder/*',
            'detail/image/*',
            'detail/emailtoticket/*',
            'imageview/*',
            'detail/imagedownload/*',
            'detail/emailtoticket/*',
            'detail/emailtoticketdownload/*',
            'detail/getimage/*',
            'detail/csrftoken',
            'detail/assets/i18n/*',
            'detail/error404',
            'detail/error503',
            'detail/error429',
            'detail/getProfile',
            'detail/notificationsreading',
            'detail/notificationalerts',
            'detail/timeupdate',
            'detail/captcha',
        ];

        try {
            DB::connection()->getPdo();
            if (!DB::getSchemaBuilder()->hasTable('settings')) {

                return $next($request);
            } else {
                if (
                    settingpages('MAINTENANCE_MODE') == 'on' && !$this->isExcludedRoute($request, $excludedRoutes)
                ) {
                    // return response()->view('errors.503', [], 503);
                    $redirectionUrl = settingpages('redirectionURL');
                    if ($redirectionUrl) {
                        return redirect($redirectionUrl);
                    } else {
                        return response()->view('errors.503', [], 503);
                    }
                }
                return $next($request);
            }
        } catch (\Exception $e) {
            return $next($request);
            die("Could not connect to the database.  Please check your configuration. error:" . $e);
        }
    }

    private function isExcludedRoute(Request $request, array $excludedRoutes): bool
    {
        foreach ($excludedRoutes as $route) {
            if (Str::is($route, $request->path())) {
                return true;
            }
        }

        return false;
    }
}
