<?php

namespace App\Imports;

use App\Models\Projects;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\SkipsOnError;
use Maatwebsite\Excel\Concerns\SkipsErrors;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Concerns\SkipsOnFailure;
use Maatwebsite\Excel\Concerns\SkipsFailures;
use Maatwebsite\Excel\Validators\Failure;
use Throwable;

class ProjectImport implements ToModel, WithHeadingRow, SkipsOnError, WithValidation
{

    use Importable, SkipsErrors;
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public $hasData = false;
    public function model(array $row)
    {
        if (!empty($row['projecttitle'])) {
            $this->hasData = true;            
        }
        
        $project =  new Projects([
            
            'name' => $row['projecttitle'],
        ]);
        
        return $project;
    }


    public function onError(Throwable $error)
    {
        // this is mandatory function
    }

  

    public function rules(): array
    {
        return  [
            '*.projecttitle' => ['required','string', 'unique:projects,name'],
        ];

       
    }

  

}
