<?php

namespace App\Imports;

use App\Models\User;
use Spatie\Permission\Models\Role;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Concerns\SkipsOnFailure;
use Maatwebsite\Excel\Concerns\SkipsFailures;
use Maatwebsite\Excel\Validators\Failure;
use Hash;
use Throwable;
use Exception;

class UserImport implements ToModel, WithHeadingRow, WithValidation
{
    use Importable;


    protected $nonExistentRoles = [];
    protected $importedEmpIds = [];

    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public $hasData = false;
    public function model(array $row)
    {
        if (!empty($row['email'])) {
            $this->hasData = true; 
        }
        
        $role = Role::where('name', $row['role'])->first();
        if($role){
            $user = User::where('empid', $row['empid'])->first();

            if ($user) {
                $user->update([
                    'firstname'     => $row['firstname'],
                    'lastname'     => $row['lastname'],
                    'name'     => $row['firstname'].' '.$row['lastname'],
                    'email'    => $row['email'],
                    'password' => Hash::make($row['password']),
                    'dashboard' => ($row['role'] == 'superadmin') ? 'Admin' : 'Employee',
                ]);
            } else {
                $user = new User([
                    'firstname'     => $row['firstname'],
                    'lastname'     => $row['lastname'],
                    'name'     => $row['firstname'].' '.$row['lastname'],
                    'email'    => $row['email'],
                    'empid'    => $row['empid'],
                    'password' => Hash::make($row['password']),
                    'status' => '1',
                    'dashboard' => ($row['role'] == 'superadmin') ? 'Admin' : 'Employee',
                    'verified' => '1',
                    'darkmode' => setting('DARK_MODE')
                ]);
            }

            $user->assignRole($role);
            $this->importedEmpIds[] = $user->empid;

            return $user;
        }else{
            $this->nonExistentRoles[] = $row['role'];
        }
    }

    public function rules(): array
    {
        return  [
            '*.firstname' => ['required','alpha_num'],
            '*.lastname' => ['required','alpha_num'],
            '*.email' => ['required','string', 'email', 'unique:users,email'],
            '*.password' => ['required'],
            '*.empid' => ['required'],
            '*.role' => ['required'],
        ];
    }

    public function getImportedUserEmpIds()
    {
        return $this->importedEmpIds;
    }

    public function __destruct()
    {
        if (!empty($this->nonExistentRoles)) {
            throw new Exception(implode(', ', $this->nonExistentRoles) . ' roles are not existing in your application, please provide existing roles or create new role for this.');
        }
    }
}
