<?php

namespace App\Jobs;

use App\Mail\mailmailablesend;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Mail;

class BulkMails implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $emails;

    public $mailsend;
    //https://chatgpt.com/c/824b290b-9017-47ae-a95c-3dd6fa401110

    /**
     * Create a new job instance.
     */
    public function __construct($emails, $mailsend)
    {
        $this->emails = $emails;
        $this->mailsend = $mailsend;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $ticketData = [
            'notification_subject' => $this->mailsend->mailsubject,
            'notification_message' => $this->mailsend->mailtext,
            'notification_tag' => $this->mailsend->tag,
        ];

        foreach ($this->emails as $email) {
            Mail::to($email)->send(new mailmailablesend('when_send_customnotify_email_to_selected_member', $ticketData));
        }
    }
}
