<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Apptitle extends Model
{
    use HasFactory;

    protected $fillable = [
        'searchtitle',
        'searchsub',
        'featuretitle',
        'featuresub',
        'testimonialtitle',
        'testimonialsub',
        'faqtitle',
        'faqsub',
        'articletitle',
        'articlesub',
        'image',
        'image1',
        'image2',
        'image3',
        'image4',
        'title',
        'checkbox',
        'featurecheck',
        'testimonialcheck',
        'faqcheck',
        'articlecheck'
    ];



    protected static function booted()
    {
        // Use retrieved event to automatically set the "image" attribute when loading an existing model

        static::updating(function ($model) {
            if ($model['logoimage']) {
                unset($model['logoimage']);
            }
            if ($model['logoimage1']) {
                unset($model['logoimage1']);
            }
            if ($model['logoimage2']) {
                unset($model['logoimage2']);
            }
            if ($model['logoimage3']) {
                unset($model['logoimage3']);
            }
            if ($model['logoimage4']) {
                unset($model['logoimage4']);
            }
            return;
        });
        static::retrieved(function ($model) {
            $model->setImageValAttribute();
        });
    }

    // Define a method to set the "image" attribute
    protected function setImageValAttribute()
    {
        if ($this->image) {
            $this['logoimage'] = asset('/uploads/logo/logo/' . $this->image);
        } else {
            $this['logoimage'] = asset('/uploads/logo/logo/logo-white.png');
        }
        if ($this->image1) {
            $this['logoimage1'] = asset('/uploads/logo/darklogo/' . $this->image1);
        } else {
            $this['logoimage1'] = asset('/uploads/logo/darklogo/logo.png');
        }
        if ($this->image2) {
            $this['logoimage2'] = asset('/uploads/logo/icon/' . $this->image2);
        } else {
            $this['logoimage2'] = asset('/uploads/logo/icon/icon.png');
        }
        if ($this->image3) {
            $this['logoimage3'] = asset('/uploads/logo/darkicon/' . $this->image3);
        } else {
            $this['logoimage3'] = asset('/uploads/logo/darkicon/icon-white.png');
        }
        if ($this->image4) {
            $this['logoimage4'] = asset('/uploads/logo/favicons/' . $this->image4);
        } else {
            $this['logoimage4'] = asset('/uploads/logo/favicons/favicon.ico');
        }
    }
}
