<?php

namespace App\Models\Ticket;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\Ticket\Comment;
use App\Models\Ticket\Category;
use App\Models\Customer;
use App\Models\User;
use App\Models\Role;
use App\Models\CategoryUser;
use App\Models\Ticketnote;
use App\Models\Subcategorychild;
use App\Models\Subcategory;
use App\Models\TicketCustomfield;
use App\Models\ticketassignchild;
use App\Models\TicketDraft;
use App\Models\tickethistory;
use App\Models\Ticketviolation;
use App\Models\Userrating;
use Auth;
use Illuminate\Support\Str;
use Spatie\MediaLibrary\MediaCollections\Models\Media;
use App\Models\AllTransactions;
use Carbon\Carbon;

class Ticket extends Model implements HasMedia
{
    use HasFactory, SoftDeletes;
    use InteractsWithMedia;

    protected $table = "tickets";
    protected $fillable = [
        'cust_id',
        'category_id',
        'image',
        'ticket_id',
        'title',
        'priority',
        'message',
        'tickettype',
        'imap_id',
        'ticketreopen',
        'storage_disk',
        'MessageID',
        'status',
        'subject',
        'user_id',
        'project_id',
        'auto_close_ticket',
        'autoresponse',
        'project',
        'purchasecode',
        'item_name',
        'purchasecodesupport',
        'subcategory',
        'ticketviolation',
        'ticketviolationnote',
        'selfassignuser_id',
        'myassignuser_id',
        'fileupload_allowed'
    ];

    protected $dates = [
        'closing_ticket',
        'last_reply',
        'craeted_at',
        'updated_at',
        'auto_replystatus',
        'auto_close_ticket',
        'auto_overdue_ticket'
    ];

    public function cust()
    {
        return $this->belongsTo(Customer::class, 'cust_id');
    }

    public function users()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    public function toassignuser()
    {
        return $this->belongsTo(User::class, 'toassignuser_id');
    }
    public function myassignuser()
    {
        return $this->belongsTo(User::class, 'myassignuser_id');
    }
    public function comments()
    {
        return $this->hasMany(Comment::class)->latest('created_at');
    }
    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }

    public function role()
    {
        return $this->hasMany(Role::class);
    }

    public function product()
    {
        return $this->hasMany(CategoryUser::class, 'category_id');
    }

    public function ticketnote()
    {
        return $this->hasmany(Ticketnote::class, 'ticket_id');
    }
    public function ticketdraft()
    {
        return $this->hasmany(TicketDraft::class, 'ticket_id');
    }
    public function ticketviolation()
    {
        return $this->hasmany(Ticketviolation::class, 'ticket_id')->with('users');
    }

    public function registerMediaCollections(): void
    {
        $this->addMediaCollection('ticket');
        //add option
    }
    public function subcategories()
    {
        return $this->belongsTo(Subcategorychild::class, 'subcategory', 'subcategory_id');
    }

    public function subcategoriess()
    {
        return $this->belongsTo(Subcategory::class, 'subcategory', 'id');
    }

    public function selfassign()
    {
        return $this->belongsTo(User::class, 'selfassignuser_id');
    }

    public function closedusers()
    {
        return $this->belongsTo(User::class, 'closedby_user');
    }

    public function ticket_customfield()
    {
        return $this->hasMany(TicketCustomfield::class, 'ticket_id');
    }

    public function ticketassignmutliple()
    {
        return $this->belongsToMany(ticketassignchild::class, 'ticketassignchildren', 'ticket_id', 'toassignuser_id');
    }

    public function ticketassignmutliples()
    {
        return $this->hasMany(ticketassignchild::class)
            ->with('toassignuser');
    }

    public function ticket_history()
    {
        return $this->hasMany(tickethistory::class, 'ticket_id');
    }
    public function userratings()
    {
        return $this->hasMany(Userrating::class, 'ticket_id');
    }

    protected static function booted()
    {
        // Use retrieved event to automatically set the "image" attribute when loading an existing model
        static::updating(function ($model) {
            if ($model['purchasecodeVal']) {
                unset($model['purchasecodeVal']);
            }
            if ($model['enc_id']) {
                unset($model['enc_id']);
            }
            if ($model['enc_ticket_id']) {
                unset($model['enc_ticket_id']);
            }
            if ($model['enc_last_reply']) {
                unset($model['enc_last_reply']);
            }
            return;
        });
        static::retrieved(function ($model) {
            $model->modifyPurchaseCode();
        });
    }

    // Define a method to set the "image" attribute
    protected function modifyPurchaseCode()
    {
        if ($this->last_reply) {
            $this['enc_last_reply'] = Carbon::parse($this->last_reply);
        }
        if ($this->ticket_id) {
            $this['enc_ticket_id'] = encrypt($this->ticket_id);
        }
        if ($this->id) {
            $this['enc_id'] = encrypt($this->id);
        }
        if ($this->purchasecode) {

            $val = decrypt($this->purchasecode);
            if (Auth::check()) {
                // User is authenticated
                if (Auth::user()->getRoleNames()[0] == 'superadmin') {
                    $this['purchasecodeVal'] = $val;
                } else if (setting('purchasecode_on') == 'on') {
                    $this['purchasecodeVal'] = $val;
                } else {
                    $this['purchasecodeVal'] = Str::limit($val, 5, '*******************************');
                }
            } else {
                $this['purchasecodeVal'] = Str::limit($val, 5, '*******************************');
            }
        }
    }
    public function invoice()
    {
        return $this->hasOne(AllTransactions::class, 'ticket_id');
    }
}
