<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnToYourTableName extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('footertexts', function (Blueprint $table) {
            $table->longText('copyright')->nullable()->after('id')->change();
        });
        
        Schema::table('tickethistories', function (Blueprint $table) {
            $table->boolean('ticketnote')->nullable()->after('ticketactions');
            $table->string('overduestatus')->nullable()->after('ticketactions');
            $table->string('replystatus')->nullable()->after('ticketactions');
            $table->string('ticketviolation')->nullable()->after('ticketactions');
            $table->string('oldcomment')->nullable()->after('ticketactions');
            $table->string('commentmodify')->nullable()->after('ticketactions');
            $table->string('currentAction')->nullable()->after('ticketactions');
            $table->string('replytype')->nullable()->after('ticketactions');
            $table->longText('assignUser')->nullable()->after('ticketactions');
            $table->string('status')->nullable()->after('ticketactions');
            $table->string('username')->nullable()->after('ticketactions');
            $table->string('type')->nullable()->after('ticketactions');
        });
    }

    

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('tickethistories', function (Blueprint $table) {
            //
        });
    }
}
