<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {

        Schema::table('senduserlists', function (Blueprint $table) {
            // Drop existing foreign keys
            $table->dropForeign(['mail_id']);
            $table->dropForeign(['touser_id']);
            $table->dropForeign(['tocust_id']);

            // Add new foreign keys
            $table->foreign('mail_id')->references('id')->on('sendmails')->onUpdate('cascade')->onDelete('cascade');
            $table->foreign('touser_id')->references('id')->on('users')->onUpdate('cascade')->onDelete('cascade');
            $table->foreign('tocust_id')->references('id')->on('customers')->onUpdate('cascade')->onDelete('cascade');
        });


        Schema::table('tickets', function (Blueprint $table) {
            $table->string('importantticket')->nullable()->after('storage_disk');
        });

        Schema::table('customers', function (Blueprint $table) {
            $table->integer('phoneVerified')->after('phone')->default(0);
            $table->integer('phonesmsenable')->after('phoneVerified')->default(0);
        });

        Schema::table('cannedmessages', function (Blueprint $table) {
            $table->string('responsetype')->nullable()->after('messages');
        });

        Schema::table('announcements', function (Blueprint $table) {
            $table->string('buttonlable')->nullable()->after('status');
            $table->string('buttonurl')->nullable()->after('buttonlable');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
    }
};
