<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('all_transactions', function (Blueprint $table) {
            $table->id();
            $table->integer('invoiceId');
            $table->unsignedBigInteger('cust_id');
            $table->bigInteger('amount');
            $table->string('currency');
            $table->string('customerAmount');
            $table->boolean('cust_viewed')->nullable();
            $table->string('transaction_id');
            $table->text('refundReason')->nullable();
            $table->timestamp('refundCreatedDate')->nullable();
            $table->string('discount')->nullable();
            $table->string('payment_method');
            $table->timestamp('payment_date')->nullable();
            $table->string('dateIssued')->nullable();
            $table->string('last4Digits')->nullable();
            $table->string('cardType')->nullable();
            $table->string('cardBrand')->nullable();
            $table->string('ticket_type');
            $table->string('package_name')->nullable();
            $table->integer('package_id')->nullable();
            $table->integer('category_id')->nullable();
            $table->string('ticket_id')->nullable();
            $table->string('status');
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->string('country')->nullable();
            $table->string('postal_code')->nullable();
            $table->string('refundTxId')->nullable();
            $table->string('gatewayName')->nullable();
            $table->decimal('gatewayFee', 8, 2)->nullable();
            $table->string('countryTaxName')->nullable();
            $table->decimal('countryTaxAmount', 8, 2)->nullable();
            $table->decimal('netAmountRefunded', 8, 2)->nullable();
            $table->timestamps();
            $table->foreign('cust_id')->references('id')->on('customers')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
