<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('all_invoices', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('parentId');
            $table->string('companyName');
            $table->string('companyLogo')->nullable();
            $table->string('customInvoiceId');
            $table->string('addressLine1')->nullable();
            $table->string('addressLine2')->nullable();
            $table->string('cityName')->nullable();
            $table->string('stateName')->nullable();
            $table->string('zipPostalCode')->nullable();
            $table->string('countryName')->nullable();
            $table->string('taxName')->nullable();
            $table->string('taxPercent')->nullable();
            $table->string('taxId')->nullable();
            $table->string('customerName')->nullable();
            $table->string('ticket_id')->nullable();
            $table->string('clcompanyName')->nullable();
            $table->string('status')->nullable();
            $table->string('paidDate')->nullable();
            $table->string('clemail')->nullable();
            $table->string('clmobile')->nullable();
            $table->string('cltaxName')->nullable();
            $table->string('cltaxId')->nullable();
            $table->string('claddress')->nullable();
            $table->string('clcountry')->nullable();
            $table->text('invoicenote')->nullable();
            $table->text('invoicetc')->nullable();
            $table->string('subtotal');
            $table->string('totalFinalPrice');
            $table->foreign('parentId')->references('id')->on('all_transactions')->onUpdate('cascade')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('all_invoices');
    }
};
