<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>

	<!-- Meta data -->
	<meta charset="UTF-8">
	<meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
	<!-- Title -->
	<title>Under Maintenance</title>

	@php
	use App\Models\Apptitle;

	$title = Apptitle::first();
	@endphp

	@if ($title && $title->image4 != null)

	<!--Favicon -->
	<link rel="icon" href="{{asset('uploads/logo/favicons/'.$title->image4)}}" type="image/x-icon" />
	@else

	<!--Favicon -->
	<link rel="icon" href="{{asset('uploads/logo/favicons/favicon.ico')}}" type="image/x-icon" />
	@endif

	@if(str_replace('_', '-', app()->getLocale()) == 'عربى')

	<!-- Bootstrap css -->
	<link href="{{asset('client/assets/plugins/bootstrap/css/bootstrap.rtl.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />
	@else

	<!-- Bootstrap css -->
	<link href="{{asset('client/assets/plugins/bootstrap/css/bootstrap.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />
	@endif

	<!-- Style css -->
	<link href="{{asset('client/assets/css/style.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />
	<link href="{{asset('client/assets/updatestyle/updatestyles.css')}}?v=<?php echo time(); ?>" rel="stylesheet" />

	@if(setting('GOOGLEFONT_DISABLE') == 'off')
	<style>
		@import url('https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap');
	</style>
	@endif

</head>

<body class="@if(str_replace('_', '-', app()->getLocale()) == 'عربى')
		rtl
	@endif
@if(setting('DARK_MODE') == 1) dark-mode @endif">

	<!--Row-->
	<div class="page error-bg">
		<div class="page-content m-0">
			<div class="container text-center">
				<div class="display-2 mb-5 font-weight-semibold">{{settingpages('503title')}}</div>
				<h1 class="h3  mb-3">{{settingpages('503subtitle')}}</h1>
				<p class="h5 font-weight-normal mb-4 leading-normal">{{settingpages('503description')}}</p>
				<div class="row">
					<div class="col-md-6 d-block mx-auto mb-2">
						<div class="row">
							<div class="col text-start">
								<span class="badge badge-danger-light badge-pill">{{lang('Working', 'errorpages')}}</span>
							</div>
						</div>
						<div class="col col-auto">
							<div class="fs-18 font-weight-semibold">{{lang('60%', 'errorpages')}}</div>
						</div>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="progress-wrapper mb-5 col-md-6 d-block mx-auto">
					<div class="progress progress-md">
						<div class="progress-bar-striped progress-bar-animated bg-success" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100" style="width: 60%;"></div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!--Row-->


	<!-- Bootstrap4 js-->
	<script src="{{asset('client/assets/plugins/bootstrap/popper.min.js')}}?v=<?php echo time(); ?>"></script>
	<script src="{{asset('client/assets/plugins/bootstrap/js/bootstrap.min.js')}}?v=<?php echo time(); ?>"></script>

</body>

</html>