<?php


use App\Http\Controllers\Admin\AddSpaceController;
use App\Http\Controllers\Admin\AdminPaymentsController;
use App\Http\Controllers\Admin\AdminReportController;
use App\Http\Controllers\Admin\AdminSettingController;
use App\Http\Controllers\Admin\ApptitleController;
use App\Http\Controllers\Admin\Auth\LoginController;
use App\Http\Controllers\Admin\checkUser;
use App\Http\Controllers\Admin\EnvatoAppinfoController;
use App\Http\Controllers\Admin\GeneralPageController;
use App\Http\Controllers\Admin\LanguagesController;
use App\Http\Controllers\Admin\TextGeneratorController;
use App\Http\Controllers\Contactform\ContactController;
use App\Http\Controllers\CurrencyController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ArticleCommentController;
use App\Http\Controllers\CategorypageController;
use App\Http\Controllers\GuestticketController;
use App\Http\Controllers\TranslateController;
use App\Http\Controllers\User\DashboardController;
use App\Http\Controllers\User\PaymentController;
use Illuminate\Support\Facades\Route;
use Spatie\Honeypot\ProtectAgainstSpam;
use App\Http\Controllers\User\Ticket\CommentsController;
use App\Http\Controllers\Admin\HolidayController;
use App\Http\Controllers\Admin\LiveChatController;
use App\Http\Controllers\ImageController;
use Illuminate\Support\Facades\Auth;
use laravelLara\infoinst\Http\Controllers\UserRegistrationController;
use Illuminate\Support\Facades\Artisan;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::middleware(ProtectAgainstSpam::class)->group(function () {
	Route::middleware(['checkinstallation'])->group(function () {

		Route::group(['prefix'	 => 'detail'], function () {
			Route::middleware(['throttle:refresh',  'ipblockunblock', 'datarecovery', 'admincountryblock'])->group(function () {

				Route::group(['namespace' => 'Admin', 'prefix' => 'admin'], function () {
					Route::group(['namespace'	 => 'Auth'], function () {
						Route::get('/login', 'LoginController@showloginform');
						Route::post('/login', 'LoginController@login');
						Route::post('/logout', 'LoginController@logout');

						Route::get('/forgot', 'ForgotPasswordController@showLinkRequestForm');
						Route::post('/forgot', 'ForgotPasswordController@sendResetLinkEmail');
						Route::get('/{token}/reset-password', 'ResetPasswordController@showResetForm');
						Route::post('/reset-password', 'ResetPasswordController@reset');
					});

					Route::post('/adminemailchange', 'AdminprofileController@adminemailchange')->name('adminemailchange');
					Route::post('/userpasswordverify', 'AdminprofileController@userpasswordverify')->name('userpasswordverify');
					Route::post('/adminnewemailstore', 'AdminprofileController@adminnewemailstore')->name('admin.newemailstore');
					Route::post('/adminemailupdateotpverify/{oldemail}', 'AdminprofileController@adminemailupdateotpverify')->name('adminemail.updateotpverify');
					Route::get('/adminemailupdate/{email}', 'AdminprofileController@adminemailupdate')->name('adminemailupdate');

					Route::get('adminemailtwofactresendotp/{email}', 'AdminprofileController@resendotp')->name('admin.resendotp');
					Route::get('adminemailtwofact/{email}', 'AdminprofileController@emailtwofactorlogin')->name('admin.emailtwofactorlogin');
					Route::post('admingoogle2faotpverify', 'AdminprofileController@admingoogle2faotpverify')->name('admingoogle2falogin.otpverify');
					Route::get('adminindexlogin/{email}', 'AdminprofileController@google2faadminlogin')->name('admin.google2falogin');
					Route::post('emptwofactqr', 'AdminprofileController@emptwofactqr')->name('emptwofactqr');
					Route::post('empgoogle2faotp', 'AdminprofileController@empgoogle2faotp')->name('empgoogle2faotp.verify');
					Route::post('empemail2faotp', 'AdminprofileController@empemail2fa')->name('user.emailtwofactor');
					Route::post('enabletwofactor', 'AdminprofileController@enabletwofactor')->name('admin.enabletwofactor');

					Route::middleware('admin.auth')->group(function () {

						//clear cache
						Route::post('clearcache', 'AdminDashboardController@clearcache');

						// To get the user list for other assign
						Route::get('/assigned/{id}', 'AdminAssignedticketsController@show');


						// To get the Tickets Count
						Route::get('/dashboardcount', 'AdminDashboardController@index');
						Route::get('/dashboardtabledata', 'AdminDashboardController@dashboardtabledata');

						Route::get('/adminLayout', 'AdminprofileController@adminLayout');

						//
						Route::get('faqcategory/list', 'FaqCategoryController@faqcategorylist')->name('faqsub.faqcategorylist');
						//
						Route::post('markallnotify', 'AdminDashboardController@markallnotify')->name('admin.notify.markallread');
						//
						Route::post('/emailonoff', 'AdminprofileController@emailonoff')->name('admin.emailonoff');
						//
						Route::post('customerprofiledelete', 'AdminSettingController@customerprofiledelete')->name('admin.customerprofiledelete');

						Route::post('twofactauthsetting', 'AdminSettingController@twofactauthsetting')->name('admin.twofactauthsetting');
						Route::post('customerautologout', 'AdminSettingController@customerautologout')->name('admin.customerautologout');
						//
						// Route::get('applicationinfodata',[EnvatoAppinfoController::class,'testinginfo'])->name('admin.testinginfo');
						Route::get('licenseinfo', 'EnvatoAppinfoController@index')->name('admin.licenseinfo');
						Route::post('licenseinfoenter', 'EnvatoAppinfoController@store')->name('admin.licenseinfoenter');

						// To Assign the user for self Assign
						Route::post('/selfassign/{id}', 'CategoriesController@selfassign');
						// To unassign
						Route::get('/assigned/update/{id}', 'AdminAssignedticketsController@update');
						// To Assign Other Agent
						Route::post('/otherassign/create', 'AdminAssignedticketsController@create');
						// Admin ticket view 
						Route::get('/ticket-view/{ticket_id}', 'AdminTicketController@show')->name('admin.ticketshow');
						Route::get('/ticket-view/violationdetails/{id}', 'AdminTicketController@violationdetails')->name('violationdetails.customer');
						Route::post('/employeesreplyingremove', 'AdminTicketController@employeesreplyingremove')->name('employeesreplyingremove');
						Route::post('/employeesreplyingstore', 'AdminTicketController@employeesreplyingstore')->name('employeesreplyingstore');
						Route::post('/ticket/{ticket_id}', 'CommentsController@postComment');
						Route::get('/latestcommentimgdelete/{id}', 'CommentsController@latestcommentimgdelete'); // new
						Route::post('/ticketdraft', 'CommentsController@ticketdraft'); //draft
						Route::get('/ticketdraftimage/{id}', 'CommentsController@ticketdraftimage'); //draft
						Route::get('/draftdelete/{id}', 'CommentsController@draftdelete'); //draft
						Route::post('/ticket/imageupload/{ticket_id}', 'CommentsController@storeMedia');
						Route::post('/ticket/reopen/{id}', 'CommentsController@reopenticket');
						Route::post('/note/create', 'AdminTicketController@note');
						Route::post('/ticketnote/delete/{id}', 'AdminTicketController@notedestroy');
						Route::post('/deleteViolation/delete/{id}', 'AdminTicketController@deleteViolation');
						Route::post('/ticket/editcomment/{id}', 'CommentsController@updateedit');
						Route::post('/ticket/deletecomment/{id}', 'CommentsController@deletecomment');
						Route::post('/priority/change/', 'AdminTicketController@changepriority');
						// Deletye ticket
						Route::post('/delete-ticket/{id}', 'AdminTicketController@destroy');

						// new link start
						Route::post('/purchasedetailsverify', 'AdminTicketController@purchasedetailsverify')->name('purchasedetailsverify');
						Route::post('/wrongcustomer', 'AdminTicketController@wrongcustomer')->name('wrongcustomer');
						Route::post('/adminticketclosing/{id}', 'AdminTicketController@adminticketclosing')->name('admin.ticketclosing');
						Route::post('/addimportantticket/{id}', 'AdminTicketController@addimportantticket')->name('admin.addimportantticket');
						Route::post('/fileuploadpermission/{id}','AdminTicketController@fileuploadPermission')->name('admin.fileuploadPermission');
						// new link end 

						Route::post('/ticket/delete/tickets', 'AdminTicketController@ticketmassdestroy');

						Route::get('/createticket', 'AdminTicketController@createticket');
						Route::post('/createticket', 'AdminTicketController@gueststore');
						Route::post('/imageupload', 'AdminTicketController@guestmedia')->name('imageuploadadmin');

						Route::get('tickethistory/{id}', 'AdminTicketViewController@tickethistory')->name('admin.tickethistory');
						Route::get('customerprevioustickets/{cust_id}', 'AdminTicketViewController@customerprevioustickets')->name('admin.customer.tickethistory');
						// all Tickets
						Route::get('/alltickets', 'AdminTicketController@alltickets');
						// recent Tickets
						Route::get('/recenttickets', 'AdminDashboardController@recenttickets');
						Route::get('/activeticket', 'AdminDashboardController@activeticket');
						Route::get('/closedticket', 'AdminDashboardController@closedticket');

						Route::group(['prefix' => 'activeticket'], function () {
							Route::get('/inprogress', 'AdminTicketViewController@allactiveinprogresstickets');
							Route::get('/reopen', 'AdminTicketViewController@allactivereopentickets');
							Route::get('/onhold', 'AdminTicketViewController@allactiveonholdtickets');
							Route::get('/assigned', 'AdminTicketViewController@allactiveassignedtickets');
						});
						Route::get('/onholdtickets', 'AdminDashboardController@onholdticket');
						Route::get('/overduetickets', 'AdminDashboardController@overdueticket');
						Route::get('/allassignedtickets', 'AdminDashboardController@adminallassignedtickets');
						Route::get('/suspendedtickets', 'AdminDashboardController@suspendedtickets');

						Route::get('/myselfassigned', 'AdminTicketViewController@selfassignticketview');
						Route::get('/myassignedtickets', 'AdminDashboardController@myassignedTickets');
						Route::get('/myclosedtickets', 'AdminTicketViewController@myclosedtickets');
						Route::get('/mysuspendtickets', 'AdminTicketViewController@mysuspendtickets');

						// suspend 
						Route::post('suspend', 'AdminTicketViewController@suspend')->name('admin.suspend');

						// employee 
						Route::get('/employee', 'AgentCreateController@index')->name('employee');
						Route::get('/employee/create', 'AgentCreateController@create');
						Route::post('/userimport', 'AgentCreateController@usercsv')->name('customer.ucsvimport');
						Route::post('/agent', 'AgentCreateController@store');
						Route::get('/agentprofile/{id}', 'AgentCreateController@show');
						Route::post('/agentprofile/{id}', 'AgentCreateController@update');
						Route::get('/userimport', 'AgentCreateController@userimportindex')->name('user.userimport');
						Route::post('/agentdelte/{id}', 'AgentCreateController@destroy');
						Route::post('/massuser/deleteall', 'AgentCreateController@usermassdestroy');
						Route::post('/agent/status/{id}', 'AgentCreateController@status');

						Route::post('/employeepasswordreset', 'AgentCreateController@employeepasswordreset');

						Route::get('role', 'RoleCreateController@index');
						Route::get('role/create', 'RoleCreateController@create');
						Route::post('role/create', 'RoleCreateController@store');
						Route::get('role/edit/{id}', 'RoleCreateController@edit');
						Route::post('role/edit/{id}', 'RoleCreateController@update');

						// languages 
						Route::group(['prefix' => 'languages'], function () {
							Route::get('/', 'LanguagesController@index');
							Route::get('/create', 'LanguagesController@create')->name('create');
							Route::post('/store', 'LanguagesController@store');
							Route::get('/translates/{code}', 'LanguagesController@translate');
							Route::post('/insert/{id}', 'LanguagesController@add');
							Route::post('/addOnNotFound/{id}', 'LanguagesController@addOnNotFound');
							Route::get('/edit/{id}', 'LanguagesController@edit')->name('edit');
							Route::post('/edit/{id}', 'LanguagesController@update')->name('edit.update');
							Route::post('/destroy/{id}', 'LanguagesController@destroy')->name('destroy');
							Route::post('{id}/update', 'LanguagesController@translateUpdate');
							Route::get('/translate/{code}/{group}', 'LanguagesController@translate');
						});
						//trashed tickets
						Route::get('/tickettrashed', 'AdminTicketViewController@tickettrashed')->name('admin.tickettrashed');
						Route::post('/tickettrashedrestore/{id}', 'AdminTicketViewController@tickettrashedrestore')->name('admin.tickettrashedrestore');
						Route::post('/tickettrasheddestroy/{id}', 'AdminTicketViewController@tickettrasheddestroy')->name('admin.tickettrasheddestroy');
						Route::get('/tickettrashedview/{id}', 'AdminTicketViewController@tickettrashedview')->name('admin.tickettrashedview');
						Route::post('/tickettrashed/restore', 'AdminTicketViewController@alltrashedticketrestore')->name('admin.alltrashedticketrestore');
						Route::post('/tickettrashed/delete', 'AdminTicketViewController@alltrashedticketdelete')->name('admin.alltrashedticketdelete');
						// catergory
						Route::get('/categories', 'CategoriesController@index');
						Route::post('/categories/create', 'CategoriesController@store');
						Route::post('/categories/status{id}', 'CategoriesController@status');
						Route::get('/categoryassigned/{id}', 'CategoriesController@agentshow');
						Route::get('/category/list/{ticket_id}', 'CategoriesController@categorylist');
						Route::get('/totalcategorylist', 'CategoriesController@totalcategorylist');
						Route::get('/categorylist', 'CategoriesController@categorylistshow');
						Route::post('/categoryenvatoassign', 'CategoriesController@categoryenvatoassign');
						Route::post('/category/change/', 'CategoriesController@categorychange');
						Route::post('/category/all/', 'CategoriesController@categorygetall');
						Route::post('/categories/{id}', 'CategoriesController@destroy')->name('delete');
						Route::post('/category/deleteall', 'CategoriesController@categorymassdestroy');
						Route::get('/subcategories', 'CategoriesController@subcategoryindex');
						Route::post('/subcategories', 'CategoriesController@subcategorystore');
						Route::post('/subcategory/status/', 'CategoriesController@subcategorystatusupdate');
						Route::post('/subcategory/delete/', 'CategoriesController@subcategorydelete');
						Route::post('/subcategory/deleteall', 'CategoriesController@subcategorydeleteall');
						Route::get('/groupassigned/{id}', 'CategoriesController@groupshow');
						Route::post('/groupcategory/group', 'CategoriesController@categorygroupassign');
						Route::post('/assignedcategory/createagent', 'CategoriesController@agentshowcreate');

						//articles

						Route::get('/article', 'ArticlesController@index');
						Route::post('/article', 'ArticlesController@article');
						Route::get('/article/create', 'ArticlesController@create');
						Route::post('/article/create', 'ArticlesController@store');
						Route::post('/article/imageupload', 'ArticlesController@storeMedia');
						Route::post('/article/featureimageupload', 'ArticlesController@featureimagestoreMedia');
						Route::get('/article/{id}/edit', 'ArticlesController@show');
						Route::post('/article/{id}/edit', 'ArticlesController@update');
						Route::post('/article/{id}', 'ArticlesController@destroy');
						Route::post('/massarticle/delete', 'ArticlesController@articlemassdestroy');
						Route::post('/article/status/{id}', 'ArticlesController@status');
						Route::post('/article/privatestatus/{id}', 'ArticlesController@privatestatus');
						Route::post('/article/featureimage/{id}', 'ArticlesController@featureimage');
						Route::post('/image/delete/{id}', 'CommentsController@imagedestroy');

						// ticket to artical
						Route::get('/ticketarticle/{ticket}/{comment?}', 'ArticlesController@ticketarticle')->name('admin.article.ticket');

						//projects 
						Route::get('/projects', 'ProjectsController@index');
						Route::get('/allprojects', 'ProjectsController@allprojects');
						Route::post('/projects/create', 'ProjectsController@store');
						Route::post('/projects/delete/{id}', 'ProjectsController@destroy');
						Route::post('/massproject/delete', 'ProjectsController@projectmassdestroy');
						Route::get('/projectsassigned', 'ProjectsController@projectlist');
						Route::post('/projectsassigned', 'ProjectsController@projectassignee');
						Route::get('/projectimport', 'ProjectsController@projetimport');
						Route::post('/projectimport', 'ProjectsController@projetcsv')->name('project.pcsvimport');
						Route::get('/notifications', 'ProjectsController@notificationpage');
						Route::get('notification/{id}', 'AdminDashboardController@Notificationview');

						// department
						Route::group(['prefix' => 'department', 'as' => 'department.'], function () {

							Route::get('/', 'DepartmentController@index');
							Route::post('/create', 'DepartmentController@create');
							// Route::get('/edit/{id}', 'DepartmentController@edit');
							Route::post('/delete/{id}', 'DepartmentController@delete');
							Route::post('/deleteall', 'DepartmentController@deleteall');
							Route::post('/status/{id}', 'DepartmentController@status');
						});

						// Group
						Route::group(['prefix' => 'groups'], function () {

							Route::get('/', 'GroupCreateController@index');
							Route::post('store', 'GroupCreateController@store');
							Route::post('update/{id}', 'GroupCreateController@update');
							Route::post('delete/{id}', 'GroupCreateController@destroy');
							Route::post('deleteall', 'GroupCreateController@destroyall');
							Route::post('statuschange/{id}', 'GroupCreateController@statuschange');
						});

						// notifications
						Route::get('/notifications', 'ProjectsController@notificationpage');
						Route::post('/notify/delete', 'AdminDashboardController@notifydelete');
						Route::post('/mark-as-read', 'AdminDashboardController@markNotification');

						// live chat 

						Route::get('/livechat', [LiveChatController::class, 'index'])->name('admin.livechat');
						Route::get('/operators', [LiveChatController::class, 'operators'])->name('admin.operators');
						Route::get('/livechat-flow/{id}', [LiveChatController::class, 'liveChatFlow']);
						Route::get('/livechat-flow/test-it-out/{id}', [LiveChatController::class, 'testItOut']);
						Route::get('/chat-responses', [LiveChatController::class, 'chatResponses'])->name('admin.chatResponses');
						Route::get('/solvedchats', [LiveChatController::class, 'solvedChats'])->name('admin.solvedChats');
						Route::get('/myopened', [LiveChatController::class, 'myOpenedChats'])->name('admin.myOpenedChats');
						Route::get('/livechat-settings', [LiveChatController::class, 'livechatSettings'])->name('admin.livechatSettings');
						Route::post('/operators/broadcastoperatorReplyViewed', [LiveChatController::class, 'broadcastoperatorReplyViewed']);
						Route::post('/operators/broadcastoperator', [LiveChatController::class, 'broadcastoperator'])->name('admin.broadcastoperator');
						Route::post('/operators/agentbroadcastmessagetyping', [LiveChatController::class, 'agentbroadcastmessagetyping'])->name('admin.agentbroadcastmessagetyping');
						Route::get('/operators/singleoperator/{id}', [LiveChatController::class, 'singleoperator'])->name('admin.singleoperator');
						Route::get('/operators/conversationdelete/{id}', [LiveChatController::class, 'conversationdelete'])->name('admin.conversationdelete');
						Route::get('/operators/markasunread/{id}', [LiveChatController::class, 'markasunread'])->name('admin.markasunread');
						Route::get('/operators/markasread/{id}', [LiveChatController::class, 'markasread'])->name('admin.markasread');
						Route::post('/operators/groupbroadcastoperator', [LiveChatController::class, 'groupbroadcastoperator'])->name('admin.groupbroadcastoperator');
						Route::get('/operators/groupconversion/{id}', [LiveChatController::class, 'groupconversion'])->name('admin.groupconversion');
						Route::post('/operators/groupconversionstore/{id}', [LiveChatController::class, 'groupconversionstore'])->name('admin.groupconversionstore');
						Route::get('/operators/groupconversiondelete/{id}', [LiveChatController::class, 'groupconversiondelete'])->name('admin.groupconversiondelete');
						Route::post('/livechat-flow/save', [LiveChatController::class, 'ChatFlowSave'])->name('admin.liveChatFlowSave');
						Route::get('/livechat-flow/delete/{id}', [LiveChatController::class, 'deleteChatFlow'])->name('admin.liveChatFlowDelete');
						Route::post('/livechat-flow/active-save', [LiveChatController::class, 'activeChatFlow'])->name('admin.liveChatActiveFlowSave');
						Route::post('/livechat-flow/auto-save', [LiveChatController::class, 'ChatAutoFlowSave'])->name('admin.liveChatFlowAutoSave');
						Route::post('/livechat/online-users-save', [LiveChatController::class, 'AddOnlineUsers'])->name('admin.onlineUsersSave');
						Route::post('/livechat/engage-conversation', [LiveChatController::class, 'engageConversation'])->name('admin.engageConversation');
						Route::get('/livechat/conversationleave', [LiveChatController::class, 'conversationLeave'])->name('admin.conversationLeave');
						Route::post('/livechat/conversation-reassign', [LiveChatController::class, 'conversationReassign'])->name('admin.conversationReassign');
						Route::get('/livechat/conversation-unread', [LiveChatController::class, 'conversationUnread'])->name('admin.conversationUnread');
						Route::get('/livechat/remove-user-from-unread', [LiveChatController::class, 'removeUserFromUnread'])->name('admin.removeUserFromUnread');
						Route::get('/livechat/conversation-delete', [LiveChatController::class, 'livechatConversationDelete'])->name('admin.livechatConversationDelete');
						Route::get('/livechat/mark-as-solved', [LiveChatController::class, 'markAsSolved'])->name('admin.markAsSolved');
						Route::post('/livechat/live-chat-notifications-setting', [LiveChatController::class, 'liveChatNotificationsSetting'])->name('admin.liveChatNotificationsSetting');
						Route::post('/livechat/live-chat-notifications-sound', [LiveChatController::class, 'liveChatNotificationsSound'])->name('admin.liveChatNotificationsSound');
						Route::post('/livechat/live-chat-icon',[LiveChatController::class,'liveChatIcon'])->name('admin.liveChatIconSetting');
						Route::post('/livechat/live-chat-flow-settings', [LiveChatController::class, 'liveChatFlowSettings'])->name('admin.liveChatFlowSettings');
						Route::post('/livechat/live-chat-file-settings', [LiveChatController::class, 'liveChatFileSettings'])->name('admin.liveChatFileSettings');
						Route::post('/livechat/live-chat-cust-fileupload', [LiveChatController::class, 'liveChatCustFileUpload'])->name('admin.liveChatCustFileUpload');
						Route::get('/livechat-notifications-sounds', [LiveChatController::class, 'livechatNotificationsSonds'])->name('admin.livechatNotificationsSonds');
						Route::post('/livechat-notifications-sounds-delete', [LiveChatController::class, 'livechatNotificationsSondsDelete'])->name('admin.livechatNotificationsSondsDelete');
						Route::post('/livechat-notifications-masssounds-delete', [LiveChatController::class, 'livechatNotificationsMassSondsDelete'])->name('admin.livechatNotificationsMassSondsDelete');
						Route::post('/livechat/live-chat-icon-size', [LiveChatController::class, 'liveChatIconSize'])->name('admin.liveChatIconSize');
						Route::post('/livechat/live-chat-position', [LiveChatController::class, 'liveChatPosition'])->name('admin.liveChatPosition');
						Route::post('/livechat/live-chat-offline-setting', [LiveChatController::class, 'liveChatOfflineSetting'])->name('admin.liveChatOfflineSetting');
						Route::get('/livechat/get-cannedmessages', [LiveChatController::class, 'getCannedmessages'])->name('admin.getCannedmessages');
						Route::post('/livechat/operators-notifications-setting', [LiveChatController::class, 'operatorsNotificationsSetting'])->name('admin.operatorsNotificationsSetting');
						Route::post('/livechat/livechat-credentials', [LiveChatController::class, 'livechatCredentials'])->name('admin.livechatCredentials');
						Route::post('/livechat/livechatssldstore', [LiveChatController::class, 'livechatssldstore'])->name('admin.livechatssldstore');
						Route::post('/livechat/livechat-autosave', [LiveChatController::class, 'livechatAutoSave'])->name('admin.livechatAutoSave');
						Route::post('/livechat/livechatAutoDelete', [LiveChatController::class, 'livechatAutoDelete'])->name('admin.livechatAutoDelete');
						Route::get('/livechat-tickets', [LiveChatController::class, 'livechatTickets'])->name('admin.livechatTickets');
						Route::get('/livechat-ticket-massdelete', [LiveChatController::class, 'livechatTicketMassDelete'])->name('admin.livechatTicketMassDelete');
						Route::get('/livechat-ticket-delete', [LiveChatController::class, 'livechatTicketDelete'])->name('admin.livechatTicketDelete');
						Route::post('/livechat-feedback-dropdown', [LiveChatController::class, 'livechatFeedbackDropdown'])->name('admin.livechatFeedbackDropdown');
						Route::post('/livechat-cust-welecome-title', [LiveChatController::class, 'LivechatCustWelcomeMsg'])->name('admin.LivechatCustWelcomeMsg');
						Route::get('/livechat-allratings', [LiveChatController::class, 'livechatAllRatings'])->name('admin.livechatAllRatings');
						Route::get('/livechat-employer-ratings/{id}', [LiveChatController::class, 'livechatEmpliyerRatings'])->name('admin.livechatEmpliyerRatings');
						Route::post('/livechat-delete-feedback/{id}', [LiveChatController::class, 'livechatDeleteFeedback'])->name('admin.livechatDeleteFeedback');
						Route::post('/security-settings', [LiveChatController::class, 'securitySettings'])->name('admin.securitySettings');

						// customnotification
						Route::group(['prefix' => 'customnotification'], function () {

							Route::get('/', 'MailboxController@index');
							Route::get('/customnotificationlist', 'MailboxController@customnotificationlist');
							Route::post('/customercompose', 'MailboxController@customercomposesend');
							Route::post('/employeecompose', 'MailboxController@employeecomposesend');
							Route::get('/sentmail', 'MailboxController@mailsent');
							Route::post('delete/{id}', 'MailboxController@destroy');
							Route::post('/massdelete', 'MailboxController@allnotifydelete');
						});
						// Businesshours

						Route::get('/businesshour', 'BusinesshourController@index');
						Route::post('/businesshour', 'BusinesshourController@store');
						Route::post('/businesshour/store', 'AdminSettingController@businesshourtitle');
						Route::post('/businesshour/fullhours', 'BusinesshourController@fullhours')->name('admin.fullhours.store');
						Route::post('bussinesshour/offlinemsg', 'AdminSettingController@businessofflinemsg')->name('admin.businessofflinemsg');
						Route::post('/businesslogodelete', 'AdminSettingController@businesslogodelete')->name('admin.businesslogodelete');

						// envato settings
						Route::get('/envatosetting', 'AdminSettingController@envatosetting')->name('settings.envatosetting');
						Route::post('/expiredsupport', 'AdminSettingController@expiredsupport')->name('settings.expiredsupport');

						// custom field
						Route::group(['prefix' => 'customfield', 'as' => 'admin.customfield.'], function () {
							Route::get('/', 'CustomfieldController@index');
							Route::post('/', 'CustomfieldController@storeupdate');
							Route::post('/delete/{id}', 'CustomfieldController@destroy');
							Route::post('/deleteall', 'CustomfieldController@destroyall');
							Route::post('/status/{id}', 'CustomfieldController@status')->name('status');
						});

						//general-setting
						Route::post('/general', 'ApptitleController@store');
						Route::get('/termsurl', 'AdminSettingController@termsurl');
						Route::post('/urlset', 'AdminSettingController@seturl')->name('settings.url.urlset');
						Route::post('/colorsetting', 'AdminSettingController@frontendStore');
						Route::post('/languagesetting', 'AdminSettingController@languagesettingstore')->name('settings.lang.store');
						Route::post('/datetimeformat', 'AdminSettingController@datetimeformatstore')->name('settings.timedateformat.store');
						Route::post('/startweek', 'AdminSettingController@startweekstore')->name('settings.startweek.store');
						Route::post('/timezoneupdate', 'AdminSettingController@timezoneupdate')->name('settings.timezone.store');
						Route::post('/footer', 'ApptitleController@footerstore');
						Route::post('/imageuploadupdate', 'ApptitleController@ImageUploadupdate');
						Route::post('/logodelete', 'ApptitleController@logodelete')->name('admin.logodelete');
						Route::post('/general/register', 'AdminSettingController@registerpopup');
						Route::post('/general/enableemailtoticket', 'AdminSettingController@enableemailtoticket')->name('admin.enableemailtoticket');
						Route::post('/general/email-to-ticket', 'AdminSettingController@emailToTicket');
						Route::post('/general/emailToTicketDeleteCloneTicket', 'AdminSettingController@emailToTicketDeleteCloneTicket');
						Route::post('/knowledge', 'AdminSettingController@knowledge')->name('settings.knowledge.store');
						Route::post('/profileuser', 'AdminSettingController@profileuser')->name('settings.profileuser.store');
						Route::post('/contactemail', 'AdminSettingController@contactemail')->name('settings.contactemail.store');
						Route::post('/general/logindisable', 'AdminSettingController@logindisable');

						//holidays
						Route::get('/holidays', [HolidayController::class, 'index'])->name('admin.holidays');
						Route::post('/holidays/holidaysimport', [HolidayController::class, 'holidayscsv']);
						Route::get('/holidays/holidaysimport', [HolidayController::class, 'holidaysimport'])->name('holidays.import');
						Route::post('/holidays/massdelete', [HolidayController::class, 'massdelete']);
						Route::get('/holidays/{id}', [HolidayController::class, 'edit']);
						Route::post('/holidays/delete/{id}', [HolidayController::class, 'delete']);
						Route::post('/holidays/statuschange/{id}', [HolidayController::class, 'statuschange'])->name('holidays.statuschange');
						Route::post('/holidays/saveholidays', [HolidayController::class, 'saveholidays'])->name('saveholidays');

						//customer
						Route::get('/download-files', 'AdminprofileController@downloadProject');
						Route::get('/exportDatabase', 'AdminprofileController@exportDatabase');
						Route::get('/customer/create', 'AdminprofileController@customerscreate');
						Route::post('/customer/create', 'AdminprofileController@customersstore');
						Route::get('customer/adminlogin/{id}', 'AdminprofileController@adminLogin');
						Route::get('/customer', 'AdminprofileController@customers')->name('admin.customer');
						Route::get('/customer/{id}', 'AdminprofileController@customersshow');

						// new  link start 
						Route::post('/voilating', 'AdminprofileController@voilating')->name('voilating.customer');
						Route::post('/unvoilating/{id}', 'AdminprofileController@unvoilating')->name('unvoilating.customer');
						// new  link end

						Route::post('/customer/{id}', 'AdminprofileController@customersupdate');
						Route::post('/customer/delete/{id}', 'AdminprofileController@customersdelete');
						Route::post('/masscustomer/delete', 'AdminprofileController@customermassdestroy');
						Route::get('/customerimport', 'AdminprofileController@customerimportindex')->name('admin.customer.import');
						Route::post('/customerimport', 'AdminprofileController@customercsv')->name('admin.customer.csv');
						Route::get('/customer/resendverification/{email}', 'AdminprofileController@resendverification');

						Route::post('/sessionLogout', 'AdminprofileController@sessionLogout')->name('admin.sessionLogout');

						//profile
						Route::get('/profile', 'AdminprofileController@index');
						Route::get('/change-password', 'ChangepasswordController@index');
						Route::post('/change-password', 'ChangepasswordController@changePassword');
						Route::get('/usersettings', 'AdminprofileController@usersetting');
						Route::post('/profile', 'AdminprofileController@profilesetup');
						Route::post('/image/remove/{id}', 'AdminprofileController@imageremove');

						//SEO
						Route::get('/seo', 'SeopageController@index');
						Route::post('/seo/create', 'SeopageController@store');

						//Googleanalytics
						Route::get('/googleanalytics', 'AdminSettingController@googleanalytics');
						Route::post('/googleanalytics', 'AdminSettingController@googleanalyticsStore')->name('settings.googleanalytics');

						//Custom CSS & JS
						Route::get('/customcssjssetting', 'CustomcssjsController@index');
						Route::post('/customcssjssetting', 'CustomcssjsController@customcssjs')->name('settings.custom.cssjs');

						//SendTestMail
						Route::post('/sendtestmail', 'AdminSettingController@sendTestMail')->name('settings.email.sendtestmail');

						//Email Setting
						Route::post('/emailsetting', 'AdminSettingController@emailStore')->name('settings.email.store');
						Route::get('/gettingsendnaildata', 'AdminSettingController@gettingSendMailData');
						Route::post('/imapstore', 'AdminSettingController@imapstore')->name('settings.imapstore');
						Route::post('/imaps/statuschange/{id}', 'AdminSettingController@statuschange')->name('imap.statuschange');
						Route::get('/imaps/{id}', 'AdminSettingController@edit')->name('imap.edit');
						Route::get('/imaps/delete/{id}', 'AdminSettingController@delete')->name('imap.delete');
						Route::post('/imaps/alldelete', 'AdminSettingController@massdelete')->name('imaps.alldelete');
						Route::post('/smtp/check', 'AdminSettingController@smtpcheck')->name('smtp.check');
						Route::post('/update-settings', [AdminSettingController::class, 'updateDefaultSettings'])->name('update.settings');
						// autoTranslate
						Route::post('/autoTranslate', [LanguagesController::class,'autoTranslate'])->name('language.translate');
						//Bot Response
						Route::get('/botresponsettingcreate', [AdminSettingController::class, 'botresponsettingcreate'])->name('admin.botresponsetting');
						Route::post('/botsettingstore', [AdminSettingController::class, 'botsettingstore'])->name('admin.botsettingstore');
						Route::get('/botimagedelete', [AdminSettingController::class, 'botimagedelete'])->name('admin.botimagedelete');

						Route::get('/twiliosetting', [AdminSettingController::class, 'twiliosetting'])->name('admin.twiliosetting');
						Route::post('/twiliosettingstore', [AdminSettingController::class, 'twiliosettingstore'])->name('admin.twiliosettingstore');

						Route::get('/smstemplateedit/{id}', 'AdminSettingController@smstemplateedit')->name('admin.smstemplate.edit');
						Route::post('/smstemplateUpdate/{id}', 'AdminSettingController@smstemplateUpdate')->name('admin.smstemplate.update');

						Route::delete('/voilationnotedelete/{id}', 'AdminprofileController@voilationnotedelete')->name('customer.voilationnotedelete');
						Route::get('/voilationedit/{id}', 'AdminprofileController@voilationedit')->name('customer.voilationedit');

						//EmailToTicket
						Route::get('emailticket', 'SecuritySettingController@emailtoticket');
						Route::post('emailticket', 'SecuritySettingController@emailticketstore')->name('admin.emaitickets');

						//IP List
						Route::get('ipblocklist', 'IpblockController@index')->name('ipblocklist');
						Route::get('ipblocklist/{id}', 'IpblockController@show')->name('ipblocklist.id');
						Route::post('ipblocklist/create', 'IpblockController@store')->name('ipblocklist.store');
						Route::get('ipblocklist/delete/{id}', 'IpblockController@destroy')->name('ipblocklist.destroy');
						Route::get('ipblocklist/reset/{id}', 'IpblockController@resetipblock')->name('ipblocklist.reset');
						Route::post('/ipblocklist/deleteall', 'IpblockController@allipblocklistdelete');

						//sociallogin
						Route::get('/sociallogin', 'AdminSettingController@sociallogin')->name('settings.sociallogin');
						Route::post('/sociallogin', 'AdminSettingController@socialloginupdate')->name('settings.sociallogin.update');

						//securitysetting
						Route::get('securitysetting', 'SecuritySettingController@index');
						Route::post('securitysetting', 'SecuritySettingController@store')->name('settings.security.country');
						Route::post('adminsecuritysetting/', 'SecuritySettingController@adminstore')->name('settings.security.admin.country');
						Route::post('securitysetting/ip', 'SecuritySettingController@dosstore')->name('settings.security.ip');
						Route::post('/emaildomain', 'SecuritySettingController@emaildomainlist')->name('admin.emaildomainlist');

						//External Chat Setting
						Route::get('/customchatsetting', 'CustomcssjsController@customchat');
						Route::post('/customchatsetting', 'CustomcssjsController@customchats')->name('settings.custom.chat');

						//captcha setting
						Route::get('/captcha', 'AdminSettingController@captcha')->name('settings.captcha');
						Route::post('/captcha', 'AdminSettingController@captchastore')->name('settings.captcha.store');
						Route::post('/captchacontact', 'AdminSettingController@captchacontact')->name('settings.captchacontact.store');
						Route::post('/captcharegister', 'AdminSettingController@captcharegister')->name('settings.captcharegister.store');
						Route::post('/captchalogin', 'AdminSettingController@captchalogin')->name('settings.captchalogin.store');
						Route::post('/captchaadminlogin', 'AdminSettingController@captchaadminlogin')->name('settings.captchaadminlogin.store');
						Route::post('/captchaguest', 'AdminSettingController@captchaguest')->name('settings.captchaguest.store');
						Route::post('/captchatype', 'AdminSettingController@captchatypestore');

						//ticket Setting
						Route::get('/ticketsetting', 'AdminSettingController@ticketsetting')->name('settings.ticket');
						Route::post('/ticketsetting', 'AdminSettingController@ticketsettingstore')->name('settings.ticket.store');
						Route::post('/filesetting', 'AdminSettingController@filesettingstore')->name('settings.file.store');

						// Announcement

						Route::get('/announcement', 'AdminAnnouncementController@index');
						Route::get('/announcement/{id}', 'AdminAnnouncementController@show');
						Route::post('/announcement/delete/{id}', 'AdminAnnouncementController@destroy');
						Route::post('/announcement/create', 'AdminAnnouncementController@store');
						Route::post('/announcement/update', 'AdminAnnouncementController@update')->name('announcement.update');
						Route::post('/announcement/massannouncedelete', 'AdminAnnouncementController@allannouncementdelete')->name('announcementall.delete');
						Route::post('/announcement/status{id}', 'AdminAnnouncementController@status');
						Route::post('/announcementsetting', 'AdminSettingController@announcementsetting')->name('settings.announcement');

						// emailtemplates
						Route::get('/emailtemplates', 'AdminSettingController@emailtemplates');
						Route::post('/emailtemplates/save', 'AdminSettingController@templateSettings')->name('template.settings');
						Route::get('/emailtemplates/{id}', 'AdminSettingController@emailtemplatesEdit')->name('settings.email.edit');
						Route::post('/emailtemplates/{id}', 'AdminSettingController@emailtemplatesUpdate')->name('settings.email.update');

						// reports
						Route::get('reports', 'AdminReportController@index');
						Route::get('reports/ticketreports', 'AdminReportController@ticketreports')->name('admin.ticketreports');
						Route::get('reports/employee-activity', [AdminReportController::class, 'employeeActivity']);
						Route::get('reports/employeedetails/{id}', 'AdminReportController@employeedetails')->name('admin.reports.employeedetails');
						Route::post('reports/ratingticket/delete/{id}', 'AdminReportController@ratingticketdelete')->name('admin.reports.ratingticketdelete');

						// custom pages 

						Route::post('/pages/create', 'GeneralPageController@store');
						Route::post('/pagesdelete/{id}', 'GeneralPageController@destroy');
						Route::post('/pagesdeleteall', 'GeneralPageController@destroyall');

						Route::get('/error404', 'CustomerrorpagesController@index');
						Route::post('/error404', 'CustomerrorpagesController@store');

						Route::get('/maintenancepage', 'CustomerrorpagesController@maintenancepage');
						Route::post('/maintenancepage', 'CustomerrorpagesController@maintenancepagestore');

						// landing pages

						Route::get('/bannersetting', 'ApptitleController@bannerpage');
						Route::post('/bannerstore', 'ApptitleController@bannerstore');

						Route::get('/feature-box', 'FeatureBoxController@index');
						Route::post('/feature-box/feature', 'FeatureBoxController@feature');
						Route::post('/feature-box/create', 'FeatureBoxController@store');
						Route::post('/feature-box/delete/{id}', 'FeatureBoxController@destroy');
						Route::post('/feature-box/imagedelete/{id}', 'FeatureBoxController@destroyImage');
						Route::post('/feature-box/deleteall', 'FeatureBoxController@allfeaturedelete');

						Route::get('/call-to-action', 'CalltoactionController@index');
						Route::post('/call-to-action', 'CalltoactionController@store');
						Route::post('/call-to-action/imagedelete/{id}', 'CalltoactionController@destroyImage');

						Route::group(['prefix' => 'testimonial'], function () {
							Route::get('/', 'TestimonialController@index');
							Route::post('/', 'TestimonialController@testi');
							Route::post('/create', 'TestimonialController@store');
							Route::post('/imagedelete/{id}', 'TestimonialController@destroyImage');
							Route::post('/delete/{id}', 'TestimonialController@destroy');
							Route::post('/deleteall', 'TestimonialController@alltestimonialdelete');
						});
						Route::get('/faq', 'FAQController@index')->name('faq.index');
						Route::post('/faq', 'FAQController@faq');
						Route::post('/faq/create', 'FAQController@store');
						Route::post('/faq/delete/{id}', 'FAQController@destroy');
						Route::post('/faq/deleteall', 'FAQController@allfaqdelete');
						Route::post('/faq/status{id}', 'FAQController@status');
						Route::post('/faq/privatestatus/{id}', 'FAQController@privatestatus');

						Route::get('/faqcategory', 'FaqCategoryController@index');
						Route::post('/faqcategory/store', 'FaqCategoryController@storeupdate');
						Route::post('/faqcategory/delete/{id}', 'FaqCategoryController@destroy');
						Route::post('/faqcategory/deleteall', 'FaqCategoryController@allfaqcategorydelete');
						Route::post('/faqcategory/status/{id}', 'FaqCategoryController@status');

						Route::get('language/{locale}', 'SecuritySettingController@setLanguage');

						Route::get('envatoapitoken', 'EnvatoApiTokenController@index')->name('admin.envatoapitoken');
						Route::post('envatoapitoken', 'EnvatoApiTokenController@storeupdate')->name('admin.envatoapitoken.storeupdate');
						Route::get('envatolicensesearch', 'EnvatoApiTokenController@licensesearch')->name('admin.envatolicensesearch');
						Route::post('envatolicensesearch', 'EnvatoApiTokenController@licensesearchget')->name('admin.envatolicensesearchget');

						Route::post('ticketlicenseverify', 'EnvatoApiTokenController@ticketlicenseverify')->name('admin.ticketlicenseverify');
						Route::post('ticketuserlicenseverify', 'EnvatoApiTokenController@ticketuserlicenseverify')->name('admin.ticketuserlicenseverify');
						// cannedmessages
						Route::get('/cannedmessages', 'CannedmessagesController@index')->name('admin.cannedmessages');
						Route::get('/getCannedMessage', 'CannedmessagesController@details');
						Route::post('/cannedmessages/create', 'CannedmessagesController@store')->name('admin.cannedmessages.store');
						Route::get('/cannedmessages/edit/{id}', 'CannedmessagesController@edit')->name('admin.cannedmessages.edit');
						Route::post('/cannedmessages/update/{id}', 'CannedmessagesController@update')->name('admin.cannedmessages.update');
						Route::post('/cannedmessages/status/{id}', 'CannedmessagesController@status')->name('admin.cannedmessages.statuschange');
						Route::post('/cannedmessages/delete/{id}', 'CannedmessagesController@destroy')->name('admin.cannedmessages.delete');
						Route::post('/cannedmessages/delete', 'CannedmessagesController@destroyall')->name('admin.cannedmessages.deleteall');
						
														
						Route::post('/ticketsetting/invoiceAddress', [AdminSettingController::class, 'invoiceAddress'])->name('invoice.setting.store');

						Route::get('/paymentGateways', [AdminSettingController::class, 'payments'])->name('settings.payments');
						Route::post('/stripe/store', [AdminSettingController::class, 'stripePaymentsStore'])->name('settings.stripe.store');
						Route::post('/paypal/store', [AdminSettingController::class, 'paypalPaymentsStore'])->name('settings.paypal.store');
						// geminiApi
						Route::get('/aisetup', [AdminSettingController::class, 'aisetup'])->name('settings.aisetup');
						Route::post('/geminiApi/store', [AdminSettingController::class, 'geminiApiStore'])->name('settings.geminiApi.store');

						Route::post('/generate-text', [TextGeneratorController::class, 'generateText']);


						// currencies
						Route::get('/currencies', [CurrencyController::class, 'index'])->name('currencies');
						Route::get('/currency/{id}/edit', [CurrencyController::class, 'edit']);
						Route::get('/currency/{id}', [CurrencyController::class, 'delete']);
						Route::post('/currency/status/{id}', [CurrencyController::class, 'status']);
						Route::post('/currency/deleteall', [CurrencyController::class, 'currencyMassdestroy'])->name('currency.deleteall');
						
						// payments routes
						Route::get('/allTransactions', [AdminPaymentsController::class, 'allTransactions'])->name('allTransactions');
						Route::get('/invoice/{id}', [AdminPaymentsController::class, 'adminInvoiceDetails'])->name('admin.invoice');
						Route::delete('/invoice/delete/{id}',[AdminPaymentsController::class, 'deleteInvoice'])->name('invoice.delete');
						Route::get('/invoice/cancel/{id}',[AdminPaymentsController::class, 'cancelInvoice'])->name('invoice.cancel');
						Route::post('/customInvoices/store', [AdminPaymentsController::class, 'customInvoicesStore']);
						Route::get('/get-customer-details/{id}', [AdminPaymentsController::class, 'getDetails'])->name('customer.details');
						Route::post('/refund/setting', [AdminPaymentsController::class, 'refundSettings'])->name('refunds.setting');
						Route::post('/invoice/cancel/setting', [AdminPaymentsController::class, 'autoInvoiceCancelSetting'])->name('invoiceCancellation.setting');
						Route::post('/invoice/delete/setting', [AdminPaymentsController::class, 'autoInvoicedeleteSetting'])->name('autodeleteinvoice.setting');
						Route::get('/refundRequests', [AdminPaymentsController::class, 'refundRequests']);
						Route::get('/refundRequests/{id}', [AdminPaymentsController::class, 'refundRequestsView']);
						Route::post('/refundRequests/postComment', [AdminPaymentsController::class, 'refundPostComment'])->name('admin.refund.comment');
						// Route::get('/refundRequests/getdetails/{id}', [AdminPaymentsController::class, 'refundGetdetails']);
						Route::post('/refundRequests/reject', [AdminPaymentsController::class, 'rejectRefund'])->name('admin.rejectRefund');
						Route::post('/refundRequests/approve', [AdminPaymentsController::class, 'approveRefund'])->name('admin.approveRefund');

						// addspace
						Route::get('/addspace', [AddSpaceController::class, 'index'])->name('addSpaceIndex');
						Route::post('/addspace/store', [AddSpaceController::class, 'storeAddSpace'])->name('createAddSpace');
						Route::post('/addspace/status/{id}', [AddSpaceController::class, 'changeStatus'])->name('changeAddSpaceStatus');
						Route::delete('/addspace/delete/{id}', [AddSpaceController::class, 'deleteAddSpace'])->name('deleteAddSpace');
						Route::post('deleteall', 'AddSpaceController@deleteall')->name('AddSpaceDeleteAll');
					});
				});
			});

			Route::group(['namespace' => 'Admin', 'prefix'	 => 'admin'], function () {
				//
				Route::post('/notifystatus', 'AdminDashboardController@notifystatus');
				Route::post('/notifysearch', 'AdminDashboardController@notifysearch');
				Route::get('/getemployeesreplying/{id}', 'AdminTicketController@getemployeesreplying')->name('getemployeesreplying');
			});


			Route::middleware(['countrylistbub', 'throttle:refresh', 'ipblockunblock', 'datarecovery'])->group(function () {

				Route::group(['namespace' => 'User', 'prefix' => 'customer'], function () {
					Route::get('checkLoginAdmin', 'checkuser@index');
					Route::group(['namespace' => 'Auth'], function () {


						Route::post('/google2faauthnew', 'LoginController@google2fapage')->name('google2faqr.login');
						Route::post('/google2faauthlogin', 'LoginController@google2faotpverifylogin')->name('google2falogin.otpverify');
						Route::get('google2faauth/{email}', 'LoginController@google2fa')->name('google2fa.login');
						Route::get('/resendotp/{email}', 'LoginController@resendotp')->name('resend');
						Route::get('/verifytwofactor/{email}', 'LoginController@verifytwofactor')->name('verify.twofactor');
						Route::post('/verifytwofactor', 'LoginController@otpverify')->name('twofactor');

						Route::get('/login', 'LoginController@showLoginForm')->middleware('guest:customer')->name('auth.login');
						Route::post('/login', 'LoginController@login')->middleware('guest:customer')->name('client.do_login');

						Route::post('/logout', 'LoginController@logout')->name('client.logout');

						// new link start
						Route::get('/emailverificationstore/{email}', 'LoginController@emailverificationstore')->middleware('guest:customer')->name('user.emailverificationstore');

						// new link end

						// Social Auth
						Route::get('/login/{social}', 'LoginController@socialLogin')->name('social.login');
						Route::get('/login/{social}/callback', 'LoginController@handleProviderCallback')->name('social.login-callback');

						Route::get('/register', 'RegisterController@showRegistrationForm')->middleware('guest:customer')->name('register');
						Route::post('/register', 'RegisterController@register')->name('auth.register')->middleware('guest:customer');
						Route::post('/register1', 'RegisterController@registers')->name('register1')->middleware('guest:customer');
						Route::get('/forgotpassword', 'Passwords\ForgotpasswordController@	')->middleware('guest:customer');
						Route::post('/forgotpassword', 'Passwords\ForgotpasswordController@Email')->middleware('guest:customer');
						Route::post('/change-password', 'ChangepasswordController@changepassword')->name('change.password');
						Route::get('/{token}/reset-password', 'Passwords\ResetpasswordController@resetpassword')->middleware('guest:customer');
						Route::post('/reset-password',  'Passwords\ResetpasswordController@updatePassword')->middleware('guest:customer');
						Route::get('/user/verify/{token}', 'RegisterController@verifyUser')->middleware('guest:customer');
					});

					Route::middleware('customer.auth')->group(function () {
						Route::get('/google2faotp', 'Profile\UserprofileController@google2faotpenter')->name('google2faotpenter');
						Route::post('/google2faotpverify', 'Profile\UserprofileController@google2faotpverify')->name('google2fa.otpverify');
						Route::post('/emailtwofactorcustomerset', 'Profile\UserprofileController@emailtwofactor')->name('emailtwofactor.setting');
						Route::post('/enabletwo-factor', 'Profile\UserprofileController@customerenabletwofactor')->name('customer.enabletwofactor');

						Route::post('/customeremailchange', 'Profile\UserprofileController@customeremailchange')->name('customeremailchange');
						Route::post('/customernewemailstore', 'Profile\UserprofileController@customernewemailstore')->name('customer.newemailstore');
						Route::post('/emailchangeotpverify/{oldemail}', 'Profile\UserprofileController@emailchangeotpverify')->name('emailchange.otpverify');
						Route::get('/customeremailupdate/{email}', 'Profile\UserprofileController@customeremailupdate')->name('customeremailupdate');

						Route::get('/businesshours', 'DashboardController@businesshours');
						Route::get('/dashboardcontroller', 'DashboardController@userTickets')->name('client.dashboard');
						Route::get('/ticket/view/{ticket_id}', 'Ticket\TicketController@show')->name('loadmore.load_data');
						Route::get('/profile', 'Profile\UserprofileController@profile')->name('client.profile');
						Route::post('/profile', 'Profile\UserprofileController@profilesetup')->name('client.profilesetup');
						Route::post('/profile/sendotp', 'Profile\UserprofileController@sendOtp')->name('client.profilesendOtp');
						Route::post('/profile/verifyOTP', 'Profile\UserprofileController@verifyOTP')->name('client.profileverifyOTP');
						Route::post('/custsettings', 'Profile\UserprofileController@custsetting');
						Route::post('/custtwiliosetting', 'Profile\UserprofileController@custtwiliosetting');
						Route::post('/deleteaccount/{id}', 'Profile\UserprofileController@profiledelete')->name('client.profiledelete');
						Route::post('/image/remove/{id}', 'Profile\UserprofileController@imageremove');
						Route::get('/ticket', 'Ticket\TicketController@create')->name('client.ticket');
						Route::post('/ticket', 'Ticket\TicketController@store')->name('client.ticketcreate');
						Route::post('/imageupload', 'Ticket\TicketController@storeMedia')->name('imageupload');
						Route::post('/ticket/imageupload/{ticket_id}', 'Ticket\CommentsController@storeMedia')->name('client.ticket.image');
						// Route::get('/ticket/delete/{id}', 'Ticket\TicketController@destroy')->name('client.ticket.delete');
						// Route::post('/ticket/delete/tickets', 'Ticket\TicketController@ticketmassdestroy')->name('ticket.massremove');
						Route::post('/ticket/{ticket_id}', 'Ticket\CommentsController@postComment')->name('client.comment');
						Route::post('/ticket/editcomment/{id}', 'Ticket\CommentsController@updateedit')->name('client.comment.edit');
						Route::post('/closed/{ticket_id}', 'Ticket\TicketController@close')->name('client.ticketclose');

						//Notifcation of c
						Route::get('/notification', 'DashboardController@notify')->name('client.notification');
						Route::get('notification/{id}', 'DashboardController@Notificationview')->name('customer.notiication.view');

						// cust payments routes
						Route::get('/transactions', [PaymentController::class, 'transactions'])->name('cust.transactions');
						Route::get('/quotations', [PaymentController::class, 'quotations'])->name('cust.quotations');
						// Route::get('/refunds', [PaymentController::class, 'refunds'])->name('cust.refunds');
						// Route::get('/refundView/{id}', [PaymentController::class, 'refundStatusView']);
						Route::get('/custominvoice', [PaymentController::class, 'customInvoice'])->name('cust.customInvoice');


						Route::get('/invoice/{id}', [PaymentController::class, 'getInvoiceDetails'])->name('cust.invoice');
						Route::get('/customInvoice/pay/{id}', [PaymentController::class, 'customInvoicePay']);
						Route::post('invoiceCheckout', [PaymentController::class, 'invoiceCheckout']);
						Route::get('invoicePayment/StripeSuccess', [PaymentController::class, 'invoiceStripeSuccess']);
						Route::get('invoicePayment/PaypalSuccess', [PaymentController::class, 'invoicePaypalSuccess']);
						Route::get('invoicePayment/StripeError/{id}', [PaymentController::class, 'invoiceStripeError']);
						Route::get('invoicePayment/PaypalError/{id}', [PaymentController::class, 'invoicePaypalError']);
						Route::get('/refunds', [PaymentController::class, 'refunds'])->name('cust.refunds');
						Route::post('/requestRefund', [PaymentController::class, 'requestRefund']);
						Route::get('/refundView/{id}', [PaymentController::class, 'refundStatusView']);
						Route::post('/requestRefund/postComment', [PaymentController::class, 'refundPostComment'])->name('client.refund.comment');

						Route::post('/changeCurrency', [CurrencyController::class, 'changeCurrency']);

						Route::post('/mark-as-read', 'DashboardController@markNotification')->name('customer.markNotification');

						Route::post('/markAsRead', function () {
							$notify = Auth::guard('customer')->user();
							$notify->unreadNotifications->markAsRead();
						})->name('cust.mark');
						Route::post('notify/delete', 'DashboardController@notifydelete')->name('customer.notifydelete');

						Route::get('ticket/pdfmake/{id}', 'Ticket\TicketController@pdfmake')->name('user.pdfmake');
					});
				});

				Route::post('/translate', [TranslateController::class, 'translate'])->name('translate');

				Route::get('/', [HomeController::class, 'index'])->name('home');
				Route::get('/getannouncments', [HomeController::class, 'getannouncments']);
				Route::get('/checking', [HomeController::class, 'checking']);
				Route::get('/knowledge', [ArticleCommentController::class, 'index'])->name('knowledge');
				Route::get('/faq', [HomeController::class, 'faqpage']);
				Route::get('/faq/{id}', [HomeController::class, 'faqcategorypage'])->name('faq.faqcategory');

				Route::get('/article/{id}', [HomeController::class, 'knowledge'])->name('article');
				Route::post('likedislike', [HomeController::class, 'likedislike'])->name('likedislike');
				Route::get('/page/{pageslug}', [HomeController::class, 'frontshow']);

				Route::get('/contact-us', [ContactController::class, 'contact']);
				Route::post('/contact-us', [ContactController::class, 'saveContact']);

				Route::get('/category/{id}', [CategorypageController::class, 'index']);


				Route::prefix('guest')->group(function () {
					Route::get('openticket', [GuestticketController::class, 'index'])->name('guest.ticket');
					Route::post('verifyguestotp', [GuestticketController::class, 'verifyguestotp'])->name('guest.verifyguestotp');
					Route::post('openticket', [GuestticketController::class, 'gueststore']);
					Route::post('openticketnootp', [GuestticketController::class, 'gueststore1']);
					Route::post('storemedia', [GuestticketController::class, 'guestmedia'])->name('guest.imageupload');
					Route::get('ticket-view/details/{ticket_id}', [GuestticketController::class, 'ticketdetailshow'])->name('guest.ticketdetailshow');
					Route::get('ticketdetails/{id}', [GuestticketController::class, 'guestdetails'])->name('guest.gusetticket');
					Route::get('ticket/{ticket_id}', [GuestticketController::class, 'guestview'])->name('gusetticket');
					Route::post('/image/delete/{id}', 'User\Ticket\CommentsController@imagedestroy')->name('client.imagedestroy');
					Route::post('ticket/{ticket_id}', [GuestticketController::class, 'postComment'])->name('guest.comment');
					Route::post('closed/{ticket_id}', [GuestticketController::class, 'close'])->name('guesttickets.ticketclose');
					Route::get('ticket-view/{id}', [GuestticketController::class, 'ticketview'])->name('guest.ticketview');
					Route::post('ticket-view/sendotp', [GuestticketController::class, 'senddataverify'])->name('guest.senddataverify');
				});

				Route::post('/guestticket/editcomment/{id}', [CommentsController::class, 'updateedit']);
				Route::post('/envatoverify', [GuestticketController::class, 'envatoverify'])->name('guest.envatoverify');

				Route::get('/rating/{ticket_id}', [GuestticketController::class, 'rating']);
				Route::post('/ticket/rating', [GuestticketController::class, 'ticketrating'])->name('rating');
				Route::get('/allsetting', [HomeController::class, 'allsettings']);
				Route::get('/header', [HomeController::class, 'header']);
			});
			// To get the Recent Tickets
			Route::get('admin/checkLoginAdmin', [checkUser::class, 'index']);
			Route::get('admin/time', [checkUser::class, 'time']);
			Route::get('admin/disablestatement', [AdminSettingController::class, 'disablestatement']);

			Route::post('customer/notifystatus', [DashboardController::class, 'notifystatus'])->name('customer.notifystatus');
			Route::post('customer/notifysearch', [DashboardController::class, 'notifysearch'])->name('customer.notifysearch');

			Route::post('emailsvalidate', [GuestticketController::class, 'emailsvalidateguest'])->name('guest.emailsvalidate');
			Route::post('verifyotp', [GuestticketController::class, 'verifyotp'])->name('guest.verifyotp');

			Route::post('subcategorylist', [GuestticketController::class, 'subcategorylist'])->name('guest.subcategorylist');

			Route::post('/search', [HomeController::class, 'searchlist']);

			Route::get('admin/general', [ApptitleController::class, 'index']);

			Route::get('admin/pages', [GeneralPageController::class, 'index']);

			Route::get('admin/languages/defaultlang', [LanguagesController::class, 'defaultlang']);
			Route::get('admin/languages/translate/{code}', [LanguagesController::class, 'translateData']);

			Route::get('admin/colorsetting', [AdminSettingController::class, 'getcolorsetting']);

			// notification
			Route::get('admin/notificationsreading', [GuestticketController::class, 'notificationsreading'])->name('notificationsreading');

			Route::get('customer/cnotificationsreading', [GuestticketController::class, 'cnotificationsreading'])->name('cnotificationsreading');

			Route::post('customer/markallnotify', [GuestticketController::class, 'markallnotify'])->name('customer.notify.markallread');


			Route::get('/guestLayout', [HomeController::class, 'guestLayout']);
			Route::get('/basic', [HomeController::class, 'basic']);
			Route::post('/admin/missingtranslates', [HomeController::class, 'missingtranslates']);
			Route::get('/error404', [HomeController::class, 'error404']);
			Route::get('/error429', [App\Http\Controllers\ApiController::class, 'error429']);
			Route::get('/error503', [App\Http\Controllers\ApiController::class, 'error503']);
			Route::get('ipblock', [App\Http\Controllers\CaptchaipblockController::class, 'index'])->name('ipblock');
			Route::get('getCapchaType', [App\Http\Controllers\CaptchaipblockController::class, 'getCapchaType'])->name('getCapchaType');
			Route::post('ipblock/update', [App\Http\Controllers\CaptchaipblockController::class, 'update'])->name('ipblock.update');
			Route::get('/captchasreload', [App\Http\Controllers\CaptchaipblockController::class, 'captchasreload'])->name('captchas.reload');
			Route::get('emtcimageurl/{id}/{imageurl}', 'ImageController@emtcimageurlshow')->name('emtcimageurl');
			Route::get('emtcimagedownload/{id}/{imageurl}', 'ImageController@emtcimagedownload')->name('emtcimagedownload');
			Route::get('guestimage/{id}/{imageurl}', 'ImageController@guestimage')->name('guest.imageurl');
			Route::get('/getProfile/{storage_disk}/{imagePath}', [ImageController::class, 'getProfileUrl'])->name('getprofile.url');
			// new link start
			Route::get('image/{id}/{imageurl}', 'ImageController@index')->name('imageurl');
			Route::get('imagedownload/{id}/{imageurl}', 'ImageController@imagedownload')->name('imagedownload');
			Route::get('emailtoticket/{id}/{imageurl}', 'ImageController@emailtoticketshow')->name('emailtoticketimageurl');
			Route::get('emailtoticketdownload/{id}/{imageurl}', 'ImageController@emailtoticketdownload')->name('emailtoticketdownload');
			// new link end
			Route::get('/getimage/{storage_disk}/{imagePath}', [ImageController::class, 'getImage'])->name('getImage.url');
			Route::get('/csrftoken', [HomeController::class, 'csrftoken']);
			Route::get('/assets/i18n/{lang}.json', [HomeController::class, 'getTranslation']);


			Route::post('/livechat/customerdata', [LiveChatController::class, 'customerdata'])->name('admin.customerdata')->middleware('cors');
			Route::get('/livechat/singlecustdata/{id}', [LiveChatController::class, 'singlecustdata'])->name('admin.singlecustdata');
			Route::post('/livechat/broadcast-message', [LiveChatController::class, 'broadcastMessage'])->name('broadcasMessage');
			Route::post('/livechat/broadcast-message-typing', [LiveChatController::class, 'broadcastMessageTyping'])->name('broadcasMessage.message');
			Route::get('/livechat/flow/{id}', [LiveChatController::class, 'ChatFlowData'])->name('admin.ChatFlowData')->middleware('cors');
			Route::post('/livechat/user-seen-messages-indication', [LiveChatController::class, 'userSeenMessagesIndication'])->name('admin.userSeenMessagesIndication');
			Route::post('/livechat/live-chat-image-upload', [LiveChatController::class, 'liveChatImageUpload'])->name('admin.liveChatImageUpload');
			Route::post('/livechat/live-chat-image-remove', [LiveChatController::class, 'removeChatImage'])->name('admin.removeChatImage');
			Route::get('/livechat/livechat-port', [LiveChatController::class, 'livechatPort'])->name('admin.livechatPort');
			Route::post('/livechat/customer-online', [LiveChatController::class, 'livechatCustomerOnline'])->name('admin.livechatCustomerOnline');
			Route::post('/livechat/remove-customer-online', [LiveChatController::class, 'removeLivechatOnlineUsers'])->name('admin.removeLivechatOnlineUsers');
			Route::post('/livechat/livechat-download-file', [LiveChatController::class, 'downloadFile'])->name('admin.downloadFile');
			Route::get('/livechat/run-surver', function () {
				Artisan::call('websockets:serve', [
					'--port' => 8443,
				]);
			})->name('websockets:serve');
			Route::get('authcheckdetails', [HomeController::class, 'authcheckdetails'])->name('admin.authcheckdetails');
		});
	});
});
