<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
	<head>

		<!-- Meta data -->
		<meta charset="UTF-8">
		<meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
		<!-- Title -->
		<title>Not Found</title>

		<?php
			use App\Models\Apptitle;

			$title = Apptitle::first();
		?>

		<?php if($title->image4 == null): ?>

		<!--Favicon -->	
		<link rel="icon" href="<?php echo e(asset('uploads/logo/favicons/favicon.ico')); ?>" type="image/x-icon"/>
		<?php else: ?>

		<!--Favicon -->
		<link rel="icon" href="<?php echo e(asset('uploads/logo/favicons/'.$title->image4)); ?>" type="image/x-icon"/> 
		<?php endif; ?>

		<?php if(str_replace('_', '-', app()->getLocale()) == 'عربى'): ?>

		<!-- Bootstrap css -->
		<link href="<?php echo e(asset('client/assets/plugins/bootstrap/css/bootstrap.rtl.css')); ?>?v=<?php echo time(); ?>" rel="stylesheet" />
		<?php else: ?>

		<!-- Bootstrap css -->
		<link href="<?php echo e(asset('client/assets/plugins/bootstrap/css/bootstrap.css')); ?>?v=<?php echo time(); ?>" rel="stylesheet" />
		<?php endif; ?>

		<!-- Style css -->
		<link href="<?php echo e(asset('client/assets/css/style.css')); ?>?v=<?php echo time(); ?>" rel="stylesheet" />
		<link href="<?php echo e(asset('client/assets/css/updatestyles.css')); ?>?v=<?php echo time(); ?>" rel="stylesheet" />

		<?php if(setting('GOOGLEFONT_DISABLE') == 'off'): ?>
		<style>
			@import url('https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap');
		</style>
		<?php endif; ?>

	</head>

	<body class="<?php if(str_replace('_', '-', app()->getLocale()) == 'عربى'): ?>
		rtl <?php endif; ?>
		<?php if(setting('DARK_MODE') == 1): ?> dark-mode <?php endif; ?>">

		<!--Row-->
		<div class="page error-bg">
			<div class="page-content m-0">
				<div class="container text-center">
					<div class="display-1 text-primary mb-5 font-weight-bold">404</div>
					<h1 class="h3  mb-3 font-weight-semibold"><?php echo e(settingpages('404title')); ?></h1>
					<p class="h5 font-weight-normal mb-7 leading-normal"><?php echo e(settingpages('404subtitle')); ?></p>
					<a class="btn btn-success" href="<?php echo e(url('/')); ?>"><i class="fe fe-arrow-left-circle me-1"></i><?php echo e(lang('Back to Home')); ?></a>
				</div>
			</div>
		</div>
		<!--Row-->


		<!-- Bootstrap4 js-->
		<script src="<?php echo e(asset('client/assets/plugins/bootstrap/popper.min.js')); ?>?v=<?php echo time(); ?>"></script>
		<script src="<?php echo e(asset('client/assets/plugins/bootstrap/js/bootstrap.min.js')); ?>?v=<?php echo time(); ?>"></script>

	</body>
</html><?php /**PATH C:\xampp\htdocs\projects\angular\angular_uhelp_5.0\Uhelp\resources\views/errors/404.blade.php ENDPATH**/ ?>